<?xml version="1.0"?>
<!--
NAME
    kusindxd.xsl
DESCRIPTION
    Convert INDEX document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    rapayne     08/15/08 - fix undefined templates reported via the java based
                           xsl engine.
    rapayne     12/04/06 - Integrate EM specific changes
    lbarton     11/11/05 - bug 4724986: split off kusidxwd.xsl
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     09/12/05 - SXML syntax changes required by XML schema
    sdavidso    09/28/05 - NOCOMPRESS for partions in compressed index 
    lbarton     08/10/05 - lbarton_mddiff
    lbarton     01/24/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kusidxwd.xsl"/>
 <xsl:import href="kuscommd.xsl"/>
 <!-- All DDL is text, and this is the only way to correctly render '<' -->
 <xsl:output method="text"/>
 <!-- Top-level parameters -->
 <xsl:param name="PHYSICAL_PROPERTIES">1</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="PARTITIONING">1</xsl:param>
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template: INDEX - top-level template for indexes.
******************************************************************** -->
 <xsl:template match="sxml:INDEX">
  <xsl:call-template name="DoIndex">
   <xsl:with-param name="IndNode" select="."/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
