<?xml version="1.0"?>
<!-- 
NAME
    kuoper.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_operator_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
   rapayne    11/02/05 - Bug 4715313: Reformat with XMLSpy
   htseng     12/18/02 - add EXPORT parameter
   htseng     08/02/02 - add grantee parse param
   htseng     07/26/02 - add more parse params
   lbarton    06/01/01 - remove oradb-style imports
   lbarton    10/26/00 - bugfix: schema name in primary operator
   gclaborn   10/30/00 - Add external imports; change name
   lbarton    07/24/00 - use uriref in import
   lbarton    06/02/00 - support parsing
   gclaborn   05/05/00 - Support multinesting
   gclaborn   04/25/00 - Add version string
   lbarton    03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="OPERATOR_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">OPERATOR</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>CREATE </xsl:text>
  <xsl:if test="$EXPORT=0">
   <xsl:text>OR REPLACE </xsl:text>
  </xsl:if>
  <xsl:text>OPERATOR </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:apply-templates select="BINDINGS"/>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
 <xsl:template match="BINDINGS">
  <xsl:text>BINDING</xsl:text>
  <xsl:for-each select="BINDINGS_ITEM">
   <xsl:apply-templates select="ARGS"/>
   <xsl:text> RETURN </xsl:text>
   <!-- Now do return type: Could be simple or an ADT -->
   <xsl:choose>
    <!-- The following boolean call tests if a child of type RETURNSCHEMA exists.
  -->
    <xsl:when test="boolean(RETURNSCHEMA)">
     <xsl:call-template name="QuoteObject">
      <xsl:with-param name="Schema" select="RETURNSCHEMA"/>
      <xsl:with-param name="Object" select="RETURNTYPE"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="RETURNTYPE"/>
    </xsl:otherwise>
   </xsl:choose>
   <!-- Now do implementation clause: None, Index context or Ancillary to -->
   <xsl:if test="(PROPERTY mod 2)=1">
    <!-- Index context (bit 0=1)? -->
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;	 </xsl:text>
    </xsl:if>
    <xsl:text> WITH INDEX CONTEXT, SCAN CONTEXT </xsl:text>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Schema" select="IMPSCHEMA"/>
     <xsl:with-param name="Object" select="IMPTYPE"/>
    </xsl:call-template>
    <!-- Compute ancillary data (only if index context)? (bit 1=1)? -->
    <xsl:if test="(PROPERTY mod 4)>=2">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;	 </xsl:text>
     </xsl:if>
     <xsl:text> COMPUTE ANCILLARY DATA </xsl:text>
    </xsl:if>
   </xsl:if>
   <!-- Check if this is an ancillary operator to some primaries -->
   <xsl:if test="(PROPERTY mod 8)>=4">
    <!-- Ancillary? (bit 2=1)? -->
    <xsl:apply-templates select="ANCILLARIES"/>
   </xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;	  </xsl:text>
   </xsl:if>
   <xsl:text> USING </xsl:text>
   <xsl:value-of select="FUNCTIONNAME"/>
   <!-- Print a comma if this is not the last binding -->
   <xsl:if test="not(position()=last())">
    <xsl:text>,</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="ANCILLARIES">
  <!-- HACK! Should be a list -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;	 </xsl:text>
  </xsl:if>
  <xsl:text> ANCILLARY TO </xsl:text>
  <xsl:for-each select="ANCILLARIES_ITEM">
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Schema" select="PRIMOP_OBJ/OWNER_NAME"/>
    <xsl:with-param name="Object" select="PRIMOP_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:text>&#x20;</xsl:text>
   <xsl:apply-templates select="ARGS"/>
   <!-- Print a comma if this is not the last primary op for this ancillary -->
   <xsl:if test="not(position()=last())">
    <xsl:text>, </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="ARGS">
  <!-- Print new line if this is a new binding for this op: Not a new primary
     binding for an ancillary op.
  -->
  <xsl:if test="local-name(..)='BINDINGS_ITEM'">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;	</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:text>(</xsl:text>
  <xsl:for-each select="ARGS_ITEM">
   <xsl:variable name="TypeVal" select="TYPE"/>
   <xsl:choose>
    <!-- If TYPE contains a '.', its an ADT and we have to parse and add quotes
     to the schema and name pieces. Otherwise, its a base type like 'VARCHAR2'
     and we just move the contents into the DDL string as is.
  -->
    <xsl:when test="contains($TypeVal,'.')">
     <xsl:call-template name="QuoteObject">
      <xsl:with-param name="Schema" select="substring-before($TypeVal,'.')"/>
      <xsl:with-param name="Object" select="substring-after($TypeVal,'.')"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="TYPE"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
    <!-- Put out a comma if not the last col, ')' if it is -->
    <xsl:when test="not(position()=last())">
     <xsl:text>, </xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>)</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
