/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model.spi;
import java.io.IOException;
import java.io.Reader;

import java.net.URI;

import javax.ide.model.DocumentListener;

public interface DocumentImpl extends ElementImpl
{
  public URI getURI();
  
  public void setURI( URI uri );
  
  public boolean isOpen();
  
  public boolean isNew();
  
  public void open() throws IOException;
  
  public void close() throws IOException;
  
  public void save() throws IOException;
  
  public boolean isReadOnly();
  
  public boolean isDirty();
  
  public void markDirty( boolean dirty );
  
  public long getTimestamp();
  
  public Reader getReader() throws IOException;
  
  public void addDocumentListener( DocumentListener dl );
  
  public void removeDocumentListener( DocumentListener dl );
}
