/*
 * @(#)BlockT.java
 */

package javax.ide.model.java.source.tree;

import java.util.Collection;
import java.util.List;

/**
 * A code block. Blocks may be children of methods declarations,
 * constructor declarations, class initializers, and statements.  A
 * block may contain any child that extends BlockElementT, in
 * particular: ClassT, LocalVariableDeclT, StatementT,
 * SwitchLabelT. <p/>
 * 
 * @see BlockElementT
 *
 * @author Andy Yu
 */
public interface BlockT
  extends Tree
{
  // ----------------------------------------------------------------------

  /**
   * Gets the list of block elements. The only difference between 
   * getBlockElements() and getChildren() is the type. Notice that
   * getBlockElements() returns a List<BlockElementT> whereas getChildren
   * returns a List<Tree>. <p/>
   *
   * @return The array of block elements within this block. Always
   * non-null. Returns a collection of Tree's. <p/>
   *
   * List of BlockElementTs.
   */
  public List getBlockElements();

  /**
   * Gets the collection of local classes.
   *
   * @return The array of local classes. Returns a collection of
   * ClassT's. <p/>
   *
   * Collection of ClassTs.
   */
  public Collection getLocalClasses();

  /**
   * Gets the collection of local variables.
   *
   * @return The array of local variables. Returns a collection of
   * LocalVariableT's. <p/>
   *
   * List of LocalVariableTs.
   */
  public Collection getLocalVariables();


  // ----------------------------------------------------------------------
}
