package javax.ide.menu.spi;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;

/**
 * ContextMenuHookHelper acts as an element visitor for the ContextMenuHook
 * menu element, which can contain only a section element.
 * 
 * Each ContextMenuHookHelper is only called from a single thread, but
 * there may be multiple instances and each may be called multiple times.
 */
public class ContextMenuHookHelper extends ElementVisitor
{  
  public static final String KEY_SECTION_CONTAINER = MenuHook.KEY_SECTION_CONTAINER;
  public static final String KEY_MENU_MODEL = MenuHook.KEY_MENU_MODEL;
  
  private MenuModel _menuModel;
  private String _site;
  private String _popupId;
  
  private static int _uniqueId = 0;
  
  public ContextMenuHookHelper()
  {
  }
  
  public ContextMenuHookHelper(String site, MenuModel model)
  {
    _site = site;
    _menuModel = model;
  }
  
  public void setSite(String site)
  {
    _site = site;
    // For callers that reuse the same helper, reset the _popupId each time site is set.
    _popupId = null;
  }
  
  public String getPopupId()
  {
    return _popupId;
  }
  
  public MenuModel getMenuModel()
  {
    return _menuModel;
  }
  
  private MenuModel getMenuModel(ElementContext context)
  {
    if (_menuModel == null)
    {
      _menuModel = (MenuModel) context.getScopeData().get( MenuHook.KEY_MENU_MODEL );
      if (_menuModel == null)
      {
        _menuModel = new MenuModel();
      }
    }
    return _menuModel;
  }
  
  private synchronized String createUniquePopupId()
  {
    _popupId = _site + '_'+(++_uniqueId);
    return _popupId;
  }
  
  public void start( ElementStartContext context )
  {
    if ( _site != null )
    {
      // This code more or less copied from MenusVisitor$PopupVisitor.
      
      MenuModel model = getMenuModel(context);
      
      // JSR198 code assumes MenuModel already in context, so just to be
      // on the safe side, store it there
      context.getScopeData().put( MenuHook.KEY_MENU_MODEL, model );
      
      PopupMenu popup = model.findOrCreatePopupMenu( createUniquePopupId() );
      context.getScopeData().put( MenuHook.KEY_SECTION_CONTAINER, popup );
      
      context.registerChildVisitor( SectionVisitor.SECTION, new SectionVisitor() );
    }
  }
}
