/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension;

/**
 * An element visitor that processes xml elements of type i18n_char. If 
 * the element has an rskey attribute and an ancestor extension element defined
 * a bundle using the rsbundle attribute, this implementation will use 
 * ResourceBundle.getBundle() to load a string resource from the bundle class.
 * If no rskey attribute is present, the text of the element will be used 
 * instead. In either case, {@link #characterValue( ElementContext, char )} 
 * is called with the first non-whitespace character of the resulting string.<p>
 * 
 * An error is logged if the rskey attribute is present on the element but no
 * rsbundle was defined in an ancestor extension element.
 */
public abstract class I18NCharVisitor extends ElementVisitor
{
  private final I18NStringVisitor _delegate = new I18NStringVisitor() 
  {
    protected void string( ElementContext context, String value )
    {
      characterValue( context, value.trim().charAt( 0 ) );
    }
  };
  
  public final void start( ElementStartContext context )
  {
    _delegate.start( context );
  }
  
  public final void end( ElementEndContext context )
  {
    _delegate.end( context );
  }
  
  protected abstract void characterValue( ElementContext context, char value );
}
