drop materialized view MD_REGEX_MVIEW;
drop materialized view MD_REGEX_SCHEMA_MVIEW;
drop materialized view MD_REGEX_CATALOG_MVIEW;
drop table MD_CODE_REGEX;
CREATE TABLE MD_CODE_REGEX
   (	ID NUMBER NOT NULL ENABLE, 
      REGEX VARCHAR2(100 BYTE) NOT NULL ENABLE, 
      DESCRIPTION VARCHAR2(200 BYTE) NOT NULL ENABLE
   ) ;

   COMMENT ON COLUMN MD_CODE_REGEX.ID IS 'ID of regex for searching source code';
   COMMENT ON COLUMN MD_CODE_REGEX.REGEX IS 'Regex to use in reports of artifiacts in code.  This will be used for customers to analyze what is in their code.';


--
Insert into MD_CODE_REGEX (ID,REGEX,DESCRIPTION) values (1,'\#[A-Z1-9\@\#\_]','Temporary tables');
Insert into MD_CODE_REGEX (ID,REGEX,DESCRIPTION) values (2,'INSERT','Insert statements');
Insert into MD_CODE_REGEX (ID,REGEX,DESCRIPTION) values (3,'SELECT','Select statements');
Insert into MD_CODE_REGEX (ID,REGEX,DESCRIPTION) values (4,'UPDATE','Update Statements');
Insert into MD_CODE_REGEX (ID,REGEX,DESCRIPTION) values (5,'DELETE','Delete Statements');

CREATE MATERIALIZED VIEW "REPO"."MD_REGEX_MVIEW" ("PROJECT_NAME", "PROJECT_ID", "CONNECTION_ID", "CONNECTION_NAME", "CATALOG_ID", "CATALOG_NAME", "SCHEMA_ID", "SCHEMA_NAME", "PROGRAM_ID", "PROGRAM_NAME", "ITEM", "VALUE")
  ORGANIZATION HEAP PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  BUILD IMMEDIATE
  USING INDEX 
  REFRESH FORCE ON DEMAND
  USING DEFAULT LOCAL ROLLBACK SEGMENT
  USING ENFORCED CONSTRAINTS DISABLE QUERY REWRITE
  AS
SELECT  pr.PROJECT_NAME, pr.ID "PROJECT_ID", c.ID "CONNECTION_ID", c.NAME "CONNECTION_NAME", mc.ID "CATALOG_ID",
        mc.CATALOG_NAME,s.id "SCHEMA_ID",s.NAME "SCHEMA_NAME", p.ID "PROGRAM_ID", p.name "PROGRAM_NAME",
        rg.DESCRIPTION "ITEM", regexp_count(p.native_sql,rg.REGEX,1,'ix') "VALUE"
FROM MD_STORED_PROGRAMS p,
  md_projects pr,
  md_connections c,
  md_schemas s,
  MD_CATALOGS mc,
  MD_CODE_REGEX rg
WHERE c.TYPE          IS NULL --Shows captured
AND mc.CONNECTION_ID_FK=c.id
AND mc.id              =s.CATALOG_ID_FK
AND pr.PROJECT_NAME LIKE 'SS%'
and pr.id=c.PROJECT_ID_FK
and p.SCHEMA_ID_FK=s.ID
and regexp_count(p.native_sql,rg.REGEX,1,'ix')>0;




CREATE MATERIALIZED VIEW "REPO"."MD_REGEX_SCHEMA_MVIEW" ( "PROJECT_ID", "CONNECTION_ID", "CONNECTION_NAME", "CATALOG_ID", "CATALOG_NAME", "SCHEMA_ID", "SCHEMA_NAME", "ITEM", "VALUE")
  ORGANIZATION HEAP PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  BUILD IMMEDIATE
  USING INDEX 
  REFRESH FORCE ON DEMAND
  USING DEFAULT LOCAL ROLLBACK SEGMENT
  USING ENFORCED CONSTRAINTS DISABLE QUERY REWRITE
  AS
SELECT  PROJECT_ID, CONNECTION_ID, CONNECTION_NAME,CATALOG_ID,
        CATALOG_NAME,SCHEMA_ID,SCHEMA_NAME, ITEM, SUM(VALUE) "VALUE" from MD_REGEX_MVIEW
        group by PROJECT_NAME, PROJECT_ID, CONNECTION_ID, CONNECTION_NAME,CATALOG_ID,
        CATALOG_NAME,SCHEMA_ID,SCHEMA_NAME, ITEM;

CREATE MATERIALIZED VIEW "REPO"."MD_REGEX_CATALOG_MVIEW" ( "PROJECT_ID", "CONNECTION_ID", "CONNECTION_NAME", "CATALOG_ID", "CATALOG_NAME",   "ITEM", "VALUE")
  ORGANIZATION HEAP PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  BUILD IMMEDIATE
  USING INDEX 
  REFRESH FORCE ON DEMAND
  USING DEFAULT LOCAL ROLLBACK SEGMENT
  USING ENFORCED CONSTRAINTS DISABLE QUERY REWRITE
  AS
SELECT  PROJECT_ID, CONNECTION_ID, CONNECTION_NAME,CATALOG_ID,
        CATALOG_NAME, ITEM, SUM(VALUE) "VALUE" from MD_REGEX_SCHEMA_MVIEW
        group by  PROJECT_ID, CONNECTION_ID, CONNECTION_NAME,CATALOG_ID,
        CATALOG_NAME, ITEM;


UPDATE MD_REPOVERSIONS SET REVISION=60;
commit;
