CREATE OR REPLACE TYPE name_and_count_t IS OBJECT (
  OBJECT_NAME varchar2(30),
  UPDATE_COUNT INTEGER);
 /
 CREATE OR REPLACE TYPE name_and_count_array IS VARRAY(30) OF name_and_count_t;
 /
CREATE OR REPLACE TYPE OBJECTIDLIST IS TABLE OF INTEGER;
/
CREATE OR REPLACE TYPE NAMELIST IS TABLE OF VARCHAR2(40);
/
CREATE OR REPLACE TYPE MIGR_FILTER IS OBJECT (
  FILTER_TYPE INTEGER, -- Filter Types are 0-> ALL, 1->NAMELIST, 2->WHERE CLAUSE, 3->OBJECTID LIST
  OBJTYPE VARCHAR2(40),
  OBJECTIDS OBJECTIDLIST,
  NAMES NAMELIST,
  WHERECLAUSE VARCHAR2(1000));
/
CREATE OR REPLACE TYPE MIGR_FILTER_SET IS TABLE OF MIGR_FILTER;
/

CREATE OR REPLACE TRIGGER "MD_ADDITIONAL_PROPERTY_TRG" BEFORE INSERT OR UPDATE ON MD_ADDITIONAL_PROPERTIES 
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_ADDITIONAL_PROPERTY_TRG" ENABLE;
 
CREATE OR REPLACE TRIGGER "MD_CATALOGS_TRG" BEFORE INSERT OR UPDATE ON MD_CATALOGS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_CATALOGS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_COLUMNS_TRG" BEFORE INSERT OR UPDATE ON MD_COLUMNS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_COLUMNS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_PARTITIONS_TRG" BEFORE INSERT OR UPDATE ON MD_PARTITIONS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_PARTITIONS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_CONNECTIONS_TRG" BEFORE INSERT OR UPDATE ON MD_CONNECTIONS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_CONNECTIONS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_CONSTRAINT_DETAILS_TRG" BEFORE INSERT OR UPDATE ON MD_CONSTRAINT_DETAILS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_CONSTRAINT_DETAILS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_CONSTRAINTS_TRG" BEFORE INSERT OR UPDATE ON MD_CONSTRAINTS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_CONSTRAINTS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_DERIVATIVES_TRG" BEFORE INSERT OR UPDATE ON MD_DERIVATIVES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_DERIVATIVES_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_GROUP_MEMBERS_TRG" BEFORE INSERT OR UPDATE ON MD_GROUP_MEMBERS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_GROUP_MEMBERS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_GROUPS_TRG" BEFORE INSERT OR UPDATE ON MD_GROUPS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_GROUPS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_INDEX_DETAILS_TRG" BEFORE INSERT OR UPDATE ON MD_INDEX_DETAILS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_INDEX_DETAILS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_INDEXES_TRG" BEFORE INSERT OR UPDATE ON MD_INDEXES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_INDEXES_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_OTHER_OBJECTS_TRG" BEFORE INSERT OR UPDATE ON MD_OTHER_OBJECTS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_OTHER_OBJECTS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_PACKAGES_TRG" BEFORE INSERT OR UPDATE ON MD_PACKAGES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_PACKAGES_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_PRIVILEGES_TRG" BEFORE INSERT OR UPDATE ON MD_PRIVILEGES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_PRIVILEGES_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_PROJECTS_TRG" BEFORE INSERT OR UPDATE ON MD_PROJECTS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_PROJECTS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_SCHEMAS_TRG" BEFORE INSERT OR UPDATE ON MD_SCHEMAS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_SCHEMAS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_SEQUENCES_TRG" BEFORE INSERT OR UPDATE ON MD_SEQUENCES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_SEQUENCES_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_STORED_PROGRAMS_TRG" BEFORE INSERT OR UPDATE ON MD_STORED_PROGRAMS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_STORED_PROGRAMS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_SYNONYMS_TRG" BEFORE INSERT OR UPDATE ON MD_SYNONYMS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_SYNONYMS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_TABLES_TRG" BEFORE INSERT OR UPDATE ON MD_TABLES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_TABLES_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_TABLESPACES_TRG" BEFORE INSERT OR UPDATE ON MD_TABLESPACES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_TABLESPACES_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_TRIGGERS_TRG" BEFORE INSERT OR UPDATE ON MD_TRIGGERS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_TRIGGERS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_USER_DEFINED_DATA_TYPES_TRG" BEFORE INSERT OR UPDATE ON MD_USER_DEFINED_DATA_TYPES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_USER_DEFINED_DATA_TYPES_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_USERS_TRG" BEFORE INSERT OR UPDATE ON MD_USERS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_USERS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_VIEWS_TRG" BEFORE INSERT OR UPDATE ON MD_VIEWS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_VIEWS_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_GROUP_PRIVILEGES_TRG" BEFORE INSERT OR UPDATE ON MD_GROUP_PRIVILEGES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_GROUP_PRIVILEGES_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "MD_USER_PRIVILEGES_TRG" BEFORE INSERT OR UPDATE ON MD_USER_PRIVILEGES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER TRIGGER "MD_USER_PRIVILEGES_TRG" ENABLE;

-- Trigger to ensure we keep MD_TRIGGERS clean
CREATE OR REPLACE TRIGGER "DEL_MD_TRIGGERS_T_TRG" AFTER DELETE ON MD_TABLES 
FOR EACH ROW 
BEGIN
  DELETE FROM MD_TRIGGERS WHERE MD_TRIGGERS.TABLE_OR_VIEW_ID_FK = :OLD.ID AND MD_TRIGGERS.TRIGGER_ON_FLAG = 'T';
END;
/
ALTER TRIGGER "DEL_MD_TRIGGERS_T_TRG" ENABLE;
-- Trigger to ensure we keep MD_TRIGGERS clean
CREATE OR REPLACE TRIGGER "DEL_MD_TRIGGERS_V_TRG" AFTER DELETE ON MD_VIEWS
FOR EACH ROW 
BEGIN
  DELETE FROM MD_TRIGGERS WHERE MD_TRIGGERS.TABLE_OR_VIEW_ID_FK = :OLD.ID AND MD_TRIGGERS.TRIGGER_ON_FLAG = 'V';
END;
/
ALTER TRIGGER "DEL_MD_TRIGGERS_V_TRG" ENABLE;


CREATE OR REPLACE TRIGGER "INS_APPLICATION_TRG" BEFORE INSERT OR UPDATE ON MD_APPLICATIONS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER  TRIGGER "INS_APPLICATION_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "INS_APPLICATIONFILE_TRG" BEFORE INSERT OR UPDATE ON MD_APPLICATIONFILES
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER  TRIGGER "INS_APPLICATIONFILE_TRG" ENABLE;

CREATE OR REPLACE TRIGGER "INS_FILE_ARTIFACT_TRG" BEFORE INSERT OR UPDATE ON MD_FILE_ARTIFACTS
FOR EACH ROW
BEGIN
  if inserting and :new.id is null then
        :new.id := MD_META.get_next_id;
    end if;
END;
/
ALTER  TRIGGER "INS_FILE_ARTIFACT_TRG" ENABLE;
