/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import oracle.kv.impl.security.PasswordManager;
import oracle.kv.impl.security.PasswordStore;
import oracle.kv.impl.security.PasswordStoreException;
import oracle.kv.impl.security.util.PasswordReader;
import oracle.kv.impl.security.util.SecurityUtils;
import oracle.kv.impl.util.SecurityShell;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;

class WalletCommand
extends CommandWithSubs {
    WalletCommand() {
        super(Arrays.asList(new WalletCreate(), new WalletLogin(), new WalletSecret(), new WalletPassphrase()), "wallet", 4, 1);
    }

    @Override
    public String getCommandOverview() {
        return "The wallet command allows creation and modification of an Oracle wallet.";
    }

    private static PasswordStore openStore(File walletLoc, Shell shell) throws Exception {
        PasswordManager pwdMgr = PasswordManager.load("oracle.kv.impl.security.wallet.WalletManager");
        PasswordStore wallet = pwdMgr.getStoreHandle(walletLoc);
        PasswordReader pwdReader = ((SecurityShell)shell).getPasswordReader();
        if (!wallet.exists()) {
            throw new ShellException("The store does not yet exist");
        }
        char[] pwd = null;
        if (wallet.requiresPassphrase()) {
            pwd = pwdReader.readPassword("Enter the current wallet passphrase: ");
        }
        wallet.open(pwd);
        return wallet;
    }

    private static final class WalletPassphrase
    extends CommandWithSubs.SubCommand {
        private static final String PASSPHRASE_COMMAND_NAME = "passphrase";
        private static final String PASSPHRASE_COMMAND_DESC = "Modify passphrase for an Oracle Wallet.";
        private static final String PASSPHRASE_COMMAND_ARGS = "-directory <wallet directory> [-autologin]";

        private WalletPassphrase() {
            super(PASSPHRASE_COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            String dir = null;
            boolean autologin = false;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-directory".equals(arg) || arg.startsWith("-dir") && "-directory".startsWith(arg)) {
                    dir = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-autologin".equals(arg) || arg.startsWith("-auto") && "-autologin".startsWith(arg)) {
                    autologin = true;
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (dir == null) {
                shell.badArgCount(this);
            }
            return this.doPassphrase(dir, autologin, shell);
        }

        @Override
        public String getCommandSyntax() {
            return "wallet passphrase -directory <wallet directory> [-autologin]";
        }

        @Override
        public String getCommandDescription() {
            return PASSPHRASE_COMMAND_DESC;
        }

        @Override
        protected boolean isHidden() {
            return true;
        }

        private String doPassphrase(String dir, boolean autologin, Shell shell) throws ShellException {
            try {
                PasswordReader pwdReader = ((SecurityShell)shell).getPasswordReader();
                PasswordStore wallet = WalletCommand.openStore(new File(dir), shell);
                if (!autologin) {
                    char[] passphrase = pwdReader.readPassword("Enter a new passphrase for the  store: ");
                    if (!wallet.isValidPassphrase(passphrase)) {
                        shell.println("That is not a valid passphrase");
                    } else {
                        char[] verifyPassphrase = pwdReader.readPassword("Re-enter the passphrase for verification: ");
                        if (SecurityUtils.passwordsMatch(passphrase, verifyPassphrase)) {
                            wallet.setPassphrase(passphrase);
                            shell.println("Passphrase set");
                        } else {
                            shell.println("The passwords do not match");
                        }
                    }
                } else {
                    wallet.setPassphrase(null);
                    shell.println("Set to autologin");
                }
                return "";
            }
            catch (ShellException se) {
                throw se;
            }
            catch (PasswordStoreException pwse) {
                throw new ShellException("PasswordStore error: " + pwse.getMessage(), pwse);
            }
            catch (Exception e) {
                throw new ShellException("Unknown error: " + e.getMessage(), e);
            }
        }
    }

    private static final class WalletLogin
    extends CommandWithSubs.SubCommand {
        private static final String LOGIN_COMMAND_NAME = "login";
        private static final String LOGIN_COMMAND_DESC = "Manipulate logins in an Oracle Wallet.";
        private static final String LOGIN_COMMAND_ARGS = "-directory <wallet directory> {-set [-secret <secret>] -database <db> -user <username>} | {-delete -database <db> -user <username>} | {-list}";

        private WalletLogin() {
            super(LOGIN_COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Action action;
            String dir = null;
            String user = null;
            String db = null;
            String secret = null;
            EnumSet<Action> actions = EnumSet.noneOf(Action.class);
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-directory".equals(arg) || "-dir".equals(arg)) {
                    dir = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-database".equals(arg) || "-db".equals(arg)) {
                    db = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-user".equals(arg)) {
                    user = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-set".equals(arg)) {
                    actions.add(Action.SET);
                    continue;
                }
                if ("-list".equals(arg)) {
                    actions.add(Action.LIST);
                    continue;
                }
                if ("-delete".equals(arg)) {
                    actions.add(Action.DELETE);
                    continue;
                }
                if ("-secret".equals(arg)) {
                    secret = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (dir == null || actions.size() != 1) {
                shell.badArgCount(this);
            }
            if (((action = (Action)((Object)actions.iterator().next())) == Action.SET || action == Action.DELETE) && db == null) {
                shell.badArgCount(this);
            }
            if (action == Action.SET && user == null) {
                shell.badArgCount(this);
            }
            if (action == Action.LIST && (db != null || user != null)) {
                shell.badArgCount(this);
            }
            return this.doLogin(dir, action, user, db, secret, shell);
        }

        @Override
        public String getCommandSyntax() {
            return "wallet login -directory <wallet directory> {-set [-secret <secret>] -database <db> -user <username>} | {-delete -database <db> -user <username>} | {-list}";
        }

        @Override
        public String getCommandDescription() {
            return LOGIN_COMMAND_DESC;
        }

        @Override
        protected boolean isHidden() {
            return true;
        }

        private String doLogin(String dir, Action action, String user, String db, String secretArg, Shell shell) throws ShellException {
            try {
                PasswordStore wallet = WalletCommand.openStore(new File(dir), shell);
                PasswordReader pwdReader = ((SecurityShell)shell).getPasswordReader();
                PasswordStore.LoginId loginId = new PasswordStore.LoginId(db, user);
                if (action == Action.SET) {
                    char[] verifySecret;
                    char[] secret;
                    if (secretArg != null) {
                        verifySecret = secret = secretArg.toCharArray();
                    } else {
                        secret = pwdReader.readPassword("Enter the secret value to store: ");
                        verifySecret = pwdReader.readPassword("Re-enter the secret value for verification: ");
                    }
                    if (SecurityUtils.passwordsMatch(secret, verifySecret)) {
                        if (wallet.setLogin(loginId, secret)) {
                            shell.println("Login updated");
                        } else {
                            shell.println("Login created");
                        }
                        wallet.save();
                    } else {
                        shell.println("The passwords do not match");
                    }
                } else if (action == Action.DELETE) {
                    PasswordStore.LoginId walletLoginId = wallet.getLoginId(loginId.getDatabase());
                    if (walletLoginId != null) {
                        if (loginId.getUser() == null || loginId.getUser().equals(walletLoginId.getUser())) {
                            wallet.deleteLogin(loginId.getDatabase());
                            wallet.save();
                            shell.println("Login deleted");
                        } else {
                            shell.println("The specified user does not match the wallet entry");
                        }
                    } else {
                        shell.println("Login did not exist");
                    }
                } else if (action == Action.LIST) {
                    Collection<PasswordStore.LoginId> logins = wallet.getLogins();
                    if (logins.size() == 0) {
                        shell.println("The wallet contains no logins");
                    } else {
                        shell.println("The wallet contains the following logins:");
                        for (PasswordStore.LoginId lid : logins) {
                            shell.println("   " + lid.getDatabase() + " as " + lid.getUser());
                        }
                    }
                }
                return "";
            }
            catch (ShellException se) {
                throw se;
            }
            catch (PasswordStoreException pwse) {
                throw new ShellException("PasswordStore error: " + pwse.getMessage(), pwse);
            }
            catch (Exception e) {
                throw new ShellException("Unknown error: " + e.getMessage(), e);
            }
        }
    }

    private static final class WalletSecret
    extends CommandWithSubs.SubCommand {
        private static final String SECRET_COMMAND_NAME = "secret";
        private static final String SECRET_COMMAND_DESC = "Manipulate secrets in an Oracle Wallet.";
        private static final String SECRET_COMMAND_ARGS = "-directory <wallet directory> {-set [-secret <secret>] | -delete -alias <aliasname>} | {-list}";

        private WalletSecret() {
            super(SECRET_COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Action action;
            String dir = null;
            String alias = null;
            String secret = null;
            EnumSet<Action> actions = EnumSet.noneOf(Action.class);
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-directory".equals(arg) || "-dir".equals(arg)) {
                    dir = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-alias".equals(arg)) {
                    alias = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-set".equals(arg)) {
                    actions.add(Action.SET);
                    continue;
                }
                if ("-list".equals(arg)) {
                    actions.add(Action.LIST);
                    continue;
                }
                if ("-delete".equals(arg)) {
                    actions.add(Action.DELETE);
                    continue;
                }
                if ("-secret".equals(arg)) {
                    secret = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (dir == null || actions.size() != 1) {
                shell.badArgCount(this);
            }
            if (((action = (Action)((Object)actions.iterator().next())) == Action.SET || action == Action.DELETE) && alias == null) {
                shell.badArgCount(this);
            }
            if (action == Action.LIST && alias != null) {
                shell.badArgCount(this);
            }
            return this.doSecret(dir, action, alias, secret, shell);
        }

        @Override
        public String getCommandSyntax() {
            return "wallet secret -directory <wallet directory> {-set [-secret <secret>] | -delete -alias <aliasname>} | {-list}";
        }

        @Override
        public String getCommandDescription() {
            return SECRET_COMMAND_DESC;
        }

        private String doSecret(String dir, Action action, String alias, String secretArg, Shell shell) throws ShellException {
            try {
                PasswordStore wallet = WalletCommand.openStore(new File(dir), shell);
                PasswordReader pwdReader = ((SecurityShell)shell).getPasswordReader();
                if (action == Action.SET) {
                    char[] verifySecret;
                    char[] secret;
                    if (secretArg != null) {
                        verifySecret = secret = secretArg.toCharArray();
                    } else {
                        secret = pwdReader.readPassword("Enter the secret value to store: ");
                        verifySecret = pwdReader.readPassword("Re-enter the secret value for verification: ");
                    }
                    if (SecurityUtils.passwordsMatch(secret, verifySecret)) {
                        if (wallet.setSecret(alias, secret)) {
                            shell.println("Secret updated");
                        } else {
                            shell.println("Secret created");
                        }
                        wallet.save();
                    } else {
                        shell.println("The passwords do not match");
                    }
                } else if (action == Action.DELETE) {
                    if (wallet.deleteSecret(alias)) {
                        wallet.save();
                        shell.println("Secret deleted");
                    } else {
                        shell.println("Secret did not exist");
                    }
                } else if (action == Action.LIST) {
                    Collection<String> secretAliases = wallet.getSecretAliases();
                    if (secretAliases.size() == 0) {
                        shell.println("The wallet contains no secrets");
                    } else {
                        shell.println("The wallet contains the following secrets:");
                        for (String s : secretAliases) {
                            shell.println("   " + s);
                        }
                    }
                }
                return "OK";
            }
            catch (ShellException se) {
                throw se;
            }
            catch (PasswordStoreException pwse) {
                throw new ShellException("PasswordStore error: " + pwse.getMessage(), pwse);
            }
            catch (Exception e) {
                throw new ShellException("Unknown error: " + e.getMessage(), e);
            }
        }
    }

    private static final class WalletCreate
    extends CommandWithSubs.SubCommand {
        private static final String CREATE_COMMAND_NAME = "create";
        private static final String CREATE_COMMAND_DESC = "Creates a new Oracle Wallet.";
        private static final String CREATE_COMMAND_ARGS = "-directory <wallet directory>";

        private WalletCreate() {
            super(CREATE_COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String dir = null;
            boolean autologin = true;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-directory".equals(arg) || arg.startsWith("-dir") && "-directory".startsWith(arg)) {
                    dir = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (dir == null) {
                shell.requiredArg("-directory", this);
            }
            return this.doCreate(dir, true, shell);
        }

        private String doCreate(String dir, boolean autologin, Shell shell) throws ShellException {
            SecurityShell secShell = (SecurityShell)shell;
            try {
                PasswordManager pwdMgr = PasswordManager.load("oracle.kv.impl.security.wallet.WalletManager");
                File walletLoc = new File(dir);
                PasswordStore wallet = pwdMgr.getStoreHandle(walletLoc);
                if (wallet.exists()) {
                    return "A wallet already exists at that location";
                }
                char[] pwd = null;
                if (!autologin) {
                    PasswordReader pwdReader = secShell.getPasswordReader();
                    pwd = pwdReader.readPassword("Enter a passphrase to protect the wallet: ");
                    if (!wallet.isValidPassphrase(pwd)) {
                        return "The specified password is not acceptable.";
                    }
                    char[] pwd2 = pwdReader.readPassword("Re-enter the passphrase for verification: ");
                    if (!SecurityUtils.passwordsMatch(pwd, pwd2)) {
                        return "The two passphrases do not match.";
                    }
                }
                wallet.create(pwd);
                return "Created";
            }
            catch (PasswordStoreException pwse) {
                throw new ShellException("PasswordStore error: " + pwse.getMessage(), pwse);
            }
            catch (Exception e) {
                throw new ShellException("Unknown error: " + e.getMessage(), e);
            }
        }

        @Override
        public String getCommandSyntax() {
            return "wallet create -directory <wallet directory>";
        }

        @Override
        public String getCommandDescription() {
            return CREATE_COMMAND_DESC;
        }
    }

    private static enum Action {
        SET,
        DELETE,
        LIST;

    }
}

