/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.je.rep.NodeType;
import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ObjectUtil;

@Persistent(version=1)
public class Datacenter
extends Topology.Component<DatacenterId> {
    private static final long serialVersionUID = 1L;
    private static final DatacenterType DEFAULT_DATACENTER_TYPE = DatacenterType.PRIMARY;
    private String name;
    private int repFactor;

    public static Datacenter newInstance(String name, int repFactor, DatacenterType datacenterType) {
        ObjectUtil.checkNull("datacenterType", (Object)datacenterType);
        switch (datacenterType) {
            case PRIMARY: {
                return new Datacenter(name, repFactor);
            }
            case SECONDARY: {
                return new DatacenterV2(name, repFactor, datacenterType);
            }
        }
        throw new AssertionError();
    }

    private Datacenter(String name, int repFactor) {
        this.name = name;
        this.repFactor = repFactor;
        if (repFactor < 1) {
            throw new IllegalArgumentException("Replication factor must be greater than or equal to 1");
        }
    }

    private Datacenter(Datacenter datacenter) {
        super(datacenter);
        this.name = datacenter.name;
        this.repFactor = datacenter.repFactor;
    }

    private Datacenter() {
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.DATACENTER;
    }

    public String getName() {
        return this.name;
    }

    public int getRepFactor() {
        return this.repFactor;
    }

    public void setRepFactor(int factor) {
        this.repFactor = factor;
    }

    public DatacenterType getDatacenterType() {
        return DEFAULT_DATACENTER_TYPE;
    }

    @Override
    public Datacenter clone() {
        return new Datacenter(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Datacenter other = (Datacenter)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.repFactor == other.repFactor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id=" + this.getResourceId() + " name=" + this.name + " repFactor=" + this.repFactor + " type=" + (Object)((Object)this.getDatacenterType()));
        return sb.toString();
    }

    @Persistent
    private static class DatacenterV2
    extends Datacenter {
        private static final long serialVersionUID = 1L;
        private DatacenterType datacenterType;

        DatacenterV2(String name, int repFactor, DatacenterType datacenterType) {
            super(name, repFactor);
            ObjectUtil.checkNull("datacenterType", (Object)datacenterType);
            this.datacenterType = datacenterType;
        }

        private DatacenterV2(DatacenterV2 datacenter) {
            super(datacenter);
            this.datacenterType = datacenter.datacenterType;
        }

        private DatacenterV2() {
        }

        @Override
        public DatacenterType getDatacenterType() {
            return this.datacenterType;
        }

        @Override
        public DatacenterV2 clone() {
            return new DatacenterV2(this);
        }
    }

    public static class ServerUtil {
        public static NodeType getDefaultRepNodeType(Datacenter dc) {
            return ServerUtil.getDefaultRepNodeType(dc.getDatacenterType());
        }

        public static NodeType getDefaultRepNodeType(DatacenterType type) {
            switch (type) {
                case PRIMARY: {
                    return NodeType.ELECTABLE;
                }
                case SECONDARY: {
                    return NodeType.SECONDARY;
                }
            }
            throw new AssertionError();
        }
    }
}

