/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.admin.DdlHandler;
import oracle.kv.impl.admin.SecurityDdlOperation;
import oracle.kv.impl.admin.TableDdlOperation;
import oracle.kv.impl.api.table.ArrayBuilder;
import oracle.kv.impl.api.table.MapBuilder;
import oracle.kv.impl.api.table.RecordBuilder;
import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableBuilderBase;
import oracle.kv.impl.api.table.TableEvolver;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.api.table.query.DdlException;
import oracle.kv.impl.api.table.query.ParseException;
import oracle.kv.impl.api.table.query.TableBaseListener;
import oracle.kv.impl.api.table.query.TableLexer;
import oracle.kv.impl.api.table.query.TableParser;
import oracle.kv.impl.security.util.SecurityUtils;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;

public class TableDdl
extends TableBaseListener {
    private final TableMetadata metadata;
    private TableImpl table;
    private DdlException ddlException;
    private String errorMessage;
    private final Stack<TableBuilderBase> builders = new Stack();
    private final Stack<String> fieldNames = new Stack();
    private final Stack<Field> fields = new Stack();
    private boolean ifNotExists;
    private boolean ifExists;
    private boolean isDrop;
    private boolean isEvolve;
    private boolean isDescribe;
    private boolean isShow;
    private boolean describeAsJson;
    private boolean showIndexes;
    private boolean showTables;
    private String tableName;
    private String indexName;
    private String indexComment;
    private String[] fieldArray;
    private HashSet<String> generatedNames = new HashSet();
    private DdlHandler.DdlOperation ddlOperation;
    private static final String KEYOF_TAG = "_key";
    private static final String ELEMENTOF_TAG = "[]";
    private static final String ALL_PRIVS = "ALL";

    TableDdl() {
        this.metadata = null;
    }

    TableDdl(DdlException de) {
        this.metadata = null;
        this.setDdlException(de);
    }

    TableDdl(TableMetadata metadata) {
        this.metadata = metadata;
    }

    public TableImpl getTable() {
        return this.table;
    }

    public DdlException getDdlException() {
        return this.ddlException;
    }

    public void setDdlException(DdlException de) {
        this.ddlException = de;
        this.errorMessage = de.getMessage();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean succeeded() {
        return this.ddlException == null && this.errorMessage == null;
    }

    public boolean isTableCreate() {
        return !this.isEvolve && this.table != null && !this.isDescribe && !this.isShow;
    }

    public boolean isTableEvolve() {
        return this.isEvolve && this.table != null;
    }

    public boolean isIndexAdd() {
        return !this.isDrop && !this.isDescribe && !this.isShow && this.tableName != null && this.indexName != null;
    }

    public boolean isTableDrop() {
        return this.isDrop && this.tableName != null && this.indexName == null;
    }

    public boolean isIndexDrop() {
        return this.isDrop && this.tableName != null && this.indexName != null;
    }

    public boolean isDescribe() {
        return this.isDescribe;
    }

    public boolean isShow() {
        return this.isShow;
    }

    public boolean isDescribeAsJson() {
        return this.describeAsJson;
    }

    public boolean isShowIndexes() {
        return this.showIndexes;
    }

    public boolean isShowTables() {
        return this.showTables;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public boolean getRemoveData() {
        return true;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexComment() {
        return this.indexComment;
    }

    public String[] getFieldArray() {
        return this.fieldArray;
    }

    public static TableDdl parse() throws DdlException {
        return TableDdl.parse(System.in, null);
    }

    public static TableDdl parse(String input, TableMetadata meta) throws DdlException {
        ANTLRInputStream antlrStream = new ANTLRInputStream(input.toCharArray(), input.length());
        return TableDdl.parse(antlrStream, meta);
    }

    public static TableDdl parse(InputStream input, TableMetadata meta) throws DdlException {
        try {
            ANTLRInputStream antlrStream = new ANTLRInputStream(input);
            return TableDdl.parse(antlrStream, meta);
        }
        catch (IOException ioe) {
            throw new DdlException(ioe);
        }
    }

    private static TableDdl parse(ANTLRInputStream input, TableMetadata meta) throws DdlException {
        TableLexer lexer = new TableLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        TableParser parser = new TableParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new DdlErrorListener());
        TableParser.ParseContext tree = null;
        try {
            tree = parser.parse();
        }
        catch (RecognitionException re) {
            return new TableDdl(new DdlException(re));
        }
        catch (DdlException de) {
            return new TableDdl(de);
        }
        ParseTreeWalker walker = new ParseTreeWalker();
        TableDdl ddl = new TableDdl(meta);
        try {
            walker.walk((ParseTreeListener)ddl, (ParseTree)tree);
        }
        catch (DdlException de) {
            ddl.setDdlException(de);
        }
        return ddl;
    }

    public DdlHandler.DdlOperation getDdlOperation() {
        return this.ddlOperation;
    }

    @Override
    public void enterCreate_table_statement(@NotNull TableParser.Create_table_statementContext ctx) {
        TableParser.Table_defContext table_def;
        String name = TableDdl.getNamePath(ctx.name_path(), false);
        TableImpl parentTable = this.getParentTable(ctx.name_path());
        if (ctx.IF_NOT_EXISTS() != null) {
            this.ifNotExists = true;
        }
        if ((table_def = ctx.table_def()).comment() != null && table_def.comment().size() > 1) {
            throw new ParseException("Table definition may contain only one comment");
        }
        if (table_def.key_def() == null || table_def.key_def().isEmpty() || table_def.key_def().size() > 1) {
            throw new ParseException("Table definition must contain a single primary key definition");
        }
        this.builders.push(TableBuilder.createTableBuilder(name, null, parentTable));
    }

    @Override
    public void exitCreate_table_statement(@NotNull TableParser.Create_table_statementContext ctx) {
        TableBuilder tbb = (TableBuilder)this.builders.pop();
        assert (tbb != null && this.builders.empty());
        try {
            this.table = tbb.buildTable();
        }
        catch (Exception e) {
            throw new DdlException("Invalid table state: " + e.getMessage());
        }
        this.ddlOperation = new TableDdlOperation.CreateTable(this.table, this.ifNotExists);
    }

    @Override
    public void enterAlter_table_statement(@NotNull TableParser.Alter_table_statementContext ctx) {
        String name = TableDdl.getNamePath(ctx.name_path());
        TableImpl currentTable = this.getTable(name);
        if (currentTable == null) {
            TableDdl.noTable(name);
        }
        this.builders.push(TableEvolver.createTableEvolver(currentTable));
        this.isEvolve = true;
    }

    @Override
    public void exitAlter_table_statement(@NotNull TableParser.Alter_table_statementContext ctx) {
        TableEvolver evolver = (TableEvolver)this.builders.pop();
        this.table = evolver.evolveTable();
        this.ddlOperation = new TableDdlOperation.EvolveTable(this.table);
    }

    @Override
    public void enterKey_def(@NotNull TableParser.Key_defContext ctx) {
        try {
            if (ctx.shard_key_def() == null) {
                if (ctx.id_list() == null) {
                    throw new ParseException("PRIMARY KEY must contain a list of fields");
                }
                this.builders.peek().primaryKey(TableDdl.makeIdArray(ctx.id_list().extended_id()));
                return;
            }
            List<TableParser.Extended_idContext> shardKeyList = ctx.shard_key_def().simple_field_list().id_list_with_paren().id_list().extended_id();
            this.builders.peek().shardKey(TableDdl.makeIdArray(shardKeyList));
            ArrayList<TableParser.Extended_idContext> pkey = new ArrayList<TableParser.Extended_idContext>(shardKeyList);
            if (ctx.id_list() != null) {
                pkey.addAll(ctx.id_list().extended_id());
            }
            this.builders.peek().primaryKey(TableDdl.makeIdArray(pkey));
        }
        catch (IllegalArgumentException iae) {
            throw new DdlException(iae.getMessage());
        }
    }

    @Override
    public void enterField_def(@NotNull TableParser.Field_defContext ctx) {
        String name = TableDdl.getNamePath(ctx.name_path());
        this.fieldNames.push(name);
    }

    @Override
    public void exitField_def(@NotNull TableParser.Field_defContext ctx) {
        this.fieldNames.pop();
    }

    @Override
    public void enterNot_null(@NotNull TableParser.Not_nullContext ctx) {
        Field field = this.fields.peek();
        field.setNotNullable();
    }

    @Override
    public void enterComment(@NotNull TableParser.CommentContext ctx) {
        if (!this.fields.isEmpty()) {
            this.fields.peek().setComment(TableDdl.stripFirstLast(ctx.STRING().getText()));
        } else if (!this.builders.isEmpty()) {
            this.builders.peek().setDescription(TableDdl.stripFirstLast(ctx.STRING().getText()));
        }
    }

    @Override
    public void enterArray(@NotNull TableParser.ArrayContext ctx) {
        this.builders.push(TableBuilder.createArrayBuilder());
    }

    @Override
    public void exitArray(@NotNull TableParser.ArrayContext ctx) {
        ArrayBuilder arrayBuilder = (ArrayBuilder)this.builders.pop();
        TableBuilderBase builder = this.builders.peek();
        String name = builder.isCollectionBuilder() ? null : this.fieldNames.peek();
        builder.addField(name, arrayBuilder.build());
    }

    @Override
    public void enterMap(@NotNull TableParser.MapContext ctx) {
        this.builders.push(TableBuilder.createMapBuilder());
    }

    @Override
    public void exitMap(@NotNull TableParser.MapContext ctx) {
        MapBuilder mapBuilder = (MapBuilder)this.builders.pop();
        TableBuilderBase builder = this.builders.peek();
        String name = builder.isCollectionBuilder() ? null : this.fieldNames.peek();
        builder.addField(name, mapBuilder.build());
    }

    @Override
    public void enterRecord(@NotNull TableParser.RecordContext ctx) {
        TableBuilderBase builder = this.builders.peek();
        String name = builder.isCollectionBuilder() ? this.generateFieldNameInternal("RECORD") : this.fieldNames.peek();
        this.builders.push(TableBuilder.createRecordBuilder(name));
    }

    @Override
    public void exitRecord(@NotNull TableParser.RecordContext ctx) {
        RecordBuilder recordBuilder = (RecordBuilder)this.builders.pop();
        TableBuilderBase builder = this.builders.peek();
        String name = builder.isCollectionBuilder() ? null : this.fieldNames.peek();
        builder.addField(name, recordBuilder.build());
    }

    @Override
    public void enterString(@NotNull TableParser.StringContext ctx) {
        this.fields.push(new StringField(TableDdl.getFieldName(ctx)));
    }

    @Override
    public void exitString(@NotNull TableParser.StringContext ctx) {
        Field field = this.fields.pop();
        this.addToBuilder(field);
    }

    @Override
    public void enterString_default(@NotNull TableParser.String_defaultContext ctx) {
        Field field = this.fields.peek();
        String defaultString = TableDdl.stripFirstLast(ctx.STRING().getText());
        field.setDefault(defaultString);
    }

    @Override
    public void enterExpr(@NotNull TableParser.ExprContext ctx) {
        block16: {
            String name;
            Field field = this.fields.peek();
            String value = null;
            if (ctx.extended_id() != null) {
                name = ctx.extended_id().getText();
                field.validateExpressionId(name);
            } else if (!ctx.elementof_expr().name_path().isEmpty()) {
                name = TableDdl.getNamePath(ctx.elementof_expr().name_path(0));
                TableBuilderBase builder = this.builders.peek();
                if (!(builder instanceof ArrayBuilder) && !(builder instanceof MapBuilder)) {
                    throw new ParseException("elementof() is only valid inside of an array or map definition");
                }
                if (!name.equalsIgnoreCase(this.fieldNames.peek())) {
                    throw new ParseException("Invalid identifer in elementof() expression. Expected " + this.fieldNames.peek() + ", found " + name);
                }
            }
            if (ctx.STRING() != null) {
                if (!(field instanceof StringField)) {
                    throw new ParseException("Type cannot accept quoted strings in expressions: " + field.getType());
                }
                value = TableDdl.stripFirstLast(ctx.STRING().getText());
            } else if (ctx.FLOAT() != null) {
                value = ctx.FLOAT().getText();
            } else if (ctx.INT() != null) {
                value = ctx.INT().getText();
            }
            assert (value != null);
            String op = ctx.OP().getText();
            try {
                if (op.equals(">") || op.equals(">=")) {
                    field.setMin(value, op.equals(">="));
                    break block16;
                }
                if (op.equals("<") || op.equals("<=")) {
                    field.setMax(value, op.equals("<="));
                    break block16;
                }
                throw new IllegalStateException("Unexpected operation: " + op);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Invalid numeric value for type " + field.getType() + ": " + value);
            }
        }
    }

    @Override
    public void enterInt(@NotNull TableParser.IntContext ctx) {
        boolean isLong;
        boolean bl = isLong = ctx.integer_def().LONG_T() != null;
        if (isLong) {
            this.fields.push(new LongField(TableDdl.getFieldName(ctx)));
        } else {
            this.fields.push(new IntField(TableDdl.getFieldName(ctx)));
        }
    }

    @Override
    public void exitInt(@NotNull TableParser.IntContext ctx) {
        Field field = this.fields.pop();
        this.addToBuilder(field);
    }

    @Override
    public void enterInteger_default(@NotNull TableParser.Integer_defaultContext ctx) {
        Field field = this.fields.peek();
        String defaultString = ctx.INT().getText();
        field.setDefault(defaultString);
    }

    @Override
    public void enterBinary(@NotNull TableParser.BinaryContext ctx) {
        int size = 0;
        if (ctx.binary_def().INT() != null) {
            size = Integer.parseInt(ctx.binary_def().INT().getText());
        }
        this.fields.push(new BinaryField(TableDdl.getFieldName(ctx), size));
    }

    @Override
    public void exitBinary(@NotNull TableParser.BinaryContext ctx) {
        Field field = this.fields.pop();
        this.addToBuilder(field);
    }

    @Override
    public void enterFloat(@NotNull TableParser.FloatContext ctx) {
        boolean isDouble;
        boolean bl = isDouble = ctx.float_def().DOUBLE_T() != null;
        if (isDouble) {
            this.fields.push(new DoubleField(TableDdl.getFieldName(ctx)));
        } else {
            this.fields.push(new FloatField(TableDdl.getFieldName(ctx)));
        }
    }

    @Override
    public void exitFloat(@NotNull TableParser.FloatContext ctx) {
        Field field = this.fields.pop();
        this.addToBuilder(field);
    }

    @Override
    public void enterFloat_default(@NotNull TableParser.Float_defaultContext ctx) {
        Field field = this.fields.peek();
        TerminalNode node = ctx.FLOAT() != null ? ctx.FLOAT() : ctx.INT();
        String defaultString = node.getText();
        field.setDefault(defaultString);
    }

    @Override
    public void enterBoolean(@NotNull TableParser.BooleanContext ctx) {
        this.fields.push(new BooleanField(TableDdl.getFieldName(ctx)));
    }

    @Override
    public void exitBoolean(@NotNull TableParser.BooleanContext ctx) {
        Field field = this.fields.pop();
        this.addToBuilder(field);
    }

    @Override
    public void enterBoolean_constraint(@NotNull TableParser.Boolean_constraintContext ctx) {
        Field field = this.fields.peek();
        if (ctx.DEFAULT() != null) {
            String val = ctx.BOOLEAN_VALUE().getText();
            field.setDefault(val);
        }
    }

    @Override
    public void enterEnum(@NotNull TableParser.EnumContext ctx) {
        String[] values = TableDdl.makeIdArray(ctx.enum_def().id_list_with_paren().id_list().extended_id());
        this.fields.push(new EnumField(TableDdl.getFieldName(ctx), values));
    }

    @Override
    public void enterEnum_constraint(@NotNull TableParser.Enum_constraintContext ctx) {
        Field field = this.fields.peek();
        if (ctx.extended_id() != null) {
            field.setDefault(ctx.extended_id().getText());
        }
    }

    @Override
    public void exitEnum(@NotNull TableParser.EnumContext ctx) {
        Field field = this.fields.pop();
        this.addToBuilder(field);
    }

    @Override
    public void enterDrop_field_statement(@NotNull TableParser.Drop_field_statementContext ctx) {
        TableBuilderBase builder = this.builders.peek();
        String name = TableDdl.getNamePath(ctx.name_path());
        try {
            builder.removeField(name);
        }
        catch (IllegalArgumentException iae) {
            throw new DdlException(iae.getMessage(), iae);
        }
    }

    @Override
    public void enterModify_field_statement(@NotNull TableParser.Modify_field_statementContext ctx) {
        throw new DdlException("MODIFY is not supported at this time");
    }

    @Override
    public void enterCreate_index_statement(@NotNull TableParser.Create_index_statementContext ctx) {
        if (ctx.IF_NOT_EXISTS() != null) {
            this.ifNotExists = true;
        }
        this.tableName = TableDdl.getNamePath(ctx.name_path());
        this.indexName = ctx.index_name().extended_id().getText();
        this.fieldArray = TableDdl.makeNameArray(ctx.complex_field_list().path_list().complex_name_path());
        if (ctx.comment() != null) {
            this.indexComment = TableDdl.stripFirstLast(ctx.comment().STRING().getText());
        }
        this.table = this.getTable(this.tableName);
        this.ddlOperation = new TableDdlOperation.CreateIndex(this.table, this.tableName, this.indexName, this.fieldArray, this.indexComment, this.ifNotExists);
    }

    @Override
    public void enterDrop_index_statement(@NotNull TableParser.Drop_index_statementContext ctx) {
        this.isDrop = true;
        if (ctx.IF_EXISTS() != null) {
            this.ifExists = true;
        }
        this.tableName = TableDdl.getNamePath(ctx.name_path());
        this.indexName = ctx.index_name().extended_id().getText();
        this.table = this.getTableSilently(this.tableName);
        this.ddlOperation = new TableDdlOperation.DropIndex(this.tableName, this.table, this.indexName, this.ifExists);
    }

    @Override
    public void enterDrop_table_statement(@NotNull TableParser.Drop_table_statementContext ctx) {
        this.isDrop = true;
        if (ctx.IF_EXISTS() != null) {
            this.ifExists = true;
        }
        this.tableName = TableDdl.getNamePath(ctx.name_path());
        this.table = this.getTableSilently(this.tableName);
        this.ddlOperation = new TableDdlOperation.DropTable(this.tableName, this.table, this.ifExists, this.getRemoveData());
    }

    @Override
    public void enterDescribe_statement(@NotNull TableParser.Describe_statementContext ctx) {
        if (ctx.name_path() != null) {
            this.tableName = TableDdl.getNamePath(ctx.name_path());
            if (this.getTable(this.tableName) == null) {
                TableDdl.noTable(this.tableName);
            }
            if (ctx.complex_field_list() != null) {
                this.fieldArray = TableDdl.makeNameArray(ctx.complex_field_list().path_list().complex_name_path());
            }
            if (ctx.index_name() != null) {
                this.indexName = ctx.index_name().extended_id().getText();
            }
        }
        this.isDescribe = true;
        this.describeAsJson = ctx.AS_JSON() != null;
        this.ddlOperation = new TableDdlOperation.DescribeTable(this.tableName, this.indexName, this.fieldArray, this.describeAsJson);
    }

    @Override
    public void enterShow_statement(@NotNull TableParser.Show_statementContext ctx) {
        this.ddlOperation = TableDdl.getShowUserOrRoleOp(ctx);
        if (this.ddlOperation != null) {
            this.isShow = true;
            return;
        }
        if (ctx.name_path() != null) {
            this.tableName = TableDdl.getNamePath(ctx.name_path());
            if (this.getTable(this.tableName) == null) {
                TableDdl.noTable(this.tableName);
            }
            if (ctx.INDEXES() != null) {
                this.showIndexes = true;
            }
        } else {
            assert (ctx.TABLES() != null);
            this.showTables = true;
        }
        this.isShow = true;
        this.describeAsJson = ctx.AS_JSON() != null;
        this.ddlOperation = new TableDdlOperation.ShowTableOrIndex(this.tableName, this.showTables, this.showIndexes, this.describeAsJson);
    }

    @Override
    public void exitCreate_user_statement(@NotNull TableParser.Create_user_statementContext ctx) {
        boolean passExpired;
        String userName = TableDdl.getIdentifierName(ctx.identifier(), "user");
        boolean isAdmin = ctx.ADMIN() != null;
        boolean bl = passExpired = ctx.PASSWORD_EXPIRE() != null;
        boolean isEnabled = ctx.account_lock() != null ? !TableDdl.isAccountLocked(ctx.account_lock()) : true;
        Long pwdLifetimeInMillis = ctx.password_lifetime() == null ? null : Long.valueOf(TableDdl.resolvePassLifeTime(ctx.password_lifetime()));
        char[] plainPass = TableDdl.resolvePlainPassword(ctx.identified_clause());
        if (passExpired) {
            pwdLifetimeInMillis = -1L;
        }
        this.ddlOperation = new SecurityDdlOperation.CreateUser(userName, isEnabled, isAdmin, plainPass, pwdLifetimeInMillis);
        SecurityUtils.clearPassword(plainPass);
    }

    @Override
    public void exitCreate_role_statement(@NotNull TableParser.Create_role_statementContext ctx) {
        String roleName = TableDdl.getIdentifierName(ctx.identifier(), "role");
        this.ddlOperation = new SecurityDdlOperation.CreateRole(roleName);
    }

    @Override
    public void exitAlter_user_statement(@NotNull TableParser.Alter_user_statementContext ctx) {
        Boolean isEnabled;
        Long pwdLifetimeInMillis;
        String userName = TableDdl.getIdentifierName(ctx.identifier(), "user");
        boolean retainPassword = false;
        char[] newPass = null;
        TableParser.Reset_password_clauseContext resetPassCtx = ctx.reset_password_clause();
        if (resetPassCtx != null) {
            newPass = TableDdl.resolvePlainPassword(resetPassCtx.identified_clause());
            retainPassword = resetPassCtx.RETAIN_CURRENT_PASSWORD() != null;
        }
        boolean clearRetainedPassword = ctx.CLEAR_RETAINED_PASSWORD() != null;
        boolean passwordExpire = ctx.PASSWORD_EXPIRE() != null;
        Long l = pwdLifetimeInMillis = ctx.password_lifetime() == null ? null : Long.valueOf(TableDdl.resolvePassLifeTime(ctx.password_lifetime()));
        Boolean bl = ctx.account_lock() != null ? Boolean.valueOf(!TableDdl.isAccountLocked(ctx.account_lock())) : (isEnabled = null);
        if (passwordExpire) {
            pwdLifetimeInMillis = -1L;
        }
        this.ddlOperation = new SecurityDdlOperation.AlterUser(userName, isEnabled, newPass, retainPassword, clearRetainedPassword, pwdLifetimeInMillis);
        SecurityUtils.clearPassword(newPass);
    }

    @Override
    public void exitDrop_user_statement(@NotNull TableParser.Drop_user_statementContext ctx) {
        String userName = TableDdl.getIdentifierName(ctx.identifier(), "user");
        this.ddlOperation = new SecurityDdlOperation.DropUser(userName, false);
    }

    @Override
    public void exitDrop_role_statement(@NotNull TableParser.Drop_role_statementContext ctx) {
        String roleName = TableDdl.getIdentifierName(ctx.identifier(), "role");
        this.ddlOperation = new SecurityDdlOperation.DropRole(roleName);
    }

    @Override
    public void exitGrant_statement(@NotNull TableParser.Grant_statementContext ctx) {
        HashSet<String> privSet = new HashSet<String>();
        if (ctx.grant_roles() != null) {
            String[] roleNames = TableDdl.makeIdArray(ctx.grant_roles().id_list().extended_id());
            if (ctx.grant_roles().principal().USER() != null) {
                assert (ctx.grant_roles().principal().ROLE() == null);
                String grantee = TableDdl.getIdentifierName(ctx.grant_roles().principal().identifier(), "user");
                this.ddlOperation = new SecurityDdlOperation.GrantRoles(grantee, roleNames);
            } else {
                String grantee = TableDdl.getIdentifierName(ctx.grant_roles().principal().identifier(), "role");
                this.ddlOperation = new SecurityDdlOperation.GrantRolesToRole(grantee, roleNames);
            }
            return;
        }
        if (ctx.grant_system_privileges() != null) {
            List<TableParser.Priv_itemContext> privItemList = ctx.grant_system_privileges().sys_priv_list().priv_item();
            TableDdl.getPrivSet(privItemList, privSet);
            String roleName = TableDdl.getIdentifierName(ctx.grant_system_privileges().identifier(), "role");
            this.ddlOperation = new SecurityDdlOperation.GrantPrivileges(roleName, null, privSet);
            return;
        }
        if (ctx.grant_object_privileges() != null) {
            if (!ctx.grant_object_privileges().obj_priv_list().ALL().isEmpty()) {
                privSet.add(ALL_PRIVS);
            } else {
                List<TableParser.Priv_itemContext> privItemList = ctx.grant_object_privileges().obj_priv_list().priv_item();
                TableDdl.getPrivSet(privItemList, privSet);
            }
            String roleName = TableDdl.getIdentifierName(ctx.grant_object_privileges().identifier(), "role");
            String onTable = TableDdl.getNamePath(ctx.grant_object_privileges().object().name_path());
            this.ddlOperation = new SecurityDdlOperation.GrantPrivileges(roleName, onTable, privSet);
        }
    }

    @Override
    public void exitRevoke_statement(@NotNull TableParser.Revoke_statementContext ctx) {
        HashSet<String> privSet = new HashSet<String>();
        if (ctx.revoke_roles() != null) {
            String[] roleNames = TableDdl.makeIdArray(ctx.revoke_roles().id_list().extended_id());
            if (ctx.revoke_roles().principal().USER() != null) {
                assert (ctx.revoke_roles().principal().ROLE() == null);
                String revokee = TableDdl.getIdentifierName(ctx.revoke_roles().principal().identifier(), "user");
                this.ddlOperation = new SecurityDdlOperation.RevokeRoles(revokee, roleNames);
            } else {
                String revokee = TableDdl.getIdentifierName(ctx.revoke_roles().principal().identifier(), "role");
                this.ddlOperation = new SecurityDdlOperation.RevokeRolesFromRole(revokee, roleNames);
            }
            return;
        }
        if (ctx.revoke_system_privileges() != null) {
            List<TableParser.Priv_itemContext> privItemList = ctx.revoke_system_privileges().sys_priv_list().priv_item();
            TableDdl.getPrivSet(privItemList, privSet);
            String roleName = TableDdl.getIdentifierName(ctx.revoke_system_privileges().identifier(), "role");
            this.ddlOperation = new SecurityDdlOperation.RevokePrivileges(roleName, null, privSet);
            return;
        }
        if (ctx.revoke_object_privileges() != null) {
            if (!ctx.revoke_object_privileges().obj_priv_list().ALL().isEmpty()) {
                privSet.add(ALL_PRIVS);
            } else {
                List<TableParser.Priv_itemContext> privItemList = ctx.revoke_object_privileges().obj_priv_list().priv_item();
                TableDdl.getPrivSet(privItemList, privSet);
            }
            String roleName = TableDdl.getIdentifierName(ctx.revoke_object_privileges().identifier(), "role");
            String onTable = TableDdl.getNamePath(ctx.revoke_object_privileges().object().name_path());
            this.ddlOperation = new SecurityDdlOperation.RevokePrivileges(roleName, onTable, privSet);
        }
    }

    private static SecurityDdlOperation getShowUserOrRoleOp(TableParser.Show_statementContext ctx) {
        boolean asJson;
        boolean bl = asJson = ctx.AS_JSON() != null;
        if (ctx.identifier() != null) {
            if (ctx.USER() != null) {
                String name = TableDdl.getIdentifierName(ctx.identifier(), "user");
                return new SecurityDdlOperation.ShowUser(name, asJson);
            }
            assert (ctx.ROLE() != null);
            String name = TableDdl.getIdentifierName(ctx.identifier(), "role");
            return new SecurityDdlOperation.ShowRole(name, asJson);
        }
        if (ctx.USERS() != null) {
            return new SecurityDdlOperation.ShowUser(null, asJson);
        }
        if (ctx.ROLES() != null) {
            return new SecurityDdlOperation.ShowRole(null, asJson);
        }
        return null;
    }

    private static boolean isAccountLocked(TableParser.Account_lockContext ctx) {
        if (ctx.LOCK() != null) {
            assert (ctx.UNLOCK() == null);
            return true;
        }
        return false;
    }

    private static String getIdentifierName(TableParser.IdentifierContext ctx, String idType) {
        if (ctx.extended_id() != null) {
            return ctx.extended_id().getText();
        }
        throw new ParseException("Invalid empty name of " + idType);
    }

    private static char[] resolvePlainPassword(TableParser.Identified_clauseContext ctx) {
        String passStr = ctx.by_password().STRING().getText();
        if (passStr.isEmpty() || passStr.length() <= 2) {
            throw new DdlException("Invalid empty password");
        }
        char[] result = new char[passStr.length() - 2];
        passStr.getChars(1, passStr.length() - 1, result, 0);
        return result;
    }

    private static long resolvePassLifeTime(TableParser.Password_lifetimeContext ctx) {
        long timeValue;
        try {
            timeValue = Integer.parseInt(ctx.duration().INT().getText());
            if (timeValue <= 0L) {
                throw new DdlException("Time value must not be zero or negative");
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Invalid numeric value for time value");
        }
        TimeUnit timeUnit = TableDdl.convertToTimeUnit(ctx.duration().TIME_UNIT().getText());
        return TimeUnit.MILLISECONDS.convert(timeValue, timeUnit);
    }

    private static TimeUnit convertToTimeUnit(String unitStr) {
        try {
            return TimeUnit.valueOf(unitStr.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            try {
                return DDLTimeUnit.valueOf(unitStr.toUpperCase(Locale.ENGLISH)).getUnit();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DdlException("Unrecognized time unit");
            }
        }
    }

    private String generateFieldNameInternal(String prefix) {
        String gen = "_gen";
        int num = 0;
        StringBuilder sb = new StringBuilder(prefix);
        sb.append("_gen");
        String name = sb.toString();
        while (this.generatedNames.contains(name)) {
            sb.append(num++);
            name = sb.toString();
        }
        this.generatedNames.add(name);
        return name;
    }

    private static String getNamePath(TableParser.Name_pathContext ctx) {
        return TableDdl.getNamePath(ctx, true);
    }

    private static String getNamePath(TableParser.Name_pathContext ctx, boolean fullName) {
        if (ctx.extended_id() != null) {
            return ctx.extended_id().getText();
        }
        String path = ctx.NAME_PATH().getText();
        if (fullName) {
            return path;
        }
        return path.substring(path.lastIndexOf(46) + 1);
    }

    private static String getComplexNamePath(TableParser.Complex_name_pathContext ctx) {
        if (ctx.name_path() != null) {
            return TableDdl.getNamePath(ctx.name_path(), true);
        }
        if (ctx.keyof_expr() != null) {
            ArrayList<TableParser.Name_pathContext> path = new ArrayList<TableParser.Name_pathContext>(1);
            path.add(ctx.keyof_expr().name_path());
            return TableDdl.translatePath(path, KEYOF_TAG);
        }
        if (ctx.elementof_expr() != null) {
            if (ctx.elementof_expr().name_path().isEmpty()) {
                throw new ParseException("Invalid empty elementof() expression");
            }
            return TableDdl.translatePath(ctx.elementof_expr().name_path(), ELEMENTOF_TAG);
        }
        throw new IllegalStateException("getComplexNamePath");
    }

    private static String translatePath(List<TableParser.Name_pathContext> name_paths, String tag) {
        int size = name_paths.size();
        assert (size > 0 && size <= 2);
        StringBuilder sb = new StringBuilder();
        sb.append(TableDdl.getNamePath(name_paths.get(0), true));
        sb.append(".");
        sb.append(tag);
        if (size == 2) {
            sb.append(".");
            sb.append(TableDdl.getNamePath(name_paths.get(1), true));
        }
        return sb.toString();
    }

    private TableImpl getParentTable(TableParser.Name_pathContext ctx) {
        if (ctx.extended_id() != null) {
            return null;
        }
        String fullPath = ctx.NAME_PATH().getText();
        String parentPath = fullPath.substring(0, fullPath.lastIndexOf(46));
        TableImpl parent = this.getTable(parentPath);
        if (parent == null) {
            TableDdl.noParentTable(parentPath, fullPath);
        }
        return parent;
    }

    private TableImpl getTable(String fullName) {
        if (this.metadata == null) {
            throw new DdlException("TableDdl: cannot get table, no metadata available: " + fullName);
        }
        return this.metadata.getTable(fullName);
    }

    private TableImpl getTableSilently(String fullName) {
        return this.metadata == null ? null : this.metadata.getTable(fullName);
    }

    private void addToBuilder(Field field) {
        try {
            field.addToBuilder();
        }
        catch (IllegalArgumentException iae) {
            throw new DdlException(iae.getMessage());
        }
    }

    private static String[] makeIdArray(List<TableParser.Extended_idContext> list) {
        String[] ids = new String[list.size()];
        int i = 0;
        for (TableParser.Extended_idContext idCtx : list) {
            ids[i++] = idCtx.getText();
        }
        return ids;
    }

    private static void getPrivSet(List<TableParser.Priv_itemContext> pCtxList, Set<String> privSet) {
        for (TableParser.Priv_itemContext privItem : pCtxList) {
            if (privItem.ALL_PRIVILEGES() != null) {
                privSet.add(ALL_PRIVS);
                continue;
            }
            privSet.add(TableDdl.getIdentifierName(privItem.identifier(), "privilege"));
        }
    }

    private static String[] makeNameArray(List<TableParser.Complex_name_pathContext> list) {
        String[] names = new String[list.size()];
        int i = 0;
        for (TableParser.Complex_name_pathContext path : list) {
            names[i++] = TableDdl.getComplexNamePath(path);
        }
        return names;
    }

    private static String stripFirstLast(String s) {
        return s.substring(1, s.length() - 1);
    }

    private static void noTable(String name) {
        throw new DdlException("Table does not exist: " + name);
    }

    private static void noParentTable(String parentName, String fullName) {
        throw new DdlException("Parent table does not exist (" + parentName + ") in table path " + fullName);
    }

    private static String getFieldName(TableParser.Type_defContext ctx) {
        if (ctx.parent instanceof TableParser.Field_defContext) {
            return TableDdl.getNamePath(((TableParser.Field_defContext)ctx.parent).name_path());
        }
        return null;
    }

    private static class DdlErrorListener
    extends BaseErrorListener {
        private DdlErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException re) {
            List stack = ((Parser)recognizer).getRuleInvocationStack();
            Collections.reverse(stack);
            String errorMsg = msg + ", at line " + line + ":" + charPositionInLine + "\nrule stack: " + stack;
            throw new ParseException(errorMsg);
        }
    }

    private class EnumField
    extends Field {
        String defaultValue;
        String[] values;

        EnumField(String fieldName, String[] values) {
            super(fieldName);
            this.values = values;
        }

        @Override
        void setDefault(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        String generateFieldName() {
            return TableDdl.this.generateFieldNameInternal("ENUM");
        }

        @Override
        void addToBuilder(TableBuilderBase builder, String name) {
            builder.addEnum(name, this.values, this.getComment(), this.getNullable(), this.defaultValue);
        }

        @Override
        String getType() {
            return "ENUM";
        }
    }

    private class DoubleField
    extends Field {
        Double defaultValue;
        Double min;
        Double max;

        DoubleField(String fieldName) {
            super(fieldName);
        }

        @Override
        void setMin(String minValue, boolean minInclusive) {
            if (minValue != null) {
                double d = Double.parseDouble(minValue);
                this.min = minInclusive ? d : Math.nextUp(d);
            }
        }

        @Override
        void setMax(String maxValue, boolean maxInclusive) {
            if (maxValue != null) {
                double d = Double.parseDouble(maxValue);
                this.max = maxInclusive ? d : Math.nextAfter(d, Double.NEGATIVE_INFINITY);
            }
        }

        @Override
        void setDefault(String defaultString) {
            this.defaultValue = Double.parseDouble(defaultString);
        }

        @Override
        void addToBuilder(TableBuilderBase builder, String name) {
            builder.addDouble(name, this.getComment(), this.getNullable(), this.defaultValue, this.min, this.max);
        }

        @Override
        String getType() {
            return "DOUBLE";
        }
    }

    private class FloatField
    extends Field {
        Float defaultValue;
        Float min;
        Float max;

        FloatField(String fieldName) {
            super(fieldName);
        }

        @Override
        void setMin(String minValue, boolean minInclusive) {
            if (minValue != null) {
                float f = Float.parseFloat(minValue);
                this.min = Float.valueOf(minInclusive ? f : Math.nextUp(f));
            }
        }

        @Override
        void setMax(String maxValue, boolean maxInclusive) {
            if (maxValue != null) {
                float f = Float.parseFloat(maxValue);
                this.max = Float.valueOf(maxInclusive ? f : Math.nextAfter(f, Double.NEGATIVE_INFINITY));
            }
        }

        @Override
        void setDefault(String defaultString) {
            this.defaultValue = Float.valueOf(Float.parseFloat(defaultString));
        }

        @Override
        void addToBuilder(TableBuilderBase builder, String name) {
            builder.addFloat(name, this.getComment(), this.getNullable(), this.defaultValue, this.min, this.max);
        }

        @Override
        String getType() {
            return "FLOAT";
        }
    }

    private class BinaryField
    extends Field {
        int size;

        BinaryField(String fieldName, int size) {
            super(fieldName);
            this.size = size;
        }

        @Override
        String generateFieldName() {
            if (this.size == 0) {
                return null;
            }
            return TableDdl.this.generateFieldNameInternal("BINARY");
        }

        @Override
        void addToBuilder(TableBuilderBase builder, String name) {
            if (this.size == 0) {
                builder.addBinary(name, this.getComment(), this.getNullable());
            } else {
                builder.addFixedBinary(name, this.size, this.getComment(), this.getNullable());
            }
        }

        @Override
        String getType() {
            return "BINARY";
        }
    }

    private class BooleanField
    extends Field {
        Boolean defaultValue;

        BooleanField(String fieldName) {
            super(fieldName);
        }

        @Override
        void setDefault(String defaultValue) {
            this.defaultValue = Boolean.parseBoolean(defaultValue);
        }

        @Override
        void addToBuilder(TableBuilderBase builder, String name) {
            builder.addBoolean(name, this.getComment(), this.getNullable(), this.defaultValue);
        }

        @Override
        String getType() {
            return "BOOLEAN";
        }
    }

    private class StringField
    extends Field {
        String defaultValue;
        String min;
        String max;
        Boolean minIncl;
        Boolean maxIncl;

        StringField(String fieldName) {
            super(fieldName);
        }

        @Override
        void setDefault(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        void setMin(String minValue, boolean minInclusive) {
            this.min = minValue;
            this.minIncl = minInclusive;
        }

        @Override
        void setMax(String maxValue, boolean maxInclusive) {
            this.max = maxValue;
            this.maxIncl = maxInclusive;
        }

        @Override
        void addToBuilder(TableBuilderBase builder, String name) {
            builder.addString(name, this.getComment(), this.getNullable(), this.defaultValue, this.min, this.max, this.minIncl, this.maxIncl);
        }

        @Override
        String getType() {
            return "STRING";
        }
    }

    private class LongField
    extends Field {
        Long defaultValue;
        Long min;
        Long max;

        LongField(String fieldName) {
            super(fieldName);
        }

        @Override
        void setMin(String minValue, boolean minInclusive) {
            if (minValue != null) {
                long l = Long.parseLong(minValue);
                this.min = minInclusive ? l : l + 1L;
            }
        }

        @Override
        void setMax(String maxValue, boolean maxInclusive) {
            if (maxValue != null) {
                long l = Long.parseLong(maxValue);
                this.max = maxInclusive ? l : l - 1L;
            }
        }

        @Override
        void setDefault(String defaultString) {
            this.defaultValue = Long.parseLong(defaultString);
        }

        @Override
        void addToBuilder(TableBuilderBase builder, String name) {
            builder.addLong(name, this.getComment(), this.getNullable(), this.defaultValue, this.min, this.max);
        }

        @Override
        String getType() {
            return "LONG";
        }
    }

    private class IntField
    extends Field {
        Integer defaultValue;
        Integer min;
        Integer max;

        IntField(String fieldName) {
            super(fieldName);
        }

        @Override
        void setMin(String minValue, boolean minInclusive) {
            if (minValue != null) {
                int i = Integer.parseInt(minValue);
                this.min = minInclusive ? i : i + 1;
            }
        }

        @Override
        void setMax(String maxValue, boolean maxInclusive) {
            if (maxValue != null) {
                int i = Integer.parseInt(maxValue);
                this.max = maxInclusive ? i : i - 1;
            }
        }

        @Override
        void setDefault(String defaultString) {
            this.defaultValue = Integer.parseInt(defaultString);
        }

        @Override
        void addToBuilder(TableBuilderBase builder, String name) {
            builder.addInteger(name, this.getComment(), this.getNullable(), this.defaultValue, this.min, this.max);
        }

        @Override
        String getType() {
            return "INTEGER";
        }
    }

    private abstract class Field {
        boolean notNullable;
        String comment;
        final String fieldName;
        static final String NO_NAME = "elementof()";

        Field(String fieldName) {
            this.fieldName = fieldName != null ? fieldName : NO_NAME;
        }

        void setNotNullable() {
            this.notNullable = true;
        }

        Boolean getNullable() {
            return !this.notNullable;
        }

        void setComment(String comment) {
            this.comment = comment;
        }

        String getComment() {
            return this.comment;
        }

        String generateFieldName() {
            return null;
        }

        void addToBuilder() {
            TableBuilderBase builder = (TableBuilderBase)TableDdl.this.builders.peek();
            String name = builder.isCollectionBuilder() ? this.generateFieldName() : (String)TableDdl.this.fieldNames.peek();
            this.addToBuilder(builder, name);
        }

        void validateExpressionId(String id) {
            if (!id.equalsIgnoreCase(this.fieldName)) {
                throw new ParseException("Invalid name for identifer in expression.  Expected " + this.fieldName + ", found " + id);
            }
        }

        void setMin(String minValue, boolean minInclusive) {
            throw new IllegalStateException("Type does not support ranges");
        }

        void setMax(String maxValue, boolean maxInclusive) {
            throw new IllegalStateException("Type does not support ranges");
        }

        void setDefault(String defaultString) {
            throw new IllegalStateException("Type does not support defaults");
        }

        abstract void addToBuilder(TableBuilderBase var1, String var2);

        abstract String getType();
    }

    static enum DDLTimeUnit {
        S{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.SECONDS;
            }
        }
        ,
        M{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.MINUTES;
            }
        }
        ,
        H{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.HOURS;
            }
        }
        ,
        D{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.DAYS;
            }
        };


        abstract TimeUnit getUnit();
    }
}

