/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.DurabilityException;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.Operation;
import oracle.kv.OperationExecutionException;
import oracle.kv.OperationFactory;
import oracle.kv.OperationResult;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiDeleteTable;
import oracle.kv.impl.api.ops.MultiGetTable;
import oracle.kv.impl.api.ops.MultiGetTableKeys;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.table.DeprecatedResults;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.IndexScan;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.ReturnRowImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.api.table.TableScan;
import oracle.kv.impl.api.table.TableVersionException;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.client.admin.DdlFuture;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.table.ExecutionFuture;
import oracle.kv.table.FieldRange;
import oracle.kv.table.IndexKey;
import oracle.kv.table.KeyPair;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.ReadOptions;
import oracle.kv.table.ReturnRow;
import oracle.kv.table.Row;
import oracle.kv.table.StatementResult;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;
import oracle.kv.table.TableOpExecutionException;
import oracle.kv.table.TableOperation;
import oracle.kv.table.TableOperationFactory;
import oracle.kv.table.TableOperationResult;
import oracle.kv.table.WriteOptions;

public class TableAPIImpl
implements TableAPI {
    static final String TABLE_PREFIX = "Tables";
    static final String SCHEMA_PREFIX = "Schemas";
    static final String SEPARATOR = ".";
    private final KVStoreImpl store;
    private final OpFactory opFactory;
    private final ConcurrentHashMap<String, TableImpl> fetchedTables;

    public TableAPIImpl(KVStoreImpl store) {
        this.store = store;
        this.opFactory = new OpFactory(store.getOperationFactory());
        this.fetchedTables = new ConcurrentHashMap();
    }

    @Override
    public Table getTable(String tableName) throws FaultException {
        Exception cause = null;
        TableImpl table = null;
        for (RepNodeId rnid : this.getRepNodeIds()) {
            try {
                cause = null;
                table = this.getTableFromRepNode(tableName, rnid);
                if (table == null) continue;
                return table;
            }
            catch (Exception e) {
                cause = e;
            }
        }
        if (cause != null) {
            String message = "Unable to find table " + tableName + ": " + cause.getMessage();
            throw new FaultException(message, cause, true);
        }
        return null;
    }

    @Override
    public Map<String, Table> getTables() throws FaultException {
        TableMetadata md = this.getTableMetadata();
        return md == null ? Collections.emptyMap() : md.getTables();
    }

    public TableMetadata getTableMetadata() throws FaultException {
        Exception cause = null;
        TableMetadata md = null;
        for (RepNodeId rnid : this.getRepNodeIds()) {
            try {
                cause = null;
                md = this.getTableMetadataFromRepNode(rnid);
                if (md == null) continue;
                return md;
            }
            catch (Exception e) {
                cause = e;
            }
        }
        if (cause != null) {
            String message = "Unable to get table metadata:" + cause.getMessage();
            throw new FaultException(message, cause, true);
        }
        return null;
    }

    @Override
    public Row get(PrimaryKey rowKeyArg, ReadOptions readOptions) throws FaultException {
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        Key key = rowKey.getPrimaryKey(false);
        ValueVersion vv = this.store.getInternal(key, rowKey.getTableImpl().getId(), TableAPIImpl.getConsistency(readOptions), TableAPIImpl.getTimeout(readOptions), TableAPIImpl.getTimeoutUnit(readOptions));
        if (vv == null) {
            return null;
        }
        return this.getRowFromValueVersion(vv, rowKey, true);
    }

    @Override
    public Version put(Row rowArg, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        RowImpl row = (RowImpl)rowArg;
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        Key key = row.getPrimaryKey(false);
        Value value = row.createValue();
        Version version = this.store.putInternal(key, value, rvv, row.getTableImpl().getId(), TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions));
        this.initReturnRow(prevRowArg, row, rvv);
        return version;
    }

    @Override
    public Version putIfAbsent(Row rowArg, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        RowImpl row = (RowImpl)rowArg;
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        Key key = row.getPrimaryKey(false);
        Value value = row.createValue();
        Version version = this.store.putIfAbsentInternal(key, value, rvv, row.getTableImpl().getId(), TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions));
        this.initReturnRow(prevRowArg, row, rvv);
        return version;
    }

    @Override
    public Version putIfPresent(Row rowArg, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        RowImpl row = (RowImpl)rowArg;
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        Key key = row.getPrimaryKey(false);
        Value value = row.createValue();
        Version version = this.store.putIfPresentInternal(key, value, rvv, row.getTableImpl().getId(), TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions));
        this.initReturnRow(prevRowArg, row, rvv);
        return version;
    }

    @Override
    public Version putIfVersion(Row rowArg, Version matchVersion, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        RowImpl row = (RowImpl)rowArg;
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        Key key = row.getPrimaryKey(false);
        Value value = row.createValue();
        Version version = this.store.putIfVersionInternal(key, value, matchVersion, rvv, row.getTableImpl().getId(), TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions));
        this.initReturnRow(prevRowArg, row, rvv);
        return version;
    }

    @Override
    @Deprecated
    public ExecutionFuture execute(String statement) throws IllegalArgumentException, FaultException {
        return new DeprecatedResults.ExecutionFutureWrapper(this.store.execute(statement));
    }

    @Override
    @Deprecated
    public StatementResult executeSync(String statement) throws FaultException {
        return new DeprecatedResults.StatementResultWrapper(this.store.executeSync(statement));
    }

    @Override
    @Deprecated
    public ExecutionFuture getFuture(int planId) {
        if (planId < 1) {
            throw new IllegalArgumentException("PlanId " + planId + " isn't valid, must be > 1");
        }
        byte[] futureBytes = DdlFuture.toByteArray(planId);
        return new DeprecatedResults.ExecutionFutureWrapper(this.store.getFuture(futureBytes));
    }

    @Override
    public List<Row> multiGet(PrimaryKey rowKeyArg, MultiRowOptions getOptions, ReadOptions readOptions) throws FaultException {
        boolean hasAncestorTables = false;
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        Table table = rowKey.getTable();
        TableKey key = TableKey.createKey(table, rowKey, true);
        if (!key.getMajorKeyComplete()) {
            throw new IllegalArgumentException("Cannot perform multiGet on a primary key without a complete major path");
        }
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, false);
            if (getOptions.getIncludedParentTables() != null) {
                hasAncestorTables = true;
            }
        }
        byte[] parentKeyBytes = this.store.getKeySerializer().toByteArray(key.getKey());
        PartitionId partitionId = this.store.getDispatcher().getPartitionId(parentKeyBytes);
        MultiGetTable get = new MultiGetTable(parentKeyBytes, TableAPIImpl.makeTargetTables(table, getOptions), TableAPIImpl.makeKeyRange(key, getOptions));
        Request req = this.store.makeReadRequest((InternalOperation)get, partitionId, TableAPIImpl.getConsistency(readOptions), TableAPIImpl.getTimeout(readOptions), TableAPIImpl.getTimeoutUnit(readOptions));
        Result result = this.store.executeRequest(req);
        return this.processMultiResults(table, result, hasAncestorTables);
    }

    @Override
    public List<PrimaryKey> multiGetKeys(PrimaryKey rowKeyArg, MultiRowOptions getOptions, ReadOptions readOptions) throws FaultException {
        boolean hasAncestorTables = false;
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        Table table = rowKey.getTable();
        TableKey key = TableKey.createKey(table, rowKey, true);
        if (!key.getMajorKeyComplete()) {
            throw new IllegalArgumentException("Cannot perform multiGet on a primary key without a complete major path");
        }
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, false);
            if (getOptions.getIncludedParentTables() != null) {
                hasAncestorTables = true;
            }
        }
        byte[] parentKeyBytes = this.store.getKeySerializer().toByteArray(key.getKey());
        PartitionId partitionId = this.store.getDispatcher().getPartitionId(parentKeyBytes);
        MultiGetTableKeys get = new MultiGetTableKeys(parentKeyBytes, TableAPIImpl.makeTargetTables(table, getOptions), TableAPIImpl.makeKeyRange(key, getOptions));
        Request req = this.store.makeReadRequest((InternalOperation)get, partitionId, TableAPIImpl.getConsistency(readOptions), TableAPIImpl.getTimeout(readOptions), TableAPIImpl.getTimeoutUnit(readOptions));
        Result result = this.store.executeRequest(req);
        List<byte[]> byteKeyResults = result.getKeyList();
        assert (result.getSuccess() == !byteKeyResults.isEmpty());
        return this.processMultiResults(table, byteKeyResults, hasAncestorTables);
    }

    @Override
    public TableIterator<Row> tableIterator(PrimaryKey rowKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        return this.tableIterator(rowKeyArg, getOptions, iterateOptions, null);
    }

    public TableIterator<Row> tableIterator(PrimaryKey rowKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, Set<Integer> partitions) throws FaultException {
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        Table table = rowKey.getTable();
        TableKey key = TableKey.createKey(table, rowKey, true);
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, false);
        }
        return TableScan.createTableIterator(this, key, getOptions, iterateOptions, partitions);
    }

    @Override
    public TableIterator<PrimaryKey> tableKeysIterator(PrimaryKey rowKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        Table table = rowKey.getTable();
        TableKey key = TableKey.createKey(table, rowKey, true);
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, false);
        }
        return TableScan.createTableKeysIterator(this, key, getOptions, iterateOptions);
    }

    @Override
    public boolean delete(PrimaryKey rowKeyArg, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        Key key = rowKey.getPrimaryKey(false);
        boolean retval = this.store.deleteInternal(key, rvv, TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions), rowKey.getTableImpl().getId());
        this.initReturnRow(prevRowArg, rowKey, rvv);
        return retval;
    }

    @Override
    public boolean deleteIfVersion(PrimaryKey rowKeyArg, Version matchVersion, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        Key key = rowKey.getPrimaryKey(false);
        boolean retval = this.store.deleteIfVersionInternal(key, matchVersion, rvv, TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions), rowKey.getTableImpl().getId());
        this.initReturnRow(prevRowArg, rowKey, rvv);
        return retval;
    }

    @Override
    public int multiDelete(PrimaryKey rowKeyArg, MultiRowOptions getOptions, WriteOptions writeOptions) throws FaultException {
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        Table table = rowKey.getTable();
        TableKey key = TableKey.createKey(table, rowKey, true);
        if (!key.getMajorKeyComplete()) {
            throw new IllegalArgumentException("Cannot perform multiDelete on a primary key without a complete major path.  Key: " + rowKey.toJsonString(false));
        }
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, false);
        }
        KeyRange keyRange = TableAPIImpl.makeKeyRange(key, getOptions);
        byte[] parentKeyBytes = this.store.getKeySerializer().toByteArray(key.getKey());
        PartitionId partitionId = this.store.getDispatcher().getPartitionId(parentKeyBytes);
        MultiDeleteTable del = new MultiDeleteTable(parentKeyBytes, TableAPIImpl.makeTargetTables(table, getOptions), keyRange);
        Request req = this.store.makeWriteRequest(del, partitionId, TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions));
        Result result = this.store.executeRequest(req);
        return result.getNDeletions();
    }

    @Override
    public TableIterator<Row> tableIterator(IndexKey indexKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        IndexKeyImpl indexKey = (IndexKeyImpl)indexKeyArg;
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, indexKey.getTable(), true);
        }
        return IndexScan.createTableIterator(this, indexKey, getOptions, iterateOptions);
    }

    @Override
    public TableIterator<KeyPair> tableKeysIterator(IndexKey indexKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        IndexKeyImpl indexKey = (IndexKeyImpl)indexKeyArg;
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, indexKey.getTable(), true);
        }
        return IndexScan.createTableKeysIterator(this, indexKey, getOptions, iterateOptions);
    }

    @Override
    public TableOperationFactory getTableOperationFactory() {
        return this.opFactory;
    }

    @Override
    public List<TableOperationResult> execute(List<TableOperation> operations, WriteOptions writeOptions) throws TableOpExecutionException, DurabilityException, FaultException {
        ArrayList<Operation> opList = new ArrayList<Operation>(operations.size());
        for (TableOperation op : operations) {
            opList.add(((OpWrapper)op).getOperation());
        }
        try {
            List<OperationResult> results = this.store.execute(opList, TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions));
            ArrayList<TableOperationResult> tableResults = new ArrayList<TableOperationResult>(results.size());
            int index = 0;
            for (OperationResult opRes : results) {
                PrimaryKey pkey = operations.get(index).getPrimaryKey();
                tableResults.add(new OpResultWrapper(this, opRes, pkey));
                ++index;
            }
            return tableResults;
        }
        catch (OperationExecutionException e) {
            int failedOpIndex = e.getFailedOperationIndex();
            PrimaryKey pkey = operations.get(failedOpIndex).getPrimaryKey();
            OperationResult result = e.getFailedOperationResult();
            OpResultWrapper failedResult = new OpResultWrapper(this, result, pkey);
            throw new TableOpExecutionException(operations.get(failedOpIndex), failedOpIndex, failedResult);
        }
    }

    RowImpl getRowFromValueVersion(ValueVersion vv, RowImpl row, boolean keyOnly) {
        int requiredVersion = 0;
        try {
            return row.rowFromValueVersion(vv, keyOnly);
        }
        catch (TableVersionException tve) {
            requiredVersion = tve.getRequiredVersion();
            assert (requiredVersion > row.getTable().getTableVersion());
            TableImpl newTable = this.fetchTable(row.getTable().getFullName(), requiredVersion);
            assert (requiredVersion == newTable.getTableVersion());
            newTable = (TableImpl)newTable.getVersion(row.getTable().getTableVersion());
            RowImpl newRow = newTable.createRow(row);
            return newRow.rowFromValueVersion(vv, keyOnly);
        }
    }

    TableImpl fetchTable(String tableName, int tableVersion) {
        TableImpl table = this.fetchedTables.get(tableName);
        if (table != null && table.numTableVersions() >= tableVersion) {
            return (TableImpl)table.getVersion(tableVersion);
        }
        table = (TableImpl)this.getTable(tableName);
        if (table != null && table.numTableVersions() >= tableVersion) {
            TableImpl t = this.fetchedTables.putIfAbsent(tableName, table);
            if (t != null && table.numTableVersions() > t.numTableVersions()) {
                this.fetchedTables.put(tableName, table);
            }
            return (TableImpl)table.getVersion(tableVersion);
        }
        throw new IllegalArgumentException("Table or version does not exist.  It may have been removed: " + tableName + ", version " + tableVersion);
    }

    KVStoreImpl getStore() {
        return this.store;
    }

    private Set<RepNodeId> getRepNodeIds() {
        return this.store.getDispatcher().getTopologyManager().getTopology().getRepNodeIds();
    }

    private TableImpl getTableFromRepNode(String tableName, RepNodeId rnid) throws Exception {
        RepNodeAdminAPI repNodeAdmin = this.store.getDispatcher().getRegUtils().getRepNodeAdmin(rnid);
        if (repNodeAdmin != null) {
            return (TableImpl)repNodeAdmin.getMetadata(Metadata.MetadataType.TABLE, new TableMetadata.TableMetadataKey(tableName).getMetadataKey(), 0);
        }
        return null;
    }

    private TableMetadata getTableMetadataFromRepNode(RepNodeId rnid) throws Exception {
        RepNodeAdminAPI repNodeAdmin = this.store.getDispatcher().getRegUtils().getRepNodeAdmin(rnid);
        if (repNodeAdmin != null) {
            return (TableMetadata)repNodeAdmin.getMetadata(Metadata.MetadataType.TABLE);
        }
        return null;
    }

    private ReturnValueVersion makeRVV(ReturnRow rr) {
        if (rr != null) {
            return ((ReturnRowImpl)rr).makeReturnValueVersion();
        }
        return null;
    }

    private void initReturnRow(ReturnRow rr, RowImpl key, ReturnValueVersion rvv) {
        if (rr != null) {
            ((ReturnRowImpl)rr).init(this, rvv, key);
        }
    }

    static KeyRange makeKeyRange(TableKey key, MultiRowOptions getOptions) {
        if (getOptions != null) {
            FieldRange range = getOptions.getFieldRange();
            if (range != null) {
                if (key.getKeyComplete()) {
                    throw new IllegalArgumentException("Cannot specify a FieldRange with a complete primary key");
                }
                key.validateFieldOrder(range);
                String start = null;
                String end = null;
                boolean startInclusive = true;
                boolean endInclusive = true;
                if (range.getStart() != null) {
                    start = ((FieldValueImpl)range.getStart()).formatForKey(range.getDefinition());
                    startInclusive = range.getStartInclusive();
                }
                if (range.getEnd() != null) {
                    end = ((FieldValueImpl)range.getEnd()).formatForKey(range.getDefinition());
                    endInclusive = range.getEndInclusive();
                }
                return new KeyRange(start, startInclusive, end, endInclusive);
            }
        } else {
            key.getRow().validate();
        }
        return null;
    }

    private List<PrimaryKey> processMultiResults(Table table, List<byte[]> keys, boolean hasAncestorTables) {
        ArrayList<PrimaryKey> list = new ArrayList<PrimaryKey>(keys.size());
        TableImpl t = (TableImpl)table;
        if (hasAncestorTables) {
            t = t.getTopLevelTable();
        }
        for (byte[] key : keys) {
            PrimaryKeyImpl pk = t.createPrimaryKeyFromKeyBytes(key);
            if (pk == null) continue;
            list.add(pk);
        }
        return list;
    }

    private List<Row> processMultiResults(Table table, Result result, boolean hasAncestorTables) {
        List<ResultKeyValueVersion> resultList = result.getKeyValueVersionList();
        ArrayList<Row> list = new ArrayList<Row>(resultList.size());
        TableImpl t = (TableImpl)table;
        if (hasAncestorTables) {
            t = t.getTopLevelTable();
        }
        for (ResultKeyValueVersion rkvv : result.getKeyValueVersionList()) {
            RowImpl row = t.createRowFromKeyBytes(rkvv.getKeyBytes());
            if (row == null) continue;
            ValueVersion vv = new ValueVersion(rkvv.getValue(), rkvv.getVersion());
            list.add(this.getRowFromValueVersion(vv, row, false));
        }
        return list;
    }

    private static void validateMultiRowOptions(MultiRowOptions mro, Table targetTable, boolean isIndex) {
        if (mro.getIncludedParentTables() != null) {
            for (Table t : mro.getIncludedParentTables()) {
                if (((TableImpl)targetTable).isAncestor(t)) continue;
                throw new IllegalArgumentException("Ancestor table \"" + t.getFullName() + "\" is not " + "an ancestor of target table \"" + targetTable.getFullName() + "\"");
            }
        }
        if (mro.getIncludedChildTables() != null) {
            if (isIndex) {
                throw new UnsupportedOperationException("Child table returns are not supported for index scan operations");
            }
            for (Table t : mro.getIncludedChildTables()) {
                if (((TableImpl)t).isAncestor(targetTable)) continue;
                throw new IllegalArgumentException("Child table \"" + t.getFullName() + "\" is not a " + "descendant of target table \"" + targetTable.getFullName() + "\"");
            }
        }
    }

    static Consistency getConsistency(ReadOptions opts) {
        return opts != null ? opts.getConsistency() : null;
    }

    static long getTimeout(ReadOptions opts) {
        return opts != null ? opts.getTimeout() : 0L;
    }

    static TimeUnit getTimeoutUnit(ReadOptions opts) {
        return opts != null ? opts.getTimeoutUnit() : null;
    }

    static Direction getDirection(TableIteratorOptions opts, TableKey key) {
        if (opts == null) {
            return key.getMajorKeyComplete() ? Direction.FORWARD : Direction.UNORDERED;
        }
        if (!key.getMajorKeyComplete() && opts.getDirection() != Direction.UNORDERED) {
            throw new IllegalArgumentException("Direction must be Direction.UNORDERED if major key is not complete");
        }
        return opts.getDirection();
    }

    static int getBatchSize(TableIteratorOptions opts) {
        return opts != null && opts.getResultsBatchSize() != 0 ? opts.getResultsBatchSize() : KVStoreImpl.DEFAULT_ITERATOR_BATCH_SIZE;
    }

    static Durability getDurability(WriteOptions opts) {
        return opts != null ? opts.getDurability() : null;
    }

    static long getTimeout(WriteOptions opts) {
        return opts != null ? opts.getTimeout() : 0L;
    }

    static TimeUnit getTimeoutUnit(WriteOptions opts) {
        return opts != null ? opts.getTimeoutUnit() : null;
    }

    static TargetTables makeTargetTables(Table target, MultiRowOptions getOptions) {
        List<Table> childTables = getOptions != null ? getOptions.getIncludedChildTables() : null;
        List<Table> ancestorTables = getOptions != null ? getOptions.getIncludedParentTables() : null;
        return new TargetTables(target, childTables, ancestorTables);
    }

    private static class OpFactory
    implements TableOperationFactory {
        private final OperationFactory factory;

        private OpFactory(OperationFactory factory) {
            this.factory = factory;
        }

        @Override
        public TableOperation createPut(Row rowArg, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            RowImpl row = (RowImpl)rowArg;
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            Key key = row.getPrimaryKey(false);
            Value value = row.createValue();
            Operation op = this.factory.createPut(key, value, choice, abortIfUnsuccessful);
            return new OpWrapper(op, TableOperation.Type.PUT, row);
        }

        @Override
        public TableOperation createPutIfAbsent(Row rowArg, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            RowImpl row = (RowImpl)rowArg;
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            Key key = row.getPrimaryKey(false);
            Value value = row.createValue();
            Operation op = this.factory.createPutIfAbsent(key, value, choice, abortIfUnsuccessful);
            return new OpWrapper(op, TableOperation.Type.PUT_IF_ABSENT, row);
        }

        @Override
        public TableOperation createPutIfPresent(Row rowArg, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            RowImpl row = (RowImpl)rowArg;
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            Key key = row.getPrimaryKey(false);
            Value value = row.createValue();
            Operation op = this.factory.createPutIfPresent(key, value, choice, abortIfUnsuccessful);
            return new OpWrapper(op, TableOperation.Type.PUT_IF_PRESENT, row);
        }

        @Override
        public TableOperation createPutIfVersion(Row rowArg, Version versionMatch, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            RowImpl row = (RowImpl)rowArg;
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            Key key = row.getPrimaryKey(false);
            Value value = row.createValue();
            Operation op = this.factory.createPutIfVersion(key, value, versionMatch, choice, abortIfUnsuccessful);
            return new OpWrapper(op, TableOperation.Type.PUT_IF_VERSION, row);
        }

        @Override
        public TableOperation createDelete(PrimaryKey keyArg, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            PrimaryKeyImpl rowKey = (PrimaryKeyImpl)keyArg;
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            Key key = rowKey.getPrimaryKey(false);
            Operation op = this.factory.createDelete(key, choice, abortIfUnsuccessful);
            return new OpWrapper(op, TableOperation.Type.DELETE, rowKey);
        }

        @Override
        public TableOperation createDeleteIfVersion(PrimaryKey keyArg, Version versionMatch, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            PrimaryKeyImpl rowKey = (PrimaryKeyImpl)keyArg;
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            Key key = rowKey.getPrimaryKey(false);
            Operation op = this.factory.createDeleteIfVersion(key, versionMatch, choice, abortIfUnsuccessful);
            return new OpWrapper(op, TableOperation.Type.DELETE_IF_VERSION, rowKey);
        }
    }

    private static class OpResultWrapper
    implements TableOperationResult {
        private final TableAPIImpl impl;
        private final OperationResult opRes;
        private final PrimaryKey key;

        private OpResultWrapper(TableAPIImpl impl, OperationResult opRes, PrimaryKey key) {
            this.impl = impl;
            this.opRes = opRes;
            this.key = key;
        }

        @Override
        public Version getNewVersion() {
            return this.opRes.getNewVersion();
        }

        @Override
        public Row getPreviousRow() {
            Value value = this.opRes.getPreviousValue();
            if (value != null && this.key != null) {
                return this.impl.getRowFromValueVersion(new ValueVersion(value, null), (RowImpl)((Object)this.key), true);
            }
            return null;
        }

        @Override
        public Version getPreviousVersion() {
            return this.opRes.getPreviousVersion();
        }

        @Override
        public boolean getSuccess() {
            return this.opRes.getSuccess();
        }
    }

    private static class OpWrapper
    implements TableOperation {
        private final Operation op;
        private final TableOperation.Type type;
        private final RowImpl record;

        private OpWrapper(Operation op, TableOperation.Type type, RowImpl record) {
            this.op = op;
            this.type = type;
            this.record = record;
        }

        @Override
        public Row getRow() {
            return this.record;
        }

        @Override
        public PrimaryKey getPrimaryKey() {
            if (this.record instanceof PrimaryKey) {
                return (PrimaryKey)((Object)this.record);
            }
            return this.record.createPrimaryKey();
        }

        @Override
        public TableOperation.Type getType() {
            return this.type;
        }

        @Override
        public boolean getAbortIfUnsuccessful() {
            return this.op.getAbortIfUnsuccessful();
        }

        private Operation getOperation() {
            return this.op;
        }
    }
}

