/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IntegerDefImpl;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.IntegerValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.IntNode;

@Persistent(version=1)
class IntegerValueImpl
extends FieldValueImpl
implements IntegerValue {
    private static final long serialVersionUID = 1L;
    private final int value;

    IntegerValueImpl(int value) {
        this.value = value;
    }

    IntegerValueImpl(String keyValue) {
        this.value = SortableString.intFromSortable(keyValue);
    }

    private IntegerValueImpl() {
        this.value = 0;
    }

    public static IntegerValue createFromKeyValue(String value) {
        return new IntegerValueImpl(value);
    }

    @Override
    public int get() {
        return this.value;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.INTEGER;
    }

    @Override
    public IntegerValueImpl clone() {
        return new IntegerValueImpl(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof IntegerValueImpl) {
            return this.value == ((IntegerValueImpl)other).get();
        }
        return false;
    }

    public int hashCode() {
        return Integer.valueOf(this.value).hashCode();
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof IntegerValueImpl) {
            return Integer.valueOf(this.value).compareTo(((IntegerValueImpl)other).value);
        }
        throw new ClassCastException("Object is not an IntegerValue");
    }

    @Override
    public String formatForKey(FieldDef field) {
        int len = field != null ? ((IntegerDefImpl)field).getEncodingLength() : 0;
        return SortableString.toSortable(this.value, len);
    }

    @Override
    public FieldValueImpl getNextValue() {
        if (this.value == Integer.MAX_VALUE) {
            return null;
        }
        return new IntegerValueImpl(this.value + 1);
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        return new IntegerValueImpl(Integer.MIN_VALUE);
    }

    @Override
    public JsonNode toJsonNode() {
        return new IntNode(this.value);
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append(this.toString());
    }

    @Override
    public IntegerValue asInteger() {
        return this;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

