/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Table;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class IndexImpl
implements Index,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final TableImpl table;
    private final List<String> fields;
    private IndexStatus status;
    private transient List<IndexField> indexFields;
    private transient boolean isMultiKeyMapIndex;

    public IndexImpl(String name, TableImpl table, List<String> fields, String description) {
        this.name = name;
        this.table = table;
        this.fields = IndexImpl.translateFields(fields);
        this.description = description;
        this.status = IndexStatus.TRANSIENT;
        this.validate();
        assert (this.indexFields != null);
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IndexKeyImpl createIndexKey() {
        return new IndexKeyImpl(this);
    }

    @Override
    public IndexKeyImpl createIndexKey(RecordValue value) {
        IndexKeyImpl ikey = new IndexKeyImpl(this);
        TableImpl.populateRecord(ikey, value);
        return ikey;
    }

    @Override
    public IndexKey createIndexKeyFromJson(String jsonInput, boolean exact) {
        return this.createIndexKeyFromJson(new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public IndexKey createIndexKeyFromJson(InputStream jsonInput, boolean exact) {
        IndexKeyImpl key = this.createIndexKey();
        TableImpl.createFromJson(key, jsonInput, exact);
        return key;
    }

    @Override
    public FieldRange createMapKeyFieldRange(String mapField) {
        StringBuilder sb = new StringBuilder(mapField);
        sb.append(".");
        sb.append("_key");
        return this.createFieldRange(sb.toString());
    }

    @Override
    public FieldRange createMapValueFieldRange(String mapField, String valueField) {
        StringBuilder sb = new StringBuilder(mapField);
        sb.append(".");
        sb.append("[]");
        if (valueField != null) {
            sb.append(".");
            sb.append(valueField);
        }
        return this.createFieldRange(sb.toString());
    }

    @Override
    public FieldRange createFieldRange(String fieldName) {
        IndexField field = new IndexField(this.table, fieldName);
        FieldDefImpl def = this.findIndexField(field);
        if (def == null) {
            throw new IllegalArgumentException("Field does not exist in table definition: " + fieldName);
        }
        if (!this.containsField(field)) {
            throw new IllegalArgumentException("Field does not exist in index: " + fieldName);
        }
        return new FieldRange(fieldName, def);
    }

    int numFields() {
        return this.fields.size();
    }

    public boolean isKeyOnly() {
        for (String field : this.fields) {
            if (this.table.isKeyComponent(field)) continue;
            return false;
        }
        return true;
    }

    public boolean isMultiKey() {
        for (IndexField field : this.getIndexFields()) {
            if (!field.isMultiKey()) continue;
            return true;
        }
        return false;
    }

    public IndexStatus getStatus() {
        return this.status;
    }

    public void setStatus(IndexStatus status) {
        this.status = status;
    }

    public TableImpl getTableImpl() {
        return this.table;
    }

    List<String> getFieldsInternal() {
        return this.fields;
    }

    List<IndexField> getIndexFields() {
        if (this.indexFields == null) {
            this.initIndexFields();
        }
        return this.indexFields;
    }

    private void initIndexFields() {
        if (this.indexFields == null) {
            ArrayList<IndexField> list = new ArrayList<IndexField>(this.fields.size());
            for (String field : this.fields) {
                IndexField indexField = new IndexField(this.table, field);
                this.isMultiKey(indexField);
                list.add(indexField);
            }
            this.indexFields = list;
        }
    }

    private IndexField findMultiKeyField() {
        for (IndexField field : this.getIndexFields()) {
            if (!field.isMultiKey()) continue;
            return field.getMultiKeyField();
        }
        throw new IllegalStateException("Could not find any multiKeyField in index " + this.name);
    }

    private boolean isMultiKeyMapIndex() {
        return this.isMultiKeyMapIndex;
    }

    private boolean isMultiKey(IndexField field) {
        StringBuilder sb = new StringBuilder();
        List<String> components = field.getComponents();
        int compIndex = 0;
        FieldDefImpl def = field.getFirstDef();
        sb.append(components.get(compIndex++));
        if (this.checkMultiKey(field, def, components, compIndex, sb)) {
            return true;
        }
        sb.append(".");
        while (compIndex < components.size()) {
            String current = components.get(compIndex++);
            sb.append(current);
            def = def.findField(current);
            assert (def != null);
            if (this.checkMultiKey(field, def, components, compIndex, sb)) {
                return true;
            }
            sb.append(".");
        }
        return false;
    }

    private boolean checkMultiKey(IndexField field, FieldDefImpl def, List<String> components, int compIndex, StringBuilder sb) {
        assert (sb != null);
        assert (compIndex > 0);
        if (def.isArray()) {
            field.setMultiKeyPath(sb.toString());
            return true;
        }
        if (def.isMap()) {
            FieldDefImpl elementDef = (FieldDefImpl)((MapDefImpl)def).getElement();
            if (compIndex == components.size()) {
                throw new IllegalCommandException("Indexes on maps must specify _key, [], or a path to the target field");
            }
            String next = components.get(compIndex);
            if (MapDefImpl.isMapKeyTag(next)) {
                field.setMultiKeyPath(sb.toString());
                field.setIsMapKey();
                this.isMultiKeyMapIndex = true;
                return true;
            }
            if (MapDefImpl.isMapValueTag(next)) {
                if (elementDef.isMap() || elementDef.isArray()) {
                    throw new IllegalCommandException("Indexes are not allowed on a map containing a map or array");
                }
                field.setMultiKeyPath(sb.toString());
                field.setIsMapValue();
                this.isMultiKeyMapIndex = true;
                return true;
            }
        }
        return false;
    }

    public byte[] extractIndexKey(byte[] key, byte[] data, boolean keyOnly) {
        RowImpl row = this.table.createRowFromBytes(key, data, keyOnly);
        if (row != null) {
            return this.serializeIndexKey(row, false, 0);
        }
        return null;
    }

    public List<byte[]> extractIndexKeys(byte[] key, byte[] data, boolean keyOnly) {
        RowImpl row = this.table.createRowFromBytes(key, data, keyOnly);
        if (row != null) {
            IndexField indexField = this.findMultiKeyField();
            FieldValueImpl val = row.getComplex(indexField);
            if (val == null || val.isNull()) {
                return null;
            }
            if (val.isMap()) {
                MapValueImpl mapVal = (MapValueImpl)val;
                ArrayList<byte[]> returnList = new ArrayList<byte[]>(mapVal.size());
                Map<String, FieldValue> map = mapVal.getFieldsInternal();
                for (String mapKey : map.keySet()) {
                    byte[] serKey = this.serializeIndexKey(row, false, mapKey, true);
                    if (serKey == null) continue;
                    returnList.add(serKey);
                }
                return returnList;
            }
            assert (val.isArray());
            ArrayValueImpl fv = (ArrayValueImpl)val;
            int arraySize = fv.size();
            ArrayList<byte[]> returnList = new ArrayList<byte[]>(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                byte[] serKey = this.serializeIndexKey(row, false, i);
                if (serKey == null) continue;
                returnList.add(serKey);
            }
            return returnList;
        }
        return null;
    }

    public void toJsonNode(ObjectNode node) {
        node.put("name", this.name);
        node.put("comment", this.description);
        if (this.isMultiKey()) {
            node.put("multi_key", "true");
        }
        ArrayNode fieldArray = node.putArray("fields");
        for (String s : this.fields) {
            fieldArray.add(TableImpl.translateToExternalField(s));
        }
    }

    private void validate() {
        TableImpl.validateComponent(this.name, false);
        IndexField multiKeyField = null;
        if (this.fields.isEmpty()) {
            throw new IllegalCommandException("Index requires at least one field");
        }
        assert (this.indexFields == null);
        this.indexFields = new ArrayList<IndexField>(this.fields.size());
        for (String field : this.fields) {
            if (field == null || field.length() == 0) {
                throw new IllegalCommandException("Invalid (null or empty) index field name");
            }
            IndexField ifield = new IndexField(this.table, field);
            FieldDefImpl def = this.findIndexField(ifield);
            if (def == null) {
                throw new IllegalCommandException("Index field not found in table: " + field);
            }
            if (!def.isValidIndexField()) {
                throw new IllegalCommandException("Field type is not valid in an index: " + (Object)((Object)def.getType()) + ", field name: " + field);
            }
            boolean fieldIsMultiKey = this.isMultiKey(ifield);
            if (fieldIsMultiKey) {
                IndexField mkey = ifield.getMultiKeyField();
                if (multiKeyField != null && !mkey.equals(multiKeyField)) {
                    throw new IllegalCommandException("Indexes may contain only one multiKey field");
                }
                multiKeyField = mkey;
            }
            if (this.indexFields.contains(ifield)) {
                throw new IllegalCommandException("Index already contains the field: " + field);
            }
            this.indexFields.add(ifield);
        }
        assert (this.fields.size() == this.indexFields.size());
        this.table.checkForDuplicateIndex(this);
    }

    public String toString() {
        return "Index[" + this.name + ", " + this.table.getId() + ", " + (Object)((Object)this.status) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] serializeIndexKey(RecordValueImpl record, boolean allowPartial, int arrayIndex) {
        if (this.isMultiKeyMapIndex()) {
            throw new IllegalStateException("Wrong serializer for map index");
        }
        TupleOutput out = null;
        out = new TupleOutput();
        for (IndexField field : this.getIndexFields()) {
            FieldValue val = record.findFieldValue(field.iterator(), arrayIndex);
            FieldDefImpl def = this.findIndexField(field);
            if (def == null) {
                throw new IllegalStateException("Index field not found in table: " + field);
            }
            if (val != null) {
                if (def.isArray()) {
                    def = (FieldDefImpl)((ArrayDefImpl)def).getElement();
                    val = ((ArrayValueImpl)val).get(arrayIndex);
                } else if (def.isMap()) {
                    String mapKey = ((MapValueImpl)val).getMapKey();
                    byte[] byArray = this.serializeIndexKey(record, allowPartial, mapKey, false);
                    return byArray;
                }
            }
            if (val == null) {
                if (allowPartial) break;
                byte[] byArray = null;
                return byArray;
            }
            if (val.isNull()) {
                byte[] byArray = null;
                return byArray;
            }
            IndexImpl.serializeValue(out, val, def);
        }
        byte[] byArray = out.size() != 0 ? out.toByteArray() : null;
        return byArray;
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] serializeIndexKey(RecordValueImpl record, boolean allowPartial, String mapKey, boolean extracting) {
        assert (this.isMultiKeyMapIndex());
        TupleOutput out = null;
        out = new TupleOutput();
        for (IndexField field : this.getIndexFields()) {
            String keyString = extracting || !field.isMapValue() ? mapKey : null;
            FieldValueImpl val = record.findFieldValue(field.iterator(), keyString);
            FieldDefImpl def = this.findIndexField(field);
            if (def == null) {
                throw new IllegalStateException("Could not find index field: " + field);
            }
            if (val == null) {
                if (allowPartial) break;
                byte[] byArray = null;
                return byArray;
            }
            if (val.isNull()) {
                byte[] byArray = null;
                return byArray;
            }
            IndexImpl.serializeValue(out, val, def);
        }
        byte[] byArray = out.size() != 0 ? out.toByteArray() : null;
        return byArray;
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public byte[] serializeIndexKey(IndexKeyImpl record) {
        if (this.isMultiKeyMapIndex()) {
            String mapKey = this.findMapKey(record);
            return this.serializeIndexKey(record, true, mapKey, false);
        }
        return this.serializeIndexKey(record, true, 0);
    }

    private String findMapKey(IndexKeyImpl record) {
        for (IndexField field : this.getIndexFields()) {
            IndexField mapField = field.getMultiKeyField();
            if (mapField == null) continue;
            FieldValueImpl val = record.findFieldValue(mapField.iterator(), -1);
            if (val != null) {
                if (!val.isMap()) {
                    throw new IllegalStateException("Multi-key value in index must be a map");
                }
                return ((MapValueImpl)val).getMapKey();
            }
            return null;
        }
        return null;
    }

    static TupleInput serializeValue(FieldDef def, FieldValue value) {
        TupleOutput output = new TupleOutput();
        IndexImpl.serializeValue(output, value, def);
        return new TupleInput(output);
    }

    private static void serializeValue(TupleOutput out, FieldValue val, FieldDef def) {
        switch (def.getType()) {
            case INTEGER: {
                out.writeSortedPackedInt(val.asInteger().get());
                break;
            }
            case STRING: {
                out.writeString(val.asString().get());
                break;
            }
            case LONG: {
                out.writeSortedPackedLong(val.asLong().get());
                break;
            }
            case DOUBLE: {
                out.writeSortedDouble(val.asDouble().get());
                break;
            }
            case FLOAT: {
                out.writeSortedFloat(val.asFloat().get());
                break;
            }
            case ENUM: {
                out.writeSortedPackedInt(val.asEnum().getIndex());
                break;
            }
            case MAP: 
            case ARRAY: 
            case BINARY: 
            case BOOLEAN: 
            case FIXED_BINARY: 
            case RECORD: {
                throw new IllegalStateException("Type not supported in indexes: " + (Object)((Object)def.getType()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexKeyImpl rowFromIndexKey(byte[] data, boolean partialOK) {
        IndexKeyImpl ikey = this.createIndexKey();
        TupleInput input = null;
        try {
            input = new TupleInput(data);
            for (IndexField field : this.getIndexFields()) {
                FieldDefImpl def;
                if (input.available() <= 0) break;
                IndexField mapField = field.isMapKey() ? field.getMultiKeyField() : null;
                FieldDefImpl fieldDefImpl = def = mapField != null ? this.findIndexField(mapField) : this.findIndexField(field);
                if (def == null) {
                    throw new IllegalStateException("Could not find index field: " + field);
                }
                switch (def.getType()) {
                    case INTEGER: 
                    case STRING: 
                    case LONG: 
                    case DOUBLE: 
                    case FLOAT: 
                    case ENUM: {
                        ikey.putComplex(field, def.getType(), FieldValueImpl.readTuple(def, input));
                        break;
                    }
                    case MAP: {
                        assert (mapField != null);
                        ikey.putComplex(mapField, FieldDef.Type.MAP, null);
                        MapValueImpl map = (MapValueImpl)ikey.getComplex(mapField);
                        this.handleMapKey(map, input, field);
                        break;
                    }
                    case ARRAY: {
                        ikey.putComplex(field, FieldDef.Type.ARRAY, null);
                        ArrayValueImpl array = (ArrayValueImpl)ikey.getComplex(field);
                        this.readArrayElement(array, input);
                        break;
                    }
                    case BINARY: 
                    case BOOLEAN: 
                    case FIXED_BINARY: 
                    case RECORD: {
                        throw new IllegalStateException("Type not supported in indexes: " + (Object)((Object)def.getType()));
                    }
                }
            }
            if (!partialOK && ikey.numValues() != this.fields.size()) {
                throw new IllegalStateException("Missing fields from index data for index " + this.getName() + ", expected " + this.fields.size() + ", received " + ikey.numValues());
            }
            IndexKeyImpl indexKeyImpl = ikey;
            return indexKeyImpl;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private void readArrayElement(ArrayValueImpl array, TupleInput input) {
        switch (array.getDefinition().getElement().getType()) {
            case INTEGER: {
                array.add(input.readSortedPackedInt());
                break;
            }
            case STRING: {
                array.add(input.readString());
                break;
            }
            case LONG: {
                array.add(input.readSortedPackedLong());
                break;
            }
            case DOUBLE: {
                array.add(input.readSortedDouble());
                break;
            }
            case FLOAT: {
                array.add(input.readSortedFloat());
                break;
            }
            case ENUM: {
                array.addEnum(input.readSortedPackedInt());
                break;
            }
            default: {
                throw new IllegalStateException("Type not supported in indexes: ");
            }
        }
    }

    private void handleMapKey(MapValueImpl map, TupleInput input, IndexField field) {
        if (!field.isMapKey()) {
            throw new IllegalStateException("Field should have been a map key field: " + field);
        }
        String mapKey = input.readString();
        map.putNull(mapKey);
    }

    boolean containsField(IndexField indexField) {
        for (IndexField iField : this.getIndexFields()) {
            if (!iField.equals(indexField)) continue;
            return true;
        }
        return false;
    }

    boolean containsField(String fieldName) {
        String fname = fieldName.toLowerCase();
        for (IndexField indexField : this.getIndexFields()) {
            if (!(indexField.isComplex() ? indexField.getFieldName().contains(fname) : indexField.getFieldName().equals(fname))) continue;
            return true;
        }
        return false;
    }

    public static List<String> translateFields(List<String> fieldList) {
        ArrayList<String> newList = new ArrayList<String>(fieldList.size());
        for (String field : fieldList) {
            if (field == null) {
                return fieldList;
            }
            String newField = TableImpl.translateFromExternalField(field);
            if (newField == null) {
                return fieldList;
            }
            newList.add(newField);
        }
        return newList;
    }

    FieldDefImpl findIndexField(IndexField field) {
        return TableImpl.findTableField(field);
    }

    IndexField createIndexField(String fieldName) {
        return new IndexField(this.table, fieldName);
    }

    static class IndexField
    extends TableImpl.TableField {
        private IndexField multiKeyField;
        private MultiKeyType multiKeyType = MultiKeyType.NONE;

        private IndexField(TableImpl table, String field) {
            super(table, field);
        }

        private IndexField(FieldMap fieldMap, String field) {
            super(fieldMap, field);
        }

        IndexField getMultiKeyField() {
            return this.multiKeyField;
        }

        private boolean isMultiKey() {
            return this.multiKeyField != null;
        }

        private void setMultiKeyPath(String path) {
            this.multiKeyField = new IndexField(this.getFieldMap(), path);
        }

        boolean isMapKey() {
            return this.multiKeyType == MultiKeyType.MAPKEY;
        }

        private void setIsMapKey() {
            this.multiKeyType = MultiKeyType.MAPKEY;
        }

        boolean isMapValue() {
            return this.multiKeyType == MultiKeyType.MAPVALUE;
        }

        private void setIsMapValue() {
            this.multiKeyType = MultiKeyType.MAPVALUE;
        }

        private static enum MultiKeyType {
            NONE,
            MAPKEY,
            MAPVALUE;

        }
    }

    public static enum IndexStatus {
        TRANSIENT{

            @Override
            public boolean isTransient() {
                return true;
            }
        }
        ,
        POPULATING{

            @Override
            public boolean isPopulating() {
                return true;
            }
        }
        ,
        READY{

            @Override
            public boolean isReady() {
                return true;
            }
        };


        public boolean isTransient() {
            return false;
        }

        public boolean isPopulating() {
            return false;
        }

        public boolean isReady() {
            return false;
        }
    }
}

