/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.parallelscan;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import oracle.kv.stats.StoreIteratorMetrics;

public class StoreIteratorMetricsImpl
implements Serializable,
StoreIteratorMetrics {
    private static final long serialVersionUID = 1L;
    private AtomicLong blockedResultsQueuePuts = new AtomicLong();
    private AtomicLong blockedResultsQueuePutTime = new AtomicLong();
    private AtomicLong minBlockedResultsQueuePutTime = new AtomicLong();
    private AtomicLong maxBlockedResultsQueuePutTime = new AtomicLong();
    private AtomicLong blockedResultsQueueGets = new AtomicLong();
    private AtomicLong blockedResultsQueueGetTime = new AtomicLong();
    private AtomicLong minBlockedResultsQueueGetTime = new AtomicLong();
    private AtomicLong maxBlockedResultsQueueGetTime = new AtomicLong();

    void accBlockedResultsQueuePutTime(long time) {
        if (time == 0L) {
            return;
        }
        this.blockedResultsQueuePuts.incrementAndGet();
        this.blockedResultsQueuePutTime.addAndGet(time);
        this.setMinBlockedResultsQueuePutTime(time);
        this.setMaxBlockedResultsQueuePutTime(time);
    }

    private void setMinBlockedResultsQueuePutTime(long min) {
        long currentMin;
        while ((currentMin = this.minBlockedResultsQueuePutTime.get()) > min && !this.minBlockedResultsQueuePutTime.compareAndSet(currentMin, min)) {
        }
    }

    private void setMaxBlockedResultsQueuePutTime(long max) {
        long currentMax;
        while ((currentMax = this.maxBlockedResultsQueuePutTime.get()) < max && !this.maxBlockedResultsQueuePutTime.compareAndSet(currentMax, max)) {
        }
    }

    void accBlockedResultsQueueGetTime(long time) {
        if (time == 0L) {
            return;
        }
        this.blockedResultsQueueGets.incrementAndGet();
        this.blockedResultsQueueGetTime.addAndGet(time);
        this.setMinBlockedResultsQueueGetTime(time);
        this.setMaxBlockedResultsQueueGetTime(time);
    }

    void setMinBlockedResultsQueueGetTime(long min) {
        long currentMin;
        while ((currentMin = this.minBlockedResultsQueueGetTime.get()) > min && !this.minBlockedResultsQueueGetTime.compareAndSet(currentMin, min)) {
        }
    }

    void setMaxBlockedResultsQueueGetTime(long max) {
        long currentMax;
        while ((currentMax = this.maxBlockedResultsQueueGetTime.get()) < max && !this.maxBlockedResultsQueueGetTime.compareAndSet(currentMax, max)) {
        }
    }

    @Override
    public long getBlockedResultsQueuePuts() {
        return this.blockedResultsQueuePuts.get();
    }

    @Override
    public long getAverageBlockedResultsQueuePutTime() {
        long bRQP = this.blockedResultsQueuePuts.get();
        if (bRQP == 0L) {
            return 0L;
        }
        return this.blockedResultsQueuePutTime.get() / bRQP;
    }

    @Override
    public long getMinBlockedResultsQueuePutTime() {
        return this.minBlockedResultsQueuePutTime.get();
    }

    @Override
    public long getMaxBlockedResultsQueuePutTime() {
        return this.maxBlockedResultsQueuePutTime.get();
    }

    @Override
    public long getBlockedResultsQueueGets() {
        return this.blockedResultsQueueGets.get();
    }

    @Override
    public long getAverageBlockedResultsQueueGetTime() {
        long bRQG = this.blockedResultsQueueGets.get();
        if (bRQG == 0L) {
            return 0L;
        }
        return this.blockedResultsQueueGetTime.get() / bRQG;
    }

    @Override
    public long getMinBlockedResultsQueueGetTime() {
        return this.minBlockedResultsQueueGetTime.get();
    }

    @Override
    public long getMaxBlockedResultsQueueGetTime() {
        return this.maxBlockedResultsQueueGetTime.get();
    }

    public void clear() {
        this.blockedResultsQueuePuts.set(0L);
        this.blockedResultsQueuePutTime.set(0L);
        this.blockedResultsQueueGets.set(0L);
        this.blockedResultsQueueGetTime.set(0L);
        this.minBlockedResultsQueuePutTime.set(0L);
        this.maxBlockedResultsQueuePutTime.set(0L);
        this.minBlockedResultsQueueGetTime.set(0L);
        this.maxBlockedResultsQueueGetTime.set(0L);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StoreIteratorMetrics:");
        sb.append("\n blockedResultsQueuePuts=").append(this.blockedResultsQueuePuts.get());
        sb.append("\n averageBlockedResultsQueuePutTime=").append(this.getAverageBlockedResultsQueuePutTime());
        sb.append("\n minBlockedResultsQueuePutTime=").append(this.minBlockedResultsQueuePutTime.get());
        sb.append("\n maxBlockedResultsQueuePutTime=").append(this.maxBlockedResultsQueuePutTime.get());
        sb.append("\n blockedResultsQueueGets=").append(this.blockedResultsQueueGets.get());
        sb.append("\n averageBlockedResultsQueueGetTime=").append(this.getAverageBlockedResultsQueueGetTime());
        sb.append("\n minBlockedResultsQueueGetTime=").append(this.minBlockedResultsQueueGetTime.get());
        sb.append("\n maxBlockedResultsQueueGetTime=").append(this.maxBlockedResultsQueueGetTime.get());
        sb.append("\n");
        return sb.toString();
    }
}

