/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ReturnResultValueVersion;
import oracle.kv.impl.topo.PartitionId;

public class PutIfAbsent
extends Put {
    public PutIfAbsent(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice) {
        this(keyBytes, value, prevValChoice, 0L);
    }

    public PutIfAbsent(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, long tableId) {
        super(InternalOperation.OpCode.PUT_IF_ABSENT, keyBytes, value, prevValChoice, tableId);
    }

    PutIfAbsent(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.PUT_IF_ABSENT, in, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        this.verifyDataAccess(operationHandler, this.getTableId());
        ReturnResultValueVersion prevVal = new ReturnResultValueVersion(this.getReturnValueVersionChoice());
        Version newVersion = operationHandler.putIfAbsent(txn, partitionId, this.getKeyBytes(), this.getValueBytes(), prevVal);
        return new Result.PutResult(this.getOpCode(), prevVal.getValueVersion(), newVersion);
    }
}

