/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import oracle.kv.Key;
import oracle.kv.Operation;
import oracle.kv.OperationFactory;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.KeySerializer;
import oracle.kv.impl.api.ops.Delete;
import oracle.kv.impl.api.ops.DeleteIfVersion;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.impl.api.ops.PutIfAbsent;
import oracle.kv.impl.api.ops.PutIfPresent;
import oracle.kv.impl.api.ops.PutIfVersion;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.SingleKeyOperation;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.TxnUtil;

public class Execute
extends InternalOperation {
    private final List<OperationImpl> ops;

    public Execute(List<OperationImpl> ops) {
        super(InternalOperation.OpCode.EXECUTE);
        this.ops = ops;
    }

    Execute(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.EXECUTE, in, serialVersion);
        int opsSize = in.readInt();
        this.ops = new ArrayList<OperationImpl>(opsSize);
        for (int i = 0; i < opsSize; ++i) {
            this.ops.add(new OperationImpl(in, serialVersion));
        }
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.ops.size());
        for (OperationImpl op : this.ops) {
            op.writeFastExternal(out, serialVersion);
        }
    }

    public List<OperationImpl> getOperations() {
        return this.ops;
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        int listSize = this.ops.size();
        Integer[] sortedIndices = new Integer[listSize];
        for (int i = 0; i < listSize; ++i) {
            sortedIndices[i] = i;
        }
        Arrays.sort(sortedIndices, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return OperationHandler.KEY_BYTES_COMPARATOR.compare(((OperationImpl)Execute.this.ops.get(i1)).getInternalOp().getKeyBytes(), ((OperationImpl)Execute.this.ops.get(i2)).getInternalOp().getKeyBytes());
            }
        });
        ArrayList<Result> results = new ArrayList<Result>(listSize);
        for (int i = 0; i < listSize; ++i) {
            results.add(null);
        }
        Integer[] arr$ = sortedIndices;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            OperationImpl op = this.ops.get(i);
            SingleKeyOperation internalOp = op.getInternalOp();
            Result result = internalOp.execute(txn, partitionId, operationHandler);
            if (op.getAbortIfUnsuccessful() && !result.getSuccess()) {
                TxnUtil.abort(txn);
                return new Result.ExecuteResult(this.getOpCode(), i, result);
            }
            results.set(i, result);
        }
        return new Result.ExecuteResult(this.getOpCode(), results);
    }

    @Override
    public String toString() {
        return super.toString() + " Ops: " + this.ops;
    }

    @Override
    public List<? extends KVStorePrivilege> getRequiredPrivileges() {
        HashSet<? extends KVStorePrivilege> privSet = new HashSet<KVStorePrivilege>();
        for (OperationImpl op : this.ops) {
            privSet.addAll(op.getInternalOp().getRequiredPrivileges());
        }
        return Collections.unmodifiableList(new ArrayList(privSet));
    }

    public static class OperationFactoryImpl
    implements OperationFactory {
        private final KeySerializer keySerializer;

        public OperationFactoryImpl(KeySerializer keySerializer) {
            this.keySerializer = keySerializer;
        }

        @Override
        public Operation createPut(Key key, Value value) {
            return this.createPut(key, value, null, false);
        }

        @Override
        public Operation createPut(Key key, Value value, ReturnValueVersion.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OperationImpl(key, abortIfUnsuccessful, new Put(this.keySerializer.toByteArray(key), value, prevReturn != null ? prevReturn : ReturnValueVersion.Choice.NONE));
        }

        @Override
        public Operation createPutIfAbsent(Key key, Value value) {
            return this.createPutIfAbsent(key, value, null, false);
        }

        @Override
        public Operation createPutIfAbsent(Key key, Value value, ReturnValueVersion.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OperationImpl(key, abortIfUnsuccessful, new PutIfAbsent(this.keySerializer.toByteArray(key), value, prevReturn != null ? prevReturn : ReturnValueVersion.Choice.NONE));
        }

        @Override
        public Operation createPutIfPresent(Key key, Value value) {
            return this.createPutIfPresent(key, value, null, false);
        }

        @Override
        public Operation createPutIfPresent(Key key, Value value, ReturnValueVersion.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OperationImpl(key, abortIfUnsuccessful, new PutIfPresent(this.keySerializer.toByteArray(key), value, prevReturn != null ? prevReturn : ReturnValueVersion.Choice.NONE));
        }

        @Override
        public Operation createPutIfVersion(Key key, Value value, Version version) {
            return this.createPutIfVersion(key, value, version, null, false);
        }

        @Override
        public Operation createPutIfVersion(Key key, Value value, Version version, ReturnValueVersion.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OperationImpl(key, abortIfUnsuccessful, new PutIfVersion(this.keySerializer.toByteArray(key), value, prevReturn != null ? prevReturn : ReturnValueVersion.Choice.NONE, version));
        }

        @Override
        public Operation createDelete(Key key) {
            return this.createDelete(key, null, false);
        }

        @Override
        public Operation createDelete(Key key, ReturnValueVersion.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OperationImpl(key, abortIfUnsuccessful, new Delete(this.keySerializer.toByteArray(key), prevReturn != null ? prevReturn : ReturnValueVersion.Choice.NONE));
        }

        @Override
        public Operation createDeleteIfVersion(Key key, Version version) {
            return this.createDeleteIfVersion(key, version, null, false);
        }

        @Override
        public Operation createDeleteIfVersion(Key key, Version version, ReturnValueVersion.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OperationImpl(key, abortIfUnsuccessful, new DeleteIfVersion(this.keySerializer.toByteArray(key), prevReturn != null ? prevReturn : ReturnValueVersion.Choice.NONE, version));
        }
    }

    public static class OperationImpl
    implements Operation,
    FastExternalizable {
        private final Key key;
        private final boolean abortIfUnsuccessful;
        private final SingleKeyOperation internalOp;

        OperationImpl(Key key, boolean abortIfUnsuccessful, SingleKeyOperation internalOp) {
            this.key = key;
            this.abortIfUnsuccessful = abortIfUnsuccessful;
            this.internalOp = internalOp;
        }

        OperationImpl(ObjectInput in, short serialVersion) throws IOException {
            this.key = null;
            this.abortIfUnsuccessful = in.readBoolean();
            this.internalOp = (SingleKeyOperation)InternalOperation.readFastExternal(in, serialVersion);
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            out.writeBoolean(this.abortIfUnsuccessful);
            this.internalOp.writeFastExternal(out, serialVersion);
        }

        public SingleKeyOperation getInternalOp() {
            return this.internalOp;
        }

        @Override
        public Key getKey() {
            if (this.key == null) {
                throw new IllegalStateException();
            }
            return this.key;
        }

        @Override
        public Operation.Type getType() {
            return this.internalOp.getOpCode().getExecuteType();
        }

        @Override
        public boolean getAbortIfUnsuccessful() {
            return this.abortIfUnsuccessful;
        }

        public static List<OperationImpl> downcast(List<Operation> ops) {
            return ops;
        }
    }
}

