/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.io.IOException;
import java.util.Set;
import oracle.kv.hadoop.hive.table.TableHiveInputSplit;
import oracle.kv.hadoop.hive.table.TableHiveRecordReader;
import oracle.kv.hadoop.hive.table.TableTaskAttemptContext;
import oracle.kv.hadoop.hive.table.V1V2TableUtil;
import oracle.kv.hadoop.table.TableInputSplit;
import oracle.kv.hadoop.table.TableRecordReader;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Row;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;

public class TableHiveInputFormat<K, V>
implements org.apache.hadoop.mapred.InputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog("oracle.kv.hadoop.hive.TableHiveInputFormat");

    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        LOG.debug("split = " + split);
        TableInputSplit v2Split = V1V2TableUtil.getSplitMap(job, (TableHiveInputSplit)split).get(split);
        TableRecordReader v2Reader = new TableRecordReader();
        try {
            v2Reader.initialize(v2Split, new TableTaskAttemptContext((Configuration)job));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return new TableHiveRecordReader(v2Reader);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        InputFormat<PrimaryKey, Row> v2InputFormat = V1V2TableUtil.getInputFormat(job);
        Set<TableHiveInputSplit> v1SplitKeySet = V1V2TableUtil.getSplitMap(job).keySet();
        return (InputSplit[])v1SplitKeySet.toArray(new TableHiveInputSplit[v1SplitKeySet.size()]);
    }
}

