/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.security.SecureRandom;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.FaultException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreException;
import oracle.kv.LoginCredentials;
import oracle.kv.ReauthenticateHandler;
import oracle.kv.impl.api.ClientId;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.RequestDispatcherImpl;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.RepNodeLoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.client.ClientLoggerUtils;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RegistryUtils;

public class KVStoreFactory {
    private static final SecureRandom secureRandom = new SecureRandom();

    public static KVStore getStore(KVStoreConfig config) throws FaultException {
        return KVStoreFactory.getStore(config, null, null);
    }

    public static KVStore getStore(KVStoreConfig config, LoginCredentials creds, ReauthenticateHandler reauthHandler) throws FaultException {
        Properties securityProps = config.getSecurityProperties();
        LoginCredentials loginCreds = creds == null ? KVStoreLogin.makeLoginCredentials(securityProps) : creds;
        ReauthenticateHandler loginReauthHandler = reauthHandler == null ? KVStoreLogin.makeReauthenticateHandler(new KVStoreLogin.StoreLoginCredentialsProvider(securityProps)) : reauthHandler;
        return KVStoreFactory.getStoreInternal(config, loginCreds, loginReauthHandler, securityProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KVStore getStoreInternal(KVStoreConfig config, LoginCredentials loginCreds, ReauthenticateHandler reauthHandler, Properties securityProps) throws FaultException {
        RequestDispatcherImpl handler;
        ClientId clientId;
        SecureRandom secureRandom = KVStoreFactory.secureRandom;
        synchronized (secureRandom) {
            clientId = new ClientId(KVStoreFactory.secureRandom.nextLong());
        }
        long requestTimeoutMs = config.getRequestTimeout(TimeUnit.MILLISECONDS);
        long readTimeoutMs = config.getSocketReadTimeout(TimeUnit.MILLISECONDS);
        if (requestTimeoutMs > readTimeoutMs) {
            String format = "Invalid KVStoreConfig. Request timeout: %,d ms exceeds socket read timeout: %,d ms";
            throw new IllegalArgumentException(String.format("Invalid KVStoreConfig. Request timeout: %,d ms exceeds socket read timeout: %,d ms", requestTimeoutMs, readTimeoutMs));
        }
        Logger logger = ClientLoggerUtils.getLogger(KVStore.class, clientId.toString());
        ClientSocketFactory.setTimeoutLogger(logger);
        try {
            ClientSocketFactory.setRMIPolicy(securityProps, config.getStoreName());
        }
        catch (RuntimeException rte) {
            throw new FaultException(rte, false);
        }
        RepNodeLoginManager loginMgr = null;
        try {
            RegistryUtils.setRegistrySocketTimeouts((int)config.getRegistryOpenTimeout(TimeUnit.MILLISECONDS), (int)config.getRegistryReadTimeout(TimeUnit.MILLISECONDS), config.getStoreName());
            String csfName = ClientSocketFactory.factoryName(config.getStoreName(), RepNodeId.getPrefix(), RegistryUtils.InterfaceType.MAIN.interfaceName());
            int openTimeoutMs = (int)config.getSocketOpenTimeout(TimeUnit.MILLISECONDS);
            ClientSocketFactory.configureStoreTimeout(csfName, openTimeoutMs, (int)readTimeoutMs);
            KVSHandler exceptionHandler = new KVSHandler(logger);
            if (loginCreds != null) {
                loginMgr = new RepNodeLoginManager(loginCreds.getUsername(), true);
                loginMgr.bootstrap(config.getHelperHosts(), loginCreds, config.getStoreName());
            }
            handler = new RequestDispatcherImpl(config, clientId, (LoginManager)loginMgr, (Thread.UncaughtExceptionHandler)exceptionHandler, logger);
            if (loginMgr != null) {
                loginMgr.setTopology(handler.getTopologyManager());
            }
        }
        catch (KVStoreException e) {
            throw new FaultException(e, false);
        }
        return new KVStoreImpl(logger, handler, config, loginMgr, reauthHandler);
    }

    private static class KVSHandler
    implements Thread.UncaughtExceptionHandler {
        final Logger logger;

        public KVSHandler(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.logger.log(Level.SEVERE, "Uncaught exception in thread:" + t.getName(), e);
        }
    }
}

