/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.InternetFilesManager;
import oracle.ide.webbrowser.InternetFilesOptions;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.javatools.columnlayout.LayoutBuilder;

public class InternetFilesPanel
extends DefaultTraversablePanel
implements ActionListener {
    private final JCheckBox _cbEnableInternetCookies = new JCheckBox();
    private JButton _clearAllCookies = new JButton();
    private TraversableContext _tc;

    public InternetFilesPanel() {
        this.initUI();
    }

    protected void initUI() {
        this.setHelpID("f1_prefweb_internet_html");
        LayoutBuilder lb = new LayoutBuilder();
        this._clearAllCookies.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._cbEnableInternetCookies, (String)BrowserArb.getString(71));
        ResourceUtils.resButton((AbstractButton)this._clearAllCookies, (String)BrowserArb.getString(72));
        lb.add((Component)this._cbEnableInternetCookies, LayoutBuilder.CONTROL_INSETS, 1, false, true, 17, 2);
        lb.nl();
        lb.add((Component)this._clearAllCookies, LayoutBuilder.CONTROL_INSETS, 1, false, false, 18, 0);
        lb.nl();
        lb.addVFiller();
        lb.nl();
        lb.addToPanel((Container)((Object)this));
    }

    public void onEntry(TraversableContext tc) {
        this._tc = tc;
        InternetFilesOptions options = InternetFilesPanel.getInternetFilesOptions(tc);
        this._cbEnableInternetCookies.setSelected(options.getEnableCookies());
        this._cbEnableInternetCookies.setEnabled(true);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        InternetFilesOptions options = InternetFilesPanel.getInternetFilesOptions(tc);
        options.setEnableCookies(this._cbEnableInternetCookies.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj == this._clearAllCookies) {
            InternetFilesManager.getInstance().clearAllCookies();
        }
    }

    private static InternetFilesOptions getInternetFilesOptions(TraversableContext tc) {
        return InternetFilesOptions.getInstance(tc.getPropertyStorage());
    }
}

