/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraNormalizer;
import oracle.i18n.text.UTFUtility;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.text.converter.CharsetMeta;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.HashTree;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.UnicodeCatTable;
import oracle.i18n.util.UnicodeDecompTree;

public class OraUnicodeProperty
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    public static final short LU = 1;
    public static final short LL = 2;
    public static final short LT = 3;
    public static final short MN = 4;
    public static final short MC = 5;
    public static final short ME = 6;
    public static final short ND = 7;
    public static final short NL = 8;
    public static final short NO = 9;
    public static final short ZS = 10;
    public static final short ZL = 11;
    public static final short ZP = 12;
    public static final short CC = 13;
    public static final short CF = 14;
    public static final short CS = 15;
    public static final short CO = 16;
    public static final short CN = 17;
    public static final short LM = 18;
    public static final short LO = 19;
    public static final short PC = 20;
    public static final short PD = 21;
    public static final short PS = 22;
    public static final short PE = 23;
    public static final short PI = 24;
    public static final short PF = 25;
    public static final short PO = 26;
    public static final short SM = 27;
    public static final short SC = 28;
    public static final short SK = 29;
    public static final short SO = 30;
    public static final short ALPHA = 1;
    public static final short LETTER = 2;
    public static final short LOWER = 3;
    public static final short UPPER = 4;
    public static final short TITLE = 5;
    public static final short ALPHANUMERIC = 6;
    public static final short DIGIT = 7;
    public static final short HEX_DIGIT = 8;
    public static final short CTRL = 9;
    public static final short PUNCTUATION = 10;
    public static final short BLANK = 11;
    public static final short SPACE = 12;
    public static final short BASE = 13;
    public static final short GRAPH = 14;
    public static final short PRINTABLE = 15;
    private static final int GENERAL_MASK = 255;
    private static final int BIDICATEGORY_MASK = 32512;
    private static final int COMPATIBILITY_MASK = 32768;
    private static OraUnicodeProperty upCache = null;
    private static final String FILENAME = GDKOracleMetaData.getDataPath() + "unicodeproperty.glb";
    public static final int NO_DECOMP = 0;
    public static final int CANONICAL_DECOMP = 1;
    public static final int COMPATIBILITY_DECOMP = 2;
    public static final int EXCLUSION_DECOMP = 3;
    public static final int MULTI_DECOMP = 10;
    private static final int NFD = 0;
    private static final int NFC = 1;
    private static final int NFKD = 2;
    private static final int NFKC = 3;
    public static final int DW_ZERO = 0;
    public static final int DW_ONE = 1;
    public static final int DW_TWO = 2;
    public static final int DW_AMBIGUOUS = -1;
    protected static final int DW_DELTA = 2;
    protected UnicodeCatTable classTable = null;
    protected UnicodeCatTable combineTable = null;
    protected UnicodeCatTable propTable = null;
    protected UnicodeCatTable bidiTable = null;
    protected HashTree compTable = null;
    protected UnicodeDecompTree decompTable = null;
    protected UnicodeCatTable displayWidthTable = null;
    private HashMap charConvCache = new HashMap();

    protected OraUnicodeProperty() {
    }

    public static synchronized OraUnicodeProperty getInstance() {
        if (upCache == null) {
            upCache = (OraUnicodeProperty)OraBoot.readObj((String)FILENAME);
        }
        return upCache;
    }

    public int getCombiningClass(int n) {
        return this.combineTable.getProperties(n);
    }

    public int getUnicodeProperty(int n) {
        return this.propTable.getProperties(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDisplayWidth(int n, String string, boolean bl) throws SQLException, UnsupportedEncodingException {
        int n2 = this.displayWidthTable.getProperties(n);
        if (n2 != 0) {
            if (n2 != -1) {
                return n2 - 2;
            }
            if (string == null) {
                return this.getDefaultDisplayWidthCJK(n);
            }
            CharacterConverterOGS characterConverterOGS = null;
            OraUnicodeProperty oraUnicodeProperty = this;
            synchronized (oraUnicodeProperty) {
                characterConverterOGS = (CharacterConverterOGS)this.charConvCache.get(string);
                if (characterConverterOGS == null) {
                    String string2 = LocaleMapper.getOraCharacterSet((int)3, (String)string);
                    if (string2 == null) {
                        throw new UnsupportedEncodingException(GDKMessage.getMessage(7001, (Object)string));
                    }
                    String string3 = CharsetMeta.getInstance().getCharSetId(string2);
                    characterConverterOGS = (CharacterConverterOGS)CharacterConverterOGS.getInstance(Integer.parseInt(string3));
                    if (characterConverterOGS == null) {
                        return this.getDefaultDisplayWidthCJK(n);
                    }
                    this.charConvCache.put(string, characterConverterOGS);
                }
            }
            return characterConverterOGS.getDisplayWidth(n, bl);
        }
        return this.getDefaultDisplayWidthCJK(n);
    }

    private int getDefaultDisplayWidthCJK(int n) {
        if (n >>> 16 > 0) {
            return 2;
        }
        return n >= 12287 ? 2 : 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDisplayWidth(String string, String string2, boolean bl) throws SQLException, UnsupportedEncodingException {
        OraNormalizer oraNormalizer = OraNormalizer.getInstance();
        string = oraNormalizer.compose(string);
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            int n5 = n4 = string.charAt(n2++);
            if (UTFUtility.isHiSurrogate((char)n4)) {
                char c;
                int n6 = n4;
                if (n2 + 1 >= n) throw new UnsupportedEncodingException(GDKMessage.getMessage(7002, (Object)new Integer(n2)));
                if (!UTFUtility.isLoSurrogate(c = string.charAt(n2++))) throw new UnsupportedEncodingException(GDKMessage.getMessage(7002, (Object)new Integer(n2 - 1)));
                n5 = n6 << 16 | c;
            }
            n3 += this.getDisplayWidth(n5, string2, bl);
        }
        return n3;
    }

    public short getGeneral(int n) {
        return (short)(this.propTable.getProperties(n) & 0xFF);
    }

    public boolean isCompatibility(int n) {
        if (n >= 63744 && n <= 64045) {
            return true;
        }
        return (this.propTable.getProperties(n) & 0x8000) == 32768;
    }

    public short getClassification(int n) {
        return (short)this.classTable.getProperties(n);
    }

    public short getBidicategory(int n) {
        return 0;
    }

    public void canonicalSort(char[] cArray) {
        int n = cArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            if (cArray[i] >> 10 == 54) {
                n2 = (cArray[i] << 16) + cArray[i + 1];
                nArray[i + 1] = n3 = this.getCombiningClass(n2);
            } else {
                n2 = 0;
                n3 = this.getCombiningClass(cArray[i]);
            }
            nArray[i] = n3;
            if (n3 == 0 || i == 0) continue;
            for (int j = i - 1; j >= 0 && nArray[j] != 0 && n3 < nArray[j]; --j) {
                char c;
                if (n2 == 0) {
                    nArray[j + 1] = nArray[j];
                    nArray[j] = n3;
                    c = cArray[j + 1];
                    cArray[j + 1] = cArray[j];
                    cArray[j] = c;
                    continue;
                }
                nArray[j + 2] = nArray[j];
                nArray[j + 1] = nArray[j] = n3;
                c = cArray[j + 2];
                cArray[j + 2] = cArray[j];
                cArray[j] = cArray[j + 1];
                cArray[j + 1] = c;
            }
            if (n2 == 0) continue;
            ++i;
            n2 = 0;
        }
    }

    public String compose(String string) {
        int n = string.length();
        String string2 = new String();
        String string3 = new String();
        char[] cArray = null;
        for (int i = 0; i < n; ++i) {
            byte by = (byte)(string.charAt(i) >>> 8);
            if (by == 17 || by >= 172 && by < 219) {
                if (string3.length() != 0) {
                    cArray = this.compTable.getData(string3.toCharArray());
                    string2 = string2 + new String(cArray);
                    string3 = new String();
                }
                while (by == 17 || by >= 172 && by < 219) {
                    string3 = string3 + string.charAt(i++);
                    if (i >= n) break;
                    by = (byte)(string.charAt(i) >>> 8);
                }
                string2 = string2 + OraNormalizer.composeHangul(string3);
                string3 = new String();
            }
            if (i >= n) continue;
            string3 = string3 + string.charAt(i);
        }
        if (string3.length() != 0) {
            cArray = this.compTable.getData(string3.toCharArray());
            string2 = string2 + new String(cArray);
        }
        return string2;
    }

    public String decompose(String string, int n) {
        int n2 = string.length();
        char[] cArray = null;
        cArray = this.decompTable.getData(string, n);
        this.canonicalSort(cArray);
        String string2 = new String(cArray);
        return string2;
    }

    public String normalize(String string, int n) {
        String string2;
        switch (n) {
            case 0: {
                string2 = this.decompose(string, 1);
                break;
            }
            case 2: {
                string2 = this.decompose(string, 2);
                break;
            }
            case 3: {
                string2 = this.decompose(string, 2);
                string2 = this.compose(string2);
                break;
            }
            case 1: {
                string2 = this.decompose(string, 2);
                string2 = this.compose(string2);
                break;
            }
            default: {
                string2 = null;
            }
        }
        return string2;
    }
}

