/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ConnectionRecognizer;
import oracle.dbtools.thirdparty.jdbc.DMJDBCBasicPanel;

public class DMJDBCConnectionRecognizer
implements ConnectionRecognizer {
    public static String getURL(Connection conn) {
        String url = null;
        try {
            Method m;
            Class<Connection> c = Class.forName("sun.jdbc.odbc.JdbcOdbcConnection").asSubclass(Connection.class);
            if (c.isAssignableFrom(conn.getClass()) && (m = c.getDeclaredMethod("getURL", new Class[0])) != null) {
                url = (String)m.invoke((Object)conn, new Object[0]);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(DMJDBCBasicPanel.class.getClass().getName()).log(Level.WARNING, ex.getStackTrace()[0].toString(), ex);
        }
        return url;
    }

    public ConnectionInfo createConnectionInfo(String cName, Connection conn) {
        ConnectionInfo inf = null;
        DatabaseMetaData dmd = null;
        try {
            dmd = conn.getMetaData();
            Version ver = DBUtil.getDbVersion((Connection)conn);
            String url = DMJDBCConnectionRecognizer.getURL(conn);
            if (url != null && url.indexOf("Microsoft Access") == -1) {
                inf = new ConnectionInfo(cName, conn, ver, "ODBCBridge", null, dmd.getUserName());
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DMJDBCBasicPanel.class.getClass().getName()).log(Level.WARNING, ex.getStackTrace()[0].toString(), ex);
        }
        return inf;
    }
}

