/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.MissingResourceException;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.Loader;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import org.apache.log4j.Category;
import org.apache.log4j.xml.DOMConfigurator;

public class Logger {
    private static boolean initialized = false;
    private static boolean firstLog = true;
    private static String configurationFile = "log4j.xml";
    private static String LOG_FILE_NAME = "log.file.name";
    private static Long watchDelay = null;
    private Category category = null;

    public Logger(Class component) {
        if (!initialized) {
            Logger.init();
        }
        this.category = Category.getInstance((Class)component);
        if (firstLog) {
            try {
                this.info(Extension.getExtensionVersion());
            }
            catch (Exception e) {
                this.info("3.0");
            }
            firstLog = false;
        }
    }

    private static String getExtensionDir() {
        try {
            ExtensionRegistry er;
            javax.ide.extension.Extension ext;
            if (!Extension.isDataModeler() && (ext = (er = ExtensionRegistry.getExtensionRegistry()).findExtension(Extension.getExtensionID())) != null) {
                String dir = er.getInstallDirectory(ext).getAbsolutePath();
                File file = new File(dir, "log");
                if (!file.exists()) {
                    file.mkdirs();
                }
                return dir;
            }
            return ApplicationView.basePath;
        }
        catch (Exception exception) {
            return "../";
        }
    }

    private static synchronized void init() {
        if (!initialized) {
            URL customUrl = Logger.getCustomLogDir();
            if (customUrl != null) {
                if (!customUrl.getPath().equals("")) {
                    File file = new File(customUrl.getPath());
                    if (file.isDirectory() && Logger.hasPermissions(customUrl.getPath())) {
                        System.setProperty(LOG_FILE_NAME, new File(customUrl.getPath(), "/datamodeler.log").getAbsolutePath());
                    } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
                        System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
                    } else {
                        System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
                    }
                } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
                    System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
                } else {
                    System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
                }
            } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
                System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
            } else {
                System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
            }
            try {
                URL url = Loader.getResource(configurationFile, Logger.class);
                if (watchDelay != null) {
                    DOMConfigurator.configureAndWatch((String)url.getFile(), (long)watchDelay);
                } else {
                    DOMConfigurator.configure((URL)url);
                }
            }
            catch (MissingResourceException mre) {
                System.out.println(mre.getMessage());
            }
            initialized = true;
        }
    }

    public static void configure(String configFile, Long wDelay) {
        if (configurationFile != null) {
            configurationFile = configFile;
        }
        if (watchDelay != null) {
            watchDelay = wDelay;
        }
        initialized = false;
        Logger.init();
    }

    public void debug(Object o) {
        this.category.debug(o);
    }

    public void debug(Object o, Throwable e) {
        this.category.debug(o, e);
    }

    public void error(Object o) {
        this.category.error(o);
    }

    public void error(Object o, Throwable e) {
        this.category.error(o, e);
    }

    public void info(Object o) {
        this.category.info(o);
    }

    public void info(Object o, Throwable e) {
        this.category.info(o, e);
    }

    public void warn(Object o) {
        this.category.warn(o);
    }

    public void warn(Object o, Throwable e) {
        this.category.warn(o, e);
    }

    public boolean isDebugEnabled() {
        return this.category.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.category.isInfoEnabled();
    }

    private static URL getCustomLogDir() {
        try {
            IdeSettings settings = Ide.getSettings();
            EnvironOptions envopts = (EnvironOptions)settings.getData("environment-options");
            if (envopts.isSaveLogToFile()) {
                return envopts.getLogFilePrefix();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void update() {
        URL customUrl = Logger.getCustomLogDir();
        if (customUrl != null) {
            if (!customUrl.getPath().equals("")) {
                File file = new File(customUrl.getPath());
                if (file.isDirectory() && Logger.hasPermissions(customUrl.getPath())) {
                    System.setProperty(LOG_FILE_NAME, new File(customUrl.getPath(), "/datamodeler.log").getAbsolutePath());
                } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
                    System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
                } else {
                    System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
                }
            } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
                System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
            } else {
                System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
            }
        } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
            System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
        } else {
            System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
        }
        try {
            URL url = Loader.getResource(configurationFile, Logger.class);
            if (watchDelay != null) {
                DOMConfigurator.configureAndWatch((String)url.getFile(), (long)watchDelay);
            } else {
                DOMConfigurator.configure((URL)url);
            }
        }
        catch (MissingResourceException mre) {
            System.out.println(mre.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasPermissions(String path) {
        PrintWriter out = null;
        File f = new File(path + "test.log");
        try {
            FileWriter outFile = new FileWriter(f);
            out = new PrintWriter(outFile);
            out.write("test");
            out.flush();
            out.close();
            f.delete();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

