/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.util.Messages;

public class JDBCDriverLoader
extends URLClassLoader {
    private static JDBCDriverLoader instance = null;

    private JDBCDriverLoader() {
        super(new URL[0]);
    }

    public static JDBCDriverLoader getInstance() {
        if (instance == null) {
            instance = new JDBCDriverLoader();
        }
        return instance;
    }

    private void addFile(String path) throws MalformedURLException {
        String urlPath = "jar:file:" + path.replace('\\', '/') + "!/";
        this.addURL(new URL(urlPath));
    }

    private boolean urlExists(String urlStr) {
        URL[] urls = this.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            if (!url.toString().equalsIgnoreCase(urlStr)) continue;
            return true;
        }
        return false;
    }

    public void loadDrivers(List drivers) {
        try {
            for (String url : drivers) {
                if (this.urlExists(url)) continue;
                this.addFile(url);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public Connection getConnection(String classPath, String url, String user, String password) throws Exception {
        Properties prop = new Properties();
        prop.setProperty("user", user);
        prop.setProperty("password", password);
        return this.getConnection(classPath, url, prop);
    }

    public Connection getConnection(String classPath, String url, Properties props) throws Exception {
        if (classPath == null) {
            classPath = "";
        }
        if (url == null) {
            url = "";
        }
        try {
            Driver dr = (Driver)this.loadClass(classPath).newInstance();
            Connection con = dr.connect(url, props);
            if (con == null) {
                throw new Exception(Messages.getString("JDBCDriverLoader.getConnection_invalid_url_for_driver"));
            }
            return con;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception(e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }
}

