/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfiguration;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StandardReportConfigurationsPersistence {
    private static final String SR_FILE_NAME = "standard_reports_configurations.xml";
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(StandardReportConfigurationsPersistence.class);

    StandardReportConfigurationsPersistence(ApplicationView appView) {
        this.appView = appView;
    }

    void saveStandardReportConfigurations() {
        StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        buffer.append("\n");
        buffer.append("<").append("report_templates").append(">");
        for (StandardReportConfiguration sr : this.appView.getStandardReportConfigurations()) {
            List objects;
            buffer.append("\n");
            buffer.append("\t").append("<").append("standard_report").append(' ');
            buffer.append("name=\"").append(StringUtilities.encodeAttributeValue(sr.getName())).append("\"").append(' ');
            buffer.append("description=\"").append(StringUtilities.encodeAttributeValue(sr.getDescription())).append("\"").append(' ');
            buffer.append("design=\"").append(sr.getDesignID()).append("\"").append(' ');
            buffer.append("model=\"").append(sr.getModelID()).append("\"").append(' ');
            buffer.append("inc_dp=\"").append(sr.isIncludeDuplicates()).append("\"").append(' ');
            buffer.append("class=\"").append(sr.getClazz().getName()).append("\"").append(">");
            List<String> sws = sr.getSubviews();
            if (sws.size() > 0) {
                buffer.append("\n");
                buffer.append("\t").append("\t").append("<").append("subviews").append(">");
                for (String sw : sws) {
                    buffer.append("\n");
                    buffer.append("\t").append("\t").append("\t").append("<").append("subview").append(' ');
                    buffer.append("id=\"").append(sw).append("\"").append(' ');
                    buffer.append("/>");
                }
                buffer.append("\n");
                buffer.append("\t").append("\t").append("</").append("subviews").append(">");
            }
            if ((objects = sr.getObjects()).size() > 0) {
                buffer.append("\n");
                buffer.append("\t").append("\t").append("<").append("objects").append(">");
                for (String o : objects) {
                    buffer.append("\n");
                    buffer.append("\t").append("\t").append("\t").append("<").append("object").append(' ');
                    buffer.append("id=\"").append(o).append("\"").append(' ');
                    buffer.append("/>");
                }
                buffer.append("\n");
                buffer.append("\t").append("\t").append("</").append("objects").append(">");
            }
            buffer.append("\n");
            buffer.append("\t").append("</").append("standard_report").append(">");
        }
        buffer.append("\n");
        buffer.append("</").append("report_templates").append(">");
        this.writeToFile(buffer);
    }

    private void writeToFile(StringBuffer buffer) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(XMLTransformationManager.getDefaultSystemTypesPath(), SR_FILE_NAME));
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(buffer.toString());
            osw.close();
        }
        catch (Exception e) {
            LOGGER.error("Unable to save standard reports: ", e);
        }
    }

    public void loadStandardReportConfigurations() {
        try {
            File file = new File(XMLTransformationManager.getDefaultSystemTypesPath(this.appView.getSettings()), SR_FILE_NAME);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                this.loadData(doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load standard report configurations: ", e);
        }
    }

    private void loadData(Document doc) {
        ArrayList<StandardReportConfiguration> loadedReportConfigurations = new ArrayList<StandardReportConfiguration>();
        try {
            NodeList nodes1 = doc.getElementsByTagName("standard_report");
            int nodesLength1 = nodes1.getLength();
            for (int i = 0; i < nodesLength1; ++i) {
                Element elm = (Element)nodes1.item(i);
                Class<?> clazz = null;
                String rc = elm.getAttribute("rc");
                if (!rc.trim().equals("")) {
                    int repCode = Integer.valueOf(rc);
                    if (repCode == 1 || repCode == 2) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.relational.Table");
                    } else if (repCode == 3 || repCode == 4) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.logical.Entity");
                    } else if (repCode == 5) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.Domain");
                    } else if (repCode == 7 || repCode == 8) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.datatypes.StructuredType");
                    } else if (repCode == 9 || repCode == 10) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.datatypes.CollectionType");
                    } else if (repCode == 11 || repCode == 12) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.datatypes.DistinctType");
                    } else if (repCode == 13) {
                        clazz = Class.forName("oracle.dbtools.crest.model.ChangeRequest");
                    } else if (repCode == 14) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.Measurement");
                    }
                } else {
                    clazz = Class.forName(elm.getAttribute("class"));
                }
                if (clazz == null) continue;
                ArrayList<String> subviews = new ArrayList<String>();
                NodeList subviewsNode = elm.getElementsByTagName("subviews");
                int nodesLength = subviewsNode.getLength();
                for (int j = 0; j < nodesLength; ++j) {
                    Element e = (Element)subviewsNode.item(j);
                    NodeList elements = e.getElementsByTagName("subview");
                    int elementsLength = elements.getLength();
                    for (int k = 0; k < elementsLength; ++k) {
                        Element e1 = (Element)elements.item(k);
                        subviews.add(e1.getAttribute("id"));
                    }
                }
                ArrayList<String> objects = new ArrayList<String>();
                NodeList objectsNode = elm.getElementsByTagName("objects");
                int objectsLength = objectsNode.getLength();
                for (int j = 0; j < objectsLength; ++j) {
                    Element e = (Element)objectsNode.item(j);
                    NodeList elements = e.getElementsByTagName("object");
                    int elementsLength = elements.getLength();
                    for (int k = 0; k < elementsLength; ++k) {
                        Element e1 = (Element)elements.item(k);
                        objects.add(e1.getAttribute("id"));
                    }
                }
                StandardReportConfiguration src = new StandardReportConfiguration(clazz, StringUtilities.decodeAttributeValue(elm.getAttribute("name")), StringUtilities.decodeAttributeValue(elm.getAttribute("description")), elm.getAttribute("design"), elm.getAttribute("model"), Boolean.valueOf(elm.getAttribute("inc_dp")), subviews, objects);
                loadedReportConfigurations.add(src);
            }
            this.appView.getStandardReportConfigurations().clear();
            this.appView.getStandardReportConfigurations().addAll(loadedReportConfigurations);
        }
        catch (Exception e) {
            LOGGER.error("Unable to load standard report configurations: ", e);
        }
    }
}

