/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.odbc;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;

public class DBMExtractionWizardODBC
extends AbstractDBMExtractionWizardImpl {
    private static DBMExtractionWizardODBC impl;

    public DBMExtractionWizardODBC(DBMExtractionWizard wizard) {
        super(wizard);
    }

    public static AbstractDBMExtractionWizardImpl getInstance(DBMExtractionWizard wizard) {
        if (impl == null) {
            impl = new DBMExtractionWizardODBC(wizard);
        }
        return impl;
    }

    public static void clearInstance() {
        impl = null;
    }

    @Override
    protected List getCurrentList() {
        int tab = this.getTabbedPane().getSelectedIndex();
        switch (tab) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.lsViews;
            }
        }
        return this.lsTables;
    }

    @Override
    protected void addTabs() {
        if (this.tbTables == null) {
            this.tbTables = this.addTab(this.tbTables, this.lsTables, Messages.getString("DBMExtractionWizardODBC.Tables"));
            this.tbViews = this.addTab(this.tbViews, this.lsViews, Messages.getString("DBMExtractionWizardODBC.Views"));
        }
    }

    @Override
    protected void updateTables() {
        this.tbTables.updateUI();
        this.tbViews.updateUI();
    }

    @Override
    public List getSelectedObjects() {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dbo : this.lsTables) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsViews) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        return list;
    }

    @Override
    protected void clearAll() {
        this.lsTables.clear();
        this.lsViews.clear();
    }

    @Override
    protected void initSpecificObjects(List dbObjects) {
        this.clearAll();
        for (DBObject dbo : dbObjects) {
            String type = dbo.getType();
            if (type.equalsIgnoreCase("TABLE")) {
                this.lsTables.add(dbo);
                continue;
            }
            if (!type.equalsIgnoreCase("VIEW")) continue;
            this.lsViews.add(dbo);
        }
    }
}

