/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.text.pdf.BaseFont;
import java.awt.Font;
import java.io.File;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.logging.Logger;

public class UnicodeFontMapper
implements FontMapper {
    private DefaultFontMapper dfm = new DefaultFontMapper();
    private BaseFont baseFont = null;
    private static final Logger LOGGER = new Logger(UnicodeFontMapper.class);

    public UnicodeFontMapper() {
        try {
            String pdfFont = System.getProperty("datamodeler.pdf.font");
            if (pdfFont != null && pdfFont.trim().length() > 0) {
                try {
                    this.baseFont = BaseFont.createFont((String)pdfFont, (String)"Identity-H", (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.error("Error in UnicodeFontMapper: Unable to create BaseFont", e);
                }
            }
            if (this.baseFont == null) {
                File font;
                if (OSEnvironment.isWindows()) {
                    File font2 = new File("C:/Windows/Fonts/Arialuni.ttf");
                    if (font2.exists()) {
                        this.baseFont = BaseFont.createFont((String)font2.getAbsolutePath(), (String)"Identity-H", (boolean)true);
                    }
                } else if (OSEnvironment.isMacOS() && (font = new File("/Library/Fonts/Arial Unicode.ttf")).exists()) {
                    this.baseFont = BaseFont.createFont((String)font.getAbsolutePath(), (String)"Identity-H", (boolean)true);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in UnicodeFontMapper:", e);
        }
    }

    public BaseFont awtToPdf(Font font) {
        if (this.baseFont != null) {
            return this.baseFont;
        }
        return this.dfm.awtToPdf(font);
    }

    public Font pdfToAwt(BaseFont font, int size) {
        if (this.baseFont != null) {
            return null;
        }
        return this.dfm.pdfToAwt(font, size);
    }
}

