/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.RepaintManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.printing.Messages;

public class PrintPreviewModel
extends Observable
implements Pageable,
Printable {
    private Object objectToPrint = null;
    private Dimension objectDimension = null;
    private PageFormat pageformat = ApplicationView.getInstance().getSettings().getPageFormat();
    private boolean pageCornersEnabled = true;
    private int printXScalingFactor = 100;
    private int printYScalingFactor = 100;
    private int previewXScalingFactor = 10;
    private int previewYScalingFactor = 10;
    private boolean computeRequired = false;
    private int numberOfPages;
    private int numberOfColumns;
    private int numberOfRows;
    private int widthPieceOfObject;
    private int heightPieceOfObject;

    public PrintPreviewModel(Component component, Dimension dimension) {
        this.objectToPrint = component;
        this.objectDimension = dimension;
        this.computeRequired = true;
    }

    @Override
    public int getNumberOfPages() {
        this.computePrintLayout();
        return this.numberOfPages;
    }

    public void setPageCorners(boolean enabled) {
        this.pageCornersEnabled = enabled;
        this.updateObservers();
    }

    public boolean getPageCorners() {
        return this.pageCornersEnabled;
    }

    public void setPageFormat(PageFormat pageformat) {
        this.pageformat = pageformat;
        this.computeRequired = true;
        this.updateObservers();
    }

    public PageFormat getPageFormat() {
        return this.pageformat;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        this.computePrintLayout();
        if (pageIndex >= this.numberOfPages) {
            throw new IndexOutOfBoundsException(MessageFormat.format(Messages.getString("PrintPreviewModel.NumberOfPages"), this.numberOfPages, pageIndex));
        }
        return this.pageformat;
    }

    public int getPreviewHeight() {
        if (this.pageformat.getOrientation() == 1) {
            return (int)(this.pageformat.getHeight() * ((double)this.previewYScalingFactor / 100.0));
        }
        return (int)(this.pageformat.getWidth() * ((double)this.previewYScalingFactor / 100.0));
    }

    public void setPreviewScalingFactors(int previewXScalingFactor, int previewYScalingFactor) {
        this.previewXScalingFactor = previewXScalingFactor;
        this.previewYScalingFactor = previewYScalingFactor;
        this.updateObservers();
    }

    public int getPreviewWidth() {
        if (this.pageformat.getOrientation() == 1) {
            return (int)(this.pageformat.getWidth() * ((double)this.previewXScalingFactor / 100.0));
        }
        return (int)(this.pageformat.getHeight() * ((double)this.previewXScalingFactor / 100.0));
    }

    public int getPreviewXScalingFactor() {
        return this.previewXScalingFactor;
    }

    public int getPreviewYScalingFactor() {
        return this.previewYScalingFactor;
    }

    public void setPrintScalingFactors(int printXScalingFactor, int printYScalingFactor) {
        this.printXScalingFactor = printXScalingFactor;
        this.printYScalingFactor = printYScalingFactor;
        this.computeRequired = true;
        this.updateObservers();
    }

    public int getPrintXScalingFactor() {
        return this.printXScalingFactor;
    }

    public int getPrintYScalingFactor() {
        return this.printYScalingFactor;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        this.computePrintLayout();
        if (pageIndex >= this.numberOfPages) {
            throw new IndexOutOfBoundsException("Number of pages : " + this.numberOfPages + " Requested pageindex : " + pageIndex);
        }
        return this;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        return this.printPieceOfObject(g, pageIndex, false);
    }

    public int printPreview(Graphics g, int pageIndex) {
        return this.printPieceOfObject(g, pageIndex, true);
    }

    public void updateObservers() {
        this.setChanged();
        if (this.countObservers() != 0) {
            this.notifyObservers();
        }
    }

    public void updateObservers(Observer o) {
        this.setChanged();
        this.notifyObservers(o);
    }

    private boolean isDoubleBufferingEnabled() {
        if (this.objectToPrint instanceof Component) {
            RepaintManager currentManager = RepaintManager.currentManager((Component)this.objectToPrint);
            return currentManager.isDoubleBufferingEnabled();
        }
        return false;
    }

    private void computePrintLayout() {
        if (!this.computeRequired) {
            return;
        }
        if (this.objectToPrint == null) {
            this.numberOfPages = 0;
            return;
        }
        int widthScaledObject = (int)((double)this.objectDimension.width * ((double)this.printXScalingFactor / 100.0));
        int heightScaledObject = (int)((double)this.objectDimension.height * ((double)this.printYScalingFactor / 100.0));
        int widthPage = (int)this.pageformat.getImageableWidth();
        int heightPage = (int)this.pageformat.getImageableHeight();
        if (this.pageformat.getOrientation() == 0 || this.pageformat.getOrientation() == 2) {
            widthPage = (int)this.pageformat.getImageableHeight();
            heightPage = (int)this.pageformat.getImageableWidth();
        }
        this.numberOfColumns = Math.max((int)Math.ceil((double)widthScaledObject / (double)widthPage), 1);
        this.numberOfRows = Math.max((int)Math.ceil((double)heightScaledObject / (double)heightPage), 1);
        this.widthPieceOfObject = (int)((double)widthPage / ((double)this.printXScalingFactor / 100.0));
        this.heightPieceOfObject = (int)((double)heightPage / ((double)this.printYScalingFactor / 100.0));
        this.numberOfPages = this.numberOfColumns * this.numberOfRows;
        this.computeRequired = false;
    }

    private void disableDoubleBuffering() {
        if (this.objectToPrint instanceof Component) {
            RepaintManager currentManager = RepaintManager.currentManager((Component)this.objectToPrint);
            currentManager.setDoubleBufferingEnabled(false);
        }
    }

    private void enableDoubleBuffering() {
        if (this.objectToPrint instanceof Component) {
            RepaintManager currentManager = RepaintManager.currentManager((Component)this.objectToPrint);
            currentManager.setDoubleBufferingEnabled(true);
        }
    }

    private int printPieceOfObject(Graphics g, int pageIndex, boolean scaleForPreview) {
        this.computePrintLayout();
        if (pageIndex >= this.numberOfPages || this.objectToPrint == null) {
            return 1;
        }
        boolean reEnableDoubleBuffering = false;
        if (this.isDoubleBufferingEnabled()) {
            this.disableDoubleBuffering();
            reEnableDoubleBuffering = true;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform transform = g2d.getTransform();
        double pageXScalingFactor = 1.0;
        double pageYScalingFactor = 1.0;
        if (scaleForPreview) {
            pageXScalingFactor = (double)this.previewXScalingFactor / 100.0;
            pageYScalingFactor = (double)this.previewYScalingFactor / 100.0;
        }
        double imageXScalingFactor = (double)this.printXScalingFactor / 100.0;
        double imageYScalingFactor = (double)this.printYScalingFactor / 100.0;
        if (scaleForPreview) {
            imageXScalingFactor *= (double)this.previewXScalingFactor / 100.0;
            imageYScalingFactor *= (double)this.previewYScalingFactor / 100.0;
        }
        int iCol = pageIndex % this.numberOfColumns;
        int iRow = pageIndex / this.numberOfColumns;
        int xImage = iCol * this.widthPieceOfObject;
        int yImage = iRow * this.heightPieceOfObject;
        int wImage = Math.min(this.widthPieceOfObject, this.objectDimension.width - xImage);
        int hImage = Math.min(this.heightPieceOfObject, this.objectDimension.height - yImage);
        if (this.objectToPrint instanceof Image) {
            g2d.translate(this.pageformat.getPaper().getImageableX() * pageXScalingFactor, this.pageformat.getPaper().getImageableY() * pageYScalingFactor);
            g2d.scale(imageXScalingFactor, imageYScalingFactor);
            g2d.drawImage((Image)this.objectToPrint, 0, 0, wImage - 1, hImage - 1, xImage, yImage, xImage + wImage - 1, yImage + hImage - 1, null);
        } else {
            g2d.translate(this.pageformat.getPaper().getImageableX() * pageXScalingFactor, this.pageformat.getPaper().getImageableY() * pageYScalingFactor);
            g2d.translate((double)(-xImage) * imageXScalingFactor, (double)(-yImage) * imageYScalingFactor);
            g2d.scale(imageXScalingFactor, imageYScalingFactor);
            Shape clip = g2d.getClip();
            g2d.clipRect(xImage, yImage, wImage, hImage);
            ((Component)this.objectToPrint).paint(g2d);
            g2d.setClip(clip);
        }
        g2d.setTransform(transform);
        g2d.translate(this.pageformat.getPaper().getImageableX() * pageXScalingFactor, this.pageformat.getPaper().getImageableY() * pageYScalingFactor);
        g2d.scale(pageXScalingFactor, pageYScalingFactor);
        int widthPage = (int)this.pageformat.getImageableWidth();
        int heightPage = (int)this.pageformat.getImageableHeight();
        if (this.pageformat.getOrientation() == 0 || this.pageformat.getOrientation() == 2) {
            widthPage = (int)this.pageformat.getImageableHeight();
            heightPage = (int)this.pageformat.getImageableWidth();
        }
        if (this.pageCornersEnabled && this.numberOfPages > 1) {
            g2d.setColor(Color.black);
            g2d.drawLine(0, 0, 20, 0);
            g2d.drawLine(0, 0, 0, 20);
            g2d.drawLine(widthPage, 0, widthPage - 20, 0);
            g2d.drawLine(widthPage, 0, widthPage, 20);
            g2d.drawLine(0, heightPage, 20, heightPage);
            g2d.drawLine(0, heightPage, 0, heightPage - 20);
            g2d.drawLine(widthPage, heightPage, widthPage - 20, heightPage);
            g2d.drawLine(widthPage, heightPage, widthPage, heightPage - 20);
        }
        g2d.setTransform(transform);
        if (this.numberOfPages > 1) {
            FontMetrics fm = g.getFontMetrics();
            String footer = "row " + (iRow + 1) + " / col " + (iCol + 1);
            if (this.pageformat.getOrientation() == 1) {
                int xCursor = ((int)this.pageformat.getWidth() - fm.stringWidth(footer)) / 2;
                g2d.drawString(footer, xCursor, (int)this.pageformat.getHeight() - 20);
            } else {
                int xCursor = ((int)this.pageformat.getHeight() - fm.stringWidth(footer)) / 2;
                g2d.drawString(footer, xCursor, (int)this.pageformat.getWidth() - 20);
            }
        }
        if (reEnableDoubleBuffering) {
            this.enableDoubleBuffering();
        }
        return 0;
    }

    public void computeSettings() {
        this.computePrintLayout();
    }

    public Object getObjectToPrint() {
        return this.objectToPrint;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getPageWidth() {
        return this.widthPieceOfObject;
    }

    public int getPageHeight() {
        return this.heightPieceOfObject;
    }
}

