/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class NodegroupPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private NodeGroupUDB nodegroup;
    private JComboBox cbScope;
    private JTextField tfNodeNumbers;

    public NodegroupPropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.nodegroup = (NodeGroupUDB)object;
        this.setHeight(140);
        this.initCommentsView(35);
        this.initCommentsInRDBMS(35);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("NodegroupPropertyDialogUDB.NodegroupProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initScope();
        this.initNodeNumbers();
    }

    private void initScope() {
        JLabel label = new JLabel(Messages.getString("NodegroupPropertyDialogUDB.Scope"));
        this.general.add(label);
        this.cbScope = new JComboBox<String>(NodeGroupUDB.getAvailableScopes());
        this.cbScope.addActionListener(new ScopeListener());
        this.setBG(this.cbScope);
        this.cbScope.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScope);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbScope, 50);
    }

    private void initNodeNumbers() {
        JLabel label = new JLabel(Messages.getString("NodegroupPropertyDialogUDB.NodeNumbers"));
        this.general.add(label);
        this.tfNodeNumbers = new JTextField("", 26);
        this.general.add(this.tfNodeNumbers);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfNodeNumbers, 80);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.nodegroup.getName());
        this.tfName.setText(this.nodegroup.getName());
        this.cbScope.setSelectedItem(this.nodegroup.getScope());
        this.tfNodeNumbers.setText(this.nodegroup.getNodeNumbers());
        if (this.nodegroup.getScope().equalsIgnoreCase("ON SOME NODES")) {
            this.tfNodeNumbers.setEnabled(true);
        } else {
            this.tfNodeNumbers.setEnabled(false);
        }
        this.getCommentsList().insert(this.nodegroup.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.nodegroup.getCommentInRDBMS(), 0);
        if (this.nodegroup.isNullInstance()) {
            this.tfName.setEditable(false);
            this.cbScope.setEnabled(false);
            this.tfNodeNumbers.setEditable(false);
            this.getCommentsList().setEditable(false);
            this.getCommentsInRDBMSList().setEditable(false);
        }
    }

    @Override
    protected void setProperties() {
        if (this.nodegroup != null && !this.nodegroup.isNullInstance()) {
            this.nodegroup.setName(this.tfName.getText());
            this.nodegroup.setScope((String)this.cbScope.getSelectedItem());
            this.nodegroup.setNodeNumbers(this.tfNodeNumbers.getText());
            this.nodegroup.setComment(this.getCommentsList().getText());
            this.nodegroup.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    private class ScopeListener
    implements ActionListener {
        private ScopeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((String)NodegroupPropertyDialogUDB.this.cbScope.getSelectedItem()).equalsIgnoreCase("ON SOME NODES")) {
                NodegroupPropertyDialogUDB.this.tfNodeNumbers.setEnabled(true);
            } else {
                NodegroupPropertyDialogUDB.this.tfNodeNumbers.setEnabled(false);
            }
        }
    }
}

