/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.UDPLibrary;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.editor.UserDefinedPropertyGroup;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.util.ColorChooserDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class UDPLibraryPropertiesDialog
extends CustomDialogML
implements AbstractEditorConstants {
    private static final String UDP_NAME = "UDP";
    private static final String UDP_GROUP_NAME = "UDPGroup";
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private JDialog dialog;
    private List lovList;
    private List objectsList;
    private int gCounter = 0;
    private int pCounter = 0;
    private JTextField tfFileName;
    private JTextArea taDescription;
    private JTextField tfPropertyName;
    private JTextField tfDisplayName;
    private JComboBox cmbType;
    private JComboBox cmbGroup;
    private JTextField tfDefaultValue;
    private JButton bnAddToLOV;
    private JButton bnRemoveFromLOV;
    private JButton bnRemoveProperty;
    private JTextField propertyFilter;
    private JTable lovTable;
    private JTable objectsTable;
    private ApplicationView appView;
    private UDPLibrary library;
    private DefaultListModel parentModel;
    private UserDefinedProperty currentSelectedProperty;
    private UserDefinedProperty previousSelectedProperty;
    private boolean editMode;
    private String tableStr = ReportConstants.classToNameMap.get(Table.class);
    private String entityStr = ReportConstants.classToNameMap.get(Entity.class);
    private JPanel northPanel;
    private JPanel westPanel;
    private JPanel eastPanel;
    private JPanel buttonsPanel;
    private DefaultComboBoxModel cmbGroupModel;
    private JTable groupsTable;
    private UDPGroupTableModel udpGroupTableModel;
    private List udpGroupsList;
    private JTextField groupFilter;
    private List propertiesList;
    private PropertiesTableModel propertiesTableModel;
    private JTable propertiesTable;
    private PropertiesTableSelectionListener propertiesTableSelectionListener;
    private JButton btnSave;
    private static final Logger LOGGER = new Logger(UDPLibraryPropertiesDialog.class);

    public UDPLibraryPropertiesDialog(ApplicationView appView, UDPLibrary lib, DefaultListModel model) {
        super(appView);
        this.appView = appView;
        this.parentModel = model;
        if (lib != null) {
            this.library = lib;
            this.editMode = true;
        } else {
            this.library = new UDPLibrary();
            this.editMode = false;
        }
        this.initGUI();
        this.initButtons();
        this.initData();
        this.add((Component)this.northPanel, new CC().maxHeight("60").minHeight("60").growX().dockNorth());
        this.add((Component)this.westPanel, new CC().minWidth("220").grow());
        this.add((Component)this.eastPanel, new CC().minWidth("480").grow());
        this.add((Component)this.buttonsPanel, new CC().height("50").dockSouth());
    }

    private void initGUI() {
        this.northPanel = new JPanel((LayoutManager)new MigLayout());
        this.northPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UDPLibraryPropertiesDialog.File")));
        JLabel lbFileName = new JLabel(Messages.getString("UDPLibraryPropertiesDialog.FileName"));
        this.tfFileName = new JTextField();
        JLabel lbFileNameExt = new JLabel(".udposdm");
        this.northPanel.add((Component)lbFileName, new CC().minWidth("100").maxWidth("100"));
        this.northPanel.add((Component)this.tfFileName, new CC().minWidth("200").maxWidth("200"));
        this.northPanel.add((Component)lbFileNameExt, new CC().minWidth("100").maxWidth("100"));
        this.westPanel = new JPanel((LayoutManager)new MigLayout(new LC().fill().flowY().minWidth("220").maxWidth("300").minHeight("100")));
        JPanel udpGroupsPanel = new JPanel((LayoutManager)new MigLayout(new LC().fill().flowY()));
        udpGroupsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.Groups")));
        JToolBar toolBar1 = new JToolBar(0);
        toolBar1.setFloatable(false);
        toolBar1.setRollover(true);
        toolBar1.setBorder(null);
        JButton bnAddGroup = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        bnAddGroup.setToolTipText(BTN_ADD);
        bnAddGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDefinedPropertyGroup group = new UserDefinedPropertyGroup(null, UDPLibraryPropertiesDialog.this.generateUDPGroupName());
                if (UDPLibraryPropertiesDialog.this.groupsTable.getRowSorter() != null) {
                    UDPLibraryPropertiesDialog.this.groupsTable.getRowSorter().setSortKeys(null);
                }
                UDPLibraryPropertiesDialog.this.udpGroupsList.add(group);
                UDPLibraryPropertiesDialog.this.library.getUDPGroups().add(group);
                UDPLibraryPropertiesDialog.this.reloadComboBoxGroups();
                if (UDPLibraryPropertiesDialog.this.udpGroupsList.size() == 1) {
                    UDPLibraryPropertiesDialog.this.initGroupsTableSorter();
                }
                WindowsTableHeader.setSortedHeader(UDPLibraryPropertiesDialog.this.groupsTable, 0);
                int lastRow = UDPLibraryPropertiesDialog.this.groupsTable.convertRowIndexToView(UDPLibraryPropertiesDialog.this.udpGroupsList.size() - 1);
                UDPLibraryPropertiesDialog.this.groupsTable.setRowSelectionInterval(lastRow, lastRow);
                UDPLibraryPropertiesDialog.this.groupsTable.updateUI();
            }
        });
        final JButton bnRemoveGroup = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        bnRemoveGroup.setToolTipText(BTN_REMOVE);
        bnRemoveGroup.setEnabled(false);
        bnRemoveGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selRow = UDPLibraryPropertiesDialog.this.groupsTable.getSelectedRow();
                if (selRow > -1) {
                    UserDefinedPropertyGroup group = (UserDefinedPropertyGroup)UDPLibraryPropertiesDialog.this.udpGroupsList.get(UDPLibraryPropertiesDialog.this.groupsTable.convertRowIndexToModel(UDPLibraryPropertiesDialog.this.groupsTable.getSelectedRow()));
                    int result = JOptionPane.showConfirmDialog(UDPLibraryPropertiesDialog.this, MessageFormat.format(Messages.getString("UDPLibraryPropertiesDialog.AreUSure"), group.getName()), Messages.getString("UDPLibraryPropertiesDialog.SelectAnOption"), 0);
                    if (result == 0) {
                        UDPLibraryPropertiesDialog.this.library.getUDPGroups().remove(group);
                        UDPLibraryPropertiesDialog.this.udpGroupsList.remove(group);
                        if (UDPLibraryPropertiesDialog.this.groupsTable.getRowSorter() != null) {
                            if (UDPLibraryPropertiesDialog.this.udpGroupsList.size() >= 1) {
                                UDPLibraryPropertiesDialog.this.groupsTable.getRowSorter().setSortKeys(null);
                            } else {
                                UDPLibraryPropertiesDialog.this.groupsTable.setAutoCreateRowSorter(false);
                                UDPLibraryPropertiesDialog.this.groupsTable.setRowSorter(null);
                            }
                        }
                        UDPLibraryPropertiesDialog.this.groupsTable.updateUI();
                        if (UDPLibraryPropertiesDialog.this.udpGroupsList.size() >= 1) {
                            WindowsTableHeader.setSortedHeader(UDPLibraryPropertiesDialog.this.groupsTable, 0);
                        }
                        for (UserDefinedProperty udp : UDPLibraryPropertiesDialog.this.library.getPropertiesList()) {
                            if (!udp.getGroup().getId().equals(group.getId())) continue;
                            udp.setGroup(null);
                        }
                    }
                }
            }
        });
        JLabel groupFilterLabel = new JLabel(Messages.getString("UDPLibraryPropertiesDialog.Filter"));
        groupFilterLabel.setPreferredSize(new Dimension(50, 20));
        groupFilterLabel.setMinimumSize(new Dimension(50, 20));
        groupFilterLabel.setMaximumSize(new Dimension(50, 20));
        this.groupFilter = new JTextField();
        this.groupFilter.setEnabled(false);
        this.groupFilter.setPreferredSize(new Dimension(105, 20));
        this.groupFilter.setMinimumSize(new Dimension(105, 20));
        this.groupFilter.setMaximumSize(new Dimension(105, 20));
        this.groupFilter.getDocument().addDocumentListener(new GroupFilterListener());
        toolBar1.add(bnAddGroup);
        toolBar1.add(bnRemoveGroup);
        toolBar1.addSeparator();
        toolBar1.add(groupFilterLabel);
        toolBar1.add(this.groupFilter);
        this.udpGroupsList = new ArrayList();
        this.udpGroupTableModel = new UDPGroupTableModel();
        this.groupsTable = new JTable(this.udpGroupTableModel);
        this.groupsTable.setShowGrid(false);
        this.groupsTable.getTableHeader().setReorderingAllowed(false);
        this.groupsTable.setIntercellSpacing(new Dimension(0, 0));
        this.groupsTable.setSelectionMode(0);
        this.groupsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selRow = UDPLibraryPropertiesDialog.this.groupsTable.getSelectedRow();
                if (selRow == -1) {
                    bnRemoveGroup.setEnabled(false);
                } else {
                    bnRemoveGroup.setEnabled(true);
                }
            }
        });
        TableColumn col1 = this.groupsTable.getColumnModel().getColumn(1);
        col1.setCellRenderer(new ButtonColumnCellRenderer());
        col1.setCellEditor(new ButtonColumnCellEditor());
        col1.setMinWidth(20);
        col1.setMaxWidth(20);
        col1.setPreferredWidth(20);
        DefaultCellEditor singleclick = new DefaultCellEditor(new JTextField());
        singleclick.setClickCountToStart(1);
        TableColumn col = this.groupsTable.getColumnModel().getColumn(0);
        col.setCellEditor(singleclick);
        this.udpGroupsList.addAll(this.library.getUDPGroups());
        this.initGroupsTableSorter();
        udpGroupsPanel.add((Component)toolBar1, new CC().dockNorth());
        udpGroupsPanel.add((Component)new JScrollPane(this.groupsTable), new CC().maxHeight("150").growX());
        JPanel propertiesPanel = new JPanel((LayoutManager)new MigLayout(new LC().fill().flowY()));
        propertiesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UDPLibraryPropertiesDialog.Properties")));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        JButton bnAddProperty = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        bnAddProperty.setToolTipText(BTN_ADD);
        bnAddProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UDPLibraryPropertiesDialog.this.propertiesTable.getRowSorter() != null) {
                    UDPLibraryPropertiesDialog.this.propertiesTable.getRowSorter().setSortKeys(null);
                }
                UDPLibraryPropertiesDialog.this.savePreviousSelectedProperty();
                UserDefinedProperty p = new UserDefinedProperty(UDPLibraryPropertiesDialog.this.library, UDPLibraryPropertiesDialog.this.generatePropertyName(), UserDefinedProperty.TEXT);
                UDPLibraryPropertiesDialog.this.propertiesList.add(p);
                if (UDPLibraryPropertiesDialog.this.propertiesList.size() == 1) {
                    UDPLibraryPropertiesDialog.this.initPropertiesTableSorter();
                }
                WindowsTableHeader.setSortedHeader(UDPLibraryPropertiesDialog.this.propertiesTable, 0);
                int lastRow = UDPLibraryPropertiesDialog.this.propertiesTable.convertRowIndexToView(UDPLibraryPropertiesDialog.this.propertiesList.size() - 1);
                UDPLibraryPropertiesDialog.this.propertiesTable.setRowSelectionInterval(lastRow, lastRow);
                UDPLibraryPropertiesDialog.this.propertiesTable.updateUI();
            }
        });
        this.bnRemoveProperty = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.bnRemoveProperty.setToolTipText(BTN_REMOVE);
        this.bnRemoveProperty.setEnabled(false);
        this.bnRemoveProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDefinedProperty property = (UserDefinedProperty)UDPLibraryPropertiesDialog.this.propertiesList.get(UDPLibraryPropertiesDialog.this.propertiesTable.convertRowIndexToModel(UDPLibraryPropertiesDialog.this.propertiesTable.getSelectedRow()));
                int result = JOptionPane.showConfirmDialog(UDPLibraryPropertiesDialog.this, MessageFormat.format(Messages.getString("UDPLibraryPropertiesDialog.AreUSure"), property.getName()), Messages.getString("UDPLibraryPropertiesDialog.SelectAnOption"), 0);
                if (result == 0) {
                    UDPLibraryPropertiesDialog.this.propertiesList.remove(property);
                    if (UDPLibraryPropertiesDialog.this.propertiesTable.getRowSorter() != null) {
                        if (UDPLibraryPropertiesDialog.this.propertiesList.size() >= 1) {
                            UDPLibraryPropertiesDialog.this.propertiesTable.getRowSorter().setSortKeys(null);
                        } else {
                            UDPLibraryPropertiesDialog.this.propertiesTable.setAutoCreateRowSorter(false);
                            UDPLibraryPropertiesDialog.this.propertiesTable.setRowSorter(null);
                        }
                    }
                    UDPLibraryPropertiesDialog.this.propertiesTable.updateUI();
                    if (UDPLibraryPropertiesDialog.this.propertiesList.size() >= 1) {
                        WindowsTableHeader.setSortedHeader(UDPLibraryPropertiesDialog.this.propertiesTable, 0);
                    }
                }
            }
        });
        JLabel propertyFilterLabel = new JLabel(Messages.getString("UDPLibraryPropertiesDialog.Filter"));
        propertyFilterLabel.setPreferredSize(new Dimension(50, 20));
        propertyFilterLabel.setMinimumSize(new Dimension(50, 20));
        propertyFilterLabel.setMaximumSize(new Dimension(50, 20));
        this.propertyFilter = new JTextField();
        this.propertyFilter.setEnabled(false);
        this.propertyFilter.setPreferredSize(new Dimension(105, 20));
        this.propertyFilter.setMinimumSize(new Dimension(105, 20));
        this.propertyFilter.setMaximumSize(new Dimension(105, 20));
        this.propertyFilter.getDocument().addDocumentListener(new PropertyFilterListener());
        toolBar.add(bnAddProperty);
        toolBar.add(this.bnRemoveProperty);
        toolBar.addSeparator();
        toolBar.add(propertyFilterLabel);
        toolBar.add(this.propertyFilter);
        this.propertiesList = new ArrayList();
        this.propertiesTableModel = new PropertiesTableModel();
        this.propertiesTable = new JTable(this.propertiesTableModel);
        this.propertiesTable.setShowGrid(false);
        this.propertiesTable.setIntercellSpacing(new Dimension(0, 0));
        this.propertiesTable.setSelectionMode(0);
        this.propertiesTableSelectionListener = new PropertiesTableSelectionListener();
        this.propertiesTable.getSelectionModel().addListSelectionListener(this.propertiesTableSelectionListener);
        TableColumn col0 = this.propertiesTable.getColumnModel().getColumn(0);
        col0.setCellRenderer(new PropertyNameTableContentRenderer());
        propertiesPanel.add((Component)toolBar, new CC().dockNorth());
        propertiesPanel.add((Component)new JScrollPane(this.propertiesTable), new CC().grow());
        this.westPanel.add((Component)udpGroupsPanel, new CC().dockNorth());
        this.westPanel.add((Component)propertiesPanel, new CC().grow());
        this.eastPanel = new JPanel((LayoutManager)new MigLayout(new LC().flowY().fill(), new AC(), new AC()));
        this.eastPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UDPLibraryPropertiesDialog.7")));
        JLabel lbPropertyName = new JLabel(Messages.getString("UDPLibraryPropertiesDialog.PropertyDetails"));
        this.tfPropertyName = new JTextField();
        this.tfPropertyName.setEnabled(false);
        JLabel lbDisplayName = new JLabel(Messages.getString("UDPLibraryPropertiesDialog.DisplayName"));
        this.tfDisplayName = new JTextField();
        this.tfDisplayName.setEnabled(false);
        JLabel lbType = new JLabel(Messages.getString("UDPLibraryPropertiesDialog.Type"));
        this.cmbType = new JComboBox<String>(UserDefinedProperty.TYPES_ARRAY);
        this.cmbType.setSelectedItem(UserDefinedProperty.TEXT);
        this.cmbType.setEnabled(false);
        this.cmbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String current = (String)UDPLibraryPropertiesDialog.this.cmbType.getSelectedItem();
                if (current.equals(UserDefinedProperty.LIST)) {
                    UDPLibraryPropertiesDialog.this.lovTable.setEnabled(true);
                    UDPLibraryPropertiesDialog.this.bnAddToLOV.setEnabled(true);
                    UDPLibraryPropertiesDialog.this.tfDefaultValue.setEnabled(false);
                } else {
                    UDPLibraryPropertiesDialog.this.stopCellEditing(UDPLibraryPropertiesDialog.this.lovTable);
                    UDPLibraryPropertiesDialog.this.lovTable.clearSelection();
                    UDPLibraryPropertiesDialog.this.lovTable.setEnabled(false);
                    UDPLibraryPropertiesDialog.this.bnAddToLOV.setEnabled(false);
                    UDPLibraryPropertiesDialog.this.tfDefaultValue.setEnabled(true);
                }
            }
        });
        JLabel lbGroup = new JLabel(Messages.getString("UDPLibraryPropertiesDialog.Group"));
        this.cmbGroupModel = new DefaultComboBoxModel();
        this.cmbGroup = new JComboBox(this.cmbGroupModel);
        this.cmbGroupModel.addElement(" ");
        this.reloadComboBoxGroups();
        this.cmbGroup.setRenderer(new GroupRenderer());
        this.cmbGroup.setEnabled(false);
        JLabel lbDefaultValue = new JLabel(Messages.getString("UDPLibraryPropertiesDialog.DefaultValue"));
        this.tfDefaultValue = new JTextField();
        this.tfDefaultValue.setEnabled(false);
        JPanel lovPanel = new JPanel((LayoutManager)new MigLayout(new LC().fill()));
        lovPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UDPLibraryPropertiesDialog.ListOfValues")));
        JToolBar lovToolBar = new JToolBar(0);
        lovToolBar.setFloatable(false);
        lovToolBar.setRollover(true);
        lovToolBar.setBorder(null);
        this.bnAddToLOV = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.bnAddToLOV.setToolTipText(BTN_ADD);
        this.bnAddToLOV.setEnabled(false);
        this.bnAddToLOV.addActionListener(new AddToLOVAction());
        this.bnRemoveFromLOV = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.bnRemoveFromLOV.setToolTipText(BTN_REMOVE);
        this.bnRemoveFromLOV.setEnabled(false);
        this.bnRemoveFromLOV.addActionListener(new RemoveFromLOVAction());
        lovToolBar.add(this.bnAddToLOV);
        lovToolBar.add(this.bnRemoveFromLOV);
        this.lovList = new ArrayList();
        this.lovTable = new JTable(new LOVTableModel());
        this.lovTable.setSurrendersFocusOnKeystroke(true);
        this.lovTable.setSelectionMode(0);
        JScrollPane lovSP = new JScrollPane(this.lovTable);
        lovPanel.add((Component)lovToolBar, new CC().dockNorth());
        lovPanel.add((Component)lovSP, new CC().grow());
        this.lovTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (UDPLibraryPropertiesDialog.this.lovTable.getSelectedRow() == -1) {
                        UDPLibraryPropertiesDialog.this.bnRemoveFromLOV.setEnabled(false);
                    } else {
                        UDPLibraryPropertiesDialog.this.bnRemoveFromLOV.setEnabled(true);
                    }
                }
            }
        });
        this.lovTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tc0 = this.lovTable.getColumnModel().getColumn(0);
        tc0.setCellEditor(new LOVValueCellEditor(new JTextField()));
        TableColumn tc1 = this.lovTable.getColumnModel().getColumn(1);
        tc1.setPreferredWidth(50);
        tc1.setMinWidth(50);
        tc1.setMaxWidth(50);
        tc1.setCellRenderer(new RadioButtonRenderer());
        tc1.setCellEditor(new RadioButtonEditor(new JCheckBox()));
        this.objectsList = new ArrayList();
        this.objectsTable = new JTable(new ObjectsTableModel());
        this.objectsTable.setSelectionMode(0);
        this.objectsTable.setEnabled(false);
        JScrollPane objectsSP = new JScrollPane(this.objectsTable);
        objectsSP.setBorder(BorderFactory.createTitledBorder(Messages.getString("UDPLibraryPropertiesDialog.Objects")));
        this.objectsTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tcOT0 = this.objectsTable.getColumnModel().getColumn(0);
        TableColumn tcOT1 = this.objectsTable.getColumnModel().getColumn(1);
        tcOT1.setPreferredWidth(50);
        tcOT1.setMinWidth(50);
        tcOT1.setMaxWidth(50);
        TableColumn tcOT2 = this.objectsTable.getColumnModel().getColumn(2);
        tcOT2.setPreferredWidth(50);
        tcOT2.setMinWidth(50);
        tcOT2.setMaxWidth(50);
        tcOT2.setCellRenderer(new ColumnVisibleRenderer());
        TableColumn tcOT3 = this.objectsTable.getColumnModel().getColumn(3);
        tcOT3.setPreferredWidth(50);
        tcOT3.setMinWidth(50);
        tcOT3.setMaxWidth(50);
        tcOT3.setCellEditor(new ObjectColorCellEditor());
        tcOT3.setCellRenderer(new ObjectColorCellRenderer());
        this.taDescription = new JTextArea();
        this.taDescription.setWrapStyleWord(true);
        this.taDescription.setEnabled(false);
        JScrollPane descriptionSP = new JScrollPane(this.taDescription);
        descriptionSP.setBorder(BorderFactory.createTitledBorder(Messages.getString("UDPLibraryPropertiesDialog.Description")));
        JPanel eastPanel1 = new JPanel((LayoutManager)new MigLayout(new LC(), new AC().grow(new Float(2.0f).floatValue(), new int[]{1, 3}), new AC()));
        eastPanel1.add((Component)lbPropertyName, new CC().width("100"));
        eastPanel1.add((Component)this.tfPropertyName, new CC().minWidth("150").gapRight("10").growX());
        eastPanel1.add((Component)lbType, new CC().width("50"));
        eastPanel1.add((Component)this.cmbType, new CC().minWidth("80").maxWidth("200").growX().wrap());
        eastPanel1.add((Component)lbDisplayName, new CC().width("100"));
        eastPanel1.add((Component)this.tfDisplayName, new CC().minWidth("150").gapRight("10").growX());
        eastPanel1.add((Component)lbGroup, new CC().width("50"));
        eastPanel1.add((Component)this.cmbGroup, new CC().minWidth("80").maxWidth("200").growX().wrap());
        eastPanel1.add((Component)lbDefaultValue, new CC().width("100"));
        eastPanel1.add((Component)this.tfDefaultValue, new CC().minWidth("150").gapRight("10").growX());
        this.eastPanel.add((Component)eastPanel1, new CC().dockNorth());
        this.eastPanel.add((Component)descriptionSP, new CC().spanX(4).grow().minHeight("50"));
        this.eastPanel.add((Component)lovPanel, new CC().spanX(4).grow().height("100"));
        this.eastPanel.add((Component)objectsSP, new CC().dockSouth().minHeight("250").maxHeight("250"));
    }

    private void initButtons() {
        this.buttonsPanel = new JPanel((LayoutManager)new MigLayout(new LC(), new AC().grow().align("center")));
        this.btnSave = new JButton(Messages.getString("UDPLibraryPropertiesDialog.Save"));
        this.btnSave.setEnabled(false);
        this.btnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnSave.addActionListener(new SaveAction());
        this.btnSave.setMnemonic(79);
        JButton btnCancel = new JButton(Messages.getString("UDPLibraryPropertiesDialog.Cancel"));
        btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UDPLibraryPropertiesDialog.this.close();
            }
        });
        btnCancel.setMnemonic(67);
        JButton btnHelp = new JButton(Messages.getString("UDPLibraryPropertiesDialog.Help"));
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnHelp.setMnemonic(72);
        JPanel bPanel = new JPanel();
        bPanel.add(this.btnSave);
        bPanel.add(btnCancel);
        bPanel.add(btnHelp);
        this.buttonsPanel.add(bPanel);
    }

    private void initData() {
        if (this.library != null) {
            String fn = this.library.getFileName();
            if (!fn.trim().equals("")) {
                this.tfFileName.setText(fn.substring(0, fn.lastIndexOf(".")));
            }
            this.propertiesList.clear();
            if (this.library.getPropertiesList().size() > 0) {
                for (UserDefinedProperty p : this.library.getPropertiesList()) {
                    this.propertiesList.add(p);
                }
            }
            this.initPropertiesTableSorter();
        }
        UDPLibrary uDPLibrary = this.library;
        uDPLibrary.getClass();
        this.objectsList.add(uDPLibrary.new UDPLibrary.UsedObject(Table.class));
        UDPLibrary uDPLibrary2 = this.library;
        uDPLibrary2.getClass();
        this.objectsList.add(uDPLibrary2.new UDPLibrary.UsedObject(Column.class));
        UDPLibrary uDPLibrary3 = this.library;
        uDPLibrary3.getClass();
        this.objectsList.add(uDPLibrary3.new UDPLibrary.UsedObject(Index.class));
        UDPLibrary uDPLibrary4 = this.library;
        uDPLibrary4.getClass();
        this.objectsList.add(uDPLibrary4.new UDPLibrary.UsedObject(FKIndexAssociation.class));
        UDPLibrary uDPLibrary5 = this.library;
        uDPLibrary5.getClass();
        this.objectsList.add(uDPLibrary5.new UDPLibrary.UsedObject(TableView.class));
        UDPLibrary uDPLibrary6 = this.library;
        uDPLibrary6.getClass();
        this.objectsList.add(uDPLibrary6.new UDPLibrary.UsedObject(Entity.class));
        UDPLibrary uDPLibrary7 = this.library;
        uDPLibrary7.getClass();
        this.objectsList.add(uDPLibrary7.new UDPLibrary.UsedObject(Attribute.class));
        UDPLibrary uDPLibrary8 = this.library;
        uDPLibrary8.getClass();
        this.objectsList.add(uDPLibrary8.new UDPLibrary.UsedObject(Relation.class));
        UDPLibrary uDPLibrary9 = this.library;
        uDPLibrary9.getClass();
        this.objectsList.add(uDPLibrary9.new UDPLibrary.UsedObject(EntityView.class));
        UDPLibrary uDPLibrary10 = this.library;
        uDPLibrary10.getClass();
        this.objectsList.add(uDPLibrary10.new UDPLibrary.UsedObject(StructuredType.class));
        UDPLibrary uDPLibrary11 = this.library;
        uDPLibrary11.getClass();
        this.objectsList.add(uDPLibrary11.new UDPLibrary.UsedObject(TypeElement.class));
        UDPLibrary uDPLibrary12 = this.library;
        uDPLibrary12.getClass();
        this.objectsList.add(uDPLibrary12.new UDPLibrary.UsedObject(DistinctType.class));
        UDPLibrary uDPLibrary13 = this.library;
        uDPLibrary13.getClass();
        this.objectsList.add(uDPLibrary13.new UDPLibrary.UsedObject(CollectionType.class));
        Collections.sort(this.objectsList, new ObjectsComparator());
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.appView.getFrame(), Messages.getString("UDPLibraryPropertiesDialog.UserPropertyLibrary"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(true);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "UDP_LIBRARY_PROPERTIES_DIALOG";
    }

    private boolean canSave() {
        this.savePreviousSelectedProperty();
        String fileName = this.tfFileName.getText().trim();
        if (fileName.equals("")) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("UDPLibraryPropertiesDialog.FileNameEmpty"), Messages.getString("UDPLibraryPropertiesDialog.UDPLibrary"), 0);
            return false;
        }
        if (this.propertiesList.size() == 0) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("UDPLibraryPropertiesDialog.MissingProperties"), Messages.getString("UDPLibraryPropertiesDialog.UDPLibrary"), 0);
            return false;
        }
        for (UserDefinedProperty userDefinedProperty : this.propertiesList) {
            for (UserDefinedProperty property2 : this.propertiesList) {
                if (userDefinedProperty == property2 || !userDefinedProperty.getName().equals(property2.getName())) continue;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("UDPLibraryPropertiesDialog.CanNotBeSaved"), userDefinedProperty.getName()), Messages.getString("UDPLibraryPropertiesDialog.UDPLibrary"), 0);
                return false;
            }
        }
        if (!this.editMode) {
            for (UDPLibrary uDPLibrary : Arrays.asList(this.parentModel.toArray())) {
                String fn = uDPLibrary.getFileName();
                String fnNoExt = fn.substring(0, fn.lastIndexOf("."));
                if (!fnNoExt.equals(fileName)) continue;
                int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("UDPLibraryPropertiesDialog.FileExists"), fileName), Messages.getString("UDPLibraryPropertiesDialog.UDPLibrary"), 0, 3);
                return choice == 0;
            }
        }
        return true;
    }

    private String generatePropertyName() {
        String name = UDP_NAME;
        int newNumber = 0;
        int lastNumber = this.propertiesList.size();
        if (lastNumber != 0) {
            newNumber = this.pCounter = lastNumber + 1;
        } else {
            ++this.pCounter;
            newNumber = this.pCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.propertyNameExistsInModel(nName, null)) {
            newNumber = ++this.pCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean propertyNameExistsInModel(String name, CustomReportTemplate current) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            UserDefinedProperty p = (UserDefinedProperty)this.propertiesList.get(i);
            if (!p.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void clearControls() {
        this.tfPropertyName.setEnabled(false);
        this.tfPropertyName.setText("");
        this.tfDisplayName.setEnabled(false);
        this.tfDisplayName.setText("");
        this.cmbType.setEnabled(false);
        this.cmbType.setSelectedItem(UserDefinedProperty.TEXT);
        this.cmbGroup.setEnabled(false);
        this.cmbGroup.setSelectedItem(" ");
        this.tfDefaultValue.setEnabled(false);
        this.tfDefaultValue.setText("");
        this.taDescription.setEnabled(false);
        this.taDescription.setText("");
        this.stopCellEditing(this.objectsTable);
        for (UDPLibrary.UsedObject o : this.objectsList) {
            o.setUse(false);
            o.setVisible(false);
            o.setColor(new Color(255, 255, 255));
        }
        this.objectsTable.updateUI();
        this.objectsTable.clearSelection();
        this.objectsTable.setEnabled(false);
        this.bnAddToLOV.setEnabled(false);
        this.stopCellEditing(this.lovTable);
        this.lovList.clear();
        this.lovTable.updateUI();
    }

    protected void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private void reloadSelectedPropertyData() {
        this.tfPropertyName.setText(this.currentSelectedProperty.getName());
        this.tfDisplayName.setText(this.currentSelectedProperty.getDisplayName());
        this.tfDefaultValue.setText(this.currentSelectedProperty.getDefaultValue());
        this.cmbType.setSelectedItem(this.currentSelectedProperty.getType());
        this.cmbGroup.setSelectedItem(this.currentSelectedProperty.getGroup() != null ? this.currentSelectedProperty.getGroup() : " ");
        this.taDescription.setText(this.currentSelectedProperty.getDescription());
        for (UDPLibrary.UsedObject o : this.objectsList) {
            o.setUse(false);
            o.setVisible(false);
            o.setColor(new Color(255, 255, 255));
        }
        this.objectsTable.updateUI();
        for (Map.Entry<Class, Boolean> entry : this.currentSelectedProperty.getObjectsVisibilityMap().entrySet()) {
            Class clz = entry.getKey();
            Boolean visible = entry.getValue();
            boolean found = false;
            UDPLibrary.UsedObject o22 = null;
            for (UDPLibrary.UsedObject o22 : this.objectsList) {
                if (o22.getClz() != clz) continue;
                o22.setUse(true);
                o22.setVisible(visible);
                Integer color = this.currentSelectedProperty.getObjectsColorMap().get(clz);
                if (color != null) {
                    o22.setColor(new Color(color));
                }
                found = true;
                break;
            }
            if (found) continue;
            o22.setUse(false);
            o22.setVisible(false);
            o22.setColor(new Color(255, 255, 255));
        }
        this.lovList.clear();
        this.lovTable.updateUI();
        if (this.currentSelectedProperty.getType().equals(UserDefinedProperty.LIST)) {
            for (Map.Entry<Object, Boolean> entry : this.currentSelectedProperty.getLovMap().entrySet()) {
                String value = (String)entry.getKey();
                Boolean def = entry.getValue();
                UDPLibrary uDPLibrary = this.library;
                uDPLibrary.getClass();
                UDPLibrary.LOVObject lo = uDPLibrary.new UDPLibrary.LOVObject(value);
                lo.setDef(def);
                this.lovList.add(lo);
            }
            this.tfDefaultValue.setEnabled(false);
        } else {
            Iterator<Map.Entry<Object, Boolean>> it = this.currentSelectedProperty.getLovMap().entrySet().iterator();
            if (it.hasNext()) {
                Map.Entry<Object, Boolean> entry = it.next();
                this.tfDefaultValue.setText((String)entry.getKey());
            }
            this.tfDefaultValue.setEnabled(true);
        }
        this.tfPropertyName.setEnabled(true);
        this.tfDisplayName.setEnabled(true);
        this.cmbType.setEnabled(true);
        this.cmbGroup.setEnabled(true);
        this.taDescription.setEnabled(true);
        this.objectsTable.setEnabled(true);
        this.bnRemoveProperty.setEnabled(true);
    }

    private void savePreviousSelectedProperty() {
        if (this.previousSelectedProperty != null) {
            this.stopCellEditing(this.lovTable);
            this.stopCellEditing(this.objectsTable);
            this.previousSelectedProperty.setName(this.tfPropertyName.getText());
            this.previousSelectedProperty.setDisplayName(this.tfDisplayName.getText());
            this.previousSelectedProperty.setType((String)this.cmbType.getSelectedItem());
            this.previousSelectedProperty.setGroup((UserDefinedPropertyGroup)(this.cmbGroup.getSelectedItem() != null && this.cmbGroup.getSelectedItem().equals(" ") ? null : (UserDefinedPropertyGroup)this.cmbGroup.getSelectedItem()));
            this.previousSelectedProperty.setDescription(this.taDescription.getText());
            this.previousSelectedProperty.getLovMap().clear();
            if (this.cmbType.getSelectedItem().equals(UserDefinedProperty.LIST)) {
                for (UDPLibrary.LOVObject lo : this.lovList) {
                    if (lo.getValue().equals("<null>")) continue;
                    this.previousSelectedProperty.getLovMap().put(lo.getValue(), lo.isDef());
                }
            } else if (!"".equals(this.tfDefaultValue.getText().trim())) {
                String defVal = this.tfDefaultValue.getText().trim();
                if (this.cmbType.getSelectedItem().equals(UserDefinedProperty.NUMBER)) {
                    try {
                        Double v = Double.valueOf(defVal);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("UDPLibraryPropertiesDialog.InvalidDefaultValueNumber"), this.tfPropertyName.getText()), Messages.getString("UDPLibraryPropertiesDialog.UDPLibrary"), 0);
                        this.tfDefaultValue.setText("");
                    }
                } else if (this.cmbType.getSelectedItem().equals(UserDefinedProperty.DATE)) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(MDConfiguration.getDefaultInstance().get("dateonlyformat"));
                    try {
                        Date defDate = dateFormat.parse(defVal);
                        if (defDate != null) {
                            String strDate = dateFormat.format(defDate);
                            this.tfDefaultValue.setText(strDate);
                        }
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("UDPLibraryPropertiesDialog.InvalidDefaultValueDate"), this.tfPropertyName.getText(), dateFormat.toPattern()), Messages.getString("UDPLibraryPropertiesDialog.UDPLibrary"), 0);
                        this.tfDefaultValue.setText("");
                    }
                    catch (ParseException e) {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("UDPLibraryPropertiesDialog.InvalidDefaultValueDate"), this.tfPropertyName.getText(), dateFormat.toPattern()), Messages.getString("UDPLibraryPropertiesDialog.UDPLibrary"), 0);
                        this.tfDefaultValue.setText("");
                    }
                }
            }
            this.previousSelectedProperty.setDefaultValue(this.tfDefaultValue.getText() != null ? this.tfDefaultValue.getText() : "");
            this.previousSelectedProperty.getObjectsVisibilityMap().clear();
            this.previousSelectedProperty.getObjectsColorMap().clear();
            for (UDPLibrary.UsedObject uo : this.objectsList) {
                if (!uo.isUse()) continue;
                this.previousSelectedProperty.getObjectsVisibilityMap().put(uo.getClz(), uo.isVisible());
                if (uo.getColor() == null) continue;
                this.previousSelectedProperty.getObjectsColorMap().put(uo.getClz(), uo.getColor().getRGB());
            }
        }
    }

    private void saveUDPLibrary() {
        this.savePreviousSelectedProperty();
        this.library.getUDPGroups().clear();
        Iterator itG = this.udpGroupsList.iterator();
        while (itG.hasNext()) {
            this.library.getUDPGroups().add(itG.next());
        }
        this.library.getPropertiesList().clear();
        this.library.setFileName(this.tfFileName.getText() + ".udposdm");
        this.library.getPropertiesList().addAll(this.propertiesList);
        Design cDesign = this.appView.getCurrentDesign();
        cDesign.getAppView().getUDPLibrariesPersistence().save(this.library, true, XMLTransformationManager.getDefaultSystemTypesPath());
        this.close();
        if (!this.parentModel.contains(this.library)) {
            this.parentModel.addElement(this.library);
            cDesign.getUserDefinedLibraries().add(this.library);
        }
    }

    @Override
    protected int getMinimumWidth() {
        return 720;
    }

    @Override
    protected int getMinimumHeight() {
        return 690;
    }

    private String generateUDPGroupName() {
        String name = UDP_GROUP_NAME;
        int newNumber = 0;
        int lastNumber = this.udpGroupsList.size();
        if (lastNumber != 0) {
            newNumber = this.gCounter = lastNumber + 1;
        } else {
            ++this.gCounter;
            newNumber = this.gCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.groupNameExistsInModel(nName)) {
            newNumber = ++this.gCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean groupNameExistsInModel(String name) {
        for (int i = 0; i < this.udpGroupsList.size(); ++i) {
            UserDefinedPropertyGroup p = (UserDefinedPropertyGroup)this.udpGroupsList.get(i);
            if (!p.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void reloadComboBoxGroups() {
        this.cmbGroupModel.removeAllElements();
        this.cmbGroupModel.addElement(" ");
        Iterator it = this.library.getUDPGroups().iterator();
        while (it.hasNext()) {
            this.cmbGroupModel.addElement(it.next());
        }
    }

    private void groupFilter() {
        RowFilter rf = null;
        if (this.groupsTable != null) {
            if (!"".equals(this.groupFilter.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.groupFilter.getText(), this.groupsTable.convertColumnIndexToModel(0));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.groupsTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)this.groupsTable.getRowSorter()).setRowFilter(null);
                this.groupsTable.clearSelection();
            }
        }
    }

    private void initGroupsTableSorter() {
        if (this.udpGroupsList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.groupsTable.getModel());
            sorter.setSortsOnUpdates(true);
            this.groupsTable.setRowSorter(sorter);
            this.groupsTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.groupsTable, 0);
            this.groupFilter.setEnabled(true);
        } else {
            this.groupFilter.setEnabled(false);
        }
    }

    private void propertyFilter() {
        this.savePreviousSelectedProperty();
        this.propertiesTable.getSelectionModel().removeListSelectionListener(this.propertiesTableSelectionListener);
        RowFilter rf = null;
        if (this.propertiesTable != null) {
            if (!"".equals(this.propertyFilter.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.propertyFilter.getText(), this.propertiesTable.convertColumnIndexToModel(0));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.propertiesTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)this.propertiesTable.getRowSorter()).setRowFilter(null);
                this.propertiesTable.clearSelection();
            }
            this.propertiesTable.getSelectionModel().addListSelectionListener(this.propertiesTableSelectionListener);
        }
    }

    private void initPropertiesTableSorter() {
        if (this.propertiesList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.propertiesTable.getModel());
            sorter.setSortsOnUpdates(true);
            this.propertiesTable.setRowSorter(sorter);
            this.propertiesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.propertiesTable, 0);
            this.propertyFilter.setEnabled(true);
        } else {
            this.propertyFilter.setEnabled(false);
        }
    }

    class GroupManagementDialog
    extends CustomDialog {
        private JDialog gmDialog;
        private JPanel mainPanel;
        private UserDefinedPropertyGroup currentGroup;
        private List availablePeoprtiesList;
        private List selectedPeoprtiesList;
        private JTable availablePropertiesTable;
        private JTable selectedPropertiesTable;
        private JButton buttonAddProperty;
        private JButton buttonRemoveProperty;
        private JTextField availablePropertiesFilter;
        private JTextField selectedPropertiesFilter;
        private TableColumn acCol0;

        public GroupManagementDialog(ApplicationView appView, UserDefinedPropertyGroup group) {
            super(appView);
            this.currentGroup = group;
            this.initUI();
            this.initProperties();
        }

        private void initUI() {
            this.mainPanel = new JPanel(new BorderLayout());
            this.mainPanel.setPreferredSize(new Dimension(440, 300));
            JPanel pPanel = new JPanel();
            pPanel.setLayout(new BoxLayout(pPanel, 2));
            JToolBar toolBarAP = new JToolBar(0);
            toolBarAP.setFloatable(false);
            toolBarAP.setRollover(true);
            toolBarAP.setBorder(null);
            JLabel availablePropertiesFilterLabel = new JLabel(Messages.getString("UDPLibraryPropertiesDialog.Filter"));
            availablePropertiesFilterLabel.setPreferredSize(new Dimension(50, 20));
            availablePropertiesFilterLabel.setMinimumSize(new Dimension(50, 20));
            availablePropertiesFilterLabel.setMaximumSize(new Dimension(50, 20));
            this.availablePropertiesFilter = new JTextField();
            this.availablePropertiesFilter.setEnabled(false);
            this.availablePropertiesFilter.setPreferredSize(new Dimension(105, 20));
            this.availablePropertiesFilter.setMinimumSize(new Dimension(105, 20));
            this.availablePropertiesFilter.setMaximumSize(new Dimension(105, 20));
            this.availablePropertiesFilter.getDocument().addDocumentListener(new AvailablePropertiesFilterListener());
            toolBarAP.add(availablePropertiesFilterLabel);
            toolBarAP.add(this.availablePropertiesFilter);
            JToolBar toolBarSP = new JToolBar(0);
            toolBarSP.setFloatable(false);
            toolBarSP.setRollover(true);
            toolBarSP.setBorder(null);
            JLabel selectedPropertiesFilterLabel = new JLabel(Messages.getString("UDPLibraryPropertiesDialog.Filter"));
            selectedPropertiesFilterLabel.setPreferredSize(new Dimension(50, 20));
            selectedPropertiesFilterLabel.setMinimumSize(new Dimension(50, 20));
            selectedPropertiesFilterLabel.setMaximumSize(new Dimension(50, 20));
            this.selectedPropertiesFilter = new JTextField();
            this.selectedPropertiesFilter.setEnabled(false);
            this.selectedPropertiesFilter.setPreferredSize(new Dimension(105, 20));
            this.selectedPropertiesFilter.setMinimumSize(new Dimension(105, 20));
            this.selectedPropertiesFilter.setMaximumSize(new Dimension(105, 20));
            this.selectedPropertiesFilter.getDocument().addDocumentListener(new SelectedPropertiesFilterListener());
            toolBarSP.add(selectedPropertiesFilterLabel);
            toolBarSP.add(this.selectedPropertiesFilter);
            this.availablePeoprtiesList = new ArrayList();
            this.selectedPeoprtiesList = new ArrayList();
            this.availablePropertiesTable = new JTable(new AvailableProprtiesTableModel());
            this.availablePropertiesTable.setAutoResizeMode(0);
            this.availablePropertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int[] selectedRows = GroupManagementDialog.this.availablePropertiesTable.getSelectedRows();
                        if (selectedRows.length > 0) {
                            GroupManagementDialog.this.buttonAddProperty.setEnabled(true);
                        } else {
                            GroupManagementDialog.this.buttonAddProperty.setEnabled(false);
                        }
                    }
                }
            });
            this.acCol0 = this.availablePropertiesTable.getColumnModel().getColumn(0);
            this.acCol0.setCellRenderer(new AvPropertyNameTableContentRenderer());
            this.selectedPropertiesTable = new JTable(new SelectedProprtiesTableModel());
            this.selectedPropertiesTable.setAutoResizeMode(0);
            this.selectedPropertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int[] selectedRows = GroupManagementDialog.this.selectedPropertiesTable.getSelectedRows();
                        if (selectedRows.length > 0) {
                            GroupManagementDialog.this.buttonRemoveProperty.setEnabled(true);
                        } else {
                            GroupManagementDialog.this.buttonRemoveProperty.setEnabled(false);
                        }
                    }
                }
            });
            TableColumn col = this.selectedPropertiesTable.getColumnModel().getColumn(0);
            col.setCellRenderer(new SelPropertyNameTableContentRenderer());
            col.setMinWidth(600);
            JScrollPane availablePropertiesScrollPane = new JScrollPane(this.availablePropertiesTable, 20, 30);
            JScrollPane selectedPropertiesScrollPane = new JScrollPane(this.selectedPropertiesTable, 20, 30);
            availablePropertiesScrollPane.setPreferredSize(new Dimension(200, 230));
            selectedPropertiesScrollPane.setPreferredSize(new Dimension(200, 230));
            JPanel leftPanel = new JPanel(new BorderLayout());
            leftPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UDPLibraryPropertiesDialog.Available")));
            leftPanel.add((Component)toolBarAP, "North");
            leftPanel.add((Component)availablePropertiesScrollPane, "Center");
            JPanel rightPanel = new JPanel(new BorderLayout());
            rightPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UDPLibraryPropertiesDialog.Selected")));
            rightPanel.add((Component)toolBarSP, "North");
            rightPanel.add((Component)selectedPropertiesScrollPane, "Center");
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.buttonAddProperty = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
            this.buttonAddProperty.addActionListener(new AddPropertyActionListener());
            this.buttonAddProperty.setEnabled(false);
            this.buttonAddProperty.setToolTipText(Messages.getString("UDPLibraryPropertiesDialog.Add"));
            this.buttonRemoveProperty = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
            this.buttonRemoveProperty.setEnabled(false);
            this.buttonRemoveProperty.addActionListener(new RemovePropertyActionListener());
            this.buttonRemoveProperty.setToolTipText(Messages.getString("UDPLibraryPropertiesDialog.Remove"));
            this.buttonAddProperty.setPreferredSize(new Dimension(32, 32));
            this.buttonRemoveProperty.setPreferredSize(this.buttonAddProperty.getPreferredSize());
            Box verticalBox = Box.createVerticalBox();
            verticalBox.add(Box.createVerticalGlue());
            verticalBox.add(this.buttonAddProperty);
            verticalBox.add(this.buttonRemoveProperty);
            verticalBox.add(Box.createVerticalGlue());
            pPanel.add((Component)leftPanel, "West");
            pPanel.add((Component)verticalBox, "Center");
            pPanel.add((Component)rightPanel, "East");
            JPanel bottomPanel = new JPanel();
            JButton btnOK = new JButton(Messages.getString("UDPLibraryPropertiesDialog.OK"));
            btnOK.setMnemonic(79);
            btnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (UserDefinedProperty property : GroupManagementDialog.this.selectedPeoprtiesList) {
                        for (UserDefinedProperty property1 : UDPLibraryPropertiesDialog.this.propertiesList) {
                            if (!property.getName().equals(property1.getName())) continue;
                            property1.setGroup(GroupManagementDialog.this.currentGroup);
                        }
                    }
                    GroupManagementDialog.this.close();
                }
            });
            JButton btnCancel = new JButton(Messages.getString("UDPLibraryPropertiesDialog.Cancel"));
            btnCancel.setMnemonic(67);
            btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GroupManagementDialog.this.close();
                }
            });
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bottomPanel.add(btnOK);
            bottomPanel.add(btnCancel);
            bottomPanel.add(bnHelp);
            this.mainPanel.add((Component)pPanel, "Center");
            this.mainPanel.add((Component)bottomPanel, "South");
            this.add((Component)this.mainPanel, "Center");
        }

        private void initProperties() {
            try {
                for (UserDefinedProperty property : UDPLibraryPropertiesDialog.this.propertiesList) {
                    boolean found = false;
                    if (property.getGroup() != null && property.getGroup().getId().equals(this.currentGroup.getId())) {
                        this.selectedPeoprtiesList.add(property);
                        found = true;
                    }
                    if (found) continue;
                    this.availablePeoprtiesList.add(property);
                }
                for (int column = 0; column < this.availablePropertiesTable.getColumnCount(); ++column) {
                    TableColumn tableColumn = this.availablePropertiesTable.getColumnModel().getColumn(column);
                    int preferredWidth = tableColumn.getMinWidth();
                    int maxWidth = tableColumn.getMaxWidth();
                    for (int row = 0; row < this.availablePropertiesTable.getRowCount(); ++row) {
                        TableCellRenderer cellRenderer = this.availablePropertiesTable.getCellRenderer(row, column);
                        Component c = this.availablePropertiesTable.prepareRenderer(cellRenderer, row, column);
                        int width = c.getPreferredSize().width + this.availablePropertiesTable.getIntercellSpacing().width;
                        if ((preferredWidth = Math.max(preferredWidth, width)) < maxWidth) continue;
                        preferredWidth = maxWidth;
                        break;
                    }
                    tableColumn.setPreferredWidth(preferredWidth);
                }
                this.availablePropertiesTable.updateUI();
                this.selectedPropertiesTable.updateUI();
                this.initAvailablePropertiesTableSorter();
                this.initSelectedPropertiesTableSorter();
            }
            catch (Exception e) {
                LOGGER.error("Exception in GroupManagementDialog.initProperties() ", e);
            }
        }

        private void initAvailablePropertiesTableSorter() {
            if (this.availablePeoprtiesList.size() > 0) {
                TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.availablePropertiesTable.getModel());
                sorter.setSortsOnUpdates(true);
                this.availablePropertiesTable.setRowSorter(sorter);
                this.availablePropertiesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.availablePropertiesTable, 0);
                this.availablePropertiesFilter.setEnabled(true);
            } else {
                this.availablePropertiesFilter.setEnabled(false);
            }
        }

        private void initSelectedPropertiesTableSorter() {
            if (this.selectedPeoprtiesList.size() > 0) {
                TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.selectedPropertiesTable.getModel());
                sorter.setSortsOnUpdates(true);
                this.selectedPropertiesTable.setRowSorter(sorter);
                this.selectedPropertiesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.selectedPropertiesTable, 0);
                this.selectedPropertiesFilter.setEnabled(true);
            } else {
                this.selectedPropertiesFilter.setEnabled(false);
            }
        }

        @Override
        protected Window getDialog() {
            if (this.gmDialog == null) {
                this.gmDialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("UDPLibraryPropertiesDialog.GroupProperties") + " - " + this.currentGroup.getName());
                this.gmDialog.setDefaultCloseOperation(2);
                this.gmDialog.getContentPane().add(this);
                this.setDefaultActions(this.gmDialog);
                this.gmDialog.pack();
                this.gmDialog.setModal(true);
                this.gmDialog.setResizable(false);
            }
            return this.gmDialog;
        }

        public void showDialog() {
            CommonUtil.centerOnScreen(this.getDialog());
            this.getDialog().setVisible(true);
        }

        @Override
        protected void close() {
            this.getDialog().dispose();
        }

        @Override
        protected String getHelpIndex() {
            return null;
        }

        private void availablePropertiesFilter() {
            RowFilter rf = null;
            if (this.availablePropertiesTable != null) {
                if (!"".equals(this.availablePropertiesFilter.getText())) {
                    try {
                        rf = RowFilter.regexFilter("(?i)" + this.availablePropertiesFilter.getText(), this.availablePropertiesTable.convertColumnIndexToModel(0));
                    }
                    catch (PatternSyntaxException e) {
                        return;
                    }
                    ((DefaultRowSorter)this.availablePropertiesTable.getRowSorter()).setRowFilter(rf);
                } else {
                    ((DefaultRowSorter)this.availablePropertiesTable.getRowSorter()).setRowFilter(null);
                    this.availablePropertiesTable.clearSelection();
                }
            }
        }

        private void selectedPropertiesFilter() {
            RowFilter rf = null;
            if (this.selectedPropertiesTable != null) {
                if (!"".equals(this.selectedPropertiesFilter.getText())) {
                    try {
                        rf = RowFilter.regexFilter("(?i)" + this.selectedPropertiesFilter.getText(), this.selectedPropertiesTable.convertColumnIndexToModel(0));
                    }
                    catch (PatternSyntaxException e) {
                        return;
                    }
                    ((DefaultRowSorter)this.selectedPropertiesTable.getRowSorter()).setRowFilter(rf);
                } else {
                    ((DefaultRowSorter)this.selectedPropertiesTable.getRowSorter()).setRowFilter(null);
                    this.selectedPropertiesTable.clearSelection();
                }
            }
        }

        class SelPropertyNameTableContentRenderer
        extends DefaultTableCellRenderer {
            SelPropertyNameTableContentRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setToolTipText(c.getText());
                return c;
            }
        }

        class AvPropertyNameTableContentRenderer
        extends DefaultTableCellRenderer {
            AvPropertyNameTableContentRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setToolTipText(c.getText());
                return c;
            }
        }

        private class SelectedPropertiesFilterListener
        implements DocumentListener {
            private SelectedPropertiesFilterListener() {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                GroupManagementDialog.this.selectedPropertiesFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GroupManagementDialog.this.selectedPropertiesFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GroupManagementDialog.this.selectedPropertiesFilter();
            }
        }

        private class AvailablePropertiesFilterListener
        implements DocumentListener {
            private AvailablePropertiesFilterListener() {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                GroupManagementDialog.this.availablePropertiesFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GroupManagementDialog.this.availablePropertiesFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GroupManagementDialog.this.availablePropertiesFilter();
            }
        }

        private class RemovePropertyActionListener
        implements ActionListener {
            private RemovePropertyActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupManagementDialog.this.selectedPropertiesTable.getRowSorter().setSortKeys(null);
                if (GroupManagementDialog.this.availablePropertiesTable.getRowSorter() != null && GroupManagementDialog.this.availablePeoprtiesList.size() >= 1) {
                    GroupManagementDialog.this.availablePropertiesTable.getRowSorter().setSortKeys(null);
                }
                boolean wasEmpty = GroupManagementDialog.this.availablePeoprtiesList.size() == 0;
                int[] selected = GroupManagementDialog.this.selectedPropertiesTable.getSelectedRows();
                ArrayList tempList = new ArrayList();
                for (int i = 0; i < selected.length; ++i) {
                    Object current = GroupManagementDialog.this.selectedPeoprtiesList.get(GroupManagementDialog.this.selectedPropertiesTable.convertRowIndexToModel(selected[i]));
                    if (GroupManagementDialog.this.availablePeoprtiesList.contains(current)) continue;
                    tempList.add(current);
                    GroupManagementDialog.this.availablePeoprtiesList.add(current);
                }
                GroupManagementDialog.this.selectedPeoprtiesList.removeAll(tempList);
                if (GroupManagementDialog.this.selectedPeoprtiesList.size() >= 0) {
                    WindowsTableHeader.setSortedHeader(GroupManagementDialog.this.selectedPropertiesTable, 0);
                } else {
                    GroupManagementDialog.this.selectedPropertiesTable.setAutoCreateRowSorter(false);
                    GroupManagementDialog.this.selectedPropertiesTable.setRowSorter(null);
                }
                GroupManagementDialog.this.buttonRemoveProperty.setEnabled(GroupManagementDialog.this.selectedPeoprtiesList.size() > 0);
                GroupManagementDialog.this.selectedPropertiesFilter.setEnabled(GroupManagementDialog.this.selectedPeoprtiesList.size() > 0);
                GroupManagementDialog.this.selectedPropertiesTable.clearSelection();
                GroupManagementDialog.this.selectedPropertiesTable.updateUI();
                if (wasEmpty) {
                    GroupManagementDialog.this.initAvailablePropertiesTableSorter();
                }
                WindowsTableHeader.setSortedHeader(GroupManagementDialog.this.availablePropertiesTable, 0);
                int lastRow = GroupManagementDialog.this.availablePropertiesTable.convertRowIndexToView(GroupManagementDialog.this.availablePeoprtiesList.size() - 1);
                GroupManagementDialog.this.availablePropertiesTable.setRowSelectionInterval(lastRow, lastRow);
                GroupManagementDialog.this.availablePropertiesTable.updateUI();
            }
        }

        private class AddPropertyActionListener
        implements ActionListener {
            private AddPropertyActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GroupManagementDialog.this.availablePropertiesTable.getRowSorter().setSortKeys(null);
                    if (GroupManagementDialog.this.selectedPropertiesTable.getRowSorter() != null && GroupManagementDialog.this.selectedPeoprtiesList.size() >= 1) {
                        GroupManagementDialog.this.selectedPropertiesTable.getRowSorter().setSortKeys(null);
                    }
                    boolean wasEmpty = GroupManagementDialog.this.selectedPeoprtiesList.size() == 0;
                    int[] selected = GroupManagementDialog.this.availablePropertiesTable.getSelectedRows();
                    ArrayList tempList = new ArrayList();
                    for (int i = 0; i < selected.length; ++i) {
                        Object current = GroupManagementDialog.this.availablePeoprtiesList.get(GroupManagementDialog.this.availablePropertiesTable.convertRowIndexToModel(selected[i]));
                        if (GroupManagementDialog.this.selectedPeoprtiesList.contains(current)) continue;
                        tempList.add(current);
                        GroupManagementDialog.this.selectedPeoprtiesList.add(current);
                    }
                    GroupManagementDialog.this.availablePeoprtiesList.removeAll(tempList);
                    if (GroupManagementDialog.this.availablePeoprtiesList.size() >= 0) {
                        WindowsTableHeader.setSortedHeader(GroupManagementDialog.this.availablePropertiesTable, 0);
                    } else {
                        GroupManagementDialog.this.availablePropertiesTable.setAutoCreateRowSorter(false);
                        GroupManagementDialog.this.availablePropertiesTable.setRowSorter(null);
                    }
                    GroupManagementDialog.this.buttonAddProperty.setEnabled(GroupManagementDialog.this.availablePeoprtiesList.size() > 0);
                    GroupManagementDialog.this.availablePropertiesFilter.setEnabled(GroupManagementDialog.this.availablePeoprtiesList.size() > 0);
                    GroupManagementDialog.this.availablePropertiesTable.clearSelection();
                    GroupManagementDialog.this.availablePropertiesTable.updateUI();
                    if (wasEmpty) {
                        GroupManagementDialog.this.initSelectedPropertiesTableSorter();
                    }
                    WindowsTableHeader.setSortedHeader(GroupManagementDialog.this.selectedPropertiesTable, 0);
                    int lastRow = GroupManagementDialog.this.selectedPropertiesTable.convertRowIndexToView(GroupManagementDialog.this.selectedPeoprtiesList.size() - 1);
                    GroupManagementDialog.this.selectedPropertiesTable.setRowSelectionInterval(lastRow, lastRow);
                    GroupManagementDialog.this.selectedPropertiesTable.updateUI();
                }
                catch (Exception ex) {
                    LOGGER.error("Exception in GroupManagementDialog - add property", ex);
                }
            }
        }

        private class SelectedProprtiesTableModel
        extends AbstractTableModel {
            private SelectedProprtiesTableModel() {
            }

            @Override
            public int getRowCount() {
                return GroupManagementDialog.this.selectedPeoprtiesList.size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return Messages.getString("UDPLibraryPropertiesDialog.Name");
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                UserDefinedProperty p = (UserDefinedProperty)GroupManagementDialog.this.selectedPeoprtiesList.get(rowIndex);
                if (columnIndex == 0) {
                    return p.getName();
                }
                return "";
            }
        }

        private class AvailableProprtiesTableModel
        extends AbstractTableModel {
            private AvailableProprtiesTableModel() {
            }

            @Override
            public int getRowCount() {
                return GroupManagementDialog.this.availablePeoprtiesList.size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return Messages.getString("UDPLibraryPropertiesDialog.Name");
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                UserDefinedProperty p = (UserDefinedProperty)GroupManagementDialog.this.availablePeoprtiesList.get(rowIndex);
                if (columnIndex == 0) {
                    return p.getName();
                }
                return "";
            }
        }
    }

    class PropertyNameTableContentRenderer
    extends DefaultTableCellRenderer {
        PropertyNameTableContentRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setToolTipText(c.getText());
            return c;
        }
    }

    class ButtonColumnCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JButton button;

        ButtonColumnCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            UserDefinedPropertyGroup group = (UserDefinedPropertyGroup)UDPLibraryPropertiesDialog.this.udpGroupsList.get(table.convertRowIndexToModel(row));
            GroupManagementDialog d = new GroupManagementDialog(UDPLibraryPropertiesDialog.this.appView, group);
            d.showDialog();
            return this.button;
        }
    }

    class ButtonColumnCellRenderer
    implements TableCellRenderer {
        ButtonColumnCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JButton button = new JButton();
            button.setText("...");
            button.setToolTipText(Messages.getString("UDPLibraryPropertiesDialog.Properties"));
            button.setIcon(null);
            button.setEnabled(true);
            button.setForeground(table.getForeground());
            button.setBackground(UIManager.getColor("Button.background"));
            return button;
        }
    }

    class PropertiesTableSelectionListener
    implements ListSelectionListener {
        PropertiesTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int selRow = UDPLibraryPropertiesDialog.this.propertiesTable.getSelectedRow();
                if (selRow == -1) {
                    UDPLibraryPropertiesDialog.this.clearControls();
                    UDPLibraryPropertiesDialog.this.bnRemoveProperty.setEnabled(false);
                    UDPLibraryPropertiesDialog.this.btnSave.setEnabled(false);
                } else {
                    UDPLibraryPropertiesDialog.this.currentSelectedProperty = (UserDefinedProperty)UDPLibraryPropertiesDialog.this.propertiesList.get(UDPLibraryPropertiesDialog.this.propertiesTable.convertRowIndexToModel(selRow));
                    UDPLibraryPropertiesDialog.this.previousSelectedProperty = UDPLibraryPropertiesDialog.this.currentSelectedProperty;
                    UDPLibraryPropertiesDialog.this.reloadSelectedPropertyData();
                    UDPLibraryPropertiesDialog.this.bnRemoveProperty.setEnabled(true);
                    UDPLibraryPropertiesDialog.this.btnSave.setEnabled(true);
                }
            } else {
                UDPLibraryPropertiesDialog.this.savePreviousSelectedProperty();
            }
        }
    }

    private class PropertyFilterListener
    implements DocumentListener {
        private PropertyFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            UDPLibraryPropertiesDialog.this.propertyFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            UDPLibraryPropertiesDialog.this.propertyFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            UDPLibraryPropertiesDialog.this.propertyFilter();
        }
    }

    private class GroupFilterListener
    implements DocumentListener {
        private GroupFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            UDPLibraryPropertiesDialog.this.groupFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            UDPLibraryPropertiesDialog.this.groupFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            UDPLibraryPropertiesDialog.this.groupFilter();
        }
    }

    class PropertiesTableModel
    extends AbstractTableModel {
        PropertiesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return UDPLibraryPropertiesDialog.this.propertiesList.size();
        }

        @Override
        public String getColumnName(int column) {
            return Messages.getString("UDPLibraryPropertiesDialog.Name");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            UserDefinedProperty udp = (UserDefinedProperty)UDPLibraryPropertiesDialog.this.propertiesList.get(rowIndex);
            if (columnIndex == 0) {
                return udp.getName();
            }
            return "";
        }
    }

    class UDPGroupTableModel
    extends AbstractTableModel {
        UDPGroupTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return UDPLibraryPropertiesDialog.this.udpGroupsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("UDPLibraryPropertiesDialog.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            UserDefinedPropertyGroup group = (UserDefinedPropertyGroup)UDPLibraryPropertiesDialog.this.udpGroupsList.get(rowIndex);
            if (columnIndex == 0) {
                return group.getName();
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            UserDefinedPropertyGroup group = (UserDefinedPropertyGroup)UDPLibraryPropertiesDialog.this.udpGroupsList.get(rowIndex);
            if (columnIndex == 0) {
                boolean exists = false;
                for (UserDefinedPropertyGroup g : UDPLibraryPropertiesDialog.this.udpGroupsList) {
                    if (g.getId().equals(group.getId()) || !g.getName().equals(((String)aValue).trim())) continue;
                    exists = true;
                    break;
                }
                if (exists) {
                    JOptionPane.showMessageDialog(UDPLibraryPropertiesDialog.this, MessageFormat.format(Messages.getString("UDPLibraryPropertiesDialog.ThereIsAnotherGroupWithSameName"), ((String)aValue).trim()), Messages.getString("UDPLibraryPropertiesDialog.Error"), 0);
                } else {
                    group.setName(((String)aValue).trim());
                }
            }
        }
    }

    class GroupRenderer
    extends JLabel
    implements ListCellRenderer {
        GroupRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof UserDefinedPropertyGroup) {
                this.setText(((UserDefinedPropertyGroup)value).getName());
            } else {
                this.setText(" ");
            }
            this.setFont(list.getFont());
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    class ObjectColorCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ObjectColorCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            UDPLibrary.UsedObject uo = (UDPLibrary.UsedObject)value;
            this.setOpaque(true);
            this.setBackground(uo.getColor());
            this.setToolTipText(Messages.getString("UDPLibraryPropertiesDialog.ClickToEditTheColor"));
            return this;
        }
    }

    class ObjectColorCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton colorEditButton = new JButton();
        UDPLibrary.UsedObject uo;

        ObjectColorCellEditor() {
            this.colorEditButton.setOpaque(true);
            this.colorEditButton.addActionListener(this);
            this.colorEditButton.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color newEditedColor = new ColorChooserDialog((Dialog)new JDialog(UDPLibraryPropertiesDialog.this.getApplicationView().getFrame()), Messages.getString("UDPLibraryPropertiesDialog.SelectColor"), this.uo.getColor()).showDialog();
            if (newEditedColor != null) {
                this.colorEditButton.setBackground(newEditedColor);
                this.uo.setColor(newEditedColor);
            }
            this.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.uo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.uo = (UDPLibrary.UsedObject)value;
            return this.colorEditButton;
        }
    }

    class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        public JRadioButton btn;

        public RadioButtonEditor(JCheckBox checkBox) {
            super(checkBox);
            this.btn = new JRadioButton();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            this.btn.addItemListener(this);
            if (((Boolean)value).booleanValue()) {
                this.btn.setSelected(true);
            } else {
                this.btn.setSelected(false);
            }
            this.btn.setHorizontalAlignment(0);
            return this.btn;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.btn.isSelected()) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            super.fireEditingStopped();
        }
    }

    class RadioButtonRenderer
    extends JRadioButton
    implements TableCellRenderer {
        public RadioButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
            this.setSelected((Boolean)value);
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class RemoveFromLOVAction
    implements ActionListener {
        private RemoveFromLOVAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = UDPLibraryPropertiesDialog.this.lovTable.getSelectedRow();
            UDPLibrary.LOVObject lo = (UDPLibrary.LOVObject)UDPLibraryPropertiesDialog.this.lovList.get(row);
            if (row > -1) {
                UDPLibraryPropertiesDialog.this.lovList.remove(lo);
            }
            UDPLibraryPropertiesDialog.this.lovTable.updateUI();
        }
    }

    private class AddToLOVAction
    implements ActionListener {
        private AddToLOVAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UDPLibrary uDPLibrary = UDPLibraryPropertiesDialog.this.library;
            uDPLibrary.getClass();
            UDPLibrary.LOVObject lo = uDPLibrary.new UDPLibrary.LOVObject("<null>");
            UDPLibraryPropertiesDialog.this.lovList.add(lo);
            UDPLibraryPropertiesDialog.this.lovTable.updateUI();
            UDPLibraryPropertiesDialog.this.lovTable.changeSelection(UDPLibraryPropertiesDialog.this.lovTable.getRowCount() - 1, 0, false, false);
            UDPLibraryPropertiesDialog.this.lovTable.editCellAt(UDPLibraryPropertiesDialog.this.lovTable.getRowCount() - 1, 0);
            UDPLibraryPropertiesDialog.this.lovTable.requestFocus();
        }
    }

    static class ObjectsComparator
    implements Comparator {
        ObjectsComparator() {
        }

        public int compare(Object one, Object two) {
            UDPLibrary.UsedObject uo1 = (UDPLibrary.UsedObject)one;
            UDPLibrary.UsedObject uo2 = (UDPLibrary.UsedObject)two;
            String s1 = ReportConstants.classToNameMap.get(uo1.getClz());
            String s2 = ReportConstants.classToNameMap.get(uo2.getClz());
            return s1.compareTo(s2);
        }
    }

    class LOVValueCellEditor
    extends DefaultCellEditor {
        public LOVValueCellEditor(JTextField textField) {
            super(textField);
            super.setClickCountToStart(1);
        }
    }

    public class PropertiesRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            UserDefinedProperty p = (UserDefinedProperty)value;
            this.setText(p.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    public class ColumnVisibleRenderer
    extends DefaultTableCellRenderer {
        private final BooleanRenderer booleanRenderer = new BooleanRenderer();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.getModel().getValueAt(row, 0).equals(UDPLibraryPropertiesDialog.this.tableStr) || table.getModel().getValueAt(row, 0).equals(UDPLibraryPropertiesDialog.this.entityStr)) {
                return this.booleanRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
        }

        private class BooleanRenderer
        extends JCheckBox
        implements TableCellRenderer {
            private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

            public BooleanRenderer() {
                this.setHorizontalAlignment(0);
                this.setBorderPainted(true);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    super.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                this.setSelected(value != null && (Boolean)value != false);
                if (hasFocus) {
                    this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                } else {
                    this.setBorder(this.noFocusBorder);
                }
                return this;
            }
        }
    }

    private class ObjectsTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("UDPLibraryPropertiesDialog.Type"), Messages.getString("UDPLibraryPropertiesDialog.Use"), Messages.getString("UDPLibraryPropertiesDialog.Visible"), Messages.getString("UDPLibraryPropertiesDialog.Color")};

        private ObjectsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return false;
            }
            if (columnIndex == 1) {
                return true;
            }
            return this.getValueAt(rowIndex, 0).equals(UDPLibraryPropertiesDialog.this.tableStr) || this.getValueAt(rowIndex, 0).equals(UDPLibraryPropertiesDialog.this.entityStr);
        }

        @Override
        public int getRowCount() {
            return UDPLibraryPropertiesDialog.this.objectsList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            UDPLibrary.UsedObject uo = (UDPLibrary.UsedObject)UDPLibraryPropertiesDialog.this.objectsList.get(rowIndex);
            if (columnIndex == 0) {
                return ReportConstants.classToNameMap.get(uo.getClz());
            }
            if (columnIndex == 1) {
                return uo.isUse();
            }
            if (columnIndex == 2) {
                return uo.isVisible();
            }
            if (columnIndex == 3) {
                return uo;
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            UDPLibrary.UsedObject uo = (UDPLibrary.UsedObject)UDPLibraryPropertiesDialog.this.objectsList.get(rowIndex);
            if (columnIndex == 1) {
                uo.setUse((Boolean)aValue);
            } else if (columnIndex == 2) {
                uo.setVisible((Boolean)aValue);
            }
        }
    }

    private class LOVTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("UDPLibraryPropertiesDialog.Value"), Messages.getString("UDPLibraryPropertiesDialog.Default")};

        private LOVTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getRowCount() {
            return UDPLibraryPropertiesDialog.this.lovList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            UDPLibrary.LOVObject lo = (UDPLibrary.LOVObject)UDPLibraryPropertiesDialog.this.lovList.get(rowIndex);
            if (columnIndex == 0) {
                return lo.getValue();
            }
            if (columnIndex == 1) {
                return lo.isDef();
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            UDPLibrary.LOVObject lo = (UDPLibrary.LOVObject)UDPLibraryPropertiesDialog.this.lovList.get(rowIndex);
            if (columnIndex == 0) {
                lo.setValue((String)aValue);
            } else if (columnIndex == 1) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (i == rowIndex) {
                        lo.setDef(true);
                        continue;
                    }
                    UDPLibrary.LOVObject tempLo = (UDPLibrary.LOVObject)UDPLibraryPropertiesDialog.this.lovList.get(i);
                    tempLo.setDef(false);
                }
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UDPLibraryPropertiesDialog.this.canSave()) {
                UDPLibraryPropertiesDialog.this.saveUDPLibrary();
            }
        }
    }
}

