/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypesSubView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddDocumentDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddPartyDialog;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TreeUtils;
import oracle.dbtools.crest.util.exceptions.EmptyFieldException;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class ModelPropertiesDialogEx
extends JDialog
implements AbstractEditorConstants {
    protected static final int FIELD_WIDTH = 150;
    protected static final int FIELD_HEIGHT = 20;
    public static final String BTN_PROPERTIES = Messages.getString("ModelPropertiesDialogEx.Properties");
    protected ApplicationView appView;
    protected ModelIDObject model;
    protected JTextField tfName;
    protected JTextField tfSchemaName;
    private JButton bnCancel;
    private JTree tree;
    private JPanel pnMain;
    protected CardLayout cardLayout = new CardLayout(10, 10);
    private JPanel pnGeneral;
    private JPanel pnComments;
    private JPanel pnNotes;
    private JPanel pnSummary;
    protected RSyntaxTextArea taComments;
    protected RSyntaxTextArea taNotes;
    private JPanel pnGeneralGrid;
    private Dimension defaultSize = new Dimension(150, 20);
    private int summaryPanelMinHeight = 400;
    private int summaryPanelMinWidth = 650;
    protected JPanel pnSummaryGrid;
    protected JTextField tfComment;
    protected JTextField tfObjectID;
    protected JTextField tfCreator;
    protected JTextField tfCreationTime;
    protected JTextField tfLastChangedBy;
    protected JTextField tfLastChangedTime;
    protected int summaryCount = 5;
    protected JPanel pnDataDictConnection;
    protected JPanel pnDDLFileName;
    protected JTextField tfDataDictConnection;
    protected JTextField tfDDLFileName;
    protected JPanel pnDataDictConnections;
    protected JPanel pnDDLFileNames;
    protected JComboBox cbDataDictConnections;
    protected JComboBox cbDDLFileNames;
    private JPanel pnResParties;
    private JPanel pnProcessOrder;
    protected JTable rpTable;
    protected List rpList;
    private JPanel pnDocuments;
    protected JTable docTable;
    protected List docList;
    protected boolean readonlyName = false;
    protected JCheckBox chbVisible;
    private JComboBox cbBoundModel;
    private DefaultListModel selectedColumnsModel;
    private JList selectedColumnsList;
    private String treePath = "";
    private JButton btnProcessProperties;
    private Action actF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelPropertiesDialogEx.this.showHelp();
        }
    };
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelPropertiesDialogEx.this.bnCancel.doClick();
        }
    };
    private JButton btnUp;
    private JButton btnDown;

    public ModelPropertiesDialogEx(ApplicationView view, ModelIDObject object, boolean readonlyName) {
        this(view, object);
        this.readonlyName = readonlyName;
        this.tfName.setEnabled(!readonlyName);
    }

    public ModelPropertiesDialogEx(ApplicationView view, ModelIDObject object) {
        super(view.getFrame());
        this.appView = view;
        this.model = object;
        this.model.setDialogVisible(true, this);
        this.initCaption(object.getName());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ModelPropertiesDialogEx.this.model.setDialogVisible(false, null);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                ModelPropertiesDialogEx.this.model.setDialogVisible(false, null);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = ModelPropertiesDialogEx.this.getWidth();
                int h = ModelPropertiesDialogEx.this.getHeight();
                w = Math.max(ModelPropertiesDialogEx.this.getMinimumWidth(), w);
                h = Math.max(ModelPropertiesDialogEx.this.getMinimumHeight(), h);
                ModelPropertiesDialogEx.this.setSize(w, h);
            }
        });
        this.initLayout();
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escapeAction);
        KeyStroke ksF1 = KeyStroke.getKeyStroke(112, 0, false);
        c.getInputMap(condition).put(ksF1, "KEY_F1");
        c.getActionMap().put("KEY_F1", this.actF1);
        this.pack();
        Settings.DialogSettings ds = this.appView.getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            int w = Math.max(this.getMinimumWidth(), this.summaryPanelMinWidth);
            int h = Math.max(this.getMinimumHeight(), this.summaryPanelMinHeight);
            this.setSize(w, h);
            CommonUtil.centerOnScreen(this);
        } else {
            this.setSize(ds.rec.getSize());
            this.setLocation(ds.rec.getLocation());
            this.treePath = ds.treePath;
        }
    }

    protected void showHelp() {
        HelpManager.showTopic((Component)Ide.getMainWindow(), this.getHelpIndex());
    }

    public String getCaption() {
        if (this.model instanceof DesignPartViewPlaceHolder) {
            return Messages.getString("ModelPropertiesDialogEx.SubviewProperties");
        }
        return Messages.getString("ModelPropertiesDialogEx.ModelProperties");
    }

    public void initProperties(ModelIDObject object) {
        this.model = object;
        this.tfName.setText(this.model.getName());
        this.taComments.setText(this.model.getComment());
        this.taNotes.setText(this.model.getNotes());
        this.tfObjectID.setText(this.model.getObjectID());
        this.tfCreationTime.setText(this.model.getCreationTime());
        this.tfCreator.setText(this.model.getCreator().getName());
        this.tfLastChangedBy.setText(this.model.getChanger().getName());
        this.tfLastChangedTime.setText(this.model.getChangeTime());
        if (this.model instanceof DataFlowDesign) {
            this.initProcessOrder();
        }
        if (this.model instanceof MultidimensionalDesign) {
            MultidimensionalDesign mdm = (MultidimensionalDesign)this.model;
            this.cbBoundModel.setSelectedItem(mdm.getBoundModel());
            if (!mdm.isEmpty()) {
                this.cbBoundModel.setEnabled(false);
            }
        }
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            this.chbVisible.setSelected(((DesignPart)this.model).isMainViewVisible());
            this.initResponsibleParties();
            this.initDocuments();
        } else if (this.model instanceof DesignPartViewPlaceHolder && ((DesignPartViewPlaceHolder)this.model).getDesignPartView() != null && ((DesignPartViewPlaceHolder)this.model).getDesignPartView().isMasterDPV()) {
            this.chbVisible.setSelected(((DesignPartViewPlaceHolder)this.model).getVisible());
            SchemaObject so = ((DesignPartViewPlaceHolder)this.model).getDesignPartView().getSchemaObject();
            if (so != null) {
                this.tfSchemaName.setText(so.getName());
            }
        } else {
            this.chbVisible.setEnabled(false);
        }
    }

    private void initProcessOrder() {
        if (this.model instanceof DataFlowDesign) {
            this.selectedColumnsModel.removeAllElements();
            DataFlowDesign dfd = (DataFlowDesign)this.model;
            Iterator it = dfd.getProcessOrderList().iterator();
            while (it.hasNext()) {
                this.selectedColumnsModel.addElement(it.next());
            }
            this.selectedColumnsList.updateUI();
        }
    }

    protected void checkNameExists(String name) throws EmptyFieldException {
        if (this.model instanceof DesignPart) {
            ModelIDObjectSet mos;
            ModelObject mo;
            DesignPart dt = (DesignPart)this.model;
            if (dt.getParent() instanceof ModelIDObjectSet && (mo = (mos = (ModelIDObjectSet)dt.getParent()).getByName(name)) != null && mo != this.model) {
                this.tfName.requestFocus();
                throw new EmptyFieldException(Messages.getString("ModelPropertiesDialogEx.ModelExists"));
            }
        } else if (this.model instanceof DesignPartViewPlaceHolder) {
            DesignPartView display;
            DesignPart dt = ((DesignPartViewPlaceHolder)this.model).getDesignPart();
            DesignPartView subView = dt.getSubViewByName(name);
            if (subView != null && subView != ((DesignPartViewPlaceHolder)this.model).getDesignPartView()) {
                this.tfName.requestFocus();
                throw new EmptyFieldException(Messages.getString("ModelPropertiesDialogEx.SubViewExists"));
            }
            DesignPartView dpv = ((DesignPartViewPlaceHolder)this.model).getDesignPartView();
            DesignPartView masterDPV = dpv.getMasterDPV();
            if (masterDPV != null && (display = masterDPV.getDisplayByName(name)) != null && display != dpv) {
                this.tfName.requestFocus();
                throw new EmptyFieldException(Messages.getString("ModelPropertiesDialogEx.DisplayExists"));
            }
        }
    }

    protected void setProperties() throws EmptyFieldException {
        MultidimensionalDesign mdm;
        if (!this.readonlyName) {
            if (!"".equalsIgnoreCase(this.tfName.getText().trim())) {
                this.checkNameExists(this.tfName.getText());
                this.model.setName(this.tfName.getText());
            } else {
                this.tfName.requestFocus();
                throw new EmptyFieldException(Messages.getString("ModelPropertiesDialogEx.NameCanNotBeEmpty"));
            }
        }
        this.model.setComment(this.taComments.getText());
        this.model.setNotes(this.taNotes.getText());
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            ((DesignPart)this.model).setMainViewVisible(this.chbVisible.isSelected());
            this.setResponsibleParties();
            this.setDocuments();
        } else if (this.model instanceof DesignPartViewPlaceHolder && ((DesignPartViewPlaceHolder)this.model).getDesignPartView() != null && ((DesignPartViewPlaceHolder)this.model).getDesignPartView().isMasterDPV()) {
            ((DesignPartViewPlaceHolder)this.model).setVisible(this.chbVisible.isSelected());
        }
        if (this.model instanceof MultidimensionalDesign && (mdm = (MultidimensionalDesign)this.model).isEmpty()) {
            mdm.setBoundModel((DesignPart)this.cbBoundModel.getSelectedItem());
        }
        if (this.model instanceof DataFlowDesign) {
            List list = ((DataFlowDesign)this.model).getProcessOrderList();
            for (int i = 0; i < this.selectedColumnsModel.getSize(); ++i) {
                Object obj = this.selectedColumnsModel.get(i);
                if (!list.remove(obj)) continue;
                list.add(i, obj);
            }
        }
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null && ((DesignPart)this.model).getMainView().isVisible()) {
            ((DesignPart)this.model).getMainView().getWorkSpace().repaint();
        }
    }

    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        if (this.model instanceof DataFlowDesign) {
            this.addToTree(root, this.getProcessOrderPanel());
        }
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            this.chbVisible.setSelected(((DesignPart)this.model).isMainViewVisible());
            this.addToTree(root, this.getResPartiesPanel());
            this.addToTree(root, this.getDocumentsPanel());
        }
        this.addToTree(root, this.getSummaryPanel());
    }

    protected String getHelpIndex() {
        if (this.model instanceof DesignPartViewPlaceHolder) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)this.model;
            if (ph.getObject() instanceof DPVLogicalSubView || ph.getObject() instanceof DPVRelationalSubView || ph.getObject() instanceof DPVDataTypesSubView) {
                return "SUB_VIEW_PROPERTIES_DIALOG";
            }
            if (ph.getObject() instanceof DesignPartView && !((DesignPartView)ph.getObject()).isMasterDPV()) {
                return "DISPLAY_PROPERTIES_DIALOG";
            }
        }
        return "";
    }

    protected void initCaption(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCaption()).append(" - ").append(name);
        this.setTitle(buffer.toString());
    }

    protected void selectName() {
        this.tfName.requestFocus();
        this.tfName.selectAll();
    }

    @Override
    public void show() {
        if (this.model.showModal) {
            this.setModal(true);
        }
        if (this.treePath.length() > 0) {
            String[] names = this.treePath.split("/");
            TreePath tp = TreeUtils.findByName(this.getTree(), names);
            if (tp != null) {
                this.getTree().setSelectionPath(tp);
            }
        }
        super.show();
        this.selectName();
    }

    protected int getMinimumWidth() {
        return this.summaryPanelMinWidth;
    }

    protected int getMinimumHeight() {
        return this.summaryPanelMinHeight;
    }

    public JPanel getMainPanel() {
        if (this.pnMain == null) {
            this.pnMain = new JPanel(this.cardLayout);
            this.pnMain.setMinimumSize(new Dimension(400, 0));
        }
        return this.pnMain;
    }

    protected JPanel createPage(String title) {
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        panel.setName(title);
        JPanel caption = new JPanel();
        caption.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        caption.setBackground(Color.WHITE);
        JLabel lb = new JLabel("<html><body><b>" + title + "</b>" + "</body>" + "</html>");
        caption.add(lb);
        panel.add((Component)caption, "North");
        return panel;
    }

    protected Dimension getDefaultSize() {
        return this.defaultSize;
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("ModelPropertiesDialogEx.General"));
            JPanel jpanel = new JPanel(new BorderLayout());
            this.pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbName = new JLabel(LB_NAME);
            lbName.setPreferredSize(this.getDefaultSize());
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.getDefaultSize());
            this.tfName.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(lbName, this.tfName));
            JLabel lbVisible = new JLabel(LB_VISIBLE);
            lbVisible.setPreferredSize(this.getDefaultSize());
            this.chbVisible = new JCheckBox();
            this.chbVisible.setPreferredSize(this.getDefaultSize());
            this.chbVisible.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(lbVisible, this.chbVisible));
            if (this.model instanceof MultidimensionalDesign) {
                MultidimensionalDesign mdm = (MultidimensionalDesign)this.model;
                ArrayList<LogicalDesign> list = new ArrayList<LogicalDesign>();
                mdm.getDesign().getRelationalDesigns().addAllElementsTo(list);
                Collections.sort(list, ModelIDObjectSet.NAME_COMPARATOR);
                list.add(0, mdm.getDesign().getLogicalDesign());
                JLabel lbBoundModel = new JLabel(Messages.getString("ModelPropertiesDialogEx.BoundModel"));
                lbBoundModel.setPreferredSize(this.getDefaultSize());
                this.cbBoundModel = new JComboBox<Object>(list.toArray());
                this.cbBoundModel.setPreferredSize(this.getDefaultSize());
                this.cbBoundModel.setEnabled(this.isEditable());
                this.pnGeneralGrid.add(this.createRow(lbBoundModel, this.cbBoundModel));
            }
            if (this.model instanceof DesignPartViewPlaceHolder) {
                JLabel lbSchema = new JLabel(Messages.getString("ModelPropertiesDialogEx.SubviewFoSchema"));
                lbSchema.setPreferredSize(this.getDefaultSize());
                this.tfSchemaName = new JTextField();
                this.tfSchemaName.setPreferredSize(this.getDefaultSize());
                this.tfSchemaName.setEnabled(false);
                this.pnGeneralGrid.add(this.createRow(lbSchema, this.tfSchemaName));
            }
            jpanel.add((Component)this.pnGeneralGrid, "North");
            this.pnGeneral.add((Component)jpanel, "Center");
        }
        return this.pnGeneral;
    }

    protected JPanel getCommentsPanel() {
        if (this.pnComments == null) {
            this.pnComments = this.createPage(Messages.getString("ModelPropertiesDialogEx.Comments"));
            this.taComments = new RSyntaxTextArea();
            this.taComments.setEnabled(this.isEditable());
            this.taComments.setLineWrap(true);
            this.taComments.setWrapStyleWord(true);
            this.taComments.setBorder(null);
            this.taComments.setAntiAliasingEnabled(true);
            this.taComments.setFont(this.tfName.getFont());
            this.pnComments.add(new JScrollPane((Component)this.taComments));
        }
        return this.pnComments;
    }

    protected JPanel getNotesPanel() {
        if (this.pnNotes == null) {
            this.pnNotes = this.createPage(Messages.getString("ModelPropertiesDialogEx.Notes"));
            this.taNotes = new RSyntaxTextArea();
            this.taNotes.setEnabled(this.isEditable());
            this.taNotes.setLineWrap(true);
            this.taNotes.setWrapStyleWord(true);
            this.taNotes.setBorder(null);
            this.taNotes.setAntiAliasingEnabled(true);
            this.taNotes.setFont(this.tfName.getFont());
            this.pnNotes.add(new JScrollPane((Component)this.taNotes));
        }
        return this.pnNotes;
    }

    protected JPanel getSummaryPanel() {
        if (this.pnSummary == null) {
            this.pnSummary = this.createPage(Messages.getString("ModelPropertiesDialogEx.Summary"));
            JPanel jpanel = new JPanel(new BorderLayout());
            this.pnSummaryGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbObjectID = new JLabel(LB_OBJECT_ID);
            lbObjectID.setPreferredSize(this.getDefaultSize());
            this.tfObjectID = new JTextField();
            this.tfObjectID.setPreferredSize(this.getDefaultSize());
            this.tfObjectID.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbObjectID, this.tfObjectID));
            JLabel lbCreator = new JLabel(LB_CREATOR);
            lbCreator.setPreferredSize(this.getDefaultSize());
            this.tfCreator = new JTextField();
            this.tfCreator.setPreferredSize(this.getDefaultSize());
            this.tfCreator.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbCreator, this.tfCreator));
            JLabel lbCreationTime = new JLabel(LB_CREATION_TIME);
            lbCreationTime.setPreferredSize(this.getDefaultSize());
            this.tfCreationTime = new JTextField();
            this.tfCreationTime.setPreferredSize(this.getDefaultSize());
            this.tfCreationTime.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbCreationTime, this.tfCreationTime));
            JLabel lbLastChangedBy = new JLabel(LB_LAST_CHANGED_BY);
            lbLastChangedBy.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedBy = new JTextField();
            this.tfLastChangedBy.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedBy.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbLastChangedBy, this.tfLastChangedBy));
            JLabel lbLastChangedTime = new JLabel(LB_LAST_CHANGED_TIME);
            lbLastChangedTime.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedTime = new JTextField();
            this.tfLastChangedTime.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedTime.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbLastChangedTime, this.tfLastChangedTime));
            this.summaryCount = this.pnSummaryGrid.getComponentCount();
            JLabel lbDataDictConnection = new JLabel(LB_SOURCE_DB_CONNECTION);
            lbDataDictConnection.setPreferredSize(this.getDefaultSize());
            this.tfDataDictConnection = new JTextField();
            this.tfDataDictConnection.setPreferredSize(this.getDefaultSize());
            this.tfDataDictConnection.setEditable(false);
            this.pnDataDictConnection = this.createRow(lbDataDictConnection, this.tfDataDictConnection);
            JLabel lbDataDictConnections = new JLabel(LB_SOURCE_DB_CONNECTIONS);
            lbDataDictConnections.setPreferredSize(this.getDefaultSize());
            this.cbDataDictConnections = new JComboBox();
            this.cbDataDictConnections.setMaximumRowCount(8);
            this.cbDataDictConnections.setEditable(false);
            this.pnDataDictConnections = this.createRow(lbDataDictConnections, this.cbDataDictConnections);
            JLabel lbDDLFileName = new JLabel(LB_SOURCE_DDL_FILE);
            lbDDLFileName.setPreferredSize(this.getDefaultSize());
            this.tfDDLFileName = new JTextField();
            this.tfDDLFileName.setPreferredSize(this.getDefaultSize());
            this.tfDDLFileName.setEditable(false);
            this.pnDDLFileName = this.createRow(lbDDLFileName, this.tfDDLFileName);
            JLabel lbDDLFileNames = new JLabel(LB_SOURCE_DDL_FILES);
            lbDDLFileNames.setPreferredSize(this.getDefaultSize());
            this.cbDDLFileNames = new JComboBox();
            this.cbDDLFileNames.setMaximumRowCount(8);
            this.cbDDLFileNames.setEditable(false);
            this.pnDDLFileNames = this.createRow(lbDDLFileNames, this.cbDDLFileNames);
            jpanel.add((Component)this.pnSummaryGrid, "North");
            this.pnSummary.add((Component)jpanel, "Center");
        }
        return this.pnSummary;
    }

    protected JPanel createRow(Component leftComp, Component rightComp) {
        JPanel newRow = new JPanel(new BorderLayout());
        newRow.add(leftComp, "West");
        newRow.add(rightComp, "Center");
        return newRow;
    }

    protected void addToTree(DefaultMutableTreeNode node, JPanel panel) {
        node.add(new DefaultMutableTreeNode(panel));
        this.getMainPanel().add((Component)panel, panel.getName());
    }

    protected JTree getTree() {
        if (this.tree == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
            this.tree = new JTree(root);
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.initTree(root);
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
        }
        return this.tree;
    }

    private void close() {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        String treePath = TreeUtils.createFilePath(this.getTree().getSelectionPath());
        this.appView.getSettings().setDialogSettings(this.getClass().getName(), rectangle, treePath);
        this.dispose();
    }

    protected int getMinimumTreeWidth() {
        return 150;
    }

    protected void initLayout() {
        JScrollPane scrollPane = new JScrollPane(this.getTree());
        scrollPane.setMinimumSize(new Dimension(150, 0));
        JSplitPane splitPane = new JSplitPane(1, scrollPane, this.getMainPanel());
        splitPane.setDividerLocation(this.getMinimumTreeWidth());
        splitPane.setDividerSize(3);
        FlowLayout flowLayout = new FlowLayout(2);
        JPanel pnButtons = new JPanel(flowLayout);
        if (this.isEditable()) {
            JButton bnOK = new JButton(new AbstractAction(Messages.getString("ModelPropertiesDialogEx.OK")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ModelPropertiesDialogEx.this.setProperties();
                        ModelPropertiesDialogEx.this.model.setDirty(true);
                        ModelPropertiesDialogEx.this.close();
                    }
                    catch (EmptyFieldException exp) {
                        JOptionPane.showMessageDialog(ModelPropertiesDialogEx.this, exp.getMessage(), Messages.getString("ModelPropertiesDialogEx.Error"), 0);
                    }
                }
            });
            bnOK.setMnemonic(79);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.getRootPane().setDefaultButton(bnOK);
            JButton bnApply = new JButton(new AbstractAction(Messages.getString("ModelPropertiesDialogEx.Apply")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ModelPropertiesDialogEx.this.setProperties();
                        ModelPropertiesDialogEx.this.model.setDirty(true);
                    }
                    catch (EmptyFieldException exp) {
                        JOptionPane.showMessageDialog(ModelPropertiesDialogEx.this, exp.getMessage(), Messages.getString("ModelPropertiesDialogEx.Error"), 0);
                    }
                }
            });
            bnApply.setMnemonic(65);
            bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            pnButtons.add(bnOK);
            pnButtons.add(bnApply);
        }
        this.bnCancel = new JButton(new AbstractAction(this.isEditable() ? Messages.getString("ModelPropertiesDialogEx.Cancel") : Messages.getString("ModelPropertiesDialogEx.Close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelPropertiesDialogEx.this.close();
            }
        });
        this.bnCancel.setMnemonic(67);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton bnHelp = new JButton(new AbstractAction(Messages.getString("ModelPropertiesDialogEx.Help")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelPropertiesDialogEx.this.showHelp();
            }
        });
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnCancel);
        pnButtons.add(bnHelp);
        this.getContentPane().add((Component)splitPane, "Center");
        this.getContentPane().add((Component)pnButtons, "South");
    }

    protected void initResponsibleParties() {
        this.rpList.addAll(((DesignPart)this.model).getResponsibleParties());
    }

    protected void setResponsibleParties() {
        ((DesignPart)this.model).clearResponsibleParties();
        for (BIResponsibleParty party : this.rpList) {
            ((DesignPart)this.model).addResponsibleParty(party);
        }
    }

    protected JPanel getResPartiesPanel() {
        if (this.pnResParties == null) {
            this.pnResParties = this.createPage(Messages.getString("ModelPropertiesDialogEx.ResponsibleParties"));
            this.rpList = new ArrayList();
            this.rpTable = new JTable(new ResPartyModel());
            this.rpTable.setSelectionMode(0);
            this.rpTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ModelPropertiesDialogEx.this.rpTable.getSelectedRow()) != -1 && ModelPropertiesDialogEx.this.rpList.size() > 0 && row < ModelPropertiesDialogEx.this.rpList.size()) {
                        DesignObject object = (DesignObject)ModelPropertiesDialogEx.this.rpList.get(row);
                        object.showModal = ModelPropertiesDialogEx.this.model.showModal;
                        object.showPropertyDialog();
                    }
                }
            });
            JScrollPane rpPane = new JScrollPane(this.rpTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            final JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ModelPropertiesDialogEx.this.rpTable.getSelectedRow();
                    if (row != -1 && ModelPropertiesDialogEx.this.rpList.size() > 0 && row < ModelPropertiesDialogEx.this.rpList.size()) {
                        DesignObject object = (DesignObject)ModelPropertiesDialogEx.this.rpList.get(row);
                        object.showModal = ModelPropertiesDialogEx.this.model.showModal;
                        object.showPropertyDialog();
                    }
                }
            });
            JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            btnAdd.setToolTipText(BTN_ADD);
            btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddPartyDialog dialog = new AddPartyDialog(ModelPropertiesDialogEx.this.appView, ModelPropertiesDialogEx.this.model.getDesign(), ModelPropertiesDialogEx.this.rpList);
                    dialog.setVisible(true);
                    ModelPropertiesDialogEx.this.rpTable.updateUI();
                }
            });
            final JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            btnRemove.setToolTipText(BTN_REMOVE);
            btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int objectNumber = ModelPropertiesDialogEx.this.rpTable.getSelectedRow();
                    if (objectNumber != -1 && ModelPropertiesDialogEx.this.rpList.size() > 0 && objectNumber < ModelPropertiesDialogEx.this.rpList.size()) {
                        ModelPropertiesDialogEx.this.rpList.remove(objectNumber);
                        ModelPropertiesDialogEx.this.rpTable.updateUI();
                    }
                }
            });
            this.rpTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (ModelPropertiesDialogEx.this.rpList.isEmpty()) {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    }
                }
            });
            this.rpTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (ModelPropertiesDialogEx.this.rpList.isEmpty()) {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    }
                }
            });
            JPanel rpPanel = new JPanel(new BorderLayout());
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            rpPanel.add((Component)buttonGeneral, "North");
            rpPanel.add((Component)rpPane, "Center");
            this.pnResParties.add((Component)rpPanel, "Center");
            this.rpTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int objectNumber;
                    if (e.getKeyCode() == 127 && (objectNumber = ModelPropertiesDialogEx.this.rpTable.getSelectedRow()) != -1 && ModelPropertiesDialogEx.this.rpList.size() > 0 && objectNumber < ModelPropertiesDialogEx.this.rpList.size()) {
                        ModelPropertiesDialogEx.this.rpList.remove(objectNumber);
                        ModelPropertiesDialogEx.this.rpTable.updateUI();
                    }
                }
            });
        }
        return this.pnResParties;
    }

    protected JPanel getProcessOrderPanel() {
        if (this.pnProcessOrder == null) {
            this.pnProcessOrder = this.createPage(Messages.getString("ModelPropertiesDialogEx.ProcessOrderNumber"));
            JPanel pnSelected = new JPanel(new BorderLayout());
            this.selectedColumnsModel = new DefaultListModel();
            this.selectedColumnsList = new JList(this.selectedColumnsModel);
            JScrollPane sp = new JScrollPane(this.selectedColumnsList);
            sp.setPreferredSize(new Dimension(145, 220));
            pnSelected.add(sp);
            this.selectedColumnsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = ModelPropertiesDialogEx.this.selectedColumnsList.getSelectedIndex();
                    if (row != -1) {
                        if (e.getClickCount() == 2 && ModelPropertiesDialogEx.this.selectedColumnsModel.size() > 0 && row < ModelPropertiesDialogEx.this.selectedColumnsModel.size()) {
                            DesignObject object = (DesignObject)ModelPropertiesDialogEx.this.selectedColumnsModel.get(row);
                            object.showModal = ModelPropertiesDialogEx.this.model.showModal;
                            object.showPropertyDialog();
                        }
                        ModelPropertiesDialogEx.this.btnProcessProperties.setEnabled(true);
                        ModelPropertiesDialogEx.this.btnUp.setEnabled(true);
                        ModelPropertiesDialogEx.this.btnDown.setEnabled(true);
                    } else {
                        ModelPropertiesDialogEx.this.btnProcessProperties.setEnabled(false);
                        ModelPropertiesDialogEx.this.btnUp.setEnabled(false);
                        ModelPropertiesDialogEx.this.btnDown.setEnabled(false);
                    }
                }
            });
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnProcessProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProcessProperties.setEnabled(false);
            this.btnProcessProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProcessProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ModelPropertiesDialogEx.this.selectedColumnsList.getSelectedIndex();
                    if (row != -1 && ModelPropertiesDialogEx.this.selectedColumnsModel.size() > 0 && row < ModelPropertiesDialogEx.this.selectedColumnsModel.size()) {
                        DesignObject object = (DesignObject)ModelPropertiesDialogEx.this.selectedColumnsModel.get(row);
                        object.showModal = ModelPropertiesDialogEx.this.model.showModal;
                        object.showPropertyDialog();
                    }
                }
            });
            this.btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            this.btnUp.setEnabled(false);
            this.btnUp.setToolTipText(Messages.getString("ModelPropertiesDialogEx.MoveUp"));
            this.btnUp.addActionListener(new MoveUpAction());
            this.btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            this.btnDown.setEnabled(false);
            this.btnDown.setToolTipText(Messages.getString("ModelPropertiesDialogEx.MoveDown"));
            this.btnDown.addActionListener(new MoveDownAction());
            JPanel rpPanel = new JPanel(new BorderLayout());
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnProcessProperties);
            if (this.isEditable()) {
                toolBar.addSeparator();
                toolBar.add(this.btnUp);
                toolBar.add(this.btnDown);
            }
            buttonGeneral.add(toolBar);
            rpPanel.add((Component)buttonGeneral, "North");
            rpPanel.add((Component)pnSelected, "Center");
            this.pnProcessOrder.add((Component)rpPanel, "Center");
        }
        return this.pnProcessOrder;
    }

    protected void initDocuments() {
        this.docList.addAll(((DesignPart)this.model).getDocuments());
    }

    protected void setDocuments() {
        ((DesignPart)this.model).clearDocuments();
        for (BIDocument doc : this.docList) {
            ((DesignPart)this.model).addDocument(doc);
        }
    }

    protected JPanel getDocumentsPanel() {
        if (this.pnDocuments == null) {
            this.pnDocuments = this.createPage(Messages.getString("ModelPropertiesDialogEx.Documents"));
            this.docList = new ArrayList();
            this.docTable = new JTable(new DocumentTableModel());
            this.docTable.setSelectionMode(0);
            this.docTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ModelPropertiesDialogEx.this.docTable.getSelectedRow()) != -1 && ModelPropertiesDialogEx.this.docList.size() > 0 && row < ModelPropertiesDialogEx.this.docList.size()) {
                        DesignObject object = (DesignObject)ModelPropertiesDialogEx.this.docList.get(row);
                        object.showModal = ModelPropertiesDialogEx.this.model.showModal;
                        object.showPropertyDialog();
                    }
                }
            });
            JScrollPane docPane = new JScrollPane(this.docTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            final JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ModelPropertiesDialogEx.this.docTable.getSelectedRow();
                    if (row != -1 && ModelPropertiesDialogEx.this.docList.size() > 0 && row < ModelPropertiesDialogEx.this.docList.size()) {
                        DesignObject object = (DesignObject)ModelPropertiesDialogEx.this.docList.get(row);
                        object.showModal = ModelPropertiesDialogEx.this.model.showModal;
                        object.showPropertyDialog();
                    }
                }
            });
            JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            btnAdd.setToolTipText(BTN_ADD);
            btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddDocumentDialog dialog = new AddDocumentDialog(ModelPropertiesDialogEx.this.appView, ModelPropertiesDialogEx.this.model.getDesign(), ModelPropertiesDialogEx.this.docList);
                    dialog.setVisible(true);
                    ModelPropertiesDialogEx.this.docTable.updateUI();
                }
            });
            final JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            btnRemove.setToolTipText(BTN_REMOVE);
            btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int objectNumber = ModelPropertiesDialogEx.this.docTable.getSelectedRow();
                    if (objectNumber != -1 && ModelPropertiesDialogEx.this.docList.size() > 0 && objectNumber < ModelPropertiesDialogEx.this.docList.size()) {
                        ModelPropertiesDialogEx.this.docList.remove(objectNumber);
                        ModelPropertiesDialogEx.this.docTable.updateUI();
                    }
                }
            });
            this.docTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (ModelPropertiesDialogEx.this.docList.isEmpty()) {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    }
                }
            });
            this.docTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (ModelPropertiesDialogEx.this.docList.isEmpty()) {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            JPanel docPanel = new JPanel(new BorderLayout());
            docPanel.add((Component)buttonGeneral, "North");
            docPanel.add((Component)docPane, "Center");
            this.pnDocuments.add((Component)docPanel, "Center");
            this.docTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int objectNumber;
                    if (e.getKeyCode() == 127 && (objectNumber = ModelPropertiesDialogEx.this.docTable.getSelectedRow()) != -1 && ModelPropertiesDialogEx.this.docList.size() > 0 && objectNumber < ModelPropertiesDialogEx.this.docList.size()) {
                        ModelPropertiesDialogEx.this.docList.remove(objectNumber);
                        ModelPropertiesDialogEx.this.docTable.updateUI();
                    }
                }
            });
        }
        return this.pnDocuments;
    }

    protected boolean isEditable() {
        if (this.model.getDesign().isHidden()) {
            return false;
        }
        if (this.model.isReadOnly()) {
            return false;
        }
        if (ApplicationView.IS_VIEWER) {
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            return this.model instanceof LogicalDesign;
        }
        return true;
    }

    public boolean moveToIndex(Object object, int index) {
        if (this.selectedColumnsModel.contains(object) && this.selectedColumnsModel.size() > index && index >= 0) {
            this.selectedColumnsModel.removeElement(object);
            this.selectedColumnsModel.add(index, object);
            return true;
        }
        return false;
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = ModelPropertiesDialogEx.this.selectedColumnsList.getSelectedIndices();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < ModelPropertiesDialogEx.this.selectedColumnsModel.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Object obj = ModelPropertiesDialogEx.this.selectedColumnsModel.get(objectNumber);
                    ModelPropertiesDialogEx.this.moveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                ModelPropertiesDialogEx.this.selectedColumnsList.setSelectedIndices(selection);
                ModelPropertiesDialogEx.this.selectedColumnsList.updateUI();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = ModelPropertiesDialogEx.this.selectedColumnsList.getSelectedIndices();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Object obj = ModelPropertiesDialogEx.this.selectedColumnsModel.get(objectNumber);
                    ModelPropertiesDialogEx.this.moveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                ModelPropertiesDialogEx.this.selectedColumnsList.setSelectedIndices(selection);
                ModelPropertiesDialogEx.this.selectedColumnsList.updateUI();
            }
        }
    }

    private class DocumentTableModel
    extends AbstractTableModel {
        private DocumentTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ModelPropertiesDialogEx.this.docList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ModelPropertiesDialogEx.Documents");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)ModelPropertiesDialogEx.this.docList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class ResPartyModel
    extends AbstractTableModel {
        private ResPartyModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ModelPropertiesDialogEx.this.rpList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ModelPropertiesDialogEx.ResponsibleParties");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)ModelPropertiesDialogEx.this.rpList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ModelPropertiesDialogEx.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object obj = node.getUserObject();
            if (obj instanceof Component) {
                ModelPropertiesDialogEx.this.cardLayout.show(ModelPropertiesDialogEx.this.getMainPanel(), ((Component)obj).getName());
            }
        }
    }

    public class TreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof Component) {
                Component c = (Component)node.getUserObject();
                this.setText(c.getName());
            }
            return this;
        }
    }
}

