/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewRenderer;

public class DiagramViewDiagramCell
extends DefaultDiagramCell {
    private JPopupMenu menu;
    private DiagramView diagramView;
    private JCheckBoxMenuItem miComposite;
    private JMenu miDisplays;
    private DiagramViewRenderer renderer;
    private JMenuItem miViewDiagram;

    public DiagramViewDiagramCell(DiagramView diagramView) {
        this(diagramView, DiagramConstants.createMap());
    }

    public DiagramViewDiagramCell(DiagramView diagramView, Map attributeMap) {
        this.diagramView = diagramView;
        this.setAttributes(attributeMap);
        DiagramConstants.setValue(this.getAttributes(), diagramView.getName());
    }

    private void showProperty() {
        this.getDiagramView().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.viewDiagram();
    }

    private void viewDiagram() {
        DesignPartView curdpv = ((Diagram)this.getCellView().getDiagram()).getAppView().getCurrentDPV();
        if (this.diagramView.getDesignPartView() != null && this.diagramView.getDesignPartView().getDesignPart().isLoaded()) {
            DesignPartView mdpv;
            DesignPartView.NamedTabbedPane pane;
            DesignPartView dpv;
            if (curdpv != null) {
                this.diagramView.getDesignPartView().setLastContainerDiagram(curdpv);
            }
            if ((dpv = this.diagramView.getDesignPartView()).isMasterDPV()) {
                pane = dpv.getTabbedPane();
                mdpv = dpv;
            } else {
                pane = dpv.getMasterDPV().getTabbedPane();
                mdpv = dpv.getMasterDPV();
            }
            if (dpv.activateEditor()) {
                pane.setSelectedComponent(dpv);
            } else if (mdpv == dpv.getDesignPart().getMainView()) {
                dpv.getDesignPart().setMainViewVisible(true);
            } else {
                mdpv.getPlaceHolder().setVisible(true);
            }
            if (pane.indexOfComponent(dpv) > -1 && pane.indexOfComponent(mdpv) > -1) {
                pane.setSelectedComponent(mdpv);
                pane.setSelectedComponent(dpv);
            }
        }
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.diagramView.getDesignPartView() != null) {
            this.miViewDiagram = this.menu.add(new AbstractAction(Messages.getString("DiagramViewDiagramCell.ViewDiagram")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiagramViewDiagramCell.this.viewDiagram();
                }
            });
            this.menu.addSeparator();
        }
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(DELETE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiagramViewDiagramCell.this.deleteDiagramView();
                }
            });
        }
        if (this.diagramView.getDesignPartView() != null) {
            this.menu.addSeparator();
            this.miComposite = new JCheckBoxMenuItem(new AbstractAction(Messages.getString("DiagramViewDiagramCell.CompositeView")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiagramViewDiagramCell.this.diagramView.setCompositeView(!DiagramViewDiagramCell.this.diagramView.isCompositeView());
                    DiagramViewDiagramCell.this.getDiagram().repaint(DiagramViewDiagramCell.this.getCellView().getBounds().getBounds());
                }
            });
            this.menu.add(this.miComposite);
            this.menu.addSeparator();
            this.miDisplays = new JMenu(Messages.getString("DiagramViewDiagramCell.Displays"));
            this.menu.add(this.miDisplays);
            this.menu.addSeparator();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DiagramViewDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiagramViewDiagramCell.this.showProperty();
                }
            });
            this.miComposite.setSelected(this.diagramView.isCompositeView());
            this.miComposite.setEnabled(this.diagramView.getDesignPartView().getDesignPart().isLoaded());
            this.miViewDiagram.setEnabled(this.diagramView.getDesignPartView().getDesignPart().isLoaded());
            this.updateDisplaysMenu();
        }
        return this.menu;
    }

    private void updateDisplaysMenu() {
        this.miDisplays.removeAll();
        final DesignPartView mainDPV = this.diagramView.getDesignPartView().isMasterDPV() ? this.diagramView.getDesignPartView() : this.diagramView.getDesignPartView().getMasterDPV();
        JCheckBoxMenuItem miMain = new JCheckBoxMenuItem(new AbstractAction(Messages.getString("DiagramViewDiagramCell.MainDiagram")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagramViewDiagramCell.this.diagramView.setDesignPartView(mainDPV);
                for (TopView tv : DiagramViewDiagramCell.this.diagramView.getAllViewsWithCellViews()) {
                    DiagramViewDiagramCell cell = (DiagramViewDiagramCell)tv.getCellView().getCell();
                    if (cell == null) continue;
                    cell.getRenderer().resetOverviewPanel();
                    cell.getDiagram().repaint(tv.getCellView().getBounds().getBounds());
                }
                DiagramViewDiagramCell.this.getDiagram().repaint(DiagramViewDiagramCell.this.getCellView().getBounds().getBounds());
            }
        });
        this.miDisplays.add(miMain);
        miMain.setSelected(this.diagramView.getDesignPartView().isMasterDPV());
        if (mainDPV.getSubordinateViews().size() > 0) {
            this.miDisplays.addSeparator();
            for (final DesignPartView subView : mainDPV.getSubordinateViews()) {
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(new AbstractAction(subView.getName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DiagramViewDiagramCell.this.diagramView.setDesignPartView(subView);
                        subView.setVisible(true);
                        for (TopView tv : DiagramViewDiagramCell.this.diagramView.getAllViewsWithCellViews()) {
                            DiagramViewDiagramCell cell = (DiagramViewDiagramCell)tv.getCellView().getCell();
                            if (cell == null) continue;
                            cell.getRenderer().resetOverviewPanel();
                            cell.getDiagram().repaint(tv.getCellView().getBounds().getBounds());
                        }
                    }
                });
                this.miDisplays.add(menuItem);
                menuItem.setSelected(this.diagramView.getDesignPartView() == subView);
            }
        }
    }

    public DiagramView getDiagramView() {
        return this.diagramView;
    }

    public void deleteDiagramView() {
        DiagramView dv = this.getDiagramView();
        ApplicationView.log(MessageFormat.format(Messages.getString("DiagramViewDiagramCell.DeleteDiagramView"), dv.getName()));
        dv.remove();
    }

    @Override
    public void deleteSelected() {
        this.deleteDiagramView();
    }

    public DiagramViewRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DiagramViewRenderer renderer) {
        this.renderer = renderer;
    }
}

