/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.DesignRuleManager;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.CheckResultComponent;
import oracle.dbtools.crest.swingui.designrules.DRMCellRenderer;
import oracle.dbtools.crest.swingui.designrules.DesignRuleManagerTreeModel;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSet;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSetPropertiesDialog;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;

public class DesignRuleView
extends CustomDialog
implements ActionListener {
    private static final long serialVersionUID = 8407946894969410152L;
    private static final String RULESET_NAME = "RuleSet";
    private CheckResultComponent checkResultComponent;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private DesignRuleManagerTreeModel treeModel;
    private JTree jtree;
    private JDialog dialog;
    private RelationalDesign relDesign;
    private Action applySelectedAction;
    private JPanel mainPanel;
    private JPanel designRulesPanel;
    private int cgCounter = 0;
    public List<DesignRuleSet> ruleSetsContainerList;
    private JTable ruleSetsTable;
    private JButton btnAddRuleSet;
    private JButton btnRemoveRuleSet;
    private JButton btnProperties;
    private DesignRuleSet currentRuleSet;
    protected static Settings settings;
    private JButton bnApplySelectedRuleSets;
    private JButton bnApplyAllRuleSets;
    private JButton bnApplySelected;
    public JButton bnSaveRuleSets;
    private ApplicationView appView;
    private JSplitPane splitPane;
    private ArrayList<DesignRule> allDesignRules = new ArrayList();
    private JTabbedPane tpane;
    private JPanel buttonPanel;
    public boolean ruleSetsSaved = true;
    private JButton bnApplyAll;

    public DesignRuleView(ApplicationView appView, RelationalDesign relDesign, DataFlowDesign dfd) {
        super(appView);
        this.appView = appView;
        this.relDesign = relDesign;
        appView.loadCustomDRScripts();
        this.setLayout(new BorderLayout());
        if (settings == null) {
            settings = this.getApplicationView().getSettings();
        }
    }

    @Override
    protected void close() {
        this.close(this.getDialog());
    }

    public void close(Window dialog) {
        this.getDesign().getDesignLevelSettings().getNamingStandardRule().clearGlossaries();
        Rectangle rectangle = new Rectangle(this.getDialog().getLocation(), this.getDialog().getSize());
        settings.setDialogSettings(this.getClass().getName(), rectangle);
        this.nullifyDesignRuleManager();
        dialog.dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "DESIGN_RULES_DIALOG";
    }

    public DesignRuleManager getRuleManager() {
        return this.getDesign().getAppView().getDesignRuleManager(this.relDesign);
    }

    public CheckResultComponent getCheckResultComponent() {
        if (this.checkResultComponent == null) {
            this.checkResultComponent = new CheckResultComponent(this.appView);
        }
        return this.checkResultComponent;
    }

    public DesignRuleManagerTreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new DesignRuleManagerTreeModel(this.getRuleManager());
            this.getRuleManager().addUpdateListener(this.treeModel);
        }
        return this.treeModel;
    }

    public JTree getJTree() {
        if (this.jtree == null) {
            this.jtree = new JTree(this.getTreeModel());
            this.jtree.setRootVisible(true);
            this.jtree.addTreeSelectionListener(new TreeListener());
            this.jtree.setCellRenderer(new DRMCellRenderer());
        }
        return this.jtree;
    }

    public Action createExpandAll() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.ExpandAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int row = 0; row < DesignRuleView.this.getJTree().getRowCount(); ++row) {
                    DesignRuleView.this.getJTree().expandRow(row);
                }
            }
        };
        return action;
    }

    public Action createCollapseAll() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.CollapseAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int row = DesignRuleView.this.getJTree().getRowCount(); row >= 1; --row) {
                    DesignRuleView.this.getJTree().collapseRow(row);
                }
            }
        };
        return action;
    }

    public Action createApplyAllRules() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.ApplyAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignRuleView.this.setCheckResults(DesignRuleView.this.getRuleManager().applyRulesToSubject(), DesignRuleView.this.getRuleManager().res);
            }
        };
        return action;
    }

    public Action closeAction() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.Close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DesignRuleView.this.canClose()) {
                    DesignRuleView.this.close();
                }
            }
        };
        return action;
    }

    public Action createApplySelectedRules() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.ApplySelected")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean res = false;
                List ruleHandlers = DesignRuleView.this.getSelectedRuleHandlers();
                if (ruleHandlers.size() > 0) {
                    ArrayList checkResults = new ArrayList();
                    for (Object obj : ruleHandlers) {
                        if (obj instanceof RuleHandler) {
                            RuleHandler rh = (RuleHandler)obj;
                            rh.hasEvalErr = false;
                            rh.applyRulesToSubject(checkResults);
                            if (!rh.hasEvalErr) continue;
                            res = true;
                            break;
                        }
                        if (!(obj instanceof DesignRule)) continue;
                        DesignRule rule = (DesignRule)obj;
                        RuleHandler rh = rule.getRuleHandler();
                        rh.hasEvalErr = false;
                        rh.applyRule(checkResults, rule);
                        if (!rh.hasEvalErr) continue;
                        res = true;
                        break;
                    }
                    DesignRuleView.this.setCheckResults(checkResults, res);
                }
            }
        };
        action.setEnabled(false);
        return action;
    }

    public Action createApplySelectedRuleSets() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.ApplySelecteRuleSet")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean res = false;
                ArrayList checkResults = new ArrayList();
                int[] selected = DesignRuleView.this.ruleSetsTable.getSelectedRows();
                block0: for (int i = 0; i < selected.length; ++i) {
                    DesignRuleSet current = DesignRuleView.this.ruleSetsContainerList.get(selected[i]);
                    for (DesignRule rule : current.getDesignRules()) {
                        RuleHandler rh = rule.getRuleHandler();
                        rh.hasEvalErr = false;
                        rh.applyRule(checkResults, rule);
                        if (!rh.hasEvalErr) continue;
                        res = true;
                        continue block0;
                    }
                }
                DesignRuleView.this.setCheckResults(checkResults, res);
            }
        };
        action.setEnabled(false);
        return action;
    }

    public Action createApplyAllRuleSets() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.ApplyAllRS")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean res = false;
                ArrayList checkResults = new ArrayList();
                block0: for (DesignRuleSet drs : DesignRuleView.this.ruleSetsContainerList) {
                    for (DesignRule rule : drs.getDesignRules()) {
                        RuleHandler rh = rule.getRuleHandler();
                        rh.hasEvalErr = false;
                        rh.applyRule(checkResults, rule);
                        if (!rh.hasEvalErr) continue;
                        res = true;
                        continue block0;
                    }
                }
                DesignRuleView.this.setCheckResults(checkResults, res);
            }
        };
        action.setEnabled(false);
        return action;
    }

    public void setCheckResults(Collection checkResults, boolean hasExecutionErr) {
        this.getCheckResultComponent().clearCheckResults();
        if (checkResults.size() > 0) {
            this.getCheckResultComponent().add(checkResults.toArray(new CheckResult[0]));
            this.getCheckResultComponent().bnSaveCSV.setEnabled(true);
            this.getCheckResultComponent().bnClearAll.setEnabled(true);
        } else if (!hasExecutionErr) {
            JOptionPane.showMessageDialog(this, Messages.getString("DesignRuleView.CheckDesignOK"));
        }
    }

    public List getSelectedRuleHandlers() {
        ArrayList<Object> result = new ArrayList<Object>();
        TreePath[] paths = this.getJTree().getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object item = paths[i].getLastPathComponent();
                if (!(item instanceof RuleHandler) && !(item instanceof DesignRule)) continue;
                result.add(item);
            }
        }
        return result;
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("DesignRuleView.DesignRules"), false);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.setContentPane(this);
            this.dialog.setSize(800, 800);
            this.dialog.setModal(true);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().add(this.mainPanel);
            this.tpane = new JTabbedPane();
            this.tpane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DesignRuleView.this.showHideButtons();
                }
            });
            this.designRulesPanel = new JPanel();
            this.designRulesPanel.setLayout(new BorderLayout());
            this.designRulesPanel.add((Component)this.tpane, "East");
            this.mainPanel.add((Component)this.designRulesPanel, "Center");
            this.initTreeDesignRules();
            this.initCustomDesignRuleSets();
            this.setDefaultActions(this.dialog);
            Settings.DialogSettings ds = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                this.dialog.setSize(800, 800);
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                this.dialog.setSize(ds.rec.getSize());
                this.dialog.setLocation(ds.rec.getLocation());
            }
        }
        return this.dialog;
    }

    public Window getDialog(Dialog parent) {
        if (this.dialog == null) {
            this.dialog = new JDialog(parent, Messages.getString("DesignRuleView.DesignRules"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.setSize(800, 800);
            this.dialog.setModal(true);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().add(this.mainPanel);
            this.tpane = new JTabbedPane();
            this.tpane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DesignRuleView.this.showHideButtons();
                }
            });
            this.designRulesPanel = new JPanel();
            this.designRulesPanel.setLayout(new BorderLayout());
            this.designRulesPanel.add((Component)this.tpane, "East");
            this.mainPanel.add((Component)this.designRulesPanel, "Center");
            this.initTreeDesignRules();
            this.initCustomDesignRuleSets();
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DesignRuleView.this.close();
                }
            });
            this.setDefaultActions(this.dialog);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public RelationalDesign getRelDesign() {
        return this.relDesign;
    }

    public void setRelDesign(RelationalDesign relDesign) {
        this.relDesign = relDesign;
        this.getRuleManager().setRelDesign(relDesign);
    }

    public void setDataFlowDesign(DataFlowDesign dfd) {
        this.getRuleManager().setDataFlowDesign(dfd);
    }

    private void initCustomDesignRuleSets() {
        this.initRuleSets();
        Iterator<DesignRuleSet> it = settings.getDesignRuleSets().iterator();
        while (it.hasNext()) {
            DesignRuleSet drs = it.next().copy();
            this.ruleSetsContainerList.add(drs);
        }
        this.bnApplyAllRuleSets.setEnabled(this.ruleSetsContainerList.size() > 0);
    }

    private void initRuleSets() {
        JPanel rsPanel = new JPanel(new BorderLayout());
        this.ruleSetsContainerList = new ArrayList<DesignRuleSet>();
        this.ruleSetsTable = new JTable(new RuleSetTableModel());
        TableColumn col0 = this.ruleSetsTable.getColumnModel().getColumn(0);
        col0.setWidth(30);
        col0.setMaxWidth(30);
        JTextField tf = new JTextField();
        TableColumn col1 = this.ruleSetsTable.getColumnModel().getColumn(1);
        col1.setWidth(300);
        col1.setMaxWidth(1000);
        col1.setCellEditor(new TFCellEditor(tf));
        tf.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                DesignRuleView.this.ruleSetsSaved = false;
                DesignRuleView.this.bnSaveRuleSets.setEnabled(true);
            }
        });
        this.ruleSetsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DesignRuleView.this.ruleSetsTable.getSelectedRow() == -1) {
                    DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(false);
                } else {
                    DesignRuleView.this.currentRuleSet = ((RuleSetTableModel)DesignRuleView.this.ruleSetsTable.getModel()).getRuleSetList().get(DesignRuleView.this.ruleSetsTable.getSelectedRow());
                    DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(true);
                }
            }
        });
        this.ruleSetsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DesignRuleView.this.stopCellediting();
                    DesignRuleSetPropertiesDialog dialog = new DesignRuleSetPropertiesDialog(DesignRuleView.this.appView, DesignRuleView.this.currentRuleSet, DesignRuleView.this);
                    dialog.showDialog();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.ruleSetsTable);
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        this.bnSaveRuleSets = new JButton(this.createSaveRuleSets());
        this.bnSaveRuleSets.setToolTipText(Messages.getString("DesignRuleView.SaveRuleSets"));
        this.bnSaveRuleSets.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnSaveRuleSets);
        rsPanel.add((Component)this.createRuleSetToolbarPanel(this.ruleSetsTable), "North");
        rsPanel.add((Component)scrollPane, "Center");
        rsPanel.add((Component)btnPanel, "South");
        this.tpane.addTab(Messages.getString("DesignRuleView.RuleSets"), rsPanel);
    }

    private void initTreeDesignRules() {
        JPanel treePanel = new JPanel(new BorderLayout());
        JPanel treeButtons = new JPanel(new FlowLayout(0));
        JButton expandAll = new JButton(this.createExpandAll());
        expandAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        expandAll.setToolTipText(Messages.getString("DesignRuleView.ExpandAllT"));
        expandAll.setMnemonic(69);
        JButton collapseAll = new JButton(this.createCollapseAll());
        collapseAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        collapseAll.setToolTipText(Messages.getString("DesignRuleView.CollapseAllT"));
        collapseAll.setMnemonic(79);
        treeButtons.add(expandAll);
        treeButtons.add(collapseAll);
        treePanel.add((Component)treeButtons, "North");
        treePanel.add(new JScrollPane(this.getJTree()));
        this.splitPane = new JSplitPane(1, this.tpane, this.getCheckResultComponent());
        this.splitPane.setDividerLocation(350);
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.bnApplyAll = new JButton(this.createApplyAllRules());
        this.bnApplyAll.setToolTipText(Messages.getString("DesignRuleView.ApplyAllDesignRules"));
        this.bnApplyAll.setMnemonic(65);
        this.applySelectedAction = this.createApplySelectedRules();
        this.bnApplySelected = new JButton(this.applySelectedAction);
        this.bnApplySelected.setToolTipText(Messages.getString("DesignRuleView.ApplyTreeSelectedDesignRules"));
        this.bnApplySelected.setMnemonic(83);
        this.bnApplySelectedRuleSets = new JButton(this.createApplySelectedRuleSets());
        this.bnApplySelectedRuleSets.setMnemonic(69);
        this.bnApplySelectedRuleSets.setToolTipText(Messages.getString("DesignRuleView.ApplySelectedRuleSets"));
        this.bnApplyAllRuleSets = new JButton(this.createApplyAllRuleSets());
        this.bnApplyAllRuleSets.setMnemonic(80);
        this.bnApplyAllRuleSets.setToolTipText(Messages.getString("DesignRuleView.ApplyAllRuleSets"));
        JButton bnClose = new JButton(this.closeAction());
        bnClose.setToolTipText(Messages.getString("DesignRuleView.CloseDialog"));
        bnClose.setMnemonic(67);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setToolTipText(Messages.getString("DesignRuleView.Help"));
        bnHelp.setMnemonic(72);
        this.bnApplyAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnApplySelected.setPreferredSize(MessageDialogs.BUTTON_SIZE_200);
        this.bnApplySelectedRuleSets.setPreferredSize(MessageDialogs.BUTTON_SIZE_200);
        this.bnApplyAllRuleSets.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonPanel.add(this.bnApplyAll);
        this.buttonPanel.add(this.bnApplyAllRuleSets);
        this.buttonPanel.add(this.bnApplySelected);
        this.buttonPanel.add(this.bnApplySelectedRuleSets);
        this.buttonPanel.add(bnClose);
        this.buttonPanel.add(bnHelp);
        this.designRulesPanel.add((Component)this.buttonPanel, "South");
        this.designRulesPanel.add((Component)this.splitPane, "Center");
        this.tpane.addTab(Messages.getString("DesignRuleView.DesignRules"), treePanel);
        this.getDesign().getDesignLevelSettings().getNamingStandardRule().clearGlossaries();
    }

    protected JPanel createRuleSetToolbarPanel(JTable jTable) {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        this.btnAddRuleSet = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddRuleSet.setToolTipText(Messages.getString("DesignRuleView.AddRuleSet"));
        this.btnAddRuleSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DesignRuleSet rs = new DesignRuleSet(DesignRuleView.this.generateRuleSetName(), null);
                DesignRuleView.this.ruleSetsContainerList.add(rs);
                DesignRuleView.this.ruleSetsTable.updateUI();
                DesignRuleView.this.ruleSetsTable.getSelectionModel().setSelectionInterval(DesignRuleView.this.ruleSetsTable.getRowCount() - 1, DesignRuleView.this.ruleSetsTable.getRowCount() - 1);
                DesignRuleView.this.currentRuleSet = ((RuleSetTableModel)DesignRuleView.this.ruleSetsTable.getModel()).getRuleSetList().get(DesignRuleView.this.ruleSetsTable.getSelectedRow());
                DesignRuleView.this.bnSaveRuleSets.setEnabled(true);
                DesignRuleView.this.bnApplyAllRuleSets.setEnabled(true);
                DesignRuleView.this.ruleSetsSaved = false;
                DesignRuleView.this.btnRemoveRuleSet.setEnabled(true);
                DesignRuleView.this.btnProperties.setEnabled(true);
            }
        });
        this.btnRemoveRuleSet = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveRuleSet.setToolTipText(Messages.getString("DesignRuleView.RemoveRuleSet"));
        this.btnRemoveRuleSet.setEnabled(false);
        this.btnRemoveRuleSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = DesignRuleView.this.ruleSetsTable.getSelectedRow();
                DesignRuleView.this.ruleSetsContainerList.remove(selected);
                if (DesignRuleView.this.ruleSetsContainerList.size() > 0) {
                    DesignRuleView.this.btnRemoveRuleSet.setEnabled(true);
                    DesignRuleView.this.ruleSetsTable.getSelectionModel().setSelectionInterval(0, 0);
                    DesignRuleView.this.currentRuleSet = ((RuleSetTableModel)DesignRuleView.this.ruleSetsTable.getModel()).getRuleSetList().get(DesignRuleView.this.ruleSetsTable.getSelectedRow());
                    DesignRuleView.this.bnApplyAllRuleSets.setEnabled(true);
                    DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(true);
                } else {
                    DesignRuleView.this.btnRemoveRuleSet.setEnabled(false);
                    DesignRuleView.this.btnProperties.setEnabled(false);
                    DesignRuleView.this.bnApplyAllRuleSets.setEnabled(false);
                    DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(false);
                }
                DesignRuleView.this.bnSaveRuleSets.setEnabled(true);
                DesignRuleView.this.ruleSetsSaved = false;
                DesignRuleView.this.ruleSetsTable.updateUI();
            }
        });
        this.btnProperties = new JButton(this.configuration.getIcon("EDIT_ICON", 16));
        this.btnProperties.setToolTipText(Messages.getString("DesignRuleView.RuleSetProperties"));
        this.btnProperties.setEnabled(false);
        this.btnProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = DesignRuleView.this.ruleSetsTable.getSelectedRow();
                if (row != -1) {
                    DesignRuleView.this.stopCellediting();
                    DesignRuleSetPropertiesDialog dialog = new DesignRuleSetPropertiesDialog(DesignRuleView.this.appView, DesignRuleView.this.currentRuleSet, DesignRuleView.this);
                    dialog.showDialog();
                }
            }
        });
        this.ruleSetsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DesignRuleView.this.ruleSetsTable.getSelectedRow() == -1) {
                    DesignRuleView.this.btnRemoveRuleSet.setEnabled(false);
                    DesignRuleView.this.btnProperties.setEnabled(false);
                } else {
                    DesignRuleView.this.btnRemoveRuleSet.setEnabled(true);
                    DesignRuleView.this.btnProperties.setEnabled(true);
                }
            }
        });
        if (ApplicationView.IS_VIEWER) {
            this.btnAddRuleSet.setEnabled(false);
            this.btnRemoveRuleSet.setEnabled(false);
        }
        toolBar.add(this.btnAddRuleSet);
        toolBar.add(this.btnRemoveRuleSet);
        toolBar.add(this.btnProperties);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        buttonGeneral.add(toolBar);
        return buttonGeneral;
    }

    private void stopCellediting() {
        TableCellEditor cellEditor = this.ruleSetsTable.getCellEditor();
        if (cellEditor != null) {
            this.ruleSetsTable.getCellEditor().stopCellEditing();
        }
    }

    protected String generateRuleSetName() {
        String name = RULESET_NAME;
        int newNumber = 0;
        int lastNumber = this.ruleSetsContainerList.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String ruleSetName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.ruleSetExists(ruleSetName)) {
            newNumber = ++this.cgCounter;
            ruleSetName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return ruleSetName;
    }

    private boolean ruleSetExists(String name) {
        for (int i = 0; i < this.ruleSetsContainerList.size(); ++i) {
            DesignRuleSet ruleSet = this.ruleSetsContainerList.get(i);
            if (!name.equalsIgnoreCase(ruleSet.getName())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<DesignRule> getAllDesignRules() {
        DesignRule dr;
        int n;
        RuleHandler rh;
        int i;
        this.allDesignRules.clear();
        DesignRuleManager drm = this.getRuleManager();
        RuleHandler generalRuleHandler = drm.getGeneralRuleHandler();
        RuleHandler relationalRuleHandler = drm.getRelationalRuleHandler();
        RuleHandler logicalRuleHandler = drm.getLogicalRuleHandler();
        RuleHandler processRuleHandler = drm.getProcessModelRuleHandler();
        for (i = 0; i <= generalRuleHandler.size() - 1; ++i) {
            rh = (RuleHandler)generalRuleHandler.getElement(i);
            for (n = 0; n <= rh.size() - 1; ++n) {
                dr = (DesignRule)rh.getElement(n);
                this.allDesignRules.add(dr);
            }
        }
        if (this.relDesign != null) {
            for (i = 0; i <= relationalRuleHandler.size() - 1; ++i) {
                rh = (RuleHandler)relationalRuleHandler.getElement(i);
                for (n = 0; n <= rh.size() - 1; ++n) {
                    dr = (DesignRule)rh.getElement(n);
                    this.allDesignRules.add(dr);
                }
            }
        }
        for (i = 0; i <= logicalRuleHandler.size() - 1; ++i) {
            rh = (RuleHandler)logicalRuleHandler.getElement(i);
            for (n = 0; n <= rh.size() - 1; ++n) {
                dr = (DesignRule)rh.getElement(n);
                this.allDesignRules.add(dr);
            }
        }
        for (i = 0; i <= processRuleHandler.size() - 1; ++i) {
            rh = (RuleHandler)processRuleHandler.getElement(i);
            for (n = 0; n <= rh.size() - 1; ++n) {
                dr = (DesignRule)rh.getElement(n);
                this.allDesignRules.add(dr);
            }
        }
        return this.allDesignRules;
    }

    private void showHideButtons() {
        if (this.tpane.getSelectedIndex() == 0) {
            this.bnApplySelected.setVisible(true);
            this.bnApplySelectedRuleSets.setVisible(false);
            this.bnApplyAllRuleSets.setVisible(false);
            this.bnApplyAll.setVisible(true);
        } else if (this.tpane.getSelectedIndex() == 1) {
            this.bnApplySelected.setVisible(false);
            this.bnApplySelectedRuleSets.setVisible(true);
            this.bnApplyAllRuleSets.setVisible(true);
            this.bnApplyAll.setVisible(false);
        }
    }

    @Override
    protected boolean canClose() {
        if (!this.ruleSetsSaved) {
            String s1 = Messages.getString("DesignRuleView.Yes");
            String s2 = Messages.getString("DesignRuleView.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("DesignRuleView.RuleSetsNotSaved"), Messages.getString("DesignRuleView.CloseConfirmation"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    public Action createSaveRuleSets() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.Save")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignRuleView.this.stopCellediting();
                settings.getDesignRuleSets().clear();
                settings.getDesignRuleSets().addAll(DesignRuleView.this.ruleSetsContainerList);
                DesignRuleView.this.bnSaveRuleSets.setEnabled(false);
                DesignRuleView.this.ruleSetsSaved = true;
                DesignRuleView.this.appView.saveCustomDRScripts();
            }
        };
        action.setEnabled(false);
        return action;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void nullifyDesignRuleManager() {
        this.getDesign().getAppView().nullifyDesignRuleManager();
    }

    class TFCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 5665190670341352527L;
        private JTextField tf;
        private String val;
        private JTable tab;

        public TFCellEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            tf.addFocusListener(this);
            super.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tf.setText(value.toString());
            this.tf.selectAll();
            this.tf.setBorder(null);
            this.val = this.tf.getText();
            this.tab = table;
            return this.tf;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.tf.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public boolean stopCellEditing() {
            JTextField tf = (JTextField)this.getComponent();
            String newValue = tf.getText().trim();
            if (newValue.length() == 0) {
                JOptionPane.showMessageDialog(DesignRuleView.this, Messages.getString("DesignRuleView.NameEmpty"), Messages.getString("DesignRuleView.DesignRuleView.Warning"), 2);
                tf.setText(this.val);
                tf.setBorder(new LineBorder(Color.black));
                tf.requestFocusInWindow();
                return false;
            }
            TableModel obj = this.tab.getModel();
            for (DesignRuleSet dr : ((RuleSetTableModel)obj).getRuleSetList()) {
                if (!dr.getName().equals(newValue) || newValue.equals(this.val)) continue;
                JOptionPane.showMessageDialog(DesignRuleView.this, Messages.getString("DesignRuleView.NameExists"), Messages.getString("DesignRuleView.DesignRuleView.Warning"), 2);
                tf.setText(this.val);
                tf.setBorder(new LineBorder(Color.black));
                tf.requestFocusInWindow();
                return false;
            }
            return super.stopCellEditing();
        }
    }

    class RuleCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 6102267778062841713L;

        RuleCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DesignRule dr = (DesignRule)value;
            this.setText(dr.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class RuleSetTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2214015596642439352L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("DesignRuleView.DesignRuleView.Name")};

        private RuleSetTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return DesignRuleView.this.ruleSetsContainerList.size();
        }

        public List<DesignRuleSet> getRuleSetList() {
            return DesignRuleView.this.ruleSetsContainerList;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignRuleSet rs = DesignRuleView.this.ruleSetsContainerList.get(row);
            if (col == 0) {
                return row + 1;
            }
            if (col == 1) {
                return rs.getName();
            }
            return row + 1;
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            DesignRuleSet rs = DesignRuleView.this.ruleSetsContainerList.get(rowIndex);
            if (columnIndex == 1) {
                rs.setName(obj.toString());
            }
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DesignRuleView.this.applySelectedAction.setEnabled(e.getPath() != null);
        }
    }
}

