/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.DesignRuleManager;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.designrules.DRTemporary;
import oracle.dbtools.crest.util.GUID;

public class DesignRuleSet {
    private String objectID;
    private String name;
    private ArrayList<DesignRule> designRules = new ArrayList();
    private ArrayList<DRTemporary> designRulesTemporary = new ArrayList();
    private ArrayList designRulesMissing = new ArrayList();

    public DesignRuleSet(String name, String objId) {
        this.name = name;
        this.objectID = objId == null ? new GUID().toString() : objId;
    }

    public DesignRuleSet(String name, String objId, ArrayList<DesignRule> designRules, ArrayList<DRTemporary> designRulesTemporary) {
        this(name, objId);
        this.designRules = designRules;
        this.designRulesTemporary = designRulesTemporary;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addRule(DesignRule designRule) {
        this.getDesignRules().add(designRule);
    }

    public void removeRuleSet(DesignRule designRule) {
        this.designRules.remove(designRule);
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<DesignRule> getDesignRules() {
        return this.designRules;
    }

    public void setDesignRules(ArrayList<DesignRule> desRules) {
        this.designRules = desRules;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    public void addDesignRuleTemporary(DRTemporary dr) {
        if (!this.getDesignRulesTemporary().contains(dr)) {
            this.getDesignRulesTemporary().add(dr);
        }
    }

    public ArrayList<DRTemporary> getDesignRulesTemporary() {
        return this.designRulesTemporary;
    }

    public void setDesignRulesTemporary(ArrayList<DRTemporary> designRulesTemporary) {
        this.designRulesTemporary = designRulesTemporary;
    }

    public DesignRuleSet copy() {
        return new DesignRuleSet(this.name, this.objectID, this.designRules, this.designRulesTemporary);
    }

    public void initDesignRules(ApplicationView appView) {
        this.getDesignRules().clear();
        DesignRuleManager drm = appView.getDesignRuleManager(appView.getCurrentDesign().getFirstOpenRelationalDesign());
        RuleHandler generalRuleHandler = drm.getGeneralRuleHandler();
        RuleHandler relationalRuleHandler = drm.getRelationalRuleHandler();
        RuleHandler logicalRuleHandler = drm.getLogicalRuleHandler();
        RuleHandler processRuleHandler = drm.getProcessModelRuleHandler();
        ArrayList<DRTemporary> drTemporaryDRBasic = this.getDesignRulesTemporary();
        Iterator<DRTemporary> itDRTemporaryDRBasicIterator = drTemporaryDRBasic.iterator();
        DesignRule dr = null;
        boolean found = false;
        while (itDRTemporaryDRBasicIterator.hasNext()) {
            int n;
            RuleHandler rh;
            int i;
            found = false;
            DRTemporary drT = itDRTemporaryDRBasicIterator.next();
            for (i = 0; i <= generalRuleHandler.size() - 1; ++i) {
                rh = (RuleHandler)generalRuleHandler.getElement(i);
                for (n = 0; n <= rh.size() - 1; ++n) {
                    dr = (DesignRule)rh.getElement(n);
                    if (!drT.getRuleId().equals(dr.getRuleId())) continue;
                    this.addRule(dr);
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) continue;
            if (relationalRuleHandler != null) {
                for (i = 0; i <= relationalRuleHandler.size() - 1; ++i) {
                    rh = (RuleHandler)relationalRuleHandler.getElement(i);
                    for (n = 0; n <= rh.size() - 1; ++n) {
                        dr = (DesignRule)rh.getElement(n);
                        if (!drT.getRuleId().equals(dr.getRuleId())) continue;
                        this.addRule(dr);
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (found) continue;
            }
            for (i = 0; i <= logicalRuleHandler.size() - 1; ++i) {
                rh = (RuleHandler)logicalRuleHandler.getElement(i);
                for (n = 0; n <= rh.size() - 1; ++n) {
                    dr = (DesignRule)rh.getElement(n);
                    if (!drT.getRuleId().equals(dr.getRuleId())) continue;
                    this.addRule(dr);
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) continue;
            for (i = 0; i <= processRuleHandler.size() - 1; ++i) {
                rh = (RuleHandler)processRuleHandler.getElement(i);
                for (n = 0; n <= rh.size() - 1; ++n) {
                    dr = (DesignRule)rh.getElement(n);
                    if (!drT.getRuleId().equals(dr.getRuleId())) continue;
                    this.addRule(dr);
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) continue;
            this.designRulesMissing.add(dr);
        }
    }

    public ArrayList getDesignRulesMissing() {
        return this.designRulesMissing;
    }
}

