/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.browser;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.SensitiveTypeSet;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignSet;
import oracle.dbtools.crest.model.design.GlobalKeyObjectSet;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesignSet;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;

public class NavigationTreeDesign
implements ModelObjectSetListener,
TreeModel,
SetListener,
ObjectListener,
ContainerObjectListener,
StorageObjectListener,
RelationalObjectProxySetListener,
DesignListener {
    private Set listeners = new HashSet();
    private ApplicationView appView;
    private JTree tree;

    public NavigationTreeDesign(ApplicationView appView) {
        this.appView = appView;
        this.traverseTreeAndRegisterListener(appView.getDesigns());
    }

    protected void traverseTreeAndRegisterListener(ModelObject node) {
        int num = node.getNumberOfChildren();
        if (node instanceof DesignSet) {
            ((DesignSet)node).addSetListener(this);
        }
        if (node instanceof DesignObjectSet) {
            ((DesignObjectSet)node).addSetListener(this);
        }
        if (node instanceof DesignPart) {
            ((DesignPart)node).addDesignListener(this);
        }
        if (node instanceof ModelObjectSet || node instanceof DesignObjectCollection) {
            ((ModelObjectSet)node).addSetListener(this);
        }
        if (node instanceof DesignObject) {
            ((DesignObject)node).addObjectListener(this);
        }
        if (node instanceof ContainerObject) {
            ((ContainerObject)node).addContainerListener(this);
        }
        if (node instanceof StorageObject) {
            ((StorageObject)node).addObjectListener(this);
        }
        if (node instanceof RelationalObjectProxy) {
            ((RelationalObjectProxy)node).addObjectListener(this);
        }
        if (node instanceof RelationalObjectProxySet) {
            ((RelationalObjectProxySet)node).addSetListener(this);
        }
        if (node instanceof SensitiveTypeSet) {
            ((SensitiveTypeSet)node).addSetListener(this);
        }
        for (int i = 0; i < num; ++i) {
            ModelObject child = node.getChild(i);
            if (child == null) continue;
            this.traverseTreeAndRegisterListener(child);
        }
    }

    protected ModelObject toModelObject(Object object) {
        return (ModelObject)object;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof ModelObject) {
            return this.toModelObject(node).isLeaf();
        }
        return true;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Object getRoot() {
        return this.appView.getDesigns();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object value) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Object getChild(Object node, int index) {
        return this.toModelObject(node).getChildPlain(index);
    }

    @Override
    public int getChildCount(Object node) {
        if (node instanceof ModelObject) {
            return this.toModelObject(node).getNumberOfChildren();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (child instanceof ModelObject) {
            return this.toModelObject(parent).getIndexForChild(this.toModelObject(child));
        }
        return this.toModelObject(parent).getIndexForChild(child);
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (SetEvent.SORT_COLLECTION.equals(event)) {
            return;
        }
        if (!this.isLoading()) {
            if (event.getAffected() != null) {
                if (SetEvent.OBJECT_ADDED.equals(event)) {
                    if (event.getAffected() instanceof DesignPartViewPlaceHolder) {
                        this.traverseTreeAndRegisterListener(event.getAffected());
                    } else {
                        event.getAffected().addObjectListener(this);
                    }
                    if (event.getAffected() instanceof ContainerObject) {
                        this.traverseTreeAndRegisterListener(event.getAffected());
                    }
                    if (event.getAffected() instanceof Dimension || event.getAffected() instanceof Process || event.getAffected() instanceof TransformationPackage) {
                        this.traverseTreeAndRegisterListener(event.getAffected());
                    }
                } else if (SetEvent.OBJECT_REMOVED.equals(event)) {
                    event.getAffected().removeObjectListener(this);
                    if (event.getAffected() instanceof ContainerObject) {
                        ((ContainerObject)event.getAffected()).removeContainerListener(this);
                    }
                } else if (SetEvent.STRUCTURE_CHANGED.equals(event)) {
                    // empty if block
                }
            }
            this.fireStructureChanged(set);
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (set instanceof DesignSet || set instanceof DesignObjectCollection || set instanceof GlobalKeyObjectSet || set instanceof RelationalDesignSet || set instanceof MultidimensionalDesignSet) {
            if (event.isType(1)) {
                this.traverseTreeAndRegisterListener(event.getAffected());
                if (event.childIndex > -1) {
                    this.fireStructureChanged(false, set, event.getAffected(), event.childIndex);
                } else {
                    this.fireStructureChanged(set);
                }
            } else if (event.isType(0)) {
                if (event.getAffected() instanceof DesignObject) {
                    ((DesignObject)event.getAffected()).removeObjectListener(this);
                }
                if (event.childIndex > -1) {
                    this.fireStructureChanged(true, set, event.getAffected(), event.childIndex);
                } else {
                    this.fireStructureChanged(set);
                }
            }
        } else if (event.isType(1)) {
            if (event.getAffected() instanceof RelationalObjectProxy) {
                this.traverseTreeAndRegisterListener(event.getAffected());
            } else if (event.getAffected() instanceof StorageObject) {
                this.traverseTreeAndRegisterListener(event.getAffected());
            }
            if (event.getAffected() instanceof StorageDesign) {
                this.traverseTreeAndRegisterListener(event.getAffected());
            }
            if (event.getAffected() instanceof DataFlowDesign) {
                this.traverseTreeAndRegisterListener(event.getAffected());
            }
            if (event.getAffected() instanceof SensitiveTypeSet) {
                this.traverseTreeAndRegisterListener(event.getAffected());
            }
            if (event.childIndex > -1) {
                this.fireStructureChanged(false, set, event.getAffected(), event.childIndex);
            } else {
                this.fireStructureChanged(set);
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof StorageObject) {
                ((StorageObject)event.getAffected()).removeObjectListener(this);
            }
            if (event.childIndex > -1) {
                this.fireStructureChanged(true, set, event.getAffected(), event.childIndex);
            } else {
                this.fireStructureChanged(set);
            }
        }
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof RelationalObjectProxy) {
                this.traverseTreeAndRegisterListener(event.getAffected());
            } else if (event.getAffected() instanceof StorageObject) {
                this.traverseTreeAndRegisterListener(event.getAffected());
            }
            if (event.childIndex > -1) {
                this.fireStructureChanged(false, set, event.getAffected(), event.childIndex);
            } else {
                this.fireStructureChanged(set);
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof StorageObject) {
                ((StorageObject)event.getAffected()).removeObjectListener(this);
            }
            if (event.getAffected() instanceof RelationalObjectProxy) {
                ((RelationalObjectProxy)event.getAffected()).removeObjectListener(this);
            }
            if (event.childIndex > -1) {
                this.fireStructureChanged(true, set, event.getAffected(), event.childIndex);
            } else {
                this.fireStructureChanged(set);
            }
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (!this.isLoading()) {
            Object parent;
            if (object instanceof Process && event.isType(ObjectChangeEvent.PROCESS_DECOMPOSED)) {
                this.traverseTreeAndRegisterListener(object);
            }
            if (object instanceof TransformationPackage && event.isType(ObjectChangeEvent.TRANSFORMATIONTASK_ADDED)) {
                this.traverseTreeAndRegisterListener(((TransformationPackage)object).getLastTaskAdded());
            }
            this.fireStructureChanged(object);
            if (object instanceof Table) {
                Table tab = (Table)object;
                RelationalDesign phd = (RelationalDesign)tab.getDesignPart();
                this.fireStructureChanged(phd.getFKIndexAssociationSet());
            } else if (object instanceof Entity) {
                Entity tab = (Entity)object;
                LogicalDesign ldes = (LogicalDesign)tab.getDesignPart();
                this.fireStructureChanged(ldes.getGlobalCandidateKeySet());
            } else if (!(object instanceof Relation) && !(object instanceof RelationalDesign.ColumnPlaceHolder) && object instanceof DesignObjectPlaceHolder && event.isType(ObjectChangeEvent.DESIGN_OBJECT_NAME_CHANGED) && (parent = ((DesignObjectPlaceHolder)object).getParent()) != null && parent instanceof DesignObjectCollection) {
                this.fireStructureChanged((DesignObjectCollection)parent);
            }
            if (event.isType(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED) || event.isType(ObjectChangeEvent.ENTITY_IN_RELATION_REMOVED)) {
                this.fireStructureChanged(object);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.NAME_CHANGED)) {
            ModelObject set = object.getObjectSet();
            if (object instanceof RelationalObjectProxy) {
                set = ((RelationalObjectProxy)object).getProxySet();
            }
            if (set != null) {
                this.fireStructureChanged(set);
            }
        }
        this.fireNodeChanged(object);
    }

    @Override
    public void changed(ContainerObject container, ContainerObjectEvent event) {
        if (!this.isLoading()) {
            if (event.isType(0)) {
                event.getElement().addObjectListener(this);
            } else if (event.isType(1)) {
                event.getElement().removeObjectListener(this);
            }
            this.fireStructureChanged(container);
        }
    }

    protected void fireStructureChanged(ModelObject object) {
        if (this.canUpdateTree()) {
            boolean temp = false;
            if (this.tree != null) {
                temp = this.tree.isEditable();
                this.tree.setEditable(false);
            }
            if (object.hasAlternatePaths()) {
                Object[][] altPaths = object.getAlternatePaths();
                for (int i = 0; i < altPaths.length; ++i) {
                    this.fireStructureChanged(object, altPaths[i]);
                }
            } else if (object instanceof DesignSet || object.getParent() != null) {
                this.fireStructureChanged(object, object.getPath());
            }
            if (this.tree != null) {
                this.tree.setEditable(temp);
            }
        }
    }

    protected void fireStructureChanged(boolean removed, ModelObject set, ModelObject object, int childPosition) {
        if (this.canUpdateTree()) {
            boolean temp = false;
            if (this.tree != null) {
                temp = this.tree.isEditable();
                this.tree.setEditable(false);
            }
            Object[] objarray = new Object[]{object};
            int[] posarray = new int[]{childPosition};
            if (set.hasAlternatePaths()) {
                Object[][] altPaths = set.getAlternatePaths();
                for (int i = 0; i < altPaths.length; ++i) {
                    this.fireStructureChanged(removed, altPaths[i], posarray, objarray);
                }
            } else {
                this.fireStructureChanged(removed, set.getPath(), posarray, objarray);
            }
            if (this.tree != null) {
                this.tree.setEditable(temp);
            }
        }
    }

    public void updateSubtree(ModelObject object) {
        this.traverseTreeAndRegisterListener(object);
        this.fireStructureChanged(object);
    }

    public void clear() {
        this.fireStructureChanged(this.appView.getDesigns(), this.appView.getDesigns().getPath());
        this.traverseTreeAndRegisterListener(this.appView.getDesigns());
    }

    protected void fireStructureChanged(ModelObject object, Object[] path) {
        if (this.canUpdateTree()) {
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(new TreeModelEvent((Object)this, path));
            }
        }
    }

    protected void fireStructureChanged(boolean removed, Object[] path, int[] positions, Object[] children) {
        if (this.canUpdateTree()) {
            for (TreeModelListener listener : this.listeners) {
                if (removed) {
                    listener.treeNodesRemoved(new TreeModelEvent((Object)this, path, positions, children));
                    continue;
                }
                listener.treeNodesInserted(new TreeModelEvent((Object)this, path, positions, children));
            }
        }
    }

    protected void fireNodeChanged(ModelObject object) {
        if (this.canUpdateTree()) {
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesChanged(new TreeModelEvent((Object)this, object.getPath()));
            }
        }
    }

    public void updateDesignName(TreePath path) {
        if (this.canUpdateTree()) {
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesChanged(new TreeModelEvent((Object)this, path));
            }
        }
    }

    public boolean isLoading() {
        return ApplicationView.loading;
    }

    public boolean isImporting() {
        return ApplicationView.importing;
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }

    private boolean canUpdateTree() {
        Design design = this.appView.getCurrentDesign();
        return !design.isClosing() && (!this.isLoading() || design.isMerging()) && !design.isDisableTreeUpdate();
    }

    @Override
    public void designChanged(DesignEvent event) {
        if (event.isType(DesignEvent.DESIGNPART_NAME_CHANGED) && event.getDesignPart() != null) {
            this.fireNodeChanged(event.getDesignPart());
        }
    }
}

