/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.storage;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.storage.GenericWXMLStorageObject;
import oracle.dbtools.crest.model.persistence.xml.storage.StoragePathTranslator;
import oracle.dbtools.crest.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractWXMLStorageDesign
extends AbstractXMLWriter {
    private GenericWXMLStorageObject first = null;
    private static final Logger LOGGER = new Logger(AbstractWXMLStorageDesign.class);

    public AbstractWXMLStorageDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
        this.first = new GenericWXMLStorageObject(persistenceMgr);
    }

    public void insert(GenericWXMLStorageObject writer) {
        writer.setSuccessor(this.first);
        this.first = writer;
        writer.setStorageDesignWriter(this);
    }

    @Override
    public Document writeDocument(Object object) {
        if (this.isStorageDesign(object)) {
            StorageDesign storageDesign = (StorageDesign)object;
            Document doc = this.createDocument();
            Element docElement = doc.getDocumentElement();
            this.writeStorageDesign(doc, docElement, storageDesign);
            storageDesign.setDirty(false);
            return doc;
        }
        if (this.isStorageObject(object)) {
            AbstractXMLWriter storageObjectWriter = this.first.getWriterFor(object);
            if (storageObjectWriter != null) {
                Document result = storageObjectWriter.writeDocument(object);
                return result;
            }
            LOGGER.error("writeDocument(Object): can not find appropriate delegate");
            Document noDoc = this.createDocument();
            Element docElement = noDoc.getDocumentElement();
            this.appendComment(docElement, new StringBuffer("could not find XML handler for: ").append(object).append(" id: ").append(((ModelIDObject)object).getObjectID()).toString());
            return noDoc;
        }
        return null;
    }

    public AbstractXMLWriter getWriterFromChain(StorageObject object) {
        if (this.first != null) {
            this.first.getWriterFor(object);
        }
        return null;
    }

    public void writeStorageDesign(Document doc, Element root, StorageDesign storageDesign) {
        if (storageDesign.getRepositoryOID() != null) {
            root.setAttribute("rep_oid", storageDesign.getRepositoryOID());
        }
        if (storageDesign.getRepositoryOVID() != null) {
            root.setAttribute("rep_ovid", storageDesign.getRepositoryOVID());
        }
        root.setAttribute("stdes_version", String.valueOf(storageDesign.getVersion()));
        this.writeStorageDesign(root, storageDesign);
    }

    public abstract void writeStorageDesign(Element var1, StorageDesign var2);

    @Override
    public String getFilenameFor(Object object) {
        return ((StorageDesign)object).getFileName();
    }

    @Override
    public String getRelativePath() {
        throw new RuntimeException("StorageDesigns need a variable path");
    }

    @Override
    public String getRelativePath(Object object) {
        String result = StoragePathTranslator.getPathBuffer((StorageDesign)object).toString();
        return result;
    }

    @Override
    public boolean canWrite(Object object) {
        return this.isCorrectRDBMSType(object);
    }

    public boolean isCorrectRDBMSType(Object object) {
        if (this.isStorageObject(object)) {
            return this.getRDBMSType().equals(((StorageObject)object).getRDBMSType());
        }
        if (this.isStorageDesign(object)) {
            return this.getRDBMSType().equals(((StorageDesign)object).getRDBMSType());
        }
        return false;
    }

    public abstract RDBMSType getRDBMSType();

    public boolean isStorageObjectOrDesign(Object object) {
        return this.isStorageObject(object) || this.isStorageDesign(object);
    }

    public boolean isStorageDesign(Object object) {
        return object instanceof StorageDesign;
    }

    public boolean isStorageObject(Object object) {
        return object instanceof StorageObject;
    }

    @Override
    public AbstractXMLWriter getWriterFor(Object object) {
        if (this.isStorageObject(object)) {
            return this.first.getWriterFor(object);
        }
        if (this.isStorageDesign(object) && this.isCorrectRDBMSType(object)) {
            return this;
        }
        return super.getWriterFor(object);
    }

    protected void writeStorageObjectSet(Element parent, RelationalObjectProxySet set) {
        StringBuffer buffer = new StringBuffer("Specific properties for physical objects of type: ");
        buffer.append(set.getLongName());
        this.appendComment(parent, buffer.toString(), 1);
        this.writeStorageObjectSet(parent, set.getObjectCollection().iterator(), set.getStorageDesign());
    }

    protected void writeStorageObjectSet(Element parent, StorageObjectSet set) {
        StringBuffer buffer = new StringBuffer("RDBMS objects of type: ");
        buffer.append(set);
        this.appendComment(parent, buffer.toString(), 2);
        this.writeStorageObjectSet(parent, set.iterator(), set.getStorageDesign());
    }

    protected void writeStorageObjectSet(Element parent, Iterator it, StorageDesign storageDesign) {
        boolean exp;
        Design design = storageDesign.getDesign();
        boolean bl = exp = storageDesign.getDesign().getCurrentOperation() == 5;
        while (it.hasNext()) {
            StorageObject object = (StorageObject)it.next();
            boolean contains = object.belongsTo(storageDesign);
            AbstractXMLWriter delegate = this.getWriterFor(object);
            if (delegate == null || !contains || object.isNullInstance()) continue;
            String id = object.getObjectID();
            Element objElm = this.createElement(parent, "object");
            objElm.setAttribute("oid", id);
            objElm.setAttribute("type", object.getObjectTypeName());
            objElm.setAttribute("role", contains ? OBJECT_CONTAINS : OBJECT_USES);
            objElm.setAttribute("marked_generate", String.valueOf(object.isMarkedGenerate()));
            if (this.getPersistenceManager().isXML_FromDataBase()) continue;
            if (exp) {
                if (object instanceof RelationalObjectProxy) {
                    if (!design.shouldExport((RelationalObjectProxy)object)) continue;
                    delegate.write(object);
                    continue;
                }
                delegate.write(object);
                continue;
            }
            boolean result = delegate.write(object);
            if (!result) continue;
            object.setPersisted(true);
        }
    }
}

