/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLHierarchy
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLHierarchy(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getHierarchySet().createHierarchy(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        String aID;
        int i;
        Hierarchy hierarchy = (Hierarchy)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        hierarchy.setDescription((String)map.get("description"));
        String defHier = (String)map.get("default_hierarchy");
        if (defHier != null) {
            hierarchy.setDefaultHierarchy(Boolean.valueOf(defHier));
        }
        String linkToDimId = (String)map.get("link_to_dimension");
        Link linkDim = (Link)hierarchy.getDesign().getMultidimensionalDesign().getLinkSet().getObjectByID(linkToDimId);
        hierarchy.setLinkToDimension(linkDim);
        if (linkDim != null && linkDim.getSourceMDObject() != null) {
            ((Dimension)linkDim.getSourceMDObject()).addHierarchy(hierarchy);
        }
        Map objMap = this.getProperties(objInfo, "levels");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            Level level = (Level)hierarchy.getDesign().getMultidimensionalDesign().getLevelSet().getObjectByID(aID);
            if (level == null) continue;
            hierarchy.addLevel(level);
        }
        objMap = this.getProperties(objInfo, "links");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            RollupLink link = (RollupLink)hierarchy.getDesign().getMultidimensionalDesign().getRollupLinkSet().getObjectByID(aID);
            if (link == null) continue;
            hierarchy.addLink(link);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(hierarchy.getObjectID())).append(".dmd");
        hierarchy.setFilePath(buffer.toString());
        return hierarchy;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("hierarchyPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Hierarchy.class;
    }
}

