/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.WXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypesSubView;
import oracle.dbtools.crest.swingui.datatypes.TVDTRelation;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLDataTypesDesign
extends AbstractXMLWriter {
    private DataTypesDesign design = null;
    private static float NFS = 2.4f;
    private float version = NFS;

    public WXMLDataTypesDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof DataTypesDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (DataTypesDesign)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            this.version = this.design.getDesign().getVersion();
            Document doc = this.createDocument("design");
            Element designElm = doc.getDocumentElement();
            designElm.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            Element referenced = doc.createElement("ref");
            designElm.appendChild(referenced);
            Element vRelations = null;
            Element dtSubViews = null;
            if (this.version < NFS) {
                vRelations = doc.createElement("view_relations");
                designElm.appendChild(vRelations);
                dtSubViews = doc.createElement("datatype_sub_views_collection");
                designElm.appendChild(dtSubViews);
            }
            Collection all = this.design.getStorableDesignObjects();
            Iterator it = all.iterator();
            DesignObject designObject = null;
            while (it.hasNext()) {
                designObject = (DesignObject)it.next();
                this.handleDesignObject(referenced, designObject);
            }
            if (this.version < NFS) {
                this.handleRelations(this.design, vRelations);
                this.appendSubordinateDisplays(designElm, this.design.getMainView());
                this.handleDTSubView(this.design, dtSubViews);
                this.appendDiagramViews(doc, designElm, this.design);
            } else {
                WXMLSubview svWriter = this.getPersistenceManager().getDesignPartViewWriter();
                svWriter.appendExtSubViews(designElm, this.design);
            }
            this.appendDocumentsInfo(doc, designElm, this.design);
            this.appendPartiesInfo(doc, designElm, this.design);
            this.design.setDirty(false);
            return doc;
        }
        return null;
    }

    private void appendDocumentsInfo(Document doc, Element designElm, DataTypesDesign design) {
        this.appendObjects(designElm, design.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document doc, Element docElement, DataTypesDesign design) {
        this.appendObjects(docElement, design.getResponsibleParties().toArray(), "parties");
    }

    protected void appendObjects(Element objectInfoNode, Object[] objects, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < objects.length; ++i) {
            DesignObject desObj = (DesignObject)objects[i];
            map.put(String.valueOf(i + 1), StringUtilities.encodeAttributeValue(desObj.getObjectID()));
        }
        this.appendProperties(objectInfoNode, id, map);
    }

    @Override
    protected void appendProperties(Element objectInfoNode, String id, Map map) {
        Element propertiesList = objectInfoNode.getOwnerDocument().createElement(id);
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = (String)map.get(key);
            if (key.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element param = objectInfoNode.getOwnerDocument().createElement("parameter");
            propertiesList.appendChild(param);
            this.appendProperty(param, key, value);
        }
        objectInfoNode.appendChild(propertiesList);
    }

    private void handleDesignObject(Element referenced, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            if (this.getPersistenceManager().isCheckDirty()) {
                if (designObject.isDirty()) {
                    this.getPersistenceManager().write(designObject);
                }
            } else {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(referenced, designObject);
    }

    private void appendReferencedObjectElement(Element parentNode, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document doc = parentNode.getOwnerDocument();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", designObject.belongsToDesign() ? OBJECT_CONTAINS : OBJECT_USES);
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        if (this.version < NFS && (designObject instanceof StructuredType || designObject instanceof Note)) {
            this.appendGraphicalInfo(objInfo, designObject);
        }
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, DesignObject designObject) {
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(designObject);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    public void handleRelations(DataTypesDesign dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            DTRelation rel;
            Iterator it = dsn.getDTInheritanceSet().iterator();
            while (it.hasNext()) {
                rel = (DTInheritance)it.next();
                this.appendRelationObjectElement(dsn, designElm, rel);
            }
            it = dsn.getDTReferenceSet().iterator();
            while (it.hasNext()) {
                rel = (DTReference)it.next();
                this.appendRelationObjectElement(dsn, designElm, rel);
            }
        }
    }

    private void appendRelationObjectElement(DataTypesDesign dsn, Element parentNode, DTRelation rel) {
        AbstractDTObject adto;
        Document doc = parentNode.getOwnerDocument();
        TVDTRelation tv = (TVDTRelation)rel.getTopView();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(rel.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(rel.getObjectID()));
        if (rel instanceof DTReference) {
            objInfo.setAttribute("stelement", StringUtilities.encodeAttributeValue(((DTReference)rel).getTypeElement().getObjectID()));
        }
        objInfo.setAttribute("viewid_source", (adto = rel.getSourceDTObject()) != null ? StringUtilities.encodeAttributeValue(adto.getObjectID()) : NULL_STR);
        objInfo.setAttribute("viewid_target", adto != null ? StringUtilities.encodeAttributeValue(adto.getObjectID()) : NULL_STR);
        Element points = doc.createElement("points");
        if (tv != null && tv.getCellView() != null) {
            EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
            List edgePoints = acv.getPoints();
            for (int i = 0; i < edgePoints.size(); ++i) {
                Object obj = edgePoints.get(i);
                Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                if (p == null) continue;
                Element point = doc.createElement("point");
                point.setAttribute("x_coordinate", Double.toString(p.getX()));
                point.setAttribute("y_coordinate", Double.toString(p.getY()));
                points.appendChild(point);
            }
        }
        objInfo.appendChild(points);
        if (tv != null) {
            EdgeView edgeView = (EdgeView)tv.getCellView();
            if (edgeView != null) {
                Element labels = doc.createElement("labels");
                Element lbl = doc.createElement("main_label");
                labels.appendChild(lbl);
                objInfo.appendChild(labels);
            }
            Element graphycal = doc.createElement("graphical");
            Element param = objInfo.getOwnerDocument().createElement("parameter");
            graphycal.appendChild(param);
            param.setAttribute("name", "use_default_color");
            param.setAttribute("value", Boolean.toString(tv.useDefaultColor()));
            if (!tv.useDefaultColor()) {
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "color");
                param.setAttribute("value", tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : NULL_STR);
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "width");
                param.setAttribute("value", Integer.toString(tv.getLineWidth()));
            }
            objInfo.appendChild(graphycal);
        }
        parentNode.appendChild(objInfo);
    }

    @Override
    public String getFilenameFor(Object object) {
        DataTypesDesign dsn = (DataTypesDesign)object;
        return dsn.getName();
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String designName = this.design.getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append('/').append(designName).append('/').append("datatypes");
            return buffer.toString();
        }
        return "datatypes";
    }

    public void handleDTSubView(DataTypesDesign dtd, Element logSubViews) {
        if (dtd.getAppView() != null) {
            Document doc = logSubViews.getOwnerDocument();
            SubViewObjectSet col = dtd.getDataTypesDesignSubViews();
            Iterator itsv = col.iterator();
            while (itsv.hasNext()) {
                DesignPartViewPlaceHolder dpvPH = (DesignPartViewPlaceHolder)itsv.next();
                DPVDataTypesSubView dpv = (DPVDataTypesSubView)dpvPH.getDesignPartView();
                Element dtSubView = doc.createElement("datatype_sub_view");
                dtSubView.setAttribute("subview_name", StringUtilities.encodeAttributeValue(dpv.getName()));
                dtSubView.setAttribute("id", dpv.getDPVId());
                dtSubView.setAttribute("generator", dpv.getGeneratorId());
                dtSubView.setAttribute("visible", dpvPH.getVisible() ? "true" : "false");
                dtSubView.setAttribute("comment", StringUtilities.encodeAttributeValue(dpvPH.getComment()));
                dtSubView.setAttribute("notes", StringUtilities.encodeAttributeValue(dpvPH.getNotes()));
                logSubViews.appendChild(dtSubView);
                this.addStructuredTypesInDPV(dtd, dtSubView, dpv);
                this.addNotesInDPV(dtd, dtSubView, dpv);
                Iterator itrel = dtd.getDTReferenceSet().iterator();
                while (itrel.hasNext()) {
                    DTReference ref = (DTReference)itrel.next();
                    this.appendSubViewInfoRelation(dtSubView, dpv, ref);
                }
                itrel = dtd.getDTInheritanceSet().iterator();
                while (itrel.hasNext()) {
                    DTInheritance inheritance = (DTInheritance)itrel.next();
                    this.appendSubViewInfoRelation(dtSubView, dpv, inheritance);
                }
                this.appendSubordinateDisplays(dtSubView, dpv);
            }
        }
    }

    private void appendSubViewInfoRelation(Element parentNode, DesignPartView dpv, DTRelation rel) {
        block7: {
            try {
                Document doc = parentNode.getOwnerDocument();
                TVDTRelation tv = (TVDTRelation)rel.getViewFor(dpv);
                if (tv == null || rel.getSourceTV(dpv) == null || rel.getTargetTV(dpv) == null) break block7;
                Element objInfo = doc.createElement("objectid");
                objInfo.setAttribute("role", "represents");
                objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(rel.getObjectTypeName()));
                objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(rel.getObjectID()));
                objInfo.setAttribute("viewid_source", rel.getSourceTV(dpv) != null ? rel.getSourceTV(dpv).getViewID() : NULL_STR);
                objInfo.setAttribute("viewid_target", rel.getTargetTV(dpv) != null ? rel.getTargetTV(dpv).getViewID() : NULL_STR);
                Element points = doc.createElement("points");
                if (tv != null) {
                    if (tv.getCellView() != null) {
                        List edgePoints = ((EdgeView)tv.getCellView()).getPoints();
                        for (int i = 0; i < edgePoints.size(); ++i) {
                            Object obj = edgePoints.get(i);
                            Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                            if (p == null) continue;
                            Element point = doc.createElement("point");
                            point.setAttribute("x_coordinate", Double.toString(p.getX()));
                            point.setAttribute("y_coordinate", Double.toString(p.getY()));
                            points.appendChild(point);
                        }
                    } else {
                        List edgePoints = tv.getEdgePoints();
                        for (int i = 0; i < edgePoints.size(); ++i) {
                            Object obj = edgePoints.get(i);
                            Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                            if (p == null) continue;
                            Element point = doc.createElement("point");
                            point.setAttribute("x_coordinate", Double.toString(p.getX()));
                            point.setAttribute("y_coordinate", Double.toString(p.getY()));
                            points.appendChild(point);
                        }
                    }
                }
                objInfo.appendChild(points);
                parentNode.appendChild(objInfo);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void addStructuredTypesInDPV(DataTypesDesign dsn, Element dtSubView, DPVDataTypesSubView dpv) {
        Iterator it = dsn.getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            for (TopView tv : st.getViewsForDPV(dpv)) {
                this.appendReferencedObjectReprElement(dtSubView, tv);
            }
        }
    }

    private void addNotesInDPV(DataTypesDesign dsn, Element logSubView, DPVDataTypesSubView dpv) {
        Iterator it = dsn.getNoteSet().iterator();
        while (it.hasNext()) {
            Note note = (Note)it.next();
            TopView tv = note.getFirstViewForDPV(dpv);
            if (tv == null) continue;
            this.appendReferencedObjectReprElement(logSubView, tv);
        }
    }

    private void appendReferencedObjectReprElement(Element parentNode, TopView tv) {
        Document doc = parentNode.getOwnerDocument();
        DesignObject designObject = tv.getModel();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        objInfo.setAttribute("viewid", StringUtilities.encodeAttributeValue(tv.getViewID()));
        objInfo.setAttribute("tv_generator_id", StringUtilities.encodeAttributeValue(tv.getGeneratorID()));
        this.appendGraphicalInfo(objInfo, tv);
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, TopView tv) {
        DesignObject designObject = tv.getModel();
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(tv);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }
}

