/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLModelIDObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractWXMLDesignObject
extends AbstractWXMLModelIDObject {
    public AbstractWXMLDesignObject(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public Document writeDocument(Object object) {
        DesignObject desObject = (DesignObject)object;
        if (object instanceof ModelObject) {
            ApplicationView.log(MessageFormat.format(Messages.getString("AbstractWXMLDesignObject.Writing"), ((ModelObject)object).getName()));
        }
        Document doc = this.createDocument();
        Element docElement = doc.getDocumentElement();
        Element objectElement = this.appendDesignObjectInfo(doc, docElement, desObject);
        this.appendDocumentsInfo(doc, objectElement, desObject);
        this.appendPartiesInfo(doc, objectElement, desObject);
        this.appendChangeRequestsInfo(doc, objectElement, desObject);
        List measurements = desObject.getMeasurements();
        Element mElm = doc.createElement("measurements");
        objectElement.appendChild(mElm);
        for (int i = 0; i < measurements.size(); ++i) {
            this.appendMeasurementInfo(doc, mElm, (Measurement)measurements.get(i));
        }
        if (desObject instanceof ContainerObject) {
            ContainedObject[] elements = ((ContainerObject)desObject).getElements();
            Element contElm = doc.createElement("contained");
            objectElement.appendChild(contElm);
            for (int i = 0; i < elements.length; ++i) {
                this.appendContainedObjectInfo(doc, contElm, elements[i]);
            }
            if (desObject instanceof ContainerWithKeyObject) {
                Element keyNode = doc.createElement("key");
                objectElement.appendChild(keyNode);
                KeyObject[] keys = ((ContainerWithKeyObject)desObject).getKeys();
                for (int i = 0; i < keys.length; ++i) {
                    this.appendKeyObjectInfo(doc, keyNode, keys[i]);
                }
            }
        }
        this.appendContainedElements(doc, docElement, desObject);
        return doc;
    }

    private void appendChangeRequestsInfo(Document doc, Element docElement, DesignObject desObject) {
        this.appendObjects(docElement, desObject.getRequests().toArray(), "changerequests");
    }

    private void appendDocumentsInfo(Document doc, Element docElement, DesignObject desObject) {
        this.appendObjects(docElement, desObject.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document doc, Element docElement, DesignObject desObject) {
        this.appendObjects(docElement, desObject.getResponsibleParties().toArray(), "parties");
    }

    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
    }

    protected void appendContainedElements(Document doc, Element parentNode, DesignObject object) {
    }

    protected Element appendDesignObjectInfo(Document doc, Element parentNode, DesignObject object) {
        return this.appendDesignObjectInfo(doc, parentNode, object, object.getObjectTypeName());
    }

    protected Element appendDesignObjectInfo(Document doc, Element parentNode, DesignObject object, String objectTypeName) {
        Element objInfo = this.appendObjectInfo(doc, parentNode, object, objectTypeName);
        TopView tv = object.getFirstViewForDPV(object.getDesignPart().getMainView());
        boolean visibleInMainview = tv != null && tv.getCellView() != null;
        objInfo.setAttribute("visible_in_main_view", String.valueOf(visibleInMainview));
        if (object.getImportedId() != null && !"".equalsIgnoreCase(object.getImportedId())) {
            objInfo.setAttribute("imported_id", object.getImportedId());
        }
        this.appendDesignObjectInfo(objInfo, object);
        this.appendDesignObjectColor(objInfo, object);
        this.appendOracleNames(objInfo, object);
        if (!(object instanceof Arc)) {
            Element engineerElm = this.createElement(objInfo, "engineering");
            if (object.getDesignPart() instanceof LogicalDesign) {
                Map map = object.getEngineerTo();
                Object[] keys = map.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    String key = (String)keys[i];
                    Object value = map.get(key);
                    Element elm = this.createElement(engineerElm, "relational_design");
                    elm.setAttribute("id", key);
                    elm.setAttribute("should", String.valueOf(value));
                }
            } else {
                engineerElm.setAttribute("should", object.getShouldEngineer() ? VALUE_TRUE : VALUE_FALSE);
            }
        }
        Element versionElm = this.createElement(objInfo, "des_obj_version");
        versionElm.setAttribute("version", String.valueOf(object.getVersion()));
        this.appendDesignObjectFonts(objInfo, object);
        return objInfo;
    }

    private void appendOracleNames(Element parentNode, DesignObject object) {
        if (object instanceof AbstractMDObject) {
            AbstractMDObject mdo = (AbstractMDObject)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("oracle_short_name", mdo.getOracleShortName());
            map.put("oracle_long_name", mdo.getOracleLongName());
            map.put("oracle_plural_name", mdo.getOraclePluralName());
            map.put("name_in_oracle_aw", mdo.getNameInOracleAW());
            this.appendProperties(parentNode, "oracle_names", map);
        }
    }

    protected final Element appendContainedObjectInfo(Document doc, Element containerNode, ContainedObject object) {
        ContainedObject delegate;
        String synonym;
        Element elementNode = this.appendDesignObjectInfo(doc, containerNode, object);
        containerNode.appendChild(elementNode);
        elementNode.setAttribute("unique", String.valueOf(object.isUnique()));
        elementNode.setAttribute("allownull", String.valueOf(object.getNullsAllowed()));
        String constraintName = object.getConstraintName();
        if (constraintName != null && !"".equalsIgnoreCase(constraintName)) {
            elementNode.setAttribute("constraint_name", StringUtilities.encodeAttributeValue(constraintName));
        }
        elementNode.setAttribute("usedomainconstraints", String.valueOf(object.getUseDomainConstraints()));
        elementNode.setAttribute("is_oid", String.valueOf(object.isOid()));
        elementNode.setAttribute("structured_attribute_id", String.valueOf(object.getStructAttributeID()));
        if (!object.getUseDomainConstraints()) {
            this.appendConstraint(elementNode, object.getCheck());
            this.appendConstraint(elementNode, object.getValueList());
            this.appendAVT(elementNode, object);
        }
        if ((synonym = object.getSynonym()) != null && !"".equalsIgnoreCase(synonym)) {
            elementNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(String.valueOf(object.getSynonym())));
        }
        elementNode.setAttribute("fk", String.valueOf(object.isFKElement()));
        if (object.isFKElement() && (delegate = object.getDelegateElement()) != null) {
            elementNode.setAttribute("references", delegate.getObjectID());
        }
        if (object instanceof ContainedObjectWithDomain) {
            this.appendContainedObjectWithDomainInfo(doc, elementNode, (ContainedObjectWithDomain)object);
        }
        this.appendContainedObjectInfo(elementNode, object);
        this.appendDocumentsInfo(doc, elementNode, object);
        this.appendPartiesInfo(doc, elementNode, object);
        this.appendChangeRequestsInfo(doc, elementNode, object);
        List measurements = object.getMeasurements();
        Element mElm = doc.createElement("measurements");
        elementNode.appendChild(mElm);
        for (int i = 0; i < measurements.size(); ++i) {
            this.appendMeasurementInfo(doc, mElm, (Measurement)measurements.get(i));
        }
        return elementNode;
    }

    private Element appendMeasurementInfo(Document doc, Element objectNode, Measurement m) {
        Element elementNode = this.appendDesignObjectInfo(doc, objectNode, m);
        objectNode.appendChild(elementNode);
        Element child = doc.createElement("value");
        Text content = doc.createTextNode("" + m.getValue());
        child.appendChild(content);
        elementNode.appendChild(child);
        child = doc.createElement("unit");
        content = doc.createTextNode(m.getUnit());
        child.appendChild(content);
        elementNode.appendChild(child);
        child = doc.createElement("sort");
        content = doc.createTextNode(m.getType());
        child.appendChild(content);
        elementNode.appendChild(child);
        child = doc.createElement("creationTime");
        content = doc.createTextNode(m.getCreationDate());
        child.appendChild(content);
        elementNode.appendChild(child);
        child = doc.createElement("effectiveTime");
        content = doc.createTextNode(m.getEffectiveDate());
        child.appendChild(content);
        elementNode.appendChild(child);
        return elementNode;
    }

    protected void appendConstraint(Element parent, Constraint constraint) {
        if (constraint != null) {
            Element constraintElm = this.createElement(parent, "constraint");
            constraintElm.setAttribute("type", constraint.getType());
            this.appendConstraintInfo(constraintElm, constraint);
            if (constraint instanceof ConstraintEnumeration) {
                this.appendConstraintEnumeration(constraintElm, (ConstraintEnumeration)constraint);
            }
        }
    }

    private void appendConstraintEnumeration(Element parent, ConstraintEnumeration object) {
        Element propertiesList = parent.getOwnerDocument().createElement("properties");
        Iterator it = object.getPropertyNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = object.getProperty(key);
            if (key.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element param = parent.getOwnerDocument().createElement("parameter");
            propertiesList.appendChild(param);
            this.appendProperty(param, key, value);
            String description = "";
            if (object.getValuesDescriptionMap().containsKey(value)) {
                description = (String)object.getValuesDescriptionMap().get(value);
            }
            param.setAttribute("desc", AbstractWXMLDesignObject.encodeAttributeValue(description));
        }
        parent.appendChild(propertiesList);
    }

    protected void appendConstraintInfo(Element constraintElm, Constraint constraint) {
    }

    protected void appendAVT(Element parent, ContainedObject object) {
        parent.setAttribute("avt_sort_order", String.valueOf(object.getAVTSortOrder()));
        Set avts = object.getAVTs();
        Iterator it = avts.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                AVT avt = (AVT)it.next();
                Element constraintElm = this.createElement(parent, "avt");
                Element child = constraintElm.getOwnerDocument().createElement("beginvalue");
                Text content = constraintElm.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(avt.getBeginValue()));
                child.appendChild(content);
                constraintElm.appendChild(child);
                child = constraintElm.getOwnerDocument().createElement("endvalue");
                content = constraintElm.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(avt.getEndValue()));
                child.appendChild(content);
                constraintElm.appendChild(child);
                child = constraintElm.getOwnerDocument().createElement("description");
                content = constraintElm.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(avt.getDescription()));
                child.appendChild(content);
                constraintElm.appendChild(child);
            }
        } else {
            Element constraintElm = this.createElement(parent, "avt");
            Element child = constraintElm.getOwnerDocument().createElement("beginvalue");
            Text content = constraintElm.getOwnerDocument().createTextNode("");
            child.appendChild(content);
            constraintElm.appendChild(child);
            child = constraintElm.getOwnerDocument().createElement("endvalue");
            content = constraintElm.getOwnerDocument().createTextNode("");
            child.appendChild(content);
            constraintElm.appendChild(child);
            child = constraintElm.getOwnerDocument().createElement("description");
            content = constraintElm.getOwnerDocument().createTextNode("");
            child.appendChild(content);
            constraintElm.appendChild(child);
        }
    }

    protected void appendContainedObjectInfo(Element parentNode, ContainedObject object) {
    }

    protected final void appendContainedObjectWithDomainInfo(Document doc, Element containedNode, ContainedObjectWithDomain object) {
        Domain domain = object.getDomain();
        if (domain != null) {
            Element domainElm = doc.createElement("domain");
            domainElm.setAttribute("oid", domain.getObjectID());
            domainElm.setAttribute("file", domain.getFileName());
            this.appendContainedObjectWithDomainInfo(containedNode, object);
            containedNode.appendChild(domainElm);
        }
    }

    protected void appendContainedObjectWithDomainInfo(Element parentNode, ContainedObjectWithDomain object) {
    }

    protected final Element appendKeyObjectInfo(Document doc, Element parentNode, KeyObject object) {
        Element elementNode = this.appendDesignObjectInfo(doc, parentNode, object);
        elementNode.setAttribute("pk", String.valueOf(object.isPK()));
        if (object instanceof CandidateKey) {
            elementNode.setAttribute("keystate", ((CandidateKey)object).getKeyState());
            elementNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(((CandidateKey)object).getSynonym()));
        } else if (object instanceof Index) {
            elementNode.setAttribute("indexstate", ((Index)object).getIndexState());
            this.appendFunctional(doc, elementNode, ((Index)object).getIndexExpression());
        }
        parentNode.appendChild(elementNode);
        this.appendKeyObjectInfo(elementNode, object);
        ContainedObject[] elements = object.getElements();
        for (int i = 0; i < elements.length; ++i) {
            this.appendKeyElementInfo(doc, elementNode, elements[i], object);
        }
        this.appendDocumentsInfo(doc, elementNode, object);
        this.appendPartiesInfo(doc, elementNode, object);
        this.appendChangeRequestsInfo(doc, elementNode, object);
        List measurements = object.getMeasurements();
        Element mElm = doc.createElement("measurements");
        elementNode.appendChild(mElm);
        for (int i = 0; i < measurements.size(); ++i) {
            this.appendMeasurementInfo(doc, mElm, (Measurement)measurements.get(i));
        }
        return elementNode;
    }

    private void appendFunctional(Document doc, Element docElement, Object index) {
        Element elementNode = doc.createElement("functional");
        elementNode.appendChild(doc.createTextNode(index.toString()));
        docElement.appendChild(elementNode);
    }

    protected void appendKeyObjectInfo(Element keyObjectNode, KeyObject object) {
    }

    protected final Element appendKeyElementInfo(Document doc, Element containerNode, ContainedObject object, KeyObject keyObject) {
        Element elementNode = doc.createElement("contains");
        elementNode.setAttribute("type", object.getObjectTypeName());
        if (keyObject instanceof Index && !keyObject.isFK()) {
            Index index = (Index)keyObject;
            elementNode.setAttribute("sortorder", index.getColumnSortOrder(object));
        }
        elementNode.appendChild(doc.createTextNode(object.getObjectID()));
        containerNode.appendChild(elementNode);
        this.appendKeyElementInfo(elementNode, object);
        return elementNode;
    }

    protected void appendKeyElementInfo(Element keyObjectNode, ContainedObject object) {
    }

    public void appendDataTypeInfo(Element parentNode, ContainedObjectWithDomain object) {
        Element elm = parentNode.getOwnerDocument().createElement("datatype");
        if (object.getDataType() instanceof MDDataType) {
            MDDataType type = (MDDataType)object.getDataType();
            if (type.isImplicitSized()) {
                elm.setAttribute("dttype", "builtin");
            } else if (type.isFixedLength()) {
                elm.setAttribute("dttype", "fixed");
                elm.setAttribute("size", String.valueOf(object.getSize()));
            } else if (type.isVarSized()) {
                elm.setAttribute("dttype", "var");
                elm.setAttribute("size", String.valueOf(object.getSize()));
            } else if (type.isPacked()) {
                elm.setAttribute("dttype", "packed");
                elm.setAttribute("precision", String.valueOf(object.getPrecision()));
                elm.setAttribute("scale", String.valueOf(object.getScale()));
            }
            elm.setAttribute("typename", type.getName());
        } else if (object.getDataType() instanceof DistinctType) {
            elm.setAttribute("dttype", "distinct");
            elm.setAttribute("typename", ((DistinctType)object.getDataType()).getObjectID());
        } else if (object.getDataType() instanceof StructuredType) {
            elm.setAttribute("dttype", "structured");
            elm.setAttribute("typename", ((StructuredType)object.getDataType()).getObjectID());
        } else if (object.getDataType() instanceof CollectionType) {
            elm.setAttribute("dttype", "collection");
            elm.setAttribute("typename", ((CollectionType)object.getDataType()).getObjectID());
        }
        parentNode.appendChild(elm);
    }

    public void appendScopeInfo(Element parentNode, ContainedObject object) {
        if (object.getScopeId() != null) {
            Element elm = parentNode.getOwnerDocument().createElement("scope");
            elm.setAttribute("objectid", object.getScopeId());
            parentNode.appendChild(elm);
        }
    }

    protected void appendReferenceInfo(Element parentNode, boolean use) {
        Element elm = parentNode.getOwnerDocument().createElement("reference");
        elm.setAttribute("value", String.valueOf(use));
        parentNode.appendChild(elm);
    }

    protected void appendSubtypeSubstitutionInfo(Element parentNode, boolean allow) {
        Element elm = parentNode.getOwnerDocument().createElement("subtypeSubstitution");
        elm.setAttribute("value", String.valueOf(allow));
        parentNode.appendChild(elm);
    }

    @Override
    public String getFilenameFor(Object object) {
        return ((DesignObject)object).getObjectID();
    }

    protected void appendObjects(Element objectInfoNode, Object[] objects, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < objects.length; ++i) {
            DesignObject desObj = (DesignObject)objects[i];
            map.put(String.valueOf(i + 1), desObj.getObjectID());
        }
        this.appendProperties(objectInfoNode, id, map);
    }

    protected void appendScriptInfo(Element objectInfoNode, String nodeName, String nodeValue) {
        Element element = objectInfoNode.getOwnerDocument().createElement(nodeName);
        element.setAttribute("value", StringUtilities.encodeAttributeValue(nodeValue));
        objectInfoNode.appendChild(element);
    }

    protected void appendRestrictedSubstitutionInfo(Element parentNode, ContainedObjectWithDomain co) {
        Element elm = parentNode.getOwnerDocument().createElement("restricted_substitution");
        elm.setAttribute("value", String.valueOf(co.isRestrictedTypeSubstitution()));
        if (co.isRestrictedTypeSubstitution() && co.getPermittedSubTypes().size() > 0) {
            this.appendObjects(elm, co.getPermittedSubTypes().toArray(), "permitted_types");
        }
        parentNode.appendChild(elm);
    }
}

