/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLModelIDObject;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractRXMLDesignObject
extends AbstractRXMLModelIDObject {
    private static final Logger LOGGER = new Logger(AbstractRXMLDesignObject.class);

    public AbstractRXMLDesignObject(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    protected abstract DesignObject instantiateDesignObject(String var1, Design var2, Element var3);

    protected ContainedObject instantiateContainedObject(String objectID, Design design, ContainerObject container, Element element) {
        return container.createContainedObject(objectID);
    }

    protected KeyObject instantiateKeyObject(String objectID, ContainerWithKeyObject cwkObject) {
        return cwkObject.createKeyObject(objectID);
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        try {
            Element objInfo = AbstractRXMLDesignObject.getFirstChildByTagName(doc.getDocumentElement(), "object");
            return this.recreateObject(objInfo, design, tryReadWriteLocking);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        DesignObject object;
        String aID;
        int i;
        String importedId;
        String id = objInfo.getAttribute("id");
        DesignObject designObject = design.getDesignObject(id);
        if (designObject == null) {
            designObject = this.instantiateDesignObject(id, design, objInfo);
        }
        if ((importedId = objInfo.getAttribute("imported_id")) != null && !"".equalsIgnoreCase(importedId)) {
            designObject.setImportedId(importedId);
        }
        this.readBasicObjectInfo(objInfo, designObject, tryReadWriteLocking);
        if (!(designObject instanceof TableView) && !(designObject instanceof EntityView)) {
            this.readObjectInfo(objInfo, designObject, tryReadWriteLocking);
        }
        this.readColorInfo(objInfo, designObject);
        Map objMap = this.getProperties(objInfo, "documents");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            object = design.getDesignObject(aID);
            if (object == null) continue;
            designObject.addDocument((BIDocument)object);
        }
        objMap = this.getProperties(objInfo, "parties");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            object = design.getDesignObject(aID);
            if (object == null) continue;
            designObject.addResponsibleParty((BIResponsibleParty)object);
        }
        objMap = this.getProperties(objInfo, "changerequests");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            object = design.getDesignObject(aID);
            if (object == null) continue;
            designObject.addRequest((ChangeRequest)object);
        }
        if (AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "measurements") != null) {
            NodeList objElms = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "measurements").getElementsByTagName("object");
            int length = objElms.getLength();
            for (int i2 = 0; i2 < length; ++i2) {
                Element child = (Element)objElms.item(i2);
                String childId = child.getAttribute("id");
                Measurement m = (Measurement)design.getDesignObject(childId);
                if (m != null) continue;
                m = this.instantiateMeasurement(child.getAttribute("id"), design, designObject, child);
                this.readMeasurementInfo(child, m, tryReadWriteLocking, design, designObject);
            }
        }
        if (designObject instanceof AbstractMDObject) {
            AbstractMDObject mdo = (AbstractMDObject)designObject;
            Map map = this.getProperties(objInfo, "oracle_names");
            String name = (String)map.get("oracle_short_name");
            if (name != null) {
                mdo.setOracleShortName(name);
            }
            if ((name = (String)map.get("oracle_long_name")) != null) {
                mdo.setOracleLongName(name);
            }
            if ((name = (String)map.get("oracle_plural_name")) != null) {
                mdo.setOraclePluralName(name);
            }
            if ((name = (String)map.get("name_in_oracle_aw")) != null) {
                mdo.setNameInOracleAW(name);
            }
        }
        this.readFontsInfo(objInfo, designObject);
        if (designObject instanceof ContainerObject) {
            ContainerObject containerObject = (ContainerObject)designObject;
            Element containedElm = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "contained");
            if (containedElm != null) {
                NodeList objElms = containedElm.getElementsByTagName("object");
                int length = objElms.getLength();
                for (int i3 = 0; i3 < length; ++i3) {
                    Element child = (Element)objElms.item(i3);
                    String childType = child.getAttribute("type");
                    if ("Measurement".equalsIgnoreCase(childType)) continue;
                    String childId = child.getAttribute("id");
                    ContainedObject contObject = (ContainedObject)design.getDesignObject(childId);
                    if (contObject == null) {
                        contObject = this.instantiateContainedObject(childId, design, containerObject, child);
                    }
                    if (contObject == null) continue;
                    this.readBasicContainedObjectInfo(child, contObject, tryReadWriteLocking, design, containerObject);
                    this.readContainedObjectInfo(child, contObject, tryReadWriteLocking);
                    this.readContainedObjectInfo(child, containerObject, contObject, tryReadWriteLocking);
                }
                if (containerObject instanceof TableView) {
                    this.readGroupBy(objInfo, "groupby", containerObject, ((AbstractView)containerObject).getGroupByList());
                    this.readOrderBy(objInfo, containerObject);
                } else if (containerObject instanceof EntityView) {
                    this.readGroupBy(objInfo, "groupby", containerObject, ((AbstractView)containerObject).getGroupByList());
                    this.readOrderBy(objInfo, containerObject);
                }
                if (designObject instanceof ContainerWithKeyObject) {
                    ContainedObject co;
                    KeyObject key;
                    ContainerWithKeyObject cwkObject = (ContainerWithKeyObject)designObject;
                    NodeList keys = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "key").getElementsByTagName("object");
                    length = keys.getLength();
                    for (int i4 = 0; i4 < length; ++i4) {
                        Element keyElm = (Element)keys.item(i4);
                        String childType = keyElm.getAttribute("type");
                        if ("Measurement".equalsIgnoreCase(childType)) continue;
                        String keyId = keyElm.getAttribute("id");
                        KeyObject key2 = (KeyObject)design.getDesignObject(keyId);
                        if (key2 == null) {
                            key2 = this.instantiateKeyObject(keyId, cwkObject);
                        }
                        this.readBasicKeyObjectInfo(keyElm, key2, tryReadWriteLocking);
                        this.readKeyObjectInfo(keyElm, key2, tryReadWriteLocking);
                    }
                    if (cwkObject.isBST() && (key = cwkObject.getPK()) != null && key.getElementsCollection().size() == 1 && (co = key.getElement(0)).isOid()) {
                        key.setOidKey(true);
                    }
                }
            }
        }
        return designObject;
    }

    private void readMeasurementInfo(Element objInfo, Measurement m, boolean tryReadWriteLocking, Design design, DesignObject designObject) {
        String effectiveTime;
        Node textNode;
        Element effectiveTimeElm;
        String creationTime;
        Node textNode2;
        Element creationTimeElm;
        String type;
        Node textNode3;
        Element typeElm;
        String unit;
        Node textNode4;
        Element unitElm;
        String value;
        Node textNode5;
        this.readBasicObjectInfo(objInfo, m, tryReadWriteLocking);
        Element valueElm = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "value");
        if (valueElm != null && (textNode5 = valueElm.getFirstChild()) != null && (value = textNode5.getNodeValue()) != null) {
            m.setValue(StringUtilities.decodeAttributeValue(value));
        }
        if ((unitElm = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "unit")) != null && (textNode4 = unitElm.getFirstChild()) != null && (unit = textNode4.getNodeValue()) != null) {
            m.setUnit(StringUtilities.decodeAttributeValue(unit));
        }
        if ((typeElm = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "sort")) != null && (textNode3 = typeElm.getFirstChild()) != null && (type = textNode3.getNodeValue()) != null) {
            m.setType(StringUtilities.decodeAttributeValue(type));
        }
        if ((creationTimeElm = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "creationTime")) != null && (textNode2 = creationTimeElm.getFirstChild()) != null && (creationTime = textNode2.getNodeValue()) != null) {
            m.setCreationDate(StringUtilities.decodeAttributeValue(creationTime));
        }
        if ((effectiveTimeElm = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "effectiveTime")) != null && (textNode = effectiveTimeElm.getFirstChild()) != null && (effectiveTime = textNode.getNodeValue()) != null) {
            m.setEffectiveDate(StringUtilities.decodeAttributeValue(effectiveTime));
        }
    }

    private Measurement instantiateMeasurement(String objectID, Design design, DesignObject desObject, Element child) {
        Measurement m = new Measurement(desObject.getDesignPart());
        m.setObjectID(objectID);
        m.setDesign(desObject.getDesign());
        m.setObject(desObject);
        desObject.addMeasurement(m);
        return m;
    }

    protected void readContainedObjectInfo(Element objInfo, ContainedObject contObject, boolean tryReadWriteLocking) {
    }

    protected void readContainedObjectInfo(Element objInfo, ContainerObject container, ContainedObject contObject, boolean tryReadWriteLocking) {
    }

    protected void readBasicContainedObjectInfo(Element objInfo, ContainedObject contObject, boolean tryReadWriteLocking, Design design, ContainerObject containerObject) {
        DesignObject object;
        String aID;
        int i;
        boolean an;
        this.readBasicObjectInfo(objInfo, contObject, tryReadWriteLocking);
        String temp = objInfo.getAttribute("unique");
        if (temp != null) {
            contObject.setUnique(Boolean.valueOf(temp));
        }
        if ((temp = objInfo.getAttribute("allownull")) != null) {
            an = Boolean.valueOf(temp);
            contObject.setNullsAllowed(an);
        }
        if ((temp = objInfo.getAttribute("constraint_name")) != null) {
            contObject.setConstraintName(StringUtilities.decodeAttributeValue(temp));
        }
        if ((temp = objInfo.getAttribute("usedomainconstraints")) != null) {
            an = Boolean.valueOf(temp);
            contObject.setUseDomainConstraints(an);
        }
        if ((temp = objInfo.getAttribute("is_oid")) != null) {
            an = Boolean.valueOf(temp);
            contObject.setOid(an);
        }
        if ((temp = objInfo.getAttribute("structured_attribute_id")) != null) {
            contObject.setStructAttributeID(temp);
        }
        if ((temp = objInfo.getAttribute("synonym")) != null) {
            contObject.setSynonym(StringUtilities.decodeAttributeValue(String.valueOf(temp)));
        }
        if (!contObject.getUseDomainConstraints()) {
            this.readConstraint(objInfo, contObject);
            this.readAVT(objInfo, contObject);
        }
        if ((temp = objInfo.getAttribute("fk")) != null && Boolean.valueOf(temp).booleanValue()) {
            String refId = objInfo.getAttribute("references");
            contObject.setReferedAttribute(refId);
            if (containerObject.getReferIDMap() != null) {
                containerObject.getReferIDMap().put(refId, contObject.getObjectID());
            }
            design.getFKMap().put(contObject.getObjectID(), contObject.getName());
        }
        if (contObject instanceof ContainedObjectWithDomain) {
            this.readBasicContainedObjectWithDomainInfo(objInfo, (ContainedObjectWithDomain)contObject, tryReadWriteLocking);
        }
        Map objMap = this.getProperties(objInfo, "documents");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            object = design.getDesignObject(aID);
            if (object == null) continue;
            contObject.addDocument((BIDocument)object);
        }
        objMap = this.getProperties(objInfo, "parties");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            object = design.getDesignObject(aID);
            if (object == null) continue;
            contObject.addResponsibleParty((BIResponsibleParty)object);
        }
        objMap = this.getProperties(objInfo, "changerequests");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            object = design.getDesignObject(aID);
            if (object == null) continue;
            contObject.addRequest((ChangeRequest)object);
        }
        if (AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "measurements") != null) {
            NodeList objElms = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "measurements").getElementsByTagName("object");
            int length = objElms.getLength();
            for (int i2 = 0; i2 < length; ++i2) {
                Element child = (Element)objElms.item(i2);
                String childId = child.getAttribute("id");
                Measurement m = (Measurement)design.getDesignObject(childId);
                if (m != null) continue;
                m = this.instantiateMeasurement(child.getAttribute("id"), design, contObject, child);
                this.readMeasurementInfo(child, m, tryReadWriteLocking, design, contObject);
            }
        }
    }

    protected void readConstraint(Element parent, ContainedObject contObject) {
        NodeList list = parent.getElementsByTagName("constraint");
        if (list.getLength() > 0) {
            Element constraintElm = (Element)list.item(0);
            String type = constraintElm.getAttribute("type");
            Constraint constraint = contObject.getDesign().getConstraintSet().createConstraint(type);
            this.readConstraintInfo(constraintElm, constraint);
            this.readPropertiesListLocateRoot(constraintElm, constraint);
            if (type.equalsIgnoreCase("check constraint")) {
                this.readPropertiesListLocateRoot(constraintElm, constraint);
                contObject.setCheck((CheckConstraint)constraint);
            } else if (type.equalsIgnoreCase("enumerated String")) {
                this.readConstraintEnumerationList(constraintElm, (ConstraintEnumeration)constraint);
                contObject.setValueList((ConstraintEnumeration)constraint);
            }
            if (list.getLength() > 1) {
                constraintElm = (Element)list.item(1);
                type = constraintElm.getAttribute("type");
                constraint = contObject.getDesign().getConstraintSet().createConstraint(type);
                this.readConstraintInfo(constraintElm, constraint);
                this.readPropertiesListLocateRoot(constraintElm, constraint);
                if (type.equalsIgnoreCase("check constraint")) {
                    contObject.setCheck((CheckConstraint)constraint);
                } else if (type.equalsIgnoreCase("enumerated String")) {
                    this.readConstraintEnumerationList(constraintElm, (ConstraintEnumeration)constraint);
                    contObject.setValueList((ConstraintEnumeration)constraint);
                }
            }
        }
    }

    private void readConstraintEnumerationList(Element parent, ConstraintEnumeration object) {
        NodeList list = parent.getElementsByTagName("properties");
        if (list.getLength() > 0) {
            this.readConstraintEnumeration((Element)list.item(0), object);
        }
    }

    private void readConstraintEnumeration(Element parent, ConstraintEnumeration object) {
        NodeList paramList = parent.getElementsByTagName("parameter");
        int length = paramList.getLength();
        for (int i = 0; i < length; ++i) {
            Element parameter = (Element)paramList.item(i);
            String value = parameter.getAttribute("value");
            String desc = parameter.getAttribute("desc");
            object.add(value, desc);
        }
    }

    protected void readConstraintInfo(Element constraintElm, Constraint constraint) {
        try {
            Element nameElm = AbstractRXMLDesignObject.getFirstChildByTagName(constraintElm, "name");
            if (nameElm != null && nameElm.getFirstChild() != null) {
                String name = nameElm.getFirstChild().getNodeValue();
                constraint.setName(name);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
        }
    }

    protected void readAVT(Element parent, ContainedObject contObject) {
        NodeList list;
        int length;
        String avtSortOrder = parent.getAttribute("avt_sort_order");
        if (!"".equalsIgnoreCase(avtSortOrder)) {
            try {
                int avtSO = Integer.parseInt(avtSortOrder);
                contObject.setAVTSortOrder(avtSO);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((length = (list = parent.getElementsByTagName("avt")).getLength()) > 0) {
            for (int i = 0; i < length; ++i) {
                String description;
                String endvalue;
                String beginvalue;
                Element constraintElm = (Element)list.item(i);
                AVT avt = null;
                Element nameElm = AbstractRXMLDesignObject.getFirstChildByTagName(constraintElm, "beginvalue");
                if (nameElm != null && nameElm.getFirstChild() != null && (beginvalue = nameElm.getFirstChild().getNodeValue()) != null) {
                    avt = new AVT(StringUtilities.decodeAttributeValue(beginvalue), "", "");
                }
                if ((nameElm = AbstractRXMLDesignObject.getFirstChildByTagName(constraintElm, "endvalue")) != null && nameElm.getFirstChild() != null && (endvalue = nameElm.getFirstChild().getNodeValue()) != null) {
                    if (avt != null) {
                        avt.setEndValue(StringUtilities.decodeAttributeValue(endvalue));
                    } else {
                        avt = new AVT("", StringUtilities.decodeAttributeValue(endvalue), "");
                    }
                }
                if ((nameElm = AbstractRXMLDesignObject.getFirstChildByTagName(constraintElm, "description")) != null && nameElm.getFirstChild() != null && (description = nameElm.getFirstChild().getNodeValue()) != null) {
                    if (avt != null) {
                        avt.setDescription(StringUtilities.decodeAttributeValue(description));
                    } else {
                        avt = new AVT("", "", StringUtilities.decodeAttributeValue(description));
                    }
                }
                if (avt == null) continue;
                contObject.addAVT(avt);
            }
        }
    }

    protected final void readBasicContainedObjectWithDomainInfo(Element objInfo, ContainedObjectWithDomain contObject, boolean tryReadWriteLocking) {
        Element domainElm = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "domain");
        if (domainElm != null) {
            String domainId = domainElm.getAttribute("oid");
            String domainFile = domainElm.getAttribute("file");
            if (domainFile != null && domainId != null) {
                Domain domain = contObject.getDesign().getLoadDomain(domainId, domainFile);
                contObject.setDomain(domain);
            }
        }
    }

    protected void readKeyObjectInfo(Element objInfo, KeyObject keyObject, boolean tryReadWriteLocking) {
    }

    protected void readBasicKeyObjectInfo(Element objInfo, KeyObject keyObject, boolean tryReadWriteLocking) {
        DesignObject object;
        String aID;
        int i;
        this.readBasicObjectInfo(objInfo, keyObject, tryReadWriteLocking);
        ContainerObject container = keyObject.getTopLevelContainer();
        NodeList containElms = objInfo.getElementsByTagName("contains");
        int length = containElms.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Element containElm = (Element)containElms.item(i2);
            String containedId = containElm.getFirstChild().getNodeValue();
            ContainedObject contained = container.getElementByID(containedId);
            if (contained == null) continue;
            keyObject.add(contained);
            if (!(keyObject instanceof Index)) continue;
            String sortOrder = containElm.getAttribute("sortorder");
            Index index = (Index)keyObject;
            index.setColumnSortOrder(contained, sortOrder.length() > 0 ? sortOrder : "ASC");
        }
        String indexExpression = "";
        if (AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "functional") != null && AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "functional").getFirstChild() != null) {
            indexExpression = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "functional").getFirstChild().getNodeValue();
        }
        if (Boolean.valueOf(objInfo.getAttribute("pk")).booleanValue()) {
            keyObject.makePK();
        }
        if (keyObject instanceof CandidateKey) {
            ((CandidateKey)keyObject).setKeyState(objInfo.getAttribute("keystate"));
            ((CandidateKey)keyObject).setSynonym(StringUtilities.decodeAttributeValue(objInfo.getAttribute("synonym")));
        } else if (keyObject instanceof Index) {
            ((Index)keyObject).setIndexState(objInfo.getAttribute("indexstate"));
            ((Index)keyObject).setIndexExpression(indexExpression);
        }
        Design design = keyObject.getDesign();
        Map objMap = this.getProperties(objInfo, "documents");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            object = design.getDesignObject(aID);
            if (object == null) continue;
            keyObject.addDocument((BIDocument)object);
        }
        objMap = this.getProperties(objInfo, "parties");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            object = design.getDesignObject(aID);
            if (object == null) continue;
            keyObject.addResponsibleParty((BIResponsibleParty)object);
        }
        objMap = this.getProperties(objInfo, "changerequests");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            object = design.getDesignObject(aID);
            if (object == null) continue;
            keyObject.addRequest((ChangeRequest)object);
        }
        if (AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "measurements") != null) {
            NodeList objElms = AbstractRXMLDesignObject.getFirstChildByTagName(objInfo, "measurements").getElementsByTagName("object");
            length = objElms.getLength();
            for (int i3 = 0; i3 < length; ++i3) {
                Element child = (Element)objElms.item(i3);
                String childId = child.getAttribute("id");
                Measurement m = (Measurement)design.getDesignObject(childId);
                if (m != null) continue;
                m = this.instantiateMeasurement(child.getAttribute("id"), design, keyObject, child);
                this.readMeasurementInfo(child, m, tryReadWriteLocking, design, keyObject);
            }
        }
    }

    @Override
    protected void readBasicObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        super.readBasicObjectInfo(objInfo, desObject, tryReadWriteLocking);
        NodeList list = objInfo.getElementsByTagName("engineering");
        if (list.getLength() > 0) {
            Element engineerElm = (Element)list.item(0);
            if (((DesignObject)desObject).getDesignPart() instanceof LogicalDesign) {
                NodeList rdList = engineerElm.getElementsByTagName("relational_design");
                for (int i = 0; i < rdList.getLength(); ++i) {
                    Element rdElm = (Element)rdList.item(i);
                    String rd_id = rdElm.getAttribute("id");
                    boolean value = Boolean.valueOf(rdElm.getAttribute("should"));
                    ((DesignObject)desObject).setEngineerTo(rd_id, value);
                }
            } else {
                String value = engineerElm.getAttribute("should");
                if (value != null && value.equals(VALUE_TRUE)) {
                    desObject.setShouldEngineer(true);
                } else {
                    desObject.setShouldEngineer(false);
                }
            }
        }
    }

    protected void recreateScript(Element objInfo, ContainerObject object) {
        object.setBeforeDrop(this.getElementValue(objInfo, "beforeDrop"));
        object.setBeforeCreate(this.getElementValue(objInfo, "beforeCreate"));
        object.setBeforeAlter(this.getElementValue(objInfo, "beforeAlter"));
        object.setAfterCreate(this.getElementValue(objInfo, "afterCreate"));
        object.setAfterAlter(this.getElementValue(objInfo, "afterAlter"));
        object.setEndOfScript(this.getElementValue(objInfo, "endOfScript"));
        object.setShouldGenerateScript(this.getElementBooleanValue(objInfo, "include_in_ddl", false));
    }

    private String getElementValue(Element objInfo, String nodeName) {
        return this.getElementRawValue(objInfo, nodeName, "");
    }

    private boolean getElementBooleanValue(Element objInfo, String nodeName, boolean defaultValue) {
        return Boolean.parseBoolean(this.getElementRawValue(objInfo, nodeName, String.valueOf(defaultValue)));
    }

    private String getElementRawValue(Element objInfo, String nodeName, String defaultValue) {
        Element element;
        String value = defaultValue;
        NodeList list = objInfo.getElementsByTagName(nodeName);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            value = element.getAttribute("value");
            value = StringUtilities.decodeAttributeValue(value);
        }
        return value;
    }

    protected void readOrderBy(Element element, ContainerObject view) {
    }

    protected void readGroupBy(Element mappingElement, String id, ContainerObject obj, List list) {
    }
}

