/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.util.io.EmptyInputStream;

public abstract class AbstractFileManager {
    private boolean startSeparateWriterThread = false;
    private String userName = "unknown";
    private String fileExtension = "xml";

    public abstract boolean setBasePath(String var1);

    public abstract void setDesignPath(String var1);

    public abstract boolean store(PersistenceManager var1, String var2, String var3, String var4);

    public abstract boolean store(PersistenceManager var1, String var2, String var3, InputStream var4);

    public boolean getStartWriterThread() {
        return this.startSeparateWriterThread;
    }

    public void setStartWriterThread(boolean value) {
        this.startSeparateWriterThread = value;
    }

    public abstract String readData(PersistenceManager var1, String var2, String var3);

    public abstract boolean exists(PersistenceManager var1, String var2, String var3);

    public abstract boolean deleteDesign(PersistenceManager var1, String var2, String var3, String var4);

    public abstract boolean deleteFiles(List var1);

    public abstract boolean unlockDesign(String var1, String var2, String var3);

    public abstract String getDataPath();

    public abstract Object[] listNames(String var1);

    public abstract String[] listNamesNoFileExtension(String var1);

    public abstract InputStream getDataInputStreamWithoutExtension(PersistenceManager var1, String var2, String var3);

    public abstract InputStream getDataInputStream(PersistenceManager var1, String var2, Object var3);

    public abstract File getAbsolutePath(PersistenceManager var1, String var2, String var3, boolean var4);

    public InputStream getDataInputStreamWithoutExtension(PersistenceManager pm, String location, String name, boolean lock) {
        if (lock && this.implementsLocking() && this.getLock(location, name)) {
            return this.getDataInputStreamWithoutExtension(pm, location, name);
        }
        return new EmptyInputStream();
    }

    public InputStream getDataInputStream(PersistenceManager pm, String location, Object name, boolean lock) {
        if (lock && this.implementsLocking() && this.getLock(location, (String)name)) {
            return this.getDataInputStream(pm, location, name);
        }
        return new EmptyInputStream();
    }

    public void setUserName(String user) {
        this.userName = user;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean getLock(String location, String name) {
        return this.getLock(location, name, this.getUserName());
    }

    public boolean getLock(String location, String name, String user) {
        return false;
    }

    public boolean releaseLock(String location, String name) {
        return this.releaseLock(location, name, this.getUserName());
    }

    public boolean releaseLock(String location, String name, String user) {
        return false;
    }

    public boolean implementsLocking() {
        return false;
    }

    public boolean checkConnectionStatus() {
        return true;
    }

    public String getLastConnectionStatusMessage() {
        return Messages.getString("AbstractFileManager.NoConnectioToVerify");
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String extension) {
        this.fileExtension = extension;
    }

    public String toFileName(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith("." + this.getFileExtension())) {
            return name;
        }
        StringBuffer b = new StringBuffer();
        b.append(name);
        b.append('.');
        b.append(this.getFileExtension());
        return b.toString();
    }

    public String removeExt(String name) {
        int dotPos = name.indexOf(46);
        if (dotPos == -1) {
            return name;
        }
        return name.substring(0, dotPos);
    }

    public String fixFilePath(String path) {
        int pos = path.indexOf(92);
        if (pos == -1) {
            return path;
        }
        return path.replaceAll("[\\\\]", "/");
    }

    public String fixPath(String path) {
        int pos = path.indexOf(92);
        if (pos == -1) {
            return this.addLastSlash(path);
        }
        return this.addLastSlash(path.replaceAll("[\\\\]", "/"));
    }

    public String addLastSlash(String path) {
        if (!path.endsWith("/")) {
            return path.concat("/");
        }
        return path;
    }

    public boolean isWriteFinished() {
        return false;
    }
}

