/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableSpaceName
extends AbstractDRStorageDesign {
    private final String RULE_ID = "81F49358-9D97-FD6F-ABAC-6A82D288DAA8";

    public DRTableSpaceName(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableSpaceName.CheckIifTablespaceNameIsValid"));
        this.setDescription(Messages.getString("DRTableSpaceName.TablespaceNameShouldBeValid"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableSpaceUDB tablespace = (TableSpaceUDB)object;
        if (tablespace.getName().toUpperCase().startsWith("IBM")) {
            return CheckResult.createWarning(tablespace, this, Messages.getString("DRTableSpaceName.TablespaceNameStartswithIBM"));
        }
        if (tablespace.getName().toUpperCase().startsWith("SYS")) {
            return CheckResult.createWarning(tablespace, this, Messages.getString("DRTableSpaceName.TablespaceNameStartswithSYS"));
        }
        if (tablespace.getName().toUpperCase().startsWith("DBM")) {
            return CheckResult.createWarning(tablespace, this, Messages.getString("DRTableSpaceName.TablespaceNameStartswithDBM"));
        }
        if (tablespace.getName().indexOf(32) > -1) {
            return CheckResult.createWarning(tablespace, this, Messages.getString("DRTableSpaceName.TablespaceNameContainsBlank"));
        }
        return CheckResult.createOk(tablespace, this, Messages.getString("DRTableSpaceName.TablespaceNameIsValid"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "81F49358-9D97-FD6F-ABAC-6A82D288DAA8";
    }
}

