/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.IStoredProcedure;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRStoredProcedureEmptyBody
extends AbstractDRStorageDesign {
    private final String RULE_ID = "57333C3C-6BC0-44AE-89F1-97409C01314C";

    public DRStoredProcedureEmptyBody(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRStoredProcedureEmptyBody.CheckStoredProcedureBody"));
        this.setDescription(Messages.getString("DRStoredProcedureEmptyBody.TheBodyIsNotAllowedToBeEmpty"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        IStoredProcedure proc = (IStoredProcedure)object;
        if ("".equalsIgnoreCase(proc.getBody())) {
            return CheckResult.createFailed(object, this, Messages.getString("DRStoredProcedureEmptyBody.StoredProcedureBodyIsEmpty"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRStoredProcedureEmptyBody.StoredProcedureBodyIsNotEmpty"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "57333C3C-6BC0-44AE-89F1-97409C01314C";
    }
}

