/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRColumnCheckConstraintNamingStandard
extends DesignRule {
    private final String RULE_ID = "B5375FED-9CAE-FB43-76AC-2689979D50B6";
    private NamingStandardRule namingRule;

    public DRColumnCheckConstraintNamingStandard() {
        this.setName(Messages.getString("DRColumnCheckConstraintNamingStandard.IdentifyColumnCheckConstraintsWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRColumnCheckConstraintNamingStandard.ColumnCheckConstraintsWithWrongNamingStandardsAreNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Column column = (Column)object;
        String tableName = "";
        String columnName = "";
        String tableAbbr = "";
        String modelName = "";
        this.namingRule = column.getDesign().getDesignLevelSettings().getNamingStandardRule();
        String result = this.namingRule.getColckConstr();
        if (column.getCheck() != null) {
            Table table = (Table)column.getContainer();
            tableName = table.getName();
            tableAbbr = table.getAbbreviation();
            if (tableAbbr.equals("")) {
                tableAbbr = tableName;
            }
            tableName = tableName.replaceAll("\\$", "\\\\\\$");
            result = result.replaceAll("\\{table\\}", tableName);
            tableAbbr = tableAbbr.replaceAll("\\$", "\\\\\\$");
            result = result.replaceAll("\\{table abbr\\}", tableAbbr);
            columnName = column.getShortName();
            String columnAbbr = column.getAbbreviation();
            if (columnAbbr.equals("")) {
                columnAbbr = columnName;
            }
            columnName = columnName.replaceAll("\\$", "\\\\\\$");
            result = result.replaceAll("\\{column\\}", columnName);
            columnAbbr = columnAbbr.replaceAll("\\$", "\\\\\\$");
            result = result.replaceAll("\\{column abbr\\}", columnAbbr);
            modelName = column.getDesignPart().getName();
            modelName = modelName.replaceAll("\\$", "\\\\\\$");
            result = result.replaceAll("\\{model\\}", modelName);
            if (column.getConstraintName().equalsIgnoreCase(result)) {
                return CheckResult.createOk(columnName, this, Messages.getString("DRColumnCheckConstraintNamingStandard.ColumnCheckConstraintNameIsInValidFormat"));
            }
            return CheckResult.createWarning(column, this, this.getDescription());
        }
        return CheckResult.createOk(column, this, Messages.getString("DRColumnCheckConstraintNamingStandard.ColumnCheckConstraintNameIsInValidFormat"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "B5375FED-9CAE-FB43-76AC-2689979D50B6";
    }
}

