/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k12;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.LoginSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k12.UserPropertyDialogSqlServerv2k12;

public class UserSqlServerv2k12
extends UserSqlServerv2k5 {
    private static final String[] PRIVILEGES = new String[]{"ALL", "CREATE DEFAULT", "CREATE FUNCTION", "CREATE PROCEDURE", "CREATE RULE", "CREATE TABLE", "CREATE VIEW"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    @Override
    protected boolean checkPrivileges(String value) {
        return PRIVILEGESLIST.contains(value);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        UserSqlServerv2k12 user = null;
        StorageObject stObject = (StorageObject)((StorageDesignSqlServerv2k12)targetDesign).getUserSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                user = (UserSqlServerv2k12)stObject;
            }
        } else {
            user = (UserSqlServerv2k12)((StorageDesignSqlServerv2k12)targetDesign).getUserSet().createUser();
        }
        if (user != null) {
            user.setName(this.getName());
            if (this.getDatabase() != null) {
                DataBaseSqlServerv2k5 database = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getDataBaseSet().getByName(this.getDatabase().getName());
                if (database == null) {
                    DataBaseSqlServerv2k5 newDatabase = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getDataBaseSet().createDataBase();
                    newDatabase.setName(this.getDatabase().getName());
                    newDatabase.setRawObject(true);
                    user.setDatabase(newDatabase);
                } else {
                    user.setDatabase(database);
                }
            }
            if (this.getLogin() != null) {
                LoginSqlServerv2k5 login = (LoginSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getLoginSet().getByName(this.getLogin().getName());
                if (login == null) {
                    LoginSqlServerv2k5 newLogin = (LoginSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getLoginSet().createLogin();
                    newLogin.setName(this.getLogin().getName());
                    newLogin.setRawObject(true);
                    user.setLogin(newLogin);
                } else {
                    user.setLogin(login);
                }
            }
            user.recreateSystemPrivilegesSet(this.getPrivilegesSet().toString());
            user.setComment(this.getComment());
            user.setRawObject(false);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            UserPropertyDialogSqlServerv2k12 dialog = new UserPropertyDialogSqlServerv2k12(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object one, Object two) {
            return String.valueOf(one).compareTo(String.valueOf(two));
        }
    }
}

