/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.ViewPropertyDialogSqlServer;

public class TableViewProxySqlServer
extends TableViewProxy
implements ModelObjectSetListener,
StorageObjectListener {
    private DataBaseSqlServer dataBase;
    private StorageObjectCollection indexesOnView;
    private StorageObjectCollection triggers;
    private String props = "";
    private InlineList extPropsSet = null;
    private UserSqlServer user = null;
    private String encryption = "NO";
    private String schemaBinding = "NO";
    private String viewMetaData = "NO";
    private SchemaSqlServer schema;
    protected StorageObjectCollection synonyms;

    public TableViewProxySqlServer(TableView view, StorageDesign storage) {
        super(view, storage);
        this.indexesOnView = new StorageObjectCollection(((StorageDesignSqlServer)storage).getIndexOnViewSet());
        this.indexesOnView.setParent(this);
        this.indexesOnView.setName(Messages.getString("TableProxy.Indexes"));
        this.indexesOnView.setClassForParent(TableViewProxySqlServer.class);
        this.indexesOnView.setSetMethod("setView");
        this.indexesOnView.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storage).getIndexOnViewSet().addSetListener(this);
        this.addIndexesFromDesign(((StorageDesignSqlServer)storage).getIndexOnViewSet());
        if (this.schemaBinding.equalsIgnoreCase("YES")) {
            this.enableIndexes();
        } else {
            this.disableIndexes();
        }
        this.triggers = new StorageObjectCollection(((StorageDesignSqlServer)storage).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxySqlServer.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storage).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignSqlServer)storage).getTriggerSet());
        this.setDataBase(null);
    }

    public TableViewProxySqlServer(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.indexesOnView = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getIndexOnViewSet());
        this.indexesOnView.setParent(this);
        this.indexesOnView.setName(Messages.getString("TableProxy.Indexes"));
        this.indexesOnView.setClassForParent(TableViewProxySqlServer.class);
        this.indexesOnView.setSetMethod("setView");
        this.indexesOnView.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storageDesign).getIndexOnViewSet().addSetListener(this);
        this.addIndexesFromDesign(((StorageDesignSqlServer)storageDesign).getIndexOnViewSet());
        if (this.schemaBinding.equalsIgnoreCase("YES")) {
            this.enableIndexes();
        } else {
            this.disableIndexes();
        }
        this.triggers = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxySqlServer.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.setDataBase(null);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ViewPropertyDialogSqlServer dialog = new ViewPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.indexesOnView;
            }
            case 1: {
                return this.triggers;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.indexesOnView) {
            return 0;
        }
        if (child == this.triggers) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.indexesOnView) {
            return 0;
        }
        if (child == this.triggers) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.indexesOnView.removeAll();
        this.triggers.removeAll();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof IndexOnViewSqlServer) {
                IndexOnViewSqlServer index = (IndexOnViewSqlServer)event.getAffected();
                index.addObjectListener(this);
                if (index.getView() == this) {
                    index.setParent(this.indexesOnView);
                    this.indexesOnView.add(index);
                } else {
                    this.indexesOnView.remove(index);
                }
            } else if (event.getAffected() instanceof TriggerSqlServer) {
                TriggerSqlServer tr = (TriggerSqlServer)event.getAffected();
                tr.addObjectListener(this);
                if (tr.getView() == this) {
                    tr.setParent(this.triggers);
                    this.triggers.add(tr);
                } else {
                    this.triggers.remove(tr);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof IndexOnViewSqlServer) {
                IndexOnViewSqlServer index = (IndexOnViewSqlServer)event.getAffected();
                this.indexesOnView.remove(index);
                index.removeObjectListener(this);
            } else if (event.getAffected() instanceof TriggerSqlServer) {
                TriggerSqlServer tr = (TriggerSqlServer)event.getAffected();
                this.triggers.remove(tr);
                tr.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof IndexOnViewSqlServer) {
            IndexOnViewSqlServer index = (IndexOnViewSqlServer)event.getAffected();
            if (index.getView() == this) {
                index.setParent(this.indexesOnView);
                this.indexesOnView.add(index);
                if (this.indexesOnView.size() == 1 && !this.getStorageDesign().isLoading()) {
                    index.setClustered("YES");
                    index.setUnique("YES");
                }
            } else {
                this.indexesOnView.remove(index);
            }
        } else if (event.getAffected() instanceof TriggerSqlServer) {
            TriggerSqlServer tr = (TriggerSqlServer)event.getAffected();
            if (tr.getView() == this) {
                tr.setParent(this.triggers);
                this.triggers.add(tr);
            } else {
                this.triggers.remove(tr);
            }
        }
    }

    public UserSqlServer getUser() {
        return this.user;
    }

    public void setUser(UserSqlServer user) {
        if (this.user != user) {
            this.user = user;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String encryption) {
        if (ConstantsSqlServer.checkYesNo(encryption)) {
            this.encryption = encryption;
        }
        this.fireDataFieldChange();
    }

    public String getSchemaBinding() {
        return this.schemaBinding;
    }

    public void setSchemaBinding(String schemaBinding) {
        if (ConstantsSqlServer.checkYesNo(schemaBinding)) {
            this.schemaBinding = schemaBinding;
            if (schemaBinding.equalsIgnoreCase("YES")) {
                this.enableIndexes();
            } else {
                this.disableIndexes();
            }
        }
        this.fireDataFieldChange();
    }

    public String getViewMetaData() {
        return this.viewMetaData;
    }

    public void setViewMetaData(String viewMetaData) {
        if (ConstantsSqlServer.checkYesNo(viewMetaData)) {
            this.viewMetaData = viewMetaData;
        }
        this.fireDataFieldChange();
    }

    public void setDataBase(DataBaseSqlServer dataBase) {
        this.dataBase = dataBase == null && ((StorageDesignSqlServer)this.getStorageDesign()).getDataBaseSet().hasNullInstance() ? (DataBaseSqlServer)((StorageDesignSqlServer)this.getStorageDesign()).getDataBaseSet().getNullInstance() : dataBase;
        this.fireDataFieldChange();
    }

    public DataBaseSqlServer getDataBase() {
        return this.dataBase;
    }

    protected void addIndexesFromDesign(StorageObjectSet set) {
        for (IndexOnViewSqlServer index : set) {
            index.addObjectListener(this);
            if (index.getView() == this) {
                index.setParent(this.indexesOnView);
                this.indexesOnView.add(index);
                continue;
            }
            this.indexesOnView.remove(index);
        }
    }

    protected void addTriggersFromDesign(StorageObjectSet set) {
        for (TriggerSqlServer trigger : set) {
            trigger.addObjectListener(this);
            if (trigger.getView() == this) {
                trigger.setParent(this.triggers);
                this.triggers.add(trigger);
                continue;
            }
            this.triggers.remove(trigger);
        }
    }

    public ColumnProxySqlServer getColumnProxyByName(String name) {
        ColumnProxy[] columns = this.getColumnProxies();
        for (int i = 0; i < columns.length; ++i) {
            ColumnProxySqlServer cpo = (ColumnProxySqlServer)columns[i];
            if (!name.equals(cpo.getName())) continue;
            return cpo;
        }
        return null;
    }

    private void enableIndexes() {
        this.indexesOnView.setForbiddenCreateElement(false);
    }

    private void disableIndexes() {
        this.indexesOnView.setForbiddenCreateElement(true);
        this.indexesOnView.removeAll();
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String prop) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(prop);
        } else {
            this.addExtProperty(prop);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String props2) {
        this.getExtPropsSet().add(props2);
    }

    protected void recreateExtPropertiesSet(String props1) {
        this.getExtPropsSet().clear();
        StringTokenizer st = new StringTokenizer(props1, ",");
        this.extPropsSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getExtPropsSet().add(st.nextToken().trim());
        }
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
    }

    public StorageObjectCollection getIndexesOnView() {
        return this.indexesOnView;
    }

    public IndexOnViewSqlServer createIndexOnView() {
        if (this.indexesOnView.getStorageObjectSet() != null) {
            return (IndexOnViewSqlServer)this.indexesOnView.createElement(null);
        }
        return null;
    }

    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer schema) {
        this.schema = schema;
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public String getFullyQualifiedName() {
        if (this.getSchema() != null && !this.getSchema().isNullInstance()) {
            return new StringBuffer().append(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return this.getName();
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getDataBase().isDropEnabled() || this.getDataBase().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("VIEW_ICON", 16);
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            if (this.synonyms != null) {
                this.synonyms.addAllElementsTo(list);
            }
            this.indexesOnView.addAllElementsTo(list);
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

