/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableCheckConstraintListener;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraintEvent;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableCheckConstraintOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableCheckConstraintSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TriggerOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.TablePropertyDialogOraclev10g;

public class TableProxyOraclev10g
extends TableProxyOracle
implements TableCheckConstraintListener {
    protected String suplementalLogGroupName = "";
    protected String suplementalLogConditions = suplementalLogConditionChoices[0];
    protected String IOTMappingTable = "NO";
    public static String[] suplementalLogConditionChoices = new String[]{"ON UPDATE", "ALWAYS"};
    private static Set suplementalLogConditionsSet = null;
    protected String suplementalLogColumns = "";
    protected TableProxyOracle.InlineList suplementalLogColumnSet = null;
    private String partitioned = "NO";
    private String partType = "";
    private String subpartType = "";

    public TableProxyOraclev10g(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
    }

    public TableProxyOraclev10g(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public TableProxyOracle.InlineList getSuplementalLogColumnSet() {
        if (this.suplementalLogColumnSet == null) {
            this.suplementalLogColumnSet = new TableProxyOracle.InlineList();
        }
        return this.suplementalLogColumnSet;
    }

    public void clearSuplementalLogColumns() {
        this.getSuplementalLogColumnSet().removeAllElements();
        this.suplementalLogColumns = "";
    }

    public String getSuplementalLogColumns() {
        return this.suplementalLogColumns;
    }

    public String getAllSupplementalLogColumns() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.suplementalLogColumns, ",");
        while (st.hasMoreTokens()) {
            String colID = st.nextToken().trim();
            ColumnProxy column = this.getColumnProxy(colID);
            if (column == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(column.getName());
        }
        return result.toString();
    }

    public void setSuplementalLogColumns(String col) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSuplementalLogColumnSet(col);
        } else {
            this.addSuplementalLogColumn(col);
        }
        this.suplementalLogColumns = this.getSuplementalLogColumnSet().toString();
        this.fireDataFieldChange();
    }

    private void addSuplementalLogColumn(String col) {
        this.getSuplementalLogColumnSet().add(col);
    }

    private void recreateSuplementalLogColumnSet(String col) {
        this.getSuplementalLogColumnSet().clear();
        StringTokenizer st = new StringTokenizer(col, ",");
        this.suplementalLogColumnSet = new TableProxyOracle.InlineList();
        while (st.hasMoreTokens()) {
            this.getSuplementalLogColumnSet().add(st.nextToken().trim());
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lob = (LobStorageOracle)event.getAffected();
            if (lob.getTable() == this) {
                lob.setParent(this.lobs);
                this.lobs.add(lob);
            } else {
                this.lobs.remove(lob);
            }
        } else if (event.getAffected() instanceof PartitionOraclev10g) {
            PartitionOraclev10g part = (PartitionOraclev10g)event.getAffected();
            if (part.getPartitionList() == this.partitionList && this.partitionList != null) {
                if (part.getParent() != this.partitions) {
                    part.setParent(this.partitions);
                    this.partitions.add(part);
                }
                if (part.getPosition() == 0) {
                    part.removeObjectListener(this);
                    part.setPosition(this.partitions.size());
                    part.addObjectListener(this);
                }
            }
        } else if (event.getAffected() instanceof ListStorageTemplatePartitionOraclev10g) {
            ListStorageTemplatePartitionOraclev10g storage = (ListStorageTemplatePartitionOraclev10g)event.getAffected();
            if (storage.getPartOfStorageTable() == this) {
                storage.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(storage);
            } else {
                this.listStorageTemplates.remove(storage);
            }
        } else if (event.getAffected() instanceof HashPartitionOraclev10g) {
            HashPartitionOraclev10g part = (HashPartitionOraclev10g)event.getAffected();
            if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList() && part.getPartitionList().getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                part.setParent(this.partitions);
                this.partitions.add(part);
            }
            if (part.getPartOfStorageTable() == this) {
                part.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(part);
            } else {
                this.listStorageTemplates.remove(part);
            }
        } else if (event.getAffected() instanceof ListPartitionOraclev10g) {
            ListPartitionOraclev10g part = (ListPartitionOraclev10g)event.getAffected();
            if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                part.setParent(this.partitions);
                this.partitions.add(part);
            }
        } else if (event.getAffected() instanceof BitmapJoinIndexOraclev10g) {
            BitmapJoinIndexOraclev10g ind = (BitmapJoinIndexOraclev10g)event.getAffected();
            if (ind.getTable() == this) {
                ind.setParent(this.bjIndexes);
                this.bjIndexes.add(ind);
            } else {
                this.bjIndexes.remove(ind);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lob = (LobStorageOracle)event.getAffected();
                if (lob.getTable() == this) {
                    lob.setParent(this.lobs);
                    this.lobs.add(lob);
                    lob.addObjectListener(this);
                }
            } else if (event.getAffected() instanceof PartitionOracle) {
                PartitionOracle part = (PartitionOracle)event.getAffected();
                if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                    part.setParent(this.partitions);
                    this.partitions.add(part);
                    part.removeObjectListener(this);
                    part.setPosition(this.partitions.size());
                    part.addObjectListener(this);
                }
            } else if (event.getAffected() instanceof ListStorageTemplatePartitionOraclev10g) {
                ListStorageTemplatePartitionOraclev10g storage = (ListStorageTemplatePartitionOraclev10g)event.getAffected();
                if (storage.getPartOfStorageTable() == this) {
                    storage.setParent(this.listStorageTemplates);
                    this.listStorageTemplates.add(storage);
                    storage.setPosition(this.listStorageTemplates.size());
                    storage.addObjectListener(this);
                }
            } else if (event.getAffected() instanceof HashPartitionOraclev10g) {
                HashPartitionOraclev10g part = (HashPartitionOraclev10g)event.getAffected();
                if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList() && part.getPartitionList().getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                    part.setParent(this.partitions);
                    part.setPosition(this.partitions.size());
                    part.addObjectListener(this);
                } else if (part.getPartOfStorageTable() == this) {
                    part.setParent(this.listStorageTemplates);
                    this.listStorageTemplates.add(part);
                    part.setPosition(this.listStorageTemplates.size());
                }
            } else if (event.getAffected() instanceof ListPartitionOraclev10g) {
                ListPartitionOraclev10g part = (ListPartitionOraclev10g)event.getAffected();
                if (part.getPartitionList() != null && part.getPartitionList() == this.getPartitionList()) {
                    part.setParent(this.partitions);
                    this.partitions.add(part);
                    part.setPosition(this.partitions.size());
                    part.addObjectListener(this);
                }
            } else if (event.getAffected() instanceof BitmapJoinIndexOraclev10g) {
                BitmapJoinIndexOraclev10g ind = (BitmapJoinIndexOraclev10g)event.getAffected();
                ind.addObjectListener(this);
                if (ind.getTable() == this) {
                    ind.setParent(this.bjIndexes);
                    this.bjIndexes.add(ind);
                } else {
                    this.bjIndexes.remove(ind);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lob = (LobStorageOracle)event.getAffected();
                this.lobs.remove(lob);
                lob.removeObjectListener(this);
            } else if (event.getAffected() instanceof PartitionOracle) {
                PartitionOracle part = (PartitionOracle)event.getAffected();
                if (this.partitions.remove(part)) {
                    for (int i = 0; i < this.partitions.size(); ++i) {
                        ModelObject obj = this.partitions.getElement(i);
                        if (!(obj instanceof PartitionOracle)) continue;
                        ((PartitionOracle)obj).setPosition(i + 1);
                    }
                }
                part.removeObjectListener(this);
            } else if (event.getAffected() instanceof ListStorageTemplatePartitionOraclev10g) {
                ListStorageTemplatePartitionOraclev10g storage = (ListStorageTemplatePartitionOraclev10g)event.getAffected();
                this.listStorageTemplates.remove(storage);
                storage.removeObjectListener(this);
            } else if (event.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle part = (HashPartitionOracle)event.getAffected();
                this.partitions.remove(part);
                this.listStorageTemplates.remove(part);
                part.removeObjectListener(this);
            } else if (event.getAffected() instanceof ListPartitionOraclev10g) {
                ListPartitionOraclev10g part = (ListPartitionOraclev10g)event.getAffected();
                this.partitions.remove(part);
                part.removeObjectListener(this);
            } else if (event.getAffected() instanceof BitmapJoinIndexOraclev10g) {
                BitmapJoinIndexOraclev10g ind = (BitmapJoinIndexOraclev10g)event.getAffected();
                this.bjIndexes.remove(ind);
                ind.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(TableLevelConstraint object, TableLevelConstraintEvent event) {
        if (event.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_ADDED)) {
            StorageDesignOraclev10g sd = (StorageDesignOraclev10g)this.getStorageDesign();
            TableCheckConstraintSetOraclev10g set = (TableCheckConstraintSetOraclev10g)sd.getTableCheckConstraintSet();
            set.addTableCheckConstraint(this, object);
            this.setDirty(true);
        } else if (event.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED)) {
            StorageDesignOraclev10g sd = (StorageDesignOraclev10g)this.getStorageDesign();
            TableCheckConstraintSetOraclev10g tcc = (TableCheckConstraintSetOraclev10g)sd.getTableCheckConstraintSet();
            tcc.removeTableCheckConstraint(this, object);
            this.setDirty(true);
        }
    }

    @Override
    protected void addTableCheckConstraintFromDesign(TableCheckConstraintSetOracle set) {
        for (TableCheckConstraintOracle tcc : set) {
            if (tcc.getTable() == null || tcc.getTable() != this || TableProxyOraclev10g.containsTCCWithID(this.tableCheckConstraints, tcc.getObjectID())) continue;
            tcc.setParent(this.tableCheckConstraints);
            this.tableCheckConstraints.add(tcc);
        }
        Table table = (Table)this.getObject();
        for (TableLevelConstraint constraint : table.getCheckConstraints()) {
            ((TableCheckConstraintSetOraclev10g)set).addTableCheckConstraint(this, constraint);
        }
        this.fireDataFieldChange();
    }

    @Override
    public String getIOTMappingTable() {
        return this.IOTMappingTable;
    }

    @Override
    public void setIOTMappingTable(String mappingTable) {
        this.IOTMappingTable = mappingTable;
        this.fireDataFieldChange();
    }

    public String getSuplementalLogConditions() {
        return this.suplementalLogConditions;
    }

    public void setSuplementalLogConditions(String suplementalLogConditions) {
        if (this.checkSuplementalLogConditions(suplementalLogConditions)) {
            this.suplementalLogConditions = suplementalLogConditions;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkSuplementalLogConditions(String value) {
        if (suplementalLogConditionsSet == null) {
            suplementalLogConditionsSet = new HashSet();
            suplementalLogConditionsSet.addAll(Arrays.asList(suplementalLogConditionChoices));
        }
        return suplementalLogConditionsSet.contains(value);
    }

    public String getSuplementalLogGroupName() {
        return this.suplementalLogGroupName;
    }

    public void setSuplementalLogGroupName(String suplementalLogGroupName) {
        this.suplementalLogGroupName = suplementalLogGroupName;
        this.fireDataFieldChange();
    }

    @Override
    public void setPartitionList(PartitionListOracle pList) {
        PartitionListOraclev10g partitionList = (PartitionListOraclev10g)pList;
        String newPartType = "";
        String newSubpartType = "";
        if (partitionList != null) {
            newPartType = partitionList.getPartitionType();
            if (newPartType.equalsIgnoreCase("COMPOSITE BY HASH") || newPartType.equalsIgnoreCase("COMPOSITE BY LIST")) {
                newPartType = "RANGE";
            }
            newSubpartType = partitionList.getSubpartitionType();
        }
        if (this.partitionList != null) {
            if (!this.partType.equalsIgnoreCase(newPartType)) {
                this.partitions.removeAll();
            }
            if (!this.subpartType.equalsIgnoreCase(newSubpartType)) {
                this.listStorageTemplates.removeAll();
            }
        }
        this.partType = newPartType;
        this.subpartType = newSubpartType;
        this.partitionList = partitionList;
        if (this.partitionList == null) {
            this.partitions.setForbiddenCreateElement(true);
            this.listStorageTemplates.setForbiddenCreateElement(true);
        } else {
            this.partitionList.setTable(this);
            this.partitioned = "YES";
            if (this.partType.equalsIgnoreCase("HASH BY QUANTITY")) {
                this.partitions.setForbiddenCreateElement(true);
            } else {
                this.partitions.setForbiddenCreateElement(false);
                this.partitions.setLogicalParent(partitionList);
            }
            if (this.partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getHashPartitionSet());
                this.addHashPartFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getHashPartitionSet());
            } else if (this.partType.equalsIgnoreCase("LIST")) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getListPartitionSet());
                this.addListPartFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getListPartitionSet());
            } else {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getPartitionSet());
                this.addPartFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getPartitionSet());
            }
            StorageObjectSet subPartitionStorageObjectSet = null;
            if (this.subpartType.equalsIgnoreCase("HASH")) {
                subPartitionStorageObjectSet = ((StorageDesignOraclev10g)this.getStorageDesign()).getHashPartitionSet();
            } else if (this.subpartType.equalsIgnoreCase("LIST")) {
                subPartitionStorageObjectSet = ((StorageDesignOraclev10g)this.getStorageDesign()).getListStorageTemplatePartitionSet();
            } else if (this.subpartType.equalsIgnoreCase("RANGE")) {
                subPartitionStorageObjectSet = ((StorageDesignOraclev10g)this.getStorageDesign()).getPartitionSet();
            }
            if (subPartitionStorageObjectSet != null) {
                this.listStorageTemplates.setStorageObjectSet(subPartitionStorageObjectSet);
                if ("NO".equalsIgnoreCase(partitionList.getUseSubpartStorageTemplate())) {
                    this.listStorageTemplates.setForbiddenCreateElement(true);
                } else {
                    this.listStorageTemplates.setForbiddenCreateElement(false);
                    if (this.subpartType.equalsIgnoreCase("HASH")) {
                        this.addHashPartFromDesignToTemplates(subPartitionStorageObjectSet);
                    } else if (this.subpartType.equalsIgnoreCase("LIST")) {
                        this.addStorageTemplatePartitionsFromDesign(subPartitionStorageObjectSet);
                    } else if (this.subpartType.equalsIgnoreCase("RANGE")) {
                        this.addRangePartFromDesignToTemplates(subPartitionStorageObjectSet);
                    }
                }
            } else {
                this.listStorageTemplates.setForbiddenCreateElement(true);
            }
        }
        this.fireDataFieldChange();
    }

    @Override
    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    @Override
    public void setPartitioned(String value) {
        if (!this.partitioned.equals(value) && ConstantsOracle.checkYesNo(value)) {
            this.partitioned = value;
            if (this.partitioned.equals("NO")) {
                this.setPartitionList(null);
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getPartitioned() {
        return this.partitioned;
    }

    private void addHashPartFromDesign(StorageObjectSet set) {
        for (HashPartitionOraclev10g part : set) {
            if (part.getPartitionList() == this.partitionList && this.partitionList != null) {
                part.addObjectListener(this);
                part.setParent(this.partitions);
                this.partitions.add(part);
                continue;
            }
            this.partitions.remove(part);
        }
    }

    private void addListPartFromDesign(StorageObjectSet set) {
        for (ListPartitionOraclev10g part : set) {
            if (part.getPartitionList() == this.partitionList && this.partitionList != null) {
                part.addObjectListener(this);
                part.setParent(this.partitions);
                this.partitions.add(part);
                continue;
            }
            this.partitions.remove(part);
        }
    }

    private void addStorageTemplatePartitionsFromDesign(StorageObjectSet set) {
        for (ListStorageTemplatePartitionOraclev10g storage : set) {
            if (storage.getPartOfStorageTable() == this) {
                storage.addObjectListener(this);
                storage.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(storage);
                continue;
            }
            this.listStorageTemplates.remove(storage);
        }
    }

    private void addHashPartFromDesignToTemplates(StorageObjectSet set) {
        for (HashPartitionOraclev10g hash : set) {
            if (hash.getPartOfStorageTable() == this) {
                hash.addObjectListener(this);
                hash.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(hash);
                continue;
            }
            this.listStorageTemplates.remove(hash);
        }
    }

    protected void addRangePartFromDesignToTemplates(StorageObjectSet set) {
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogOraclev10g dialog = new TablePropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Table table = (Table)targetDesign.getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxyOraclev10g tableProxy = null;
        RelationalObjectProxy storageObject = targetDesign.getTableProxySet().getProxy(table.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            tableProxy = (TableProxyOraclev10g)storageObject;
        }
        if (tableProxy != null) {
            ColumnProxy columnProxy;
            SegmentOraclev10g segment;
            AbstractStorageObjectOracle tablespace;
            tableProxy.setName(this.getName());
            for (TableCheckConstraintOraclev10g tblConstr : this.getTableCheckConstraints()) {
                TableCheckConstraintOraclev10g targetConstr = (TableCheckConstraintOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableCheckConstraintSet().getByName(tblConstr.getName());
                if (targetConstr == null) {
                    TableCheckConstraintOraclev10g newConstr = (TableCheckConstraintOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableCheckConstraintSet().createTableCheckConstraint();
                    newConstr.setName(tblConstr.getName());
                    newConstr.setRawObject(true);
                    newConstr.setTable(tableProxy);
                    tableProxy.addTableCheckConstraintFromDesign(((StorageDesignOraclev10g)targetDesign).getTableCheckConstraintSet());
                    continue;
                }
                targetConstr.setTable(tableProxy);
                tableProxy.addTableCheckConstraintFromDesign(((StorageDesignOraclev10g)targetDesign).getTableCheckConstraintSet());
            }
            for (BitmapJoinIndexOraclev10g bjIndex : this.getBjIndexes()) {
                BitmapJoinIndexOraclev10g targetBJIndex = (BitmapJoinIndexOraclev10g)((StorageDesignOraclev10g)targetDesign).getBitmapJoinIndexSet().getByName(bjIndex.getName());
                if (targetBJIndex == null) {
                    BitmapJoinIndexOraclev10g newBJIndex = (BitmapJoinIndexOraclev10g)((StorageDesignOraclev10g)targetDesign).getBitmapJoinIndexSet().createBitmapJoinIndex();
                    newBJIndex.setName(bjIndex.getName());
                    newBJIndex.setRawObject(true);
                    newBJIndex.setTable(tableProxy);
                    tableProxy.getBjIndexes().add(newBJIndex);
                    continue;
                }
                targetBJIndex.setTable(tableProxy);
                tableProxy.getBjIndexes().add(targetBJIndex);
            }
            for (LobStorageOraclev10g storage : this.getLobStorages()) {
                LobStorageOraclev10g targetStorage = (LobStorageOraclev10g)((StorageDesignOraclev10g)targetDesign).getLobStorageSet().getByName(storage.getName());
                if (targetStorage == null) {
                    LobStorageOraclev10g newStorage = (LobStorageOraclev10g)((StorageDesignOraclev10g)targetDesign).getLobStorageSet().createLobStorage();
                    newStorage.setName(storage.getName());
                    newStorage.setRawObject(true);
                    newStorage.setTable(tableProxy);
                    continue;
                }
                targetStorage.setTable(tableProxy);
            }
            for (TriggerOraclev10g trigger : this.triggers) {
                TriggerOraclev10g targetTrigger = (TriggerOraclev10g)((StorageDesignOraclev10g)targetDesign).getTriggerSet().getByName(trigger.getName());
                if (targetTrigger == null) {
                    TriggerOraclev10g newTrigger = (TriggerOraclev10g)((StorageDesignOraclev10g)targetDesign).getTriggerSet().createTrigger();
                    newTrigger.setName(trigger.getName());
                    newTrigger.setRawObject(true);
                    newTrigger.setTable(tableProxy);
                    tableProxy.addTriggersFromDesign(((StorageDesignOraclev10g)targetDesign).getTriggerSet());
                    continue;
                }
                targetTrigger.setTable(tableProxy);
                tableProxy.addTriggersFromDesign(((StorageDesignOraclev10g)targetDesign).getTriggerSet());
            }
            for (UniqueOraclev10g unKey : this.getUniqueKeys()) {
                UniqueOraclev10g targetUNKey = (UniqueOraclev10g)((StorageDesignOraclev10g)targetDesign).getUniqueSet().getByName(unKey.getName());
                if (targetUNKey == null) {
                    UniqueOraclev10g newUNKey = (UniqueOraclev10g)((UniqueSetOraclev10g)((StorageDesignOraclev10g)targetDesign).getUniqueSet()).createProxy(unKey.getObject());
                    newUNKey.setName(unKey.getName());
                    newUNKey.setRawObject(true);
                    tableProxy.addIndProxiesFromDesign(((StorageDesignOraclev10g)targetDesign).getUniqueSet());
                    continue;
                }
                tableProxy.addIndProxiesFromDesign(((StorageDesignOraclev10g)targetDesign).getUniqueSet());
            }
            if (this.getUser() != null) {
                UserOraclev10g user = (UserOraclev10g)((StorageDesignOraclev10g)targetDesign).getUserSet().getByName(this.getUser().getName());
                if (user == null) {
                    UserOraclev10g newUser = (UserOraclev10g)((StorageDesignOraclev10g)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getUser().getName());
                    newUser.setRawObject(true);
                    tableProxy.setUser(newUser);
                } else {
                    tableProxy.setUser(user);
                }
            }
            tableProxy.setTemporary(this.getTemporary());
            tableProxy.setTemporaryChanged(this.isTemporaryChanged());
            tableProxy.setTempPreserveRows(this.getTempPreserveRows());
            if (this.getTableSpace() != null) {
                tablespace = (TableSpaceOracle)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tablespace == null) {
                    tablespace = ((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)tablespace).setName(this.getTableSpace().getName());
                    tablespace.setRawObject(true);
                }
                tableProxy.setTableSpace((TableSpaceOracle)tablespace);
            }
            if (this.getTemporaryTablespace() != null) {
                tablespace = (TemporaryTablespaceOracle)((StorageDesignOraclev10g)targetDesign).getTemporaryTablespaceSet().getByName(this.getTemporaryTablespace().getName());
                if (tablespace == null) {
                    tablespace = ((StorageDesignOraclev10g)targetDesign).getTemporaryTablespaceSet().createTemporaryTablespace();
                    tablespace.setName(this.getTemporaryTablespace().getName());
                    tablespace.setRawObject(true);
                }
                tableProxy.setTemporaryTablespace((TemporaryTablespaceOracle)tablespace);
            }
            tableProxy.setOrganization(this.getOrganization());
            if (this.getCluster() != null) {
                ClusterOraclev10g cluster = (ClusterOraclev10g)((StorageDesignOraclev10g)targetDesign).getClusterSet().getByName(this.getCluster().getName());
                if (cluster == null) {
                    ClusterOraclev10g newCluster = (ClusterOraclev10g)((StorageDesignOraclev10g)targetDesign).getClusterSet().createCluster();
                    newCluster.setName(this.getCluster().getName());
                    newCluster.setRawObject(true);
                    tableProxy.setCluster(newCluster);
                } else {
                    tableProxy.setCluster(cluster);
                }
            }
            tableProxy.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                segment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (segment == null) {
                    SegmentOraclev10g newSegment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getSegment().getName());
                    newSegment.setRawObject(true);
                    tableProxy.setSegment(newSegment);
                } else {
                    tableProxy.setSegment(segment);
                }
            }
            tableProxy.setCache(this.getCache());
            tableProxy.setMonitoring(this.getMonitoring());
            tableProxy.setParallel(this.getParallel());
            tableProxy.setDegree(this.getDegree());
            tableProxy.setRowDependency(this.getRowDependency());
            tableProxy.setPartitioned(this.getPartitioned());
            tableProxy.setParttitionedRowMovement(this.getParttitionedRowMovement());
            tableProxy.setDataSegmentCompression(this.getDataSegmentCompression());
            if (this.getSnapshot() != null) {
                SnapshotOraclev10g snapshot = (SnapshotOraclev10g)((StorageDesignOraclev10g)targetDesign).getSnapshotSet().getByName(this.getSnapshot().getName());
                if (snapshot == null) {
                    SnapshotOraclev10g newSnapshot = (SnapshotOraclev10g)((StorageDesignOraclev10g)targetDesign).getSnapshotSet().createSnapshot();
                    newSnapshot.setName(this.getSnapshot().getName());
                    newSnapshot.setRawObject(true);
                    tableProxy.setSnapshot(newSnapshot);
                } else {
                    tableProxy.setSnapshot(snapshot);
                }
            }
            tableProxy.setIotCompress(this.getIotCompress());
            tableProxy.setIotPctThreshold(this.getIotPctThreshold());
            if (this.getIotIncluding() != null && (columnProxy = tableProxy.getColumnProxyByName(this.getIotIncluding().getName())) != null) {
                tableProxy.setIotIncluding(columnProxy);
            }
            tableProxy.setIotOverflowTablespace(this.getIotOverflowTablespace());
            tableProxy.setIotOverflowLogging(this.getIotOverflowLogging());
            if (this.getIotOverflowSegment() != null) {
                segment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().getByName(this.getIotOverflowSegment().getName());
                if (segment == null) {
                    segment = (SegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getSegmentSet().createSegment();
                    segment.setName(this.getIotOverflowSegment().getName());
                    segment.setRawObject(true);
                }
                tableProxy.setIotOverflowSegment(segment);
            }
            tableProxy.setIOTMappingTable(this.getIOTMappingTable());
            tableProxy.recreateColumnsSet(this.getClusterColumnsSet().toString());
            if (this.getPartitionList() != null) {
                PartitionListOraclev10g partList = (PartitionListOraclev10g)((StorageDesignOraclev10g)targetDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (partList == null) {
                    PartitionListOraclev10g newPartList = (PartitionListOraclev10g)((StorageDesignOraclev10g)targetDesign).getPartitionListSet().createPartitionList();
                    newPartList.setName(this.getPartitionList().getName());
                    newPartList.setRawObject(true);
                    tableProxy.setPartitionList(newPartList);
                } else {
                    tableProxy.setPartitionList(partList);
                }
            }
            tableProxy.setComment(this.getComment());
            tableProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxy.setRawObject(false);
        }
    }
}

