/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.ComplexPropertyWrapper;
import oracle.dbtools.crest.util.propertymap.CopyInSD_RelatedObjectsWrapper;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public abstract class TableProxyOracle
extends TableProxy
implements ModelObjectSetListener,
StorageObjectListener,
PropertiesPropagator,
OwnedObjectOracle {
    public static final String CLOB = "CLOB";
    public static final String OBJECT_RELATIONAL = "OBJECT RELATIONAL";
    public static final String ENABLE = "ENABLE";
    public static final String DISABLE = "DISABLE";
    public static final String RETENTION = "RETENTION";
    public static final String PCT_VERSION = "PCT_VERSION";
    private static final String[] STORE_AS_CHOICES = new String[]{"CLOB", "OBJECT RELATIONAL"};
    public static final String ORGANIZATION_HEAP = "HEAP";
    public static final String ORGANIZATION_INDEX = "INDEX";
    public static final String ORGANIZATION_EXTERNAL = "EXTERNAL";
    public static final String[] ORGANIZATION = new String[]{"HEAP", "INDEX", "EXTERNAL"};
    public static final String[] PARTITIONED_ROW_MOVEMENT = new String[]{"ENABLE", "DISABLE"};
    public static final String BIG_DATA_ROW_PROCESSING_JAVA = "java";
    public static final String BIG_DATA_ROW_PROCESSING_C = "c";
    public static final String BIG_DATA_ROW_PROCESSING_AUTOMATIC = "automatic";
    public static final String[] BIG_DATA_ROW_PROCESSING_OPTIONS = new String[]{"java", "c", "automatic"};
    private String bigDataRowProcessing = "automatic";
    private static List organizationList = Arrays.asList(ORGANIZATION);
    private static List partRowMovementList = Arrays.asList(PARTITIONED_ROW_MOVEMENT);
    private static Set organizationSet = null;
    private static Set partitionedRowMovementSet = null;
    private static Set storeAsSet = null;
    private static final String[] STORAGE_IN_ROW_CHOICES = new String[]{"ENABLE", "DISABLE"};
    private static final String[] XMLTYPE_CACHE_CHOICES = new String[]{"CACHE", "NOCACHE", "CACHE READS"};
    private static Set xmlTypeCacheSet = null;
    private static final String[] OLD_VERSIONS = new String[]{"RETENTION", "PCT_VERSION"};
    private static Set oldVersionSet = null;
    private InlineList clusterColumnsSet = null;
    private UserOracle user = null;
    private String temporary = "NO";
    private boolean temporaryChanged = false;
    private String tempPreserveRows = "YES";
    private TableSpaceOracle tableSpace = null;
    private TemporaryTablespaceOracle tempTablespace = null;
    private String organization = ORGANIZATION[0];
    private ClusterOracle cluster = null;
    private String clusterColumns = "";
    private String logging = "YES";
    private SegmentOracle segment = null;
    private String cache = "NO";
    private String monitoring = "NO";
    private String parallel = "NO";
    private String degree = "";
    private String rowDependency = "NO";
    protected PartitionListOracle partitionList = null;
    private String partitionedRowMovement = "DISABLE";
    private int iotCompress = 0;
    private int iotPctThreshold = 0;
    private ColumnProxy iotIncluding = null;
    private TableSpaceOracle iotOverflowTablespace = null;
    private String iotOverflowLogging = "";
    private SegmentOracle iotOverflowSegment = null;
    private String dataSegmentCompression = "NO";
    protected String storeAs = STORE_AS_CHOICES[0];
    private String xmlSchemaUrl = "";
    private String xmlSchemaElement = "";
    private String lobSegmentName = "";
    private TableSpaceOracle xmlTypeTableSpace = null;
    private String storageInRow = "ENABLE";
    protected String xmlTypeLogging = "";
    private String xmlTypeCache = XMLTYPE_CACHE_CHOICES[1];
    private int chunk = 0;
    private String oldVersions = "RETENTION";
    private int pctVersion = 0;
    private int freepools = 0;
    protected StorageObjectCollection fkeys;
    protected StorageObjectCollection pkeys;
    protected StorageObjectCollection ukeys;
    protected StorageObjectCollection tableCheckConstraints;
    protected StorageObjectCollection triggers;
    protected StorageObjectCollection synonyms;
    protected StorageObjectCollection partitions;
    protected StorageObjectCollection lobs;
    protected StorageObjectCollection listStorageTemplates;
    protected StorageObjectCollection bjIndexes;
    private SnapshotOracle snapshot = null;
    private String oidIndexName = "";
    private SegmentOracle oidIndexSegment;
    protected String accessDriverType = "oracle_loader";
    protected DirectoryOracle defaultDir;
    public static final String OPAQUE_FORMAT_SPEC = "Opaque Format Spec";
    public static final String CLOB_SUBQUERY = "CLOB Subquery";
    protected String accessParametersType = "Opaque Format Spec";
    private static final String[] accessParametersChoices = new String[]{"Opaque Format Spec", "CLOB Subquery", "NONE"};
    private static Set accessParametersSet = null;
    protected String opaqueFormatSpec = "";
    protected String clobSubquery = "";
    protected String location = "";
    private String fromExternalTableID;
    protected String rejectLimit = "";
    private boolean materializedQueryTable;
    protected List propertyWrapperList = null;
    final int numbChildren = 12;

    public TableProxyOracle(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.initStorageObjects((StorageDesignOracle)storageDesign);
    }

    public TableProxyOracle(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.initStorageObjects((StorageDesignOracle)storageDesign);
    }

    private void initStorageObjects(StorageDesignOracle storageDesign) {
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyOracle.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.pkeys = new StorageObjectCollection();
        this.pkeys.setParent(this);
        this.pkeys.setName(Messages.getString("TableProxyOracle.PrimaryKeys"));
        this.pkeys.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON", 16));
        this.ukeys = new StorageObjectCollection();
        this.ukeys.setParent(this);
        this.ukeys.setName(Messages.getString("TableProxyOracle.UniqueKeys"));
        this.ukeys.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        this.addIndProxiesFromDesign(storageDesign.getFKProxySet());
        storageDesign.getFKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(storageDesign.getPKProxySet());
        storageDesign.getPKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(storageDesign.getUniqueSet());
        storageDesign.getUniqueSet().addSetListener(this);
        this.triggers = new StorageObjectCollection();
        this.triggers.setStorageObjectSet(storageDesign.getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableProxyOracle.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        this.addTriggersFromDesign(storageDesign.getTriggerSet());
        this.synonyms = new StorageObjectCollection();
        this.synonyms.setStorageObjectSet(storageDesign.getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(TableProxyOracle.class);
        this.synonyms.setSetMethod("setTable");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        storageDesign.getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(storageDesign.getSynonymSet());
        this.bjIndexes = new StorageObjectCollection(storageDesign.getBitmapJoinIndexSet());
        this.bjIndexes.setParent(this);
        this.bjIndexes.setName(Messages.getString("TableProxyOracle.BitmapJoinIndexes"));
        this.bjIndexes.setClassForParent(TableProxyOracle.class);
        this.bjIndexes.setSetMethod("setTable");
        this.bjIndexes.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        storageDesign.getBitmapJoinIndexSet().addSetListener(this);
        this.addBJIFromDesign(storageDesign.getBitmapJoinIndexSet());
        this.partitions = new StorageObjectCollection();
        this.partitions.setParent(this);
        this.partitions.setStorageObjectSet(storageDesign.getPartitionSet());
        this.partitions.setName(Messages.getString("TableProxyOracle.Partitions"));
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.setClassForParent(PartitionListOracle.class);
        this.partitions.setSetMethod("setPartitionList");
        this.partitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        this.listStorageTemplates = new StorageObjectCollection(storageDesign.getListStorageTemplatePartitionSet());
        this.listStorageTemplates.setParent(this);
        this.listStorageTemplates.setName(Messages.getString("TableProxyOracle.SubpartitionTemplates"));
        this.listStorageTemplates.setForbiddenCreateElement(true);
        this.listStorageTemplates.setClassForParent(TableProxyOracle.class);
        this.listStorageTemplates.setSetMethod("setPartOfStorageTable");
        this.listStorageTemplates.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesign.getListStorageTemplatePartitionSet().addSetListener(this);
        this.lobs = new StorageObjectCollection();
        this.lobs.setParent(this);
        this.lobs.setStorageObjectSet(storageDesign.getLobStorageSet());
        this.lobs.setName(Messages.getString("TableProxyOracle.LobStorages"));
        this.lobs.setClassForParent(TableProxyOracle.class);
        this.lobs.setSetMethod("setTable");
        this.tableCheckConstraints = new StorageObjectCollection();
        this.tableCheckConstraints.setParent(this);
        this.tableCheckConstraints.setName(Messages.getString("TableProxyOracle.TableCheckConstraints"));
        this.tableCheckConstraints.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON", 16));
        this.addTableCheckConstraintFromDesign(storageDesign.getTableCheckConstraintSet());
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        this.tableSpace = tableSpace;
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setTemporaryTablespace(TemporaryTablespaceOracle tempTablespace) {
        this.tempTablespace = tempTablespace;
        this.fireDataFieldChange();
    }

    public TemporaryTablespaceOracle getTemporaryTablespace() {
        return this.tempTablespace;
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        try {
            this.user = user;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTemporary(String temporary) {
        String tableTemp;
        Table table = (Table)this.getObject();
        String string = tableTemp = table != null && "5".equals(table.getTypeID()) ? "YES" : "NO";
        if (tableTemp.equals(temporary)) {
            this.temporaryChanged = false;
        } else if (ConstantsOracle.checkYesNo(temporary)) {
            this.temporaryChanged = true;
            this.temporary = temporary;
        }
        this.fireDataFieldChange();
    }

    public String getTemporary() {
        if (!this.temporaryChanged) {
            Table table = (Table)this.getObject();
            return table != null && "5".equals(table.getTypeID()) ? "YES" : "NO";
        }
        return this.temporary;
    }

    public boolean isTemporaryChanged() {
        return this.temporaryChanged;
    }

    public void setTemporaryChanged(boolean temporaryChanged) {
        this.temporaryChanged = temporaryChanged;
    }

    public void setTempPreserveRows(String tempPreserveRows) {
        if (ConstantsOracle.checkYesNo(tempPreserveRows)) {
            this.tempPreserveRows = tempPreserveRows;
            this.fireDataFieldChange();
        }
    }

    public String getTempPreserveRows() {
        return this.tempPreserveRows;
    }

    public static String[] getOrganizationChoices() {
        return ORGANIZATION;
    }

    protected boolean checkOrganization(String value) {
        if (organizationSet == null) {
            organizationSet = new HashSet();
            organizationSet.addAll(Arrays.asList(TableProxyOracle.getOrganizationChoices()));
        }
        return organizationSet.contains(value);
    }

    public void setOrganization(String organization) {
        if (this.checkOrganization(organization)) {
            this.organization = organization;
            this.fireDataFieldChange();
        }
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setCluster(ClusterOracle cluster) {
        this.cluster = cluster;
        this.fireDataFieldChange();
    }

    public ClusterOracle getCluster() {
        return this.cluster;
    }

    public InlineList getClusterColumnsSet() {
        if (this.clusterColumnsSet == null) {
            this.clusterColumnsSet = new InlineList();
        }
        return this.clusterColumnsSet;
    }

    private void addColumn(String clusterColumnID) {
        if (!this.getClusterColumnsSet().contains(clusterColumnID)) {
            this.getClusterColumnsSet().add(clusterColumnID);
        }
    }

    private boolean isTableColumn(String clusterColumnID) {
        ColumnProxy[] cols = this.getColumnProxies();
        for (int i = 0; i < cols.length; ++i) {
            if (!clusterColumnID.equalsIgnoreCase(cols[i].getObjectID())) continue;
            return true;
        }
        return false;
    }

    protected void recreateColumnsSet(String cols) {
        this.getClusterColumnsSet().clear();
        StringTokenizer st = new StringTokenizer(cols, ",");
        while (st.hasMoreTokens()) {
            this.getClusterColumnsSet().add(st.nextToken().trim());
        }
    }

    public void setClusterColumns(String clusterColumn) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnsSet(clusterColumn);
        } else if (this.isTableColumn(clusterColumn)) {
            this.addColumn(clusterColumn);
        }
        this.clusterColumns = this.getClusterColumnsSet().toString();
        this.fireDataFieldChange();
    }

    public String getClusterColumns() {
        return this.clusterColumns;
    }

    public String getAllClusterColumns() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.clusterColumns, ",");
        while (st.hasMoreTokens()) {
            String colID = st.nextToken().trim();
            ColumnProxy column = this.getColumnProxy(colID);
            if (column == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(column.getName());
        }
        return result.toString();
    }

    public void setLogging(String value) {
        if (!this.logging.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.logging = value;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public void setDataSegmentCompression(String dataSegmentCompression) {
        if (ConstantsOracle.checkYesNo(dataSegmentCompression)) {
            this.dataSegmentCompression = dataSegmentCompression;
            this.fireDataFieldChange();
        }
    }

    public String getDataSegmentCompression() {
        return this.dataSegmentCompression;
    }

    public static String[] getStoreAsValues() {
        return STORE_AS_CHOICES;
    }

    protected boolean checkStoreAs(String value) {
        if (storeAsSet == null) {
            storeAsSet = new HashSet();
            storeAsSet.addAll(Arrays.asList(TableProxyOracle.getStoreAsValues()));
        }
        return storeAsSet.contains(value);
    }

    public String getStoreAs() {
        return this.storeAs;
    }

    public void setStoreAs(String storeAs) {
        if (this.checkStoreAs(storeAs)) {
            this.storeAs = storeAs;
            this.fireDataFieldChange();
        }
    }

    public String getXmlSchemaElement() {
        return this.xmlSchemaElement;
    }

    public void setXmlSchemaElement(String xmlSchemaElement) {
        this.xmlSchemaElement = xmlSchemaElement;
        this.fireDataFieldChange();
    }

    public String getXmlSchemaUrl() {
        return this.xmlSchemaUrl;
    }

    public void setXmlSchemaUrl(String xmlSchemaUrl) {
        this.xmlSchemaUrl = xmlSchemaUrl;
        this.fireDataFieldChange();
    }

    public String getLobSegmentName() {
        return this.lobSegmentName;
    }

    public void setLobSegmentName(String lobSegmentName) {
        this.lobSegmentName = lobSegmentName;
    }

    public void setXmlTypeTableSpace(TableSpaceOracle xmlTypeTableSpace) {
        this.xmlTypeTableSpace = xmlTypeTableSpace;
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getXmlTypeTableSpace() {
        return this.xmlTypeTableSpace;
    }

    public String getStorageInRow() {
        return this.storageInRow;
    }

    public void setStorageInRow(String storageInRow) {
        if (this.checkStorageInRow(storageInRow)) {
            this.storageInRow = storageInRow;
            this.fireDataFieldChange();
        }
    }

    public static String[] getStorageInRowValues() {
        return STORAGE_IN_ROW_CHOICES;
    }

    private boolean checkStorageInRow(String value) {
        return this.checkParttitionedRowMovement(value);
    }

    public void setXmlTypeLogging(String value) {
        if (!this.xmlTypeLogging.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.xmlTypeLogging = value;
            this.fireDataFieldChange();
        }
    }

    public String getXmlTypeLogging() {
        return this.xmlTypeLogging;
    }

    public String getXmlTypeCache() {
        return this.xmlTypeCache;
    }

    public void setXmlTypeCache(String xmlTypeCache) {
        if (this.checkXmlTypeCache(xmlTypeCache)) {
            this.xmlTypeCache = xmlTypeCache;
            this.fireDataFieldChange();
        }
    }

    public static String[] getXmlTypeCacheValues() {
        return XMLTYPE_CACHE_CHOICES;
    }

    protected boolean checkXmlTypeCache(String value) {
        if (xmlTypeCacheSet == null) {
            xmlTypeCacheSet = new HashSet();
            xmlTypeCacheSet.addAll(Arrays.asList(TableProxyOracle.getXmlTypeCacheValues()));
        }
        return xmlTypeCacheSet.contains(value);
    }

    public int getChunk() {
        return this.chunk;
    }

    public void setChunk(int chunk) {
        this.chunk = chunk;
    }

    public static String[] getOldVersionChoices() {
        return OLD_VERSIONS;
    }

    private boolean checkOldVersion(String value) {
        if (oldVersionSet == null) {
            oldVersionSet = new HashSet();
            oldVersionSet.addAll(Arrays.asList(TableProxyOracle.getOldVersionChoices()));
        }
        return oldVersionSet.contains(value);
    }

    public String getOldVersions() {
        return this.oldVersions;
    }

    public void setOldVersions(String oldVersions) {
        if (this.checkOldVersion(oldVersions)) {
            this.oldVersions = oldVersions;
            this.fireDataFieldChange();
        }
    }

    public int getPCTVersion() {
        return this.pctVersion;
    }

    public void setPCTVersion(int pctVersion) {
        this.pctVersion = pctVersion;
    }

    public int getFreepools() {
        return this.freepools;
    }

    public void setFreepools(int freepools) {
        this.freepools = freepools;
    }

    public void setSegment(SegmentOracle segment) {
        this.segment = segment;
        this.fireDataFieldChange();
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setCache(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.cache = value;
            this.fireDataFieldChange();
        }
    }

    public String getCache() {
        return this.cache;
    }

    public void setMonitoring(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.monitoring = value;
            this.fireDataFieldChange();
        }
    }

    public String getMonitoring() {
        return this.monitoring;
    }

    public void setParallel(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.parallel = value;
            this.fireDataFieldChange();
        }
    }

    public String getParallel() {
        return this.parallel;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        block5: {
            if (!"".equalsIgnoreCase(degree)) {
                try {
                    int intVal = Integer.parseInt(degree);
                    if (intVal > 0) {
                        this.degree = degree;
                        break block5;
                    }
                    this.degree = "";
                }
                catch (NumberFormatException e) {
                    this.degree = "";
                }
            } else {
                this.degree = "";
            }
        }
        this.fireDataFieldChange();
    }

    public void setRowDependency(String rowDependency) {
        if (ConstantsOracle.checkYesNo(rowDependency)) {
            this.rowDependency = rowDependency;
            this.fireDataFieldChange();
        }
    }

    public String getRowDependency() {
        return this.rowDependency;
    }

    public abstract void setPartitioned(String var1);

    public abstract String getPartitioned();

    public void disableListStorageTemplates() {
        this.listStorageTemplates.setForbiddenCreateElement(true);
        this.listStorageTemplates.removeAll();
    }

    public void enableListStorageTemplates() {
        this.listStorageTemplates.setForbiddenCreateElement(false);
    }

    public abstract void setPartitionList(PartitionListOracle var1);

    public abstract PartitionListOracle getPartitionList();

    public static String[] getParttitionedRowMovementChoices() {
        return PARTITIONED_ROW_MOVEMENT;
    }

    protected boolean checkParttitionedRowMovement(String value) {
        if (partitionedRowMovementSet == null) {
            partitionedRowMovementSet = new HashSet();
            partitionedRowMovementSet.addAll(Arrays.asList(TableProxyOracle.getParttitionedRowMovementChoices()));
        }
        return partitionedRowMovementSet.contains(value);
    }

    public void setParttitionedRowMovement(String partitionedRowMovement) {
        if (this.checkParttitionedRowMovement(partitionedRowMovement)) {
            this.partitionedRowMovement = partitionedRowMovement;
            this.fireDataFieldChange();
        }
    }

    public String getParttitionedRowMovement() {
        return this.partitionedRowMovement;
    }

    public void setIotCompress(int iotCompress) {
        this.iotCompress = iotCompress;
        this.fireDataFieldChange();
    }

    public int getIotCompress() {
        return this.iotCompress;
    }

    public void setIotPctThreshold(int iotPctThreshold) {
        if (iotPctThreshold >= 0 && iotPctThreshold <= 50) {
            this.iotPctThreshold = iotPctThreshold;
            this.fireDataFieldChange();
        }
    }

    public int getIotPctThreshold() {
        return this.iotPctThreshold;
    }

    public void setIotIncluding(ColumnProxy iotIncluding) {
        this.iotIncluding = iotIncluding;
        this.fireDataFieldChange();
    }

    public ColumnProxy getIotIncluding() {
        return this.iotIncluding;
    }

    public void setIotOverflowTablespace(TableSpaceOracle tablespace) {
        this.iotOverflowTablespace = tablespace;
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getIotOverflowTablespace() {
        return this.iotOverflowTablespace;
    }

    public void setIotOverflowLogging(String value) {
        if (!this.iotOverflowLogging.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.iotOverflowLogging = value;
            this.fireDataFieldChange();
        }
    }

    public String getIotOverflowLogging() {
        return this.iotOverflowLogging;
    }

    public void setIotOverflowSegment(SegmentOracle iotOverflowSegment) {
        this.iotOverflowSegment = iotOverflowSegment;
        this.fireDataFieldChange();
    }

    public SegmentOracle getIotOverflowSegment() {
        return this.iotOverflowSegment;
    }

    public abstract void setIOTMappingTable(String var1);

    public abstract String getIOTMappingTable();

    public static List getOrganizationValues() {
        return organizationList;
    }

    public static List getPartitionedRowMovementsValues() {
        return partRowMovementList;
    }

    @Override
    public String getLongName() {
        UserOracle user = this.getUser();
        if (user != null) {
            return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
        }
        Table table = (Table)this.getObject();
        SchemaObject so = table.getSchemaObject();
        if (so != null) {
            user = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(so);
            if (user != null) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public String getOwnerName() {
        UserOracle user = this.getUser();
        if (user != null) {
            return user.getLongName();
        }
        Table table = (Table)this.getObject();
        SchemaObject so = table.getSchemaObject();
        if (so != null) {
            user = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(so);
            if (user != null) {
                return user.getLongName();
            }
            if (!this.getStorageDesign().isOpen()) {
                return so.getLongName();
            }
        }
        return " ";
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    @Override
    public int getNumberOfChildren() {
        return 12;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == 11) {
            return this.synonyms;
        }
        if (index == 10) {
            return this.partitions;
        }
        if (index == 9) {
            return this.listStorageTemplates;
        }
        if (index == 8) {
            return this.lobs;
        }
        if (index == 7) {
            return this.fkeys;
        }
        if (index == 6) {
            return this.ukeys;
        }
        if (index == 5) {
            return this.pkeys;
        }
        if (index == 4) {
            return this.triggers;
        }
        if (index == 3) {
            return this.bjIndexes;
        }
        if (index == 2) {
            return this.tableCheckConstraints;
        }
        return super.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.synonyms) {
            return 11;
        }
        if (child == this.partitions) {
            return 10;
        }
        if (child == this.listStorageTemplates) {
            return 9;
        }
        if (child == this.lobs) {
            return 8;
        }
        if (child == this.fkeys) {
            return 7;
        }
        if (child == this.ukeys) {
            return 6;
        }
        if (child == this.pkeys) {
            return 5;
        }
        if (child == this.triggers) {
            return 4;
        }
        if (child == this.bjIndexes) {
            return 3;
        }
        if (child == this.tableCheckConstraints) {
            return 2;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.synonyms) {
            return 11;
        }
        if (child == this.partitions) {
            return 10;
        }
        if (child == this.listStorageTemplates) {
            return 9;
        }
        if (child == this.lobs) {
            return 8;
        }
        if (child == this.fkeys) {
            return 7;
        }
        if (child == this.ukeys) {
            return 6;
        }
        if (child == this.pkeys) {
            return 5;
        }
        if (child == this.triggers) {
            return 4;
        }
        if (child == this.bjIndexes) {
            return 3;
        }
        if (child == this.tableCheckConstraints) {
            return 2;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof IndexProxy) {
                IndexProxy ip = (IndexProxy)event.getAffected();
                Index ind = (Index)ip.getObject();
                if (this.getObject() == ind.getContainerWithKeyObject()) {
                    if (ind.isFK() && !this.fkeys.contains(ip)) {
                        ip.setParent(this.fkeys);
                        this.fkeys.add(ip);
                    } else if (ind.isPK() && !this.pkeys.contains(ip)) {
                        ip.setParent(this.pkeys);
                        this.pkeys.add(ip);
                    } else if (ind.isUnique() && !this.ukeys.contains(ip)) {
                        ip.setParent(this.ukeys);
                        this.ukeys.add(ip);
                    } else if (!this.indexes.contains(ip)) {
                        ip.setParent(this.indexes);
                        this.indexes.add(event.getAffected());
                    }
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof IndexProxy) {
            Index index;
            IndexProxy ip = (IndexProxy)event.getAffected();
            if (this.indexes.contains(ip)) {
                this.indexes.remove(event.getAffected());
            }
            if (this.fkeys.contains(ip)) {
                this.fkeys.remove(event.getAffected());
            }
            if ((index = (Index)ip.getObject()).isPK()) {
                this.pkeys.remove(event.getAffected());
            }
            if (index.isUnique()) {
                this.ukeys.remove(event.getAffected());
            }
        }
    }

    public void addIndProxiesFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            IndexProxy ip = (IndexProxy)it.next();
            Index ind = (Index)ip.getObject();
            if (this.getObject() != ind.getContainerWithKeyObject()) continue;
            if (ind.isFK()) {
                ip.setParent(this.fkeys);
                this.fkeys.add(ip);
                continue;
            }
            if (ind.isPK()) {
                ip.setParent(this.pkeys);
                this.pkeys.add(ip);
                continue;
            }
            if (!ind.isUnique()) continue;
            ip.setParent(this.ukeys);
            this.ukeys.add(ip);
        }
    }

    protected void addBJIFromDesign(StorageObjectSet set) {
        for (BitmapJoinIndexOracle ind : set) {
            if (ind.getTable() == this) {
                ind.addObjectListener(this);
                ind.setParent(this.bjIndexes);
                this.bjIndexes.add(ind);
                continue;
            }
            this.bjIndexes.remove(ind);
        }
    }

    protected abstract void addTableCheckConstraintFromDesign(TableCheckConstraintSetOracle var1);

    protected void addPartFromDesign(StorageObjectSet set) {
        for (PartitionOracle part : set) {
            if (part.getPartitionList() == this.partitionList && this.partitionList != null) {
                part.addObjectListener(this);
                part.setParent(this.partitions);
                this.partitions.add(part);
                continue;
            }
            this.partitions.remove(part);
        }
    }

    public void addTriggersFromDesign(StorageObjectSet set) {
        for (TriggerOracle trigger : set) {
            if (trigger.getTable() == this) {
                trigger.setParent(this.triggers);
                this.triggers.add(trigger);
                continue;
            }
            this.triggers.remove(trigger);
        }
    }

    public void clear() {
        this.getClusterColumnsSet().clear();
        this.clusterColumns = "";
    }

    public StorageObjectCollection getPrimaryKeys() {
        return this.pkeys;
    }

    public StorageObjectCollection getUniqueKeys() {
        return this.ukeys;
    }

    public StorageObjectCollection getLobStorages() {
        return this.lobs;
    }

    public StorageObjectCollection getPartitions() {
        return this.partitions;
    }

    @Override
    public StorageObject getUserSchema() {
        return this.getUser();
    }

    public SnapshotOracle getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(SnapshotOracle snapshot) {
        this.snapshot = snapshot;
        this.fireDataFieldChange();
    }

    public SegmentOracle getOidIndexSegment() {
        return this.oidIndexSegment;
    }

    public void setOidIndexSegment(SegmentOracle oidIndexSegment) {
        this.oidIndexSegment = oidIndexSegment;
        this.fireDataFieldChange();
    }

    public String getOidType() {
        Table table = (Table)this.getObject();
        if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
            return Messages.getString("TableProxyOracle.BasedOnPK");
        }
        return Messages.getString("TableProxyOracle.SystemGenerated");
    }

    public String getOidIndexName() {
        return this.oidIndexName;
    }

    public void setOidIndexName(String oidIndexName) {
        this.oidIndexName = oidIndexName;
        this.fireDataFieldChange();
    }

    public String getBasedOnStructuredType() {
        if (((Table)this.getObject()).getBasedOnStructuredType() == null) {
            return "";
        }
        return ((Table)this.getObject()).getBasedOnStructuredType().getName();
    }

    public TableCheckConstraintOracle getTableConstraint(TableLevelConstraint constraint) {
        for (TableCheckConstraintOracle check : this.tableCheckConstraints) {
            if (check.getTableConstraint() != constraint) continue;
            return check;
        }
        return null;
    }

    @Override
    public void setUserSchema(String schema) {
        if (schema != null) {
            UserOracle user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(schema);
            if (user == null) {
                user = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().createUser();
                user.setName(schema);
            }
            if (user != null) {
                this.setUser(user);
            }
        }
    }

    public StorageObjectCollection getFKeys() {
        return this.fkeys;
    }

    @Override
    public boolean isUnload() {
        ColumnProxy[] columns = this.getColumnProxies();
        for (int i = 0; i < columns.length; ++i) {
            ColumnProxy cpo = columns[i];
            Datatype datatype = cpo.getDataType();
            if (datatype instanceof StructuredType || datatype instanceof CollectionType) {
                return false;
            }
            String datatypeName = datatype.getName();
            if (datatypeName.equalsIgnoreCase("LONG") || datatypeName.equalsIgnoreCase("LONG RAW")) {
                return false;
            }
            if (!(this instanceof TableProxyOraclev9i) || !datatypeName.equalsIgnoreCase("BLOB") && !datatypeName.equalsIgnoreCase(CLOB) && !datatypeName.equalsIgnoreCase("NCLOB") && !datatypeName.equalsIgnoreCase("XMLTYPE")) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnloadPerPartition() {
        return this.getPartitioned().equals("YES");
    }

    @Override
    public void addObject(StorageObject sto) {
        if (sto instanceof TableCheckConstraintOracle) {
            TableCheckConstraintOracle check = (TableCheckConstraintOracle)sto;
            if (check.getTable() != null && check.getTable() == this) {
                check.setParent(this.tableCheckConstraints);
                this.removeExisting(check);
                this.tableCheckConstraints.add(check);
            }
        } else if (sto instanceof TriggerOracle) {
            TriggerOracle tr = (TriggerOracle)sto;
            if (tr.getTable() != null && tr.getTable() == this) {
                tr.setParent(this.triggers);
                this.triggers.add(tr);
            }
        } else if (sto instanceof PartitionOracle || sto instanceof HashPartitionOracle || sto instanceof ListPartitionOracle) {
            sto.addObjectListener(this);
            sto.setParent(this.partitions);
            this.partitions.add(sto);
            if (sto instanceof PartitionOracle) {
                if (((PartitionOracle)sto).getPosition() == 0) {
                    ((PartitionOracle)sto).setPosition(this.partitions.size());
                }
            } else if (sto instanceof ListPartitionOracle) {
                if (((ListPartitionOracle)sto).getPosition() == 0) {
                    ((ListPartitionOracle)sto).setPosition(this.partitions.size());
                }
            } else if (sto instanceof HashPartitionOracle && ((HashPartitionOracle)sto).getPosition() == 0) {
                ((HashPartitionOracle)sto).setPosition(this.partitions.size());
            }
        } else if (sto instanceof LobStorageOracle) {
            sto.setParent(this.lobs);
            this.lobs.add(sto);
        }
        super.addObject(sto);
    }

    @Override
    public void removeObject(StorageObject sto) {
        if (sto instanceof TableCheckConstraintOracle) {
            TableCheckConstraintOracle check = (TableCheckConstraintOracle)sto;
            this.tableCheckConstraints.remove(check);
        } else if (sto instanceof TriggerOracle) {
            TriggerOracle tr = (TriggerOracle)sto;
            this.triggers.justRemove(tr);
        } else if (sto instanceof PartitionOracle || sto instanceof HashPartitionOracle || sto instanceof ListPartitionOracle) {
            this.partitions.remove(sto);
            for (int i = 0; i < this.partitions.size(); ++i) {
                ModelObject obj = this.partitions.getElement(i);
                if (obj instanceof PartitionOracle) {
                    ((PartitionOracle)obj).setPosition(i + 1);
                    continue;
                }
                if (obj instanceof ListPartitionOracle) {
                    ((ListPartitionOracle)obj).setPosition(i + 1);
                    continue;
                }
                if (!(obj instanceof HashPartitionOracle)) continue;
                ((HashPartitionOracle)obj).setPosition(i + 1);
            }
        } else if (sto instanceof LobStorageOracle) {
            this.lobs.remove(sto);
        }
        sto.removeObjectListener(this);
        super.removeObject(sto);
    }

    private void removeExisting(TableCheckConstraintOracle check) {
        for (int i = this.tableCheckConstraints.size() - 1; i >= 0; --i) {
            TableCheckConstraintOracle tcc = (TableCheckConstraintOracle)this.tableCheckConstraints.getElement(i);
            if (tcc == check || !tcc.getObjectID().equals(check.getObjectID())) continue;
            String newname = tcc.getName();
            tcc.remove();
            this.tableCheckConstraints.remove(tcc);
            if (!this.getStorageDesign().isLoading() || !this.getDesign().isOldRepositoryType()) continue;
            check.setObjectID(check.getObjectID());
            if (check.isNameChanged()) continue;
            check.setName(newname);
        }
    }

    public static boolean containsTCCWithID(StorageObjectCollection stc, String id) {
        if (id != null && !"".equals(id)) {
            for (TableCheckConstraintOracle tcc : stc) {
                if (!id.equals(tcc.getObjectID())) continue;
                return true;
            }
        }
        return false;
    }

    public StorageObjectCollection getListStorageTemplates() {
        return this.listStorageTemplates;
    }

    public StorageObjectCollection getTableCheckConstraints() {
        return this.tableCheckConstraints;
    }

    public StorageObjectCollection getBjIndexes() {
        return this.bjIndexes;
    }

    @Override
    public List getSAC_StorageObjects() {
        ArrayList list = new ArrayList();
        this.getTableCheckConstraints().addAllElementsTo(list);
        return list;
    }

    @Override
    public void remove() {
        Object[] trigs = this.triggers.toArray();
        for (int i = 0; i < trigs.length; ++i) {
            TriggerOracle trig = (TriggerOracle)trigs[i];
            trig.remove();
            trig.setTable(null);
            this.triggers.remove(trig);
        }
        Object[] bitmapIndexes = this.bjIndexes.toArray();
        for (int i = 0; i < bitmapIndexes.length; ++i) {
            BitmapJoinIndexOracle bjIndex = (BitmapJoinIndexOracle)bitmapIndexes[i];
            bjIndex.remove();
            bjIndex.setTable(null);
            this.bjIndexes.remove(bjIndex);
        }
        Object[] lobStorages = this.lobs.toArray();
        for (int i = 0; i < lobStorages.length; ++i) {
            LobStorageOracle lob = (LobStorageOracle)lobStorages[i];
            lob.remove();
            lob.setTable(null);
            this.lobs.remove(lob);
        }
        Object[] parts = this.partitions.toArray();
        for (int i = 0; i < parts.length; ++i) {
            StorageObject sto = (StorageObject)parts[i];
            sto.remove();
            if (sto instanceof PartitionOracle) {
                ((PartitionOracle)sto).setPartitionList(null);
            } else if (sto instanceof ListPartitionOracle) {
                ((ListPartitionOracle)sto).setPartitionList(null);
            } else if (sto instanceof HashPartitionOracle) {
                ((HashPartitionOracle)sto).setPartitionList(null);
            }
            this.partitions.remove(sto);
        }
        Object[] lsTemplates = this.listStorageTemplates.toArray();
        for (int i = 0; i < lsTemplates.length; ++i) {
            StorageObject sto = (StorageObject)lsTemplates[i];
            sto.remove();
            if (sto instanceof ListStorageTemplatePartitionOracle) {
                ((ListStorageTemplatePartitionOracle)sto).setPartOfStorageTable(null);
            } else if (sto instanceof HashPartitionOracle) {
                ((HashPartitionOracle)sto).setPartOfStorageTable(null);
            } else if (sto instanceof PartitionOraclev11g) {
                ((PartitionOraclev11g)sto).setPartOfStorageTable(null);
            }
            this.listStorageTemplates.remove(sto);
        }
        super.remove();
    }

    @Override
    public void clearNoneMergableStructure() {
        this.lobs.removeAll();
        this.partitions.removeAll();
        this.listStorageTemplates.removeAll();
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            if (this.bjIndexes != null) {
                this.bjIndexes.addAllElementsTo(list);
            }
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    @Override
    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }

    public List getListOfTriggers() {
        if (this.triggers.size() > 0) {
            ArrayList list = new ArrayList();
            this.triggers.addAllElementsTo(list);
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public PartitionListOracle createPartitionList() {
        PartitionListOracle pl = (PartitionListOracle)((StorageDesignOracle)this.getStorageDesign()).getPartitionListSet().createElement(null);
        pl.setTable(this);
        return pl;
    }

    public StorageObject createPartitionOracle() {
        if (this.partitions.getStorageObjectSet() != null) {
            return (StorageObject)this.partitions.createElement(null);
        }
        return null;
    }

    public StorageObject createListStorageTemplate() {
        if (this.listStorageTemplates.getStorageObjectSet() != null) {
            return (StorageObject)this.listStorageTemplates.createElement(null);
        }
        return null;
    }

    public LobStorageOracle createLobStorage() {
        if (this.lobs.getStorageObjectSet() != null) {
            return (LobStorageOracle)this.lobs.createElement(null);
        }
        return null;
    }

    public BitmapJoinIndexOracle createBjIndex() {
        if (this.bjIndexes.getStorageObjectSet() != null) {
            return (BitmapJoinIndexOracle)this.bjIndexes.createElement(null);
        }
        return null;
    }

    public void clearPartitionList() {
        PartitionListOracle partitionList = this.partitionList;
        if (partitionList != null) {
            this.setPartitionList(null);
            partitionList.remove();
        }
    }

    @Override
    public Icon getIcon() {
        String tableIcon = this.getTemporary().equalsIgnoreCase("YES") ? "TEMPORARY_TABLE_ICON" : (this.getPartitioned().equalsIgnoreCase("YES") ? "PARTITIONED_TABLE_ICON" : (this.getOrganization().equalsIgnoreCase(ORGANIZATION_EXTERNAL) ? "EXTERNAL_TABLE_ICON" : "TABLE_ICON"));
        return GUIConfiguration.getInstance().getIcon(tableIcon, 16);
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.User"), this, "getUser", "setUser", UserOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.Temporary"), this, "getTemporary", "setTemporary", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(Messages.getString("TableProxyOracle.PreserveRows"), this, "getTempPreserveRows", "setTempPreserveRows", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.TableSpace"), this, "getTableSpace", "setTableSpace", TableSpaceOracle.class));
            if (this instanceof TableProxyOraclev11g) {
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.TemporaryTablespace"), this, "getTemporaryTablespace", "setTemporaryTablespace", TemporaryTablespaceOracle.class));
            }
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.Organization"), this, "getOrganization", "setOrganization", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.Cluster"), this, "getCluster", "setCluster", ClusterOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.Logging"), this, "getLogging", "setLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.Segment"), this, "getSegment", "setSegment", SegmentOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.Cache"), this, "getCache", "setCache", String.class));
            if (this instanceof TableProxyOraclev9i) {
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.Monitoring"), this, "getMonitoring", "setMonitoring", String.class));
            }
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.Parallel"), this, "getParallel", "setParallel", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.Degree"), this, "getDegree", "setDegree", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.RowDependency"), this, "getRowDependency", "setRowDependency", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.Partitioned"), this, "getPartitioned", "setPartitioned", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.RowMovement"), this, "getParttitionedRowMovement", "setParttitionedRowMovement", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.DataCompression"), this, "getDataSegmentCompression", "setDataSegmentCompression", String.class));
            ComplexPropertyWrapper pw = new ComplexPropertyWrapper(Messages.getString("TableProxyOracle.Partitions"), this);
            pw.addPropertyName("partitionList");
            pw.addCollectionName("partitions");
            pw.addExcludePropertyName("columnIDs");
            pw.addExcludePropertyName("subPartitionsColumnIDs");
            this.propertyWrapperList.add(pw);
            pw = new ComplexPropertyWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("PartitionPropertyTabOraclev10g.SubPartitionTemplates"), this);
            pw.addPropertyName("partitionList");
            pw.addCollectionName("subpartitionTemplates");
            pw.addExcludePropertyName("columnIDs");
            pw.addExcludePropertyName("subPartitionsColumnIDs");
            this.propertyWrapperList.add(pw);
            CopyInSD_RelatedObjectsWrapper pwc = new CopyInSD_RelatedObjectsWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("UserPropertyDialogOracle.Triggers"), this, "getListOfTriggers", "setTable", TableProxyOracle.class);
            pwc.setUniqueNames(true);
            this.propertyWrapperList.add(pwc);
            pwc = new CopyInSD_RelatedObjectsWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("DefaultPropertyDialogOracle.Permissions"), this, "getListOfPermissions", "setTable", TableProxyOracle.class);
            pwc.addAdditionalProperty("getUser", "setUser", UserOracle.class);
            pwc.addAdditionalProperty("getRole", "setRole", RoleOracle.class);
            this.propertyWrapperList.add(pwc);
        }
        return this.propertyWrapperList;
    }

    protected String getPropertyDialogName(String messageKey) {
        String uiText = oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString(messageKey);
        if (uiText.endsWith(":")) {
            uiText = uiText.substring(0, uiText.length() - 1).trim();
        }
        return uiText;
    }

    public List getListOfPermissions() {
        ArrayList<PermissionsOracle> list = new ArrayList<PermissionsOracle>();
        for (PermissionsOracle po : ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet()) {
            if (po.getTable() != this) continue;
            list.add(po);
        }
        return list;
    }

    public List getRangePartitions() {
        String partitionType;
        PartitionListOracle pl = this.getPartitionList();
        if (pl != null && ("RANGE".equalsIgnoreCase(partitionType = pl.getPartitionType()) || "COMPOSITE BY HASH".equalsIgnoreCase(partitionType) || "COMPOSITE BY LIST".equalsIgnoreCase(partitionType) || "REFERENCE".equalsIgnoreCase(partitionType) || "SYSTEM".equalsIgnoreCase(partitionType))) {
            ArrayList list = new ArrayList();
            this.getPartitions().addAllElementsTo(list);
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    public SynonymOracle createSynonym() {
        SynonymOracle syn = (SynonymOracle)this.synonyms.createElement(null);
        syn.setReferredObjectID(this.getObjectID());
        syn.setPAC_Element(this);
        return syn;
    }

    public void removeSynonym(SynonymOracle syn) {
        this.synonyms.remove(syn);
        this.setDirty(true);
    }

    public void addSynonym(SynonymOracle syn) {
        this.synonyms.add(syn);
        this.setDirty(true);
    }

    public void addSynonymsFromDesign(StorageObjectSet set) {
        for (SynonymOracle syn : set) {
            if (!syn.getReferredObjectID().equalsIgnoreCase(this.getObjectID())) continue;
            syn.setParent(this.synonyms);
            this.synonyms.add(syn);
        }
    }

    public String getAccessDriverType() {
        return this.accessDriverType;
    }

    public void setAccessDriverType(String accessDriverType) {
        this.accessDriverType = accessDriverType;
    }

    public DirectoryOracle getDefaultDir() {
        return this.defaultDir;
    }

    public void setDefaultDir(DirectoryOracle defaultDir) {
        this.defaultDir = defaultDir;
        this.fireDataFieldChange();
    }

    public String getAccessParametersType() {
        return this.accessParametersType;
    }

    public void setAccessParametersType(String accessParametersType) {
        if (this.checkAccessParameters(accessParametersType)) {
            this.accessParametersType = accessParametersType;
            this.fireDataFieldChange();
        }
    }

    public static String[] getAccessParametersChoices() {
        return accessParametersChoices;
    }

    protected boolean checkAccessParameters(String value) {
        if (accessParametersSet == null) {
            accessParametersSet = new HashSet();
            accessParametersSet.addAll(Arrays.asList(TableProxyOracle.getAccessParametersChoices()));
        }
        return accessParametersSet.contains(value);
    }

    public String getOpaqueFormatSpec() {
        return this.opaqueFormatSpec;
    }

    public void setOpaqueFormatSpec(String opaqueFormatSpec) {
        this.opaqueFormatSpec = opaqueFormatSpec;
        this.fireDataFieldChange();
    }

    public String getClobSubquery() {
        return this.clobSubquery;
    }

    public void setClobSubquery(String clobSubquery) {
        this.clobSubquery = clobSubquery;
        this.fireDataFieldChange();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
        this.fireDataFieldChange();
    }

    public String getRejectLimit() {
        return this.rejectLimit;
    }

    public void setRejectLimit(String rejectLimit) {
        if (rejectLimit != null) {
            if ((rejectLimit = rejectLimit.trim()).equals("")) {
                this.rejectLimit = "";
            } else if (rejectLimit.equalsIgnoreCase("UNLIMITED")) {
                this.rejectLimit = "UNLIMITED";
            } else {
                try {
                    Integer.parseInt(rejectLimit);
                    this.rejectLimit = rejectLimit;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.fireDataFieldChange();
        }
    }

    public String getFromExternalTableID() {
        return this.fromExternalTableID;
    }

    public void setFromExternalTableID(String fromExternalTableID) {
        this.fromExternalTableID = fromExternalTableID;
    }

    public void addTemplateSubPartition(StorageObject so) {
        HashPartitionOracle part;
        so.removeObjectListener(this);
        if (so instanceof PartitionOraclev11g) {
            PartitionOraclev11g part2 = (PartitionOraclev11g)so;
            if (part2.getPartOfStorageTable() == this) {
                part2.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(part2);
                if (part2.getPosition() == 0) {
                    part2.setPosition(this.listStorageTemplates.size());
                }
            }
        } else if (so instanceof ListStorageTemplatePartitionOracle) {
            ListStorageTemplatePartitionOracle storage = (ListStorageTemplatePartitionOracle)so;
            if (storage.getPartOfStorageTable() == this) {
                storage.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(storage);
                if (storage.getPosition() == 0) {
                    storage.setPosition(this.listStorageTemplates.size());
                }
            }
        } else if (so instanceof HashPartitionOracle && (part = (HashPartitionOracle)so).getPartOfStorageTable() == this) {
            part.setParent(this.listStorageTemplates);
            this.listStorageTemplates.add(part);
            if (part.getPosition() == 0) {
                part.setPosition(this.listStorageTemplates.size());
            }
        }
        so.addObjectListener(this);
    }

    public void removeTemplateSubPartition(StorageObject so) {
        this.listStorageTemplates.remove(so);
        for (int i = 0; i < this.listStorageTemplates.size(); ++i) {
            ModelObject obj = this.listStorageTemplates.getElement(i);
            if (obj instanceof PartitionOracle) {
                ((PartitionOracle)obj).setPosition(i + 1);
                continue;
            }
            if (obj instanceof ListStorageTemplatePartitionOracle) {
                ((ListStorageTemplatePartitionOracle)obj).setPosition(i + 1);
                continue;
            }
            if (!(obj instanceof HashPartitionOracle)) continue;
            ((HashPartitionOracle)obj).setPosition(i + 1);
        }
        so.removeObjectListener(this);
    }

    public String getBigDataRowProcessing() {
        return this.bigDataRowProcessing;
    }

    public void setBigDataRowProcessing(String bigDataRowProcessing) {
        this.bigDataRowProcessing = bigDataRowProcessing;
    }

    public boolean isMaterializedQueryTable() {
        return ((Table)this.getObject()).isMaterializedQueryTable();
    }

    public void setMaterializedQueryTable(boolean materializedQueryTable) {
        this.materializedQueryTable = materializedQueryTable;
    }

    public boolean getLocalMaterializedQueryTable() {
        return this.materializedQueryTable;
    }

    public SnapshotOracle generateSnapshot() {
        SnapshotOracle snapshot = null;
        Table table = (Table)this.getObject();
        if (table.isMaterializedQueryTable()) {
            snapshot = this.getSnapshot();
            if (snapshot == null && (snapshot = this.findPrebuildSnapshot()) == null) {
                snapshot = ((StorageDesignOracle)this.getStorageDesign()).getSnapshotSet().createSnapshot();
            }
            snapshot.setName(table.getName());
            snapshot.setNameHasQuotes(table.getNameHasQuotes());
            if (table.isOnPrebuiltTable()) {
                this.setSnapshot(null);
                snapshot.setOnPrebuildTable(this);
            } else {
                snapshot.setOnPrebuildTable(null);
                this.setSnapshot(snapshot);
            }
        }
        return snapshot;
    }

    public void updateSnapshotForPrebuilt() {
        Table table = (Table)this.getObject();
        if (table.isMaterializedQueryTable()) {
            if (table.isOnPrebuiltTable()) {
                SnapshotOracle implementingSnapshot = this.getSnapshot();
                if (implementingSnapshot != null) {
                    implementingSnapshot.setOnPrebuildTable(this);
                    this.setSnapshot(null);
                }
            } else {
                SnapshotOracle prebuildSnapshot = this.findPrebuildSnapshot();
                if (prebuildSnapshot != null) {
                    prebuildSnapshot.setOnPrebuildTable(null);
                    prebuildSnapshot.setName(this.getName());
                    prebuildSnapshot.setNameHasQuotes(this.getNameHasQuotes());
                    this.setSnapshot(prebuildSnapshot);
                }
            }
        }
    }

    public void updateSnapshotName() {
        SnapshotOracle snapshot = this.getSnapshot();
        if (snapshot != null) {
            snapshot.setName(this.getObject().getName());
        }
    }

    public SnapshotOracle findPrebuildSnapshot() {
        SnapshotOracle prebuildSnapshot = null;
        for (SnapshotOracle snapshot : ((StorageDesignOracle)this.getStorageDesign()).getSnapshotSet()) {
            if (snapshot.getOnPrebuildTable() != this) continue;
            prebuildSnapshot = snapshot;
            break;
        }
        return prebuildSnapshot;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

