/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.StructuredTypePropertyDialogOraclev9i;

public class StructuredTypeProxyOracle
extends StructuredTypeProxy {
    public static final String CURRENT_USER = "CURRENT_USER";
    public static final String DEFINER = "DEFINER";
    public static final String MAP = "MAP";
    public static final String ORDER = "ORDER";
    private UserOracle owner;
    private String invokerRights = "";
    private MethodProxyOracle mapOrderFunction = null;
    private String mapOrderType = "MAP";
    public static final String[] INVOKER_RIGHTS = new String[]{"", "CURRENT_USER", "DEFINER"};
    private static Set invokerRightSet = null;
    public static final String[] MAP_ORDER_RIGHTS = new String[]{"MAP", "ORDER"};
    private static Set mapOrderSet = null;
    protected StorageObjectCollection synonyms;

    public StructuredTypeProxyOracle(StructuredType structType, StorageDesign storageDesign) {
        super(structType, storageDesign);
        this.initSynonymsSet(storageDesign);
    }

    public StructuredTypeProxyOracle(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.initSynonymsSet(storageDesign);
    }

    private void initSynonymsSet(StorageDesign storageDesign) {
        this.synonyms = new StorageObjectCollection();
        this.synonyms.setStorageObjectSet(((StorageDesignOracle)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(SequenceOracle.class);
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        this.addSynonymsFromDesign(((StorageDesignOracle)storageDesign).getSynonymSet());
    }

    public String getInvokerRights() {
        return this.invokerRights;
    }

    public void setInvokerRights(String invokerRights) {
        if (this.checkInvokerRight(invokerRights)) {
            this.invokerRights = invokerRights;
            this.fireDataFieldChange();
        }
    }

    public MethodProxyOracle getMapOrderFunction() {
        return this.mapOrderFunction;
    }

    public void setMapOrderFunction(MethodProxyOracle mapOrderFunction) {
        if (this.mapOrderFunction != mapOrderFunction && ((StructuredType)this.getObject()).getParentType() == null) {
            this.mapOrderFunction = mapOrderFunction;
            this.fireDataFieldChange();
        }
    }

    public String getMapOrderType() {
        return this.mapOrderType;
    }

    public void setMapOrderType(String mapOrderType) {
        if (this.checkMapOrder(mapOrderType)) {
            this.mapOrderType = mapOrderType;
            this.fireDataFieldChange();
        }
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public void setOwner(UserOracle owner) {
        if (this.owner != owner) {
            this.owner = owner;
            if (owner != null) {
                boolean isPredefined = owner.getName().equalsIgnoreCase("MDSYS") || owner.getName().equalsIgnoreCase("SYS") || owner.getName().equalsIgnoreCase("ORDSYS");
                this.getStructuredType().setPredefined(isPredefined);
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public static String[] getInvokerRightChoices() {
        return INVOKER_RIGHTS;
    }

    protected boolean checkInvokerRight(String value) {
        if (invokerRightSet == null) {
            invokerRightSet = new HashSet();
            invokerRightSet.addAll(Arrays.asList(StructuredTypeProxyOracle.getInvokerRightChoices()));
        }
        return invokerRightSet.contains(value);
    }

    public static String[] getMapOrderChoices() {
        return MAP_ORDER_RIGHTS;
    }

    protected boolean checkMapOrder(String value) {
        if (mapOrderSet == null) {
            mapOrderSet = new HashSet();
            mapOrderSet.addAll(Arrays.asList(StructuredTypeProxyOracle.getMapOrderChoices()));
        }
        return mapOrderSet.contains(value);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StructuredTypePropertyDialogOraclev9i dialog = new StructuredTypePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !"".equals(this.getOwner().getLongName())) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public StorageObject getSchemaOrUser() {
        return this.getOwner();
    }

    @Override
    public int getNumberOfChildren() {
        return 3;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.elements;
            }
            case 1: {
                return this.methods;
            }
            case 2: {
                return this.synonyms;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.elements) {
            return 0;
        }
        if (child == this.methods) {
            return 1;
        }
        if (child == this.synonyms) {
            return 2;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.elements) {
            return 0;
        }
        if (child == this.methods) {
            return 1;
        }
        if (child == this.synonyms) {
            return 2;
        }
        return -1;
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    public SynonymOracle createSynonym() {
        SynonymOracle syn = (SynonymOracle)this.synonyms.createElement(null);
        syn.setReferredObjectID(this.getObjectID());
        syn.setPAC_Element(this);
        return syn;
    }

    public void removeSynonym(SynonymOracle syn) {
        this.synonyms.remove(syn);
        this.setDirty(true);
    }

    public void addSynonym(SynonymOracle syn) {
        this.synonyms.add(syn);
        this.setDirty(true);
    }

    public void addSynonymsFromDesign(StorageObjectSet set) {
        for (SynonymOracle syn : set) {
            if (!syn.getReferredObjectID().equalsIgnoreCase(this.getObjectID())) continue;
            syn.setParent(this.synonyms);
            this.synonyms.add(syn);
        }
    }
}

