/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyOracle
extends IndexProxy
implements StorageObjectListener,
Constants,
ModelObjectSetListener,
PropertiesPropagator,
OwnedObjectOracle {
    public static final String[] PARTITIONED = new String[]{"NON_PARTITIONED", "LOCAL", "GLOBAL"};
    public static final String[] SORTED_ROWS = new String[]{"NO", "SORTED", "REVERSE"};
    private static Set partitionedSet = null;
    private static Set sortedRowsSet = null;
    protected UserOracle user = null;
    protected boolean bitmapIndex = false;
    protected String partitioned = PARTITIONED[0];
    protected IndexGlobalPartitionsListOracle indexGlobalPartList = null;
    protected TableSpaceOracle tableSpace = null;
    protected String logging = "YES";
    protected SegmentOracle segment = null;
    protected int compress = 0;
    protected String parallel = "NO";
    private String degree = "";
    protected String sortedRows = "SORTED";
    protected String computeStatistics = "NO";
    protected String online = "NO";
    protected StorageObjectCollection partitions;
    protected String hashSubPartitionsTableSpaces = "";
    protected InlineList hashPartitionsTableSpacesSet = null;
    protected List propertyWrapperList = null;
    private String indexType = "";
    private String indexDomainParameters = "";
    public static final String NAME_SUBSTITUTION_TYPE = "Index";

    public IndexProxyOracle(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
        this.initPartitions((StorageDesignOracle)storageDesign);
    }

    public IndexProxyOracle(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.initPartitions((StorageDesignOracle)storageDesign);
    }

    protected void initPartitions(StorageDesignOracle storageDesign) {
        this.partitions = new StorageObjectCollection(storageDesign.getIndexGlobalPartitionSet());
        this.partitions.setParent(this);
        this.partitions.setName(Messages.getString("IndexProxyOracle.GlobalPartitions"));
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.setClassForParent(IndexGlobalPartitionsListOracle.class);
        this.partitions.setSetMethod("setIndexGlobalPartList");
        this.partitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesign.getIndexGlobalPartitionSet().addSetListener(this);
        this.addIGPFromDesign(storageDesign.getIndexGlobalPartitionSet());
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof IndexGlobalPartitionOracle) {
            IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
            if (igp.getIndexGlobalPartList() != null && igp.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                igp.setParent(this.partitions);
                this.partitions.add(igp);
            } else {
                this.partitions.remove(igp);
            }
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignOracle)this.getStorageDesign()).getPKProxySet().add(object);
            this.fireChangeNoDirty(event);
        } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_NO_PK)) {
            ((StorageDesignOracle)this.getStorageDesign()).getPKProxySet().remove(object);
            if (!this.isUniqueConstraint()) {
                this.getStorageDesign().getIndexProxySet().add(this);
            }
            this.fireChangeNoDirty(event);
        } else if (event.isType(ObjectChangeEvent.ADD_FK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignOracle)this.getStorageDesign()).getFKProxySet().add(object);
            this.fireChangeNoDirty(event);
        } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignOracle)this.getStorageDesign()).getUniqueSet().add(object);
            this.fireChangeNoDirty(event);
        } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE)) {
            ((StorageDesignOracle)this.getStorageDesign()).getUniqueSet().remove(object);
            this.getStorageDesign().getIndexProxySet().add(this);
            this.fireChangeNoDirty(event);
        }
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        if (this.user != user) {
            this.user = user;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public String getTableUser() {
        if (((TableProxyOracle)this.getTableProxy()).getUser() != null) {
            return ((TableProxyOracle)this.getTableProxy()).getUser().getName();
        }
        return "";
    }

    public void setBitmapIndex(boolean value) {
        if (!this.isUnique()) {
            this.bitmapIndex = value;
            TableProxyOracle proxy = (TableProxyOracle)this.getTableProxy();
            if (proxy != null && value && proxy.getPartitioned().equalsIgnoreCase("YES")) {
                this.setIndexPartitioned("LOCAL");
            }
            this.fireDataFieldChange();
        }
    }

    public boolean getBitmapIndex() {
        return this.bitmapIndex;
    }

    public static String[] getPartitionedChoices() {
        return PARTITIONED;
    }

    private boolean checkPartitionedChoices(String value) {
        if (partitionedSet == null) {
            partitionedSet = new HashSet();
            partitionedSet.addAll(Arrays.asList(IndexProxyOracle.getPartitionedChoices()));
        }
        return partitionedSet.contains(value);
    }

    public void setIndexPartitioned(String partitioned) {
        if (this.checkPartitionedChoices(partitioned)) {
            this.partitioned = partitioned;
            this.fireDataFieldChange();
        }
    }

    public String getIndexPartitioned() {
        TableProxyOracle tableProxy;
        if (this.bitmapIndex && (tableProxy = (TableProxyOracle)this.getTableProxy()) != null && tableProxy.getPartitioned().equalsIgnoreCase("YES")) {
            this.setIndexPartitioned("LOCAL");
        }
        return this.partitioned;
    }

    public IndexGlobalPartitionsListOracle getIndexGlobalPartitionsList() {
        return this.indexGlobalPartList;
    }

    public void setIndexGlobalPartitionsList(IndexGlobalPartitionsListOracle indexGlobalPartList) {
        if (this.indexGlobalPartList != null && this.indexGlobalPartList != indexGlobalPartList) {
            this.partitions.removeAll();
            this.partitions.setForbiddenCreateElement(true);
        }
        this.indexGlobalPartList = indexGlobalPartList;
        if (this.indexGlobalPartList != null) {
            this.partitions.setForbiddenCreateElement(false);
            this.partitions.setLogicalParent(indexGlobalPartList);
        }
        this.addIGPFromDesign(((StorageDesignOracle)this.getStorageDesign()).getIndexGlobalPartitionSet());
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getTableSpace() {
        if (this.tableSpace == null && this.segment != null) {
            return this.segment.getTableSpace();
        }
        return this.tableSpace;
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        if (this.tableSpace != tableSpace) {
            this.tableSpace = tableSpace;
            this.fireDataFieldChange();
        }
    }

    public void setLogging(String logging) {
        if (!this.logging.equals(logging) && (ConstantsOracle.checkYesNo(logging) || "".equals(logging))) {
            this.logging = logging;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segment) {
        this.segment = segment;
        this.fireDataFieldChange();
    }

    public int getCompress() {
        return this.compress;
    }

    public void setCompress(int compress) {
        if (this.compress != compress) {
            this.compress = compress;
            this.fireDataFieldChange();
        }
    }

    public void setParallel(String parallel) {
        if (ConstantsOracle.checkYesNo(parallel)) {
            this.parallel = parallel;
            this.fireDataFieldChange();
        }
    }

    public String getParallel() {
        return this.parallel;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        block5: {
            if (!"".equalsIgnoreCase(degree)) {
                try {
                    int intVal = Integer.parseInt(degree);
                    if (intVal > 0) {
                        this.degree = degree;
                        break block5;
                    }
                    this.degree = "";
                }
                catch (NumberFormatException e) {
                    this.degree = "";
                }
            } else {
                this.degree = "";
            }
        }
        this.fireDataFieldChange();
    }

    public static String[] getSortedRowsChoices() {
        return SORTED_ROWS;
    }

    private boolean checkSortedRowsChoices(String value) {
        if (sortedRowsSet == null) {
            sortedRowsSet = new HashSet();
            sortedRowsSet.addAll(Arrays.asList(IndexProxyOracle.getSortedRowsChoices()));
        }
        return sortedRowsSet.contains(value);
    }

    public void setSortedRows(String sortedRows) {
        if (this.checkSortedRowsChoices(sortedRows)) {
            this.sortedRows = sortedRows;
            this.fireDataFieldChange();
        }
    }

    public String getSortedRows() {
        return this.sortedRows;
    }

    public void setComputeStatistics(String computeStatistics) {
        if (ConstantsOracle.checkYesNo(computeStatistics)) {
            this.computeStatistics = computeStatistics;
            this.fireDataFieldChange();
        }
    }

    public String getComputeStatistics() {
        return this.computeStatistics;
    }

    public void setOnline(String online) {
        if (ConstantsOracle.checkYesNo(online)) {
            this.online = online;
            this.fireDataFieldChange();
        }
    }

    public String getOnline() {
        return this.online;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null) {
            if (!"".equals(this.getUser().getLongName())) {
                return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
            }
            return new StringBuffer(this.getName()).toString();
        }
        ContainerObject co = (ContainerObject)this.getObject();
        SchemaObject so = co.getSchemaObject();
        if (so != null) {
            UserOracle user = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(so);
            if (user != null) {
                if (!"".equals(user.getLongName())) {
                    return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
                }
                return new StringBuffer(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public String getUserNameAndName() {
        if (!this.getStorageDesign().getAppView().getSettings().isIncludeSchemaInDDL()) {
            return this.getName();
        }
        UserOracle user = this.getUser();
        if (user != null) {
            return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
        }
        Index index = this.getIndex();
        SchemaObject so = index.getSchemaObject();
        if (so != null) {
            user = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(so);
            if (user != null) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        if ((user = ((TableProxyOracle)this.getTableProxy()).getUser()) != null) {
            return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
        }
        if (index.getContainerObject() != null && (so = index.getContainerObject().getSchemaObject()) != null) {
            user = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(so);
            if (user != null) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return this.getName();
    }

    public ModelIDObject getSchemaImplementingObject() {
        TableProxy tableProxy;
        StorageObject user = this.getUser();
        if (user != null) {
            return user;
        }
        Index index = this.getIndex();
        SchemaObject schemaObject = index.getSchemaObject();
        if (schemaObject != null) {
            if (!this.getStorageDesign().isOpen()) {
                return schemaObject;
            }
            user = this.getStorageDesign().getUserSchemaSet().getBySchemaObject(schemaObject);
            if (user != null) {
                return user;
            }
        }
        if ((tableProxy = this.getTableProxy()) != null) {
            return tableProxy.getSchemaImplementingObject();
        }
        return null;
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    @Override
    public boolean isUnique() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Plain Index");
    }

    public boolean isUniqueConstraint() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Constraint");
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.partitions;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.partitions) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.partitions) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.partitions.removeAll();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
                if (igp.getIndexGlobalPartList() != null && igp.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                    if (!this.partitions.contains(igp)) {
                        igp.addObjectListener(this);
                        igp.setParent(this.partitions);
                        this.partitions.add(igp);
                    }
                } else {
                    this.partitions.remove(igp);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof IndexGlobalPartitionOracle) {
            IndexGlobalPartitionOracle igp = (IndexGlobalPartitionOracle)event.getAffected();
            this.partitions.remove(igp);
            igp.removeObjectListener(this);
        }
    }

    protected void addIGPFromDesign(StorageObjectSet set) {
        for (IndexGlobalPartitionOracle igp : set) {
            if (igp.getIndexGlobalPartList() != null && igp.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                igp.addObjectListener(this);
                igp.setParent(this.partitions);
                this.partitions.add(igp);
                continue;
            }
            if (!this.partitions.contains(igp)) continue;
            this.partitions.remove(igp);
            igp.removeObjectListener(this);
        }
    }

    public void setHashSubPartitionsTableSpaces(String hashSubPartitionsTableSpaces) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateHashSubPartitionsTSSet(hashSubPartitionsTableSpaces);
        } else {
            this.addHashSubPartitionsTS(hashSubPartitionsTableSpaces);
        }
        this.hashSubPartitionsTableSpaces = this.getHashPartitionsTableSpacesSet().toString();
        this.fireDataFieldChange();
    }

    public String getHashSubPartitionsTableSpaces() {
        return this.hashSubPartitionsTableSpaces;
    }

    public String getAllHashSubPartitionsTableSpaces() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.hashSubPartitionsTableSpaces, ",");
        while (st.hasMoreTokens()) {
            String tsID = st.nextToken().trim();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(tsID);
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getName());
        }
        return result.toString();
    }

    private void addHashSubPartitionsTS(String tableSpace) {
        if (!this.getHashPartitionsTableSpacesSet().contains(tableSpace)) {
            this.getHashPartitionsTableSpacesSet().add(tableSpace);
        }
    }

    protected void recreateHashSubPartitionsTSSet(String tableSpaces) {
        this.getHashPartitionsTableSpacesSet().clear();
        StringTokenizer st = new StringTokenizer(tableSpaces, ",");
        while (st.hasMoreTokens()) {
            this.getHashPartitionsTableSpacesSet().add(st.nextToken().trim());
        }
    }

    public InlineList getHashPartitionsTableSpacesSet() {
        if (this.hashPartitionsTableSpacesSet == null) {
            this.hashPartitionsTableSpacesSet = new InlineList();
        }
        return this.hashPartitionsTableSpacesSet;
    }

    public void clear() {
        this.getHashPartitionsTableSpacesSet().clear();
        this.hashSubPartitionsTableSpaces = "";
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.User"), this, "getUser", "setUser", UserOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.BitmapIndex"), this, "getBitmapIndex", "setBitmapIndex", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.Indextype"), this, "getIndexType", "setIndexType", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.Partitioned"), this, "getIndexPartitioned", "setIndexPartitioned", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.TableSpace"), this, "getTableSpace", "setTableSpace", TableSpaceOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.Logging"), this, "getLogging", "setLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.Segment"), this, "getSegment", "setSegment", SegmentOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.Compress"), this, "getCompress", "setCompress", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.Parallel"), this, "getParallel", "setParallel", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.Degree"), this, "getDegree", "setDegree", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.SortedRows"), this, "getSortedRows", "setSortedRows", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.ComputeStats"), this, "getComputeStatistics", "setComputeStatistics", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("IndexPropertyDialogOracle.Online"), this, "getOnline", "setOnline", String.class));
        }
        return this.propertyWrapperList;
    }

    protected String getPropertyDialogName(String messageKey) {
        String uiText = oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString(messageKey);
        if (uiText.endsWith(":")) {
            uiText = uiText.substring(0, uiText.length() - 1).trim();
        }
        return uiText;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        if (!indexType.equals("null")) {
            this.indexType = indexType;
        }
    }

    public String getIndexDomainParameters() {
        return this.indexDomainParameters;
    }

    public void setIndexDomainParameters(String indexDomainProperties) {
        if (!indexDomainProperties.equals("null")) {
            this.indexDomainParameters = indexDomainProperties;
        }
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String name = index.getName();
        if (index.isFK() && index.getFKAssociation() != null) {
            name = index.getFKAssociation().getName();
        }
        name = this.applyNameSubstitution(name);
        return name;
    }

    public StorageObjectCollection getGlobalPartitions() {
        return this.partitions;
    }

    public StorageObject createGlobalPartition() {
        if (this.partitions.getStorageObjectSet() != null) {
            return (StorageObject)this.partitions.createElement(null);
        }
        return null;
    }

    public IndexGlobalPartitionsListOracle createIndexGlobalPartitionsList() {
        IndexGlobalPartitionsListOracle igpl = (IndexGlobalPartitionsListOracle)((StorageDesignOracle)this.getStorageDesign()).getIndexGlobalPartitionsListSet().createElement(null);
        igpl.setIndex(this);
        return igpl;
    }

    public void clearIndexGlobalPartitionsList() {
        IndexGlobalPartitionsListOracle indexGlobalPartitionsList = this.indexGlobalPartList;
        if (indexGlobalPartitionsList != null) {
            this.setIndexGlobalPartitionsList(null);
            indexGlobalPartitionsList.remove();
        }
    }

    @Override
    public String getNameSubstitutionType() {
        return NAME_SUBSTITUTION_TYPE;
    }

    @Override
    public String getStorageName() {
        return "";
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

